/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.StorageOwner;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.cli.common.KotlinVersion;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.config.CompilerRunnerConstants;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.JpsKotlinCompilerSettings;
import org.jetbrains.kotlin.jps.build.GeneratedFile;
import org.jetbrains.kotlin.jps.build.GeneratedJvmClass;
import org.jetbrains.kotlin.jps.build.JpsJsModuleUtils;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilderModuleScriptGenerator;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.incremental.ChangesInfo;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.IncrementalCompilationComponentsImpl;
import org.jetbrains.kotlin.jps.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeaderKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.ModulesUtilKt;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"e\u0016)i1j\u001c;mS:\u0014U/\u001b7eKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004UB\u001c(\"\u00022vS2$'BE'pIVdW\rT3wK2\u0014U/\u001b7eKJT1\"\u001b8de\u0016lWM\u001c;bY*1A(\u001b8jizR\u0001c\u001d;bi&\u001cH/[2t\u0019><w-\u001a:\u000b1Q+\u0017-\\2jif\u001cF/\u0019;jgRL7m\u001d'pO\u001e,'OC\u0004d_:$X\r\u001f;\u000b\u001d\r{W\u000e]5mK\u000e{g\u000e^3yi*)1\r[;oW*YQj\u001c3vY\u0016\u001c\u0005.\u001e8l\u0015A!\u0017N\u001d;z\r&dWm\u001d%pY\u0012,'O\u0003\tESJ$\u0018PR5mKNDu\u000e\u001c3fe*A!-^5mI\u0016\u00148O\u0003\rKCZ\f7k\\;sG\u0016\u0014vn\u001c;EKN\u001c'/\u001b9u_JTAA[1wC*\tRj\u001c3vY\u0016\u0014U/\u001b7e)\u0006\u0014x-\u001a;\u000b\u001d=,H\u000f];u\u0007>t7/^7fe*qq*\u001e;qkR\u001cuN\\:v[\u0016\u0014(\u0002C#ySR\u001cu\u000eZ3\u000b75{G-\u001e7f\u0019\u00164X\r\u001c\"vS2$WM\u001d\u0013Fq&$8i\u001c3f\u0015\u0005ju\u000eZ;mK2+g/\u001a7Ck&dG-\u001a:%\u001fV$\b/\u001e;D_:\u001cX/\\3s\u00155\u0011W/\u001b7e\r&t\u0017n\u001d5fI*!QK\\5u\u00151\u0011W/\u001b7e'R\f'\u000f^3e\u0015-\u0019w.\u001c9jY\u0016$vNS:\u000b\u001f\r|W.\\8o\u0003J<W/\\3oiNTqcQ8n[>t7i\\7qS2,'/\u0011:hk6,g\u000e^:\u000b\u0007\rd\u0017N\u0003\u0004d_6lwN\u001c\u0006\nCJ<W/\\3oiNT1\"\u001a8wSJ|g.\\3oi*\u00192i\\7qS2,'/\u00128wSJ|g.\\3oi*q1m\\7qS2,'OU;o]\u0016\u0014(\"E5oGJ,W.\u001a8uC2\u001c\u0015m\u00195fg*QQ*\u001e;bE2,W*\u00199\u000b\u0011Q\u000b'oZ3u\u0013\u0012Tq!\\8ek2,7O\u0003\tJ]\u000e\u0014X-\\3oi\u0006d7)Y2iK*!An\\1e\u0015)\u0019w.\u001c9p]\u0016tGo\u001d\u0006\u0011[\u0016\u001c8/Y4f\u0007>dG.Z2u_JTq#T3tg\u0006<WmQ8mY\u0016\u001cGo\u001c:BI\u0006\u0004H/\u001a:\u000b\u000fA\u0014xN[3di*Q!\n]:Qe>TWm\u0019;\u000b\u000b5|G-\u001a7\u000b1=+H\u000f];u\u0013R,Wn]\"pY2,7\r^8s\u00136\u0004HN\u0003\u0003vi&d'bA'ba*)3j\u001c;mS:\u0014U/\u001b7eKJ$S*Z:tC\u001e,7i\u001c7mK\u000e$xN]!eCB$XM\u001d\u0006\rG>l\u0007/\u001b7f)>Te/\u001c\u0006\u0011C2d7i\\7qS2,GMR5mKNT!\"T;uC\ndWmU3u\u0015\u00111\u0015\u000e\\3\u000b\u0005%|'B\u00044jY\u0016\u001cHk\\\"p[BLG.\u001a\u0006\t\u001bVdG/['ba*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T!bY8oi\u0006Lg.\u001a:t\u0015\r\u0019V\r\u001e\u0006\u001bG>\u0004\u0018PS:MS\n\u0014\u0018M]=GS2,7/\u00134OK\u0016$W\r\u001a\u0006\u0019GJ,\u0017\r^3D_6\u0004\u0018\u000e\\3F]ZL'o\u001c8nK:$(\"\u00047p_.,\b\u000f\u0016:bG.,'OC\u0007M_>\\W\u000f\u001d+sC\u000e\\WM\u001d\u0006\bI>\u0014U/\u001b7e\u0015Q!wnQ8na&dW-T8ek2,7\t[;oW*!\u0012J\\2sK6,g\u000e^1m\u0007\u0006\u001c\u0007.Z%na2T1dZ3u\u0007>l\u0007/\u001b7bE2,g)\u001b7f\u000bb$XM\\:j_:\u001c(\"C!se\u0006LH*[:u\u0015\u0019\u0019FO]5oO*\tr-\u001a;HK:,'/\u0019;fI\u001aKG.Z:\u000b'=,H\u000f];u\u0013R,WnQ8mY\u0016\u001cGo\u001c:\u000b\t1K7\u000f\u001e\u0006\u000e\u000f\u0016tWM]1uK\u00124\u0015\u000e\\3\u000b%\u001d,G\u000f\u0015:fg\u0016tG/\u00192mK:\u000bW.\u001a\u0006\u0005Y\u0006twMC\nsK\u001eL7\u000f^3s\u001fV$\b/\u001e;Ji\u0016l7O\u0003\bhK:,'/\u0019;fI\u001aKG.Z:\u000b%U\u0004H-\u0019;f\u0015\u00064\u0018-T1qa&twm\u001d\u0006\u0012G>l\u0007/\u001b7bi&|g.\u0012:s_J\u001c(b\u0002\"p_2,\u0017M\u001c\u0006\u0011O\u0016tWM]1uK\u0012\u001cE.Y:tKNT\u0011cR3oKJ\fG/\u001a3Km6\u001cE.Y:t\u0015q)\b\u000fZ1uK.{G\u000f\\5o\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016T1b\u00115b]\u001e,7/\u00138g_*\u0019\u0012n]'pIVdW-T1qa&twMR5mK*\u00012\t[1oO\u0016\u001c\bK]8dKN\u001cxN\u001d\u0006\n\u0007>l\u0007/\u00198j_:TKA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\rA9!B\u0002\u0005\b!\u0019A\u0002A\u0003\u0004\t\tAQ\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001\"B\u0003\u0004\t\u000fAa\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001b\u0002\u0007\u0001\u000b\t!1\u0001#\u0005\u0006\u0007\u00115\u0001\u0002\u0003\u0007\u0001\u000b\t!i\u0001c\u0005\u0006\u0007\u0011=\u0001\"\u0003\u0007\u0001\u000b\r!9\u0001\u0003\u0006\r\u0001\u0015\u0019A\u0001\u0002\u0005\f\u0019\u0001)1\u0001\u0002\u0003\t\u00181\u0001QA\u0001C\u0004\u00111)!\u0001b\u0002\t\r\u0015\u0011Aa\u0001\u0005\b\u000b\t!i\u0001\u0003\u0005\u0006\u0005\u0011\u001d\u0001\u0012D\u0003\u0002\u0011\u0007)1\u0001\"\u0007\t\u001c1\u0001QA\u0001\u0003\u0002\u0011A)!\u0001b\u0007\t\"\u0015\u0011AA\u0004\u0005\u0012\u000b\r!i\u0002c\b\r\u0001\u0015\u0011A!\u0001E\u0013\u000b\r!y\u0002\u0003\n\r\u0001\u0015\u0019A\u0011\u0004E\u0014\u0019\u0001)!\u0001B\u0001\t*\u0015\u0019A!\u0005\u0005\u0015\u0019\u0001)!\u0001B\u0001\t,\u0015\u0011AA\u0005E\u0002\u000b\t!)\u0003c\u0002\u0006\u0005\u0011\u0019\u0002BF\u0003\u0004\tOAQ\u0003\u0004\u0001\u0006\u0007\u0011\u0015\u0001b\u0006\u0007\u0001\u000b\t!1\u0001#\r\u0006\u0007\u0011)\u0002\u0002\u0007\u0007\u0001\u000b\r!y\u0002C\r\r\u0001\u0015\u0011Aq\u0004\u0005\u001a\u000b\t!i\u0002c\b\u0006\u0005\u0011}\u0001BE\u0003\u0002\u0011')!\u0001\u0002\r\t4\u0015\u0011A\u0011\u0007\u0005\u001b\u000b\t!!\u0001#\u000e\u0006\u0005\u0011)\u0002\u0002G\u0003\u0004\t3AA\u0004\u0004\u0001\u0006\u0005\u0011A\u0002\"H\u0003\u0004\tmAI\u0004\u0004\u0001\u0006\u0003!uRA\u0001\u0003\u001d\u0011})!\u0001\"\u000f\t4\u0015\u0011A!\bE \u000b\r!Y\u0004\u0003\u0010\r\u0001\u0015\u0011A\u0011\u0007\u0005!\u000b\t!Y\u0004\u0003\u0010\u0006\u0007\u0011e\u0001B\u0007\u0007\u0001\u000b\t!\u0011\u0001c\u0002\u0006\u0005\u0011\u0001\u0003BF\u0003\u0004\t\u0003B!\u0005\u0004\u0001\u0006\u0005\u0011\u0005\u0003BI\u0003\u0003\t\u0007A9!B\u0002\u0005E!\u001dC\u0002A\u0003\u0004\tcAI\u0005\u0004\u0001\u0006\u0007\u0011e\u0001\"\n\u0007\u0001\u000b\t!\t\u0004#\u0013\u0006\u0007\u0011e\u0001R\n\u0007\u0001\u000b\r!!\u0001C\u0014\r\u0001\u0015\u0011A\u0011\u0007E'\u000b\t!\u0001\u0004\u0003\u0015\u0006\u0005\u00111\u0003\"J\u0003\u0004\t3A)\u0006\u0004\u0001\u0006\u0007\u0011\u0011\u0001r\u000b\u0007\u0001\u000b\r!!\u0005#\u0017\r\u0001\u0015\u0011AA\tE-\u000b\t!1\u0004#\u000f\u0005\u00071\u0015\u0001CL\r\u0004\u000b\u0005AA\u0001\u0007\u0003\u001e\u00047rs#\f\u0007\u0005C\u0012AJ!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\t\u0015\u0019A\u0011B\u0005\u0002\u0011\u0015ik\bB\u0006\u0019\u0006u=A\u0001\u0001E\u0006\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0001!h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\u0019Ab\u0001UB\u0001;G!\u0001\u0001c\u0004\u000e\u001b\u0015\t\u0001bB\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011%!\u0011bA\u0003\u0002\u0011#A\n\u0002G\u0004Q\u0007\u0005iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001\u0005\n1%\u000161A\u0011\u0004\u000b\u0005A\u0019\u0002g\u0005R\u0007-!)!C\u0001\t\u00155\t\u0001RC\u0007\u0002\u0011-i\u0011\u0001c\u0006\u000e\u0003!aQF\u0006\u0003\f15i\n\u0002\u0002\u0001\t\f5!Q!\u0001E\u0006\u0019\u0003AZ\u0001U\u0002\u0001C\r)\u0011\u0001C\u0007\u0019\u001bE\u001bQ\u0001B\u0007\n\u0003\u0011\u0001Q\"\u0001E\u000b[U!1\u0002\u0007\b\u001e\u0010\u0011\u0001\u00012B\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0001\t3!B\u0001\t\u001bai\u0011kA\u0003\u0005\u001d%\tA\u0001A\u0007\u0002\u0011+i[\u001b\u0001\u0003\u00021;iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001\u0005\u00071\u0019\u00016\u0001AO\b\t\u0001Aq\"D\u0002\u0006\u0003!y\u0001d\u0004)\u0004\u0002u=A\u0001\u0001E\u0012\u001b\r)\u0011\u0001\u0003\t\u0019!A\u001b\u0011!(\n\u0005\u0001!\u0019RBD\u0003\u0002\u0011CIA!C\u0002\u0006\u0003!\r\u00024E\u0005\u0005\u0013\r)\u0011\u0001\u0003\u000b\u0019)1\u0005\u0001\u0014\u0005)\u0004\u0004u=A\u0001\u0001E\u0017\u001b\r)\u0011\u0001#\u000b\u0019*A\u001b!!h\u0004\u0005\u0001!=RbA\u0003\u0002\u0011WAZ\u0003UB\u0003C\u0011)\u0011\u0001\u0003\f\r\u0002a1\u0012kA\b\u0005\u001e%\t\u0001RF\u0007\u0002\u0011-i\u0011\u0001C\f\u000e\u0003!=R\"\u0001\u0005\u001a\u001b\u0005A\u0019$D\u0001\t55r\u0015\u0001B\u0001\u00197ueA\u0001\u0001E\u001c\u001b!)\u0011\u0001#\u000e\n\t%\u0019Q!\u0001E\u001c1oA*\u0004U\u0002\u0001;\u001f!\u0001\u0001#\u0004\u000e\u0007\u0015\t\u0001B\u0002\r\u0007!\u000e\u0005Qt\u0002\u0003\u0001\u0011=i1!B\u0001\t\u001fay\u0001kA\u0001\u001e\u0010\u0011\u0001\u00012B\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0007i\u001a\u0003\u0002\u0001\t\u00105iQ!\u0001\u0005\b\u0013\u0011I1!B\u0001\t\u0011aA\u0011\u0002B\u0005\u0004\u000b\u0005A\t\u0002'\u0005\u0019\u000fA\u001b!!h\u0004\u0005\u0001!\rRbA\u0003\u0002\u0011AA\u0002\u0003UB\u0003;K!\u0001\u0001C\n\u000e\u001d\u0015\t\u0001\u0012E\u0005\u0005\u0013\r)\u0011\u0001c\t\u0019$%!\u0011bA\u0003\u0002\u0011QAB\u0003$\u0001\u0019\"A\u001b1!h\t\u0005\u0001!mR\"D\u0003\u0002\u0011yIA!C\u0002\u0006\u0003!E\u0001\u0014C\u0005\u0005\u0013\r)\u0011\u0001c\u000e\u00198aq\u0002ka\u0002\u001e\u0010\u0011\u0001\u0001RF\u0007\u0004\u000b\u0005AI\u0003'\u000bQ\u0007\u0011\tC!B\u0001\t-1\u0005\u0001DF)\u0004+\u0011Y\u0012\"\u0001E\u0017\u001b\u0005Ai$D\u0001\t\u00175\t\u0001bF\u0007\u0002\u0011+i\u0011\u0001c\u0006\u000e\u0003!=R\"\u0001\u0005\u001a\u001b\u0005Aq$D\u0001\t45~B!\u0001M!;\u001f!\u0001\u0001#\u0004\u000e\u0007\u0015\t\u0001B\u0002\r\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u0011_i1!B\u0001\t,a-\u0002k!\u0001\"\u0007\u0015\t\u0001\"\u0004\r\u000e#\u000e9A\u0011I\u0005\u0002\t\u0001i\u0011\u0001C\u0006\u000e\u0003!QR\u0006\u000e\u0003\u00021\u0005j\u001a\u0003\u0002\u0001\t'5iQ!\u0001E \u0013\u0011I1!B\u0001\t\u0012aE\u0011\u0002B\u0005\u0004\u000b\u0005AA\u0003\u0007\u000b\u0019@A\u001b\u0001!h\u0004\u0005\u0001!\rSbA\u0003\u0002\u0011\u0005B\u0012\u0005UB\u0001;\u001f!\u0001\u0001c\u0003\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\t\u0011eA\u0003\u0002\u0011AA\u0002#U\u0002\n\t\u0005J\u0011\u0001c\f\u000e\u0003!IR\"\u0001E\"\u001b\u0005A)\"Le\u0001\t\u0005A*%h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\u0019Ab\u0001U\u0002\u0001;\u001f!\u0001\u0001c\u0003\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u0005Q4\u0005\u0003\u0001\u0011\u001fiQ\"B\u0001\t\u000f%!\u0011bA\u0003\u0002\u0011!A\u0002\"\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0003M\t1\u001d\u00016!AO\b\t\u0001Ai#D\u0002\u0006\u0003!%\u0002\u0014\u0006)\u0004\u0004u=A\u0001\u0001E\u000b\u001b\r)\u0011\u0001C\u0005\u0019\u0013A\u001b!!I\u0002\u0006\u0003!M\u00014C)\u0004\u001b\u0011\u0015\u0013\"\u0001\u0005\u000b\u001b\u0005A1\"D\u0001\t\u00165\t\u0001rC\u0007\u0002\u0011gi\u0011\u0001\u0003\u0007.0\u0006!\u0011\u0001G\u0012\u001e\u001a\u0011\u0001\u0001rG\u0007\t\u000b\u0005A)$\u0003\u0003\n\u0007\u0015\t\u0001r\u0007M\u001c1k\u00016\u0001AO\b\t\u0001Ai!D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0002u=A\u0001\u0001\u0005\u0010\u001b\r)\u0011\u0001C\b\u0019\u001fA\u001b\u0011!h\u0004\u0005\u0001!-QbA\u0003\u0002\u0011\u0017AZ\u0001UB\u0002;G!\u0001\u0001c\u0004\u000e\u001b\u0015\t\u0001bB\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011%!\u0011bA\u0003\u0002\u0011#A\n\u0002G\u0004Q\u0007\tiz\u0001\u0002\u0001\t$5\u0019Q!\u0001\u0005\u00111A\u00016QAO\u0012\t\u0001AY$D\u0007\u0006\u0003!q\u0012\u0002B\u0005\u0004\u000b\u0005A\t\u0002'\u0005\n\t%\u0019Q!\u0001E\u001c1oAb\u0004U\u0002\u0004;G!\u0001\u0001C\n\u000e\u001b\u0015\t\u0001rH\u0005\u0005\u0013\r)\u0011\u0001#\u0005\u0019\u0012%!\u0011bA\u0003\u0002\u0011\u000bB*\u0005g\u0010Q\u0007\u000fiz\u0001\u0002\u0001\t.5\u0019Q!\u0001E\u00151S\u00016\u0001BO\b\t\u0001Ay#D\u0002\u0006\u0003!-\u00024\u0006)\u0004\n\u0005\"Q!\u0001\u0005\u0017\u0019\u0003Ab#U\u0002\u0018\t\rJ\u0011\u0001#\f\u000e\u0003!uR\"\u0001\u0005\f\u001b\u0005Aq#D\u0001\t\u00165\t\u0001rC\u0007\u0002\u0011_i\u0011\u0001C\u0010\u000e\u0003!IR\"\u0001E\u001a\u001b\u0005A!$l\b\u0005\u0017a!\u0013\u0005C\u0003\u0002\u0011\rJA!C\u0002\u0006\u0003!\u001d\u0003t\t\r$#\u000e\u0019A\u0001J\u0005\u0002\u0011\u0011jK\u0005B\u0001\u0019Lu=A\u0001\u0001E\u0007\u001b\r)\u0011\u0001\u0003\u0004\u0019\rA\u001b\u0001!h\u0004\u0005\u0001!1SbA\u0003\u0002\u0011YAb\u0003UB\u0001C!)\u0011\u0001#\u0013\n\t%\u0019Q!\u0001\u0005&1\u0015BJ%U\u0002\b\t\u0017J\u0011\u0001c\u0013\u000e\u0003!YQ\"\u0001E\u0017[+!1\u0002g\u0014\"\u0007\u0015\t\u0001r\tM$#\u000e\u0019AqJ\u0005\u0002\u0011\u001bjK\u0005B\u0001\u0019Ru=A\u0001\u0001E\u000b\u001b\r)\u0011\u0001C\u0005\u0019\u0013A\u001b\u0001!(\u0007\u0005\u0001!IS\u0002C\u0003\u0002\u0011\u0013JA!C\u0002\u0006\u0003!)\u0003$\nM%!\u000e\u0005\u0011eA\u0003\u0002\u00115AR\"U\u0002\b\t#J\u0011\u0001\u0002\u0001\u000e\u0003!aQ\"\u0001E&[\u000b\bA!\u0001M*;\u001f!\u0001\u0001#\u0004\u000e\u0007\u0015\t\u0001B\u0002\r\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u0011)j1!B\u0001\tOa9\u0003k!\u0001\u001e\u0010\u0011\u0001\u00012B\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0005i\u001a\u0003\u0002\u0001\t\u00105iQ!\u0001\u0005\b\u0013\u0011I1!B\u0001\t\u0011aA\u0011\u0002B\u0005\u0004\u000b\u0005A\t\u0002'\u0005\u0019\u000fA\u001b\u0019!h\t\u0005\u0001!mR\"D\u0003\u0002\u0011yIA!C\u0002\u0006\u0003!E\u0001\u0014C\u0005\u0005\u0013\r)\u0011\u0001c\u000e\u00198aq\u0002k\u0001\u0002\u001e\u001a\u0011\u0001\u0001bK\u0007\t\u000b\u0005AI%\u0003\u0003\n\u0007\u0015\t\u0001r\nM(1\u0013\u00026QA\u0011\u0004\u000b\u0005AQ\u0002G\u0007R\u0007=!\u0019&C\u0001\u0005\u00015\t\u0001bC\u0007\u0002\t\u0003i\u0011\u0001#\u0006\u000e\u0003!]Q\"\u0001\u0005 \u001b\u0005AY%L\u001d\u0005\u0003aaSt\u0002\u0003\u0001\u0011)j1!B\u0001\tOa9\u0003k\u0001\u0001\u001e$\u0011\u0001\u0001bE\u0007\u000e\u000b\u0005Ay$\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0003M\t\u0013\u0011I1!B\u0001\tFa\u0015\u0003t\b)\u0004\u0002ueA\u0001\u0001\u0005*\u001b!)\u0011\u0001#\u0013\n\t%\u0019Q!\u0001\u0005&1\u0015BJ\u0005U\u0002\u0002C\r)\u0011\u0001\u0003\u0015\u0019QE\u001b\u0011\u0002\u0002\u0017\n\u0003!ES\"\u0001C\u0001\u001b\u0005A\u0011$D\u0001\tL5\u0006B!A\u000b\u0004\u000b\u0005A9\u0004g\u000e\u0019[\u0005\u001aQ!\u0001\u0005(1\u001d\n6!\u0002\u0003.\u0013\u0005!\t!D\u0001\tSUbQa\u0003\u0003d\u0002a!\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\u0004\t\u0011I\u0011\u0001\u0002\u0001"})
public final class KotlinBuilder
extends ModuleLevelBuilder {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    @NotNull
    public static final JpsElementChildRoleBase<JpsSimpleElement<? extends LookupTracker>> LOOKUP_TRACKER;
    public static final Logger LOG;
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinBuilder.class);
        Companion companion = Companion = new Companion(null);
        KOTLIN_BUILDER_NAME = KOTLIN_BUILDER_NAME;
        JpsElementChildRoleBase jpsElementChildRoleBase = JpsElementChildRoleBase.create((String)"lookup tracker");
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsElementChildRoleBase, (String)"JpsElementChildRoleBase.create(\"lookup tracker\")");
        LOOKUP_TRACKER = jpsElementChildRoleBase;
        LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
    }

    @NotNull
    public String getPresentableName() {
        return Companion.getKOTLIN_BUILDER_NAME();
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        return KotlinPackage.arrayListOf((Object[])new String[]{"kt"});
    }

    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String historyLabel = context.getBuilderParameter("history label");
        if (historyLabel != null) {
            Companion.getLOG().debug("Label in local history: " + historyLabel);
        }
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull(dirtyFilesHolder, (String)"dirtyFilesHolder");
        Intrinsics.checkParameterIsNotNull((Object)outputConsumer, (String)"outputConsumer");
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context);
        try {
            return this.doBuild(chunk, context, dirtyFilesHolder, messageCollector, outputConsumer);
        }
        catch (StopBuildException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            String string = OutputMessageUtil.renderException(e);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OutputMessageUtil.renderException(e)");
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, string, CompilerMessageLocation.Companion.getNO_LOCATION());
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ModuleLevelBuilder.ExitCode doBuild(ModuleChunk chunk, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MessageCollectorAdapter messageCollector, ModuleLevelBuilder.OutputConsumer outputConsumer) {
        ChangesInfo changesInfo;
        Object info;
        Collection destination;
        void $receiver;
        void $receiver2;
        Object object;
        JpsSimpleElement jpsSimpleElement;
        JpsProject project;
        block23: {
            block22: {
                void $receiver3;
                JpsSimpleElement destination2;
                boolean bl;
                Object it;
                Iterable $receiver4;
                ProjectDescriptor projectDescriptor;
                block21: {
                    if (!JpsUtils.isJsKotlinModule(chunk.representativeTarget()) && !((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)true)).booleanValue()) {
                        messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin JPS plugin is disabled", CompilerMessageLocation.Companion.getNO_LOCATION());
                        return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                    }
                    projectDescriptor = context.getProjectDescriptor();
                    BuildDataManager dataManager = projectDescriptor.dataManager;
                    Iterable iterable = chunk.getTargets();
                    for (Object element : $receiver4) {
                        it = (ModuleBuildTarget)element;
                        BuildDataPaths buildDataPaths = dataManager.getDataPaths();
                        BuildTarget buildTarget = (BuildTarget)it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)buildTarget, (String)"it");
                        if (!IncrementalCacheImplKt.getKotlinCacheVersion(buildDataPaths, buildTarget).isIncompatible()) continue;
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
                if (bl) {
                    List list;
                    Iterable $receiver5;
                    Object element;
                    $receiver4 = chunk.getTargets();
                    StringBuilder stringBuilder = new StringBuilder().append("Clearing caches for ");
                    Logger logger = Companion.getLOG();
                    Iterable iterable = $receiver4;
                    element = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver4, (int)10));
                    for (Object item : $receiver5) {
                        void it2;
                        ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item;
                        list = destination2;
                        String string = it2.getPresentableName();
                        list.add(string);
                    }
                    list = (List)destination2;
                    logger.info(stringBuilder.append(KotlinPackage.join$default((Iterable)list, null, null, null, (int)0, null, (int)31)).toString());
                    Map<ModuleBuildTarget, IncrementalCacheImpl> incrementalCaches = KotlinBuilderKt.getIncrementalCaches(chunk, context);
                    $receiver5 = incrementalCaches.values();
                    for (Object element2 : $receiver5) {
                        StorageOwner p1 = (StorageOwner)element2;
                        p1.clean();
                    }
                    return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
                }
                if (!dirtyFilesHolder.hasDirtyFiles() && !dirtyFilesHolder.hasRemovedFiles() || !KotlinBuilderKt.hasKotlinDirtyOrRemovedFiles(dirtyFilesHolder, chunk)) {
                    return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                }
                messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin JPS plugin version " + KotlinVersion.VERSION, CompilerMessageLocation.Companion.getNO_LOCATION());
                project = projectDescriptor.getProject();
                jpsSimpleElement = (JpsSimpleElement)project.getContainer().getChild((JpsElementChildRole)Companion.getLOOKUP_TRACKER());
                if (jpsSimpleElement == null) break block22;
                destination2 = jpsSimpleElement;
                it = (JpsSimpleElement)$receiver3;
                String string = System.getProperty("kotlin.jps.tests");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"kotlin.jps.tests\")");
                KotlinPackage.assert((boolean)KotlinPackage.equals((String)"true", (String)string, (boolean)true), (Object)"LOOKUP_TRACKER allowed only for jps tests");
                jpsSimpleElement = (LookupTracker)it.getData();
                if (jpsSimpleElement != null) break block23;
            }
            jpsSimpleElement = LookupTracker.Companion.getDO_NOTHING();
        }
        JpsSimpleElement lookupTracker = jpsSimpleElement;
        Map<ModuleBuildTarget, IncrementalCacheImpl> incrementalCaches = KotlinBuilderKt.getIncrementalCaches(chunk, context);
        CompilerEnvironment environment = this.createCompileEnvironment(incrementalCaches, (LookupTracker)lookupTracker, context);
        if (!environment.success()) {
            environment.reportErrorsTo(messageCollector);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        CommonCompilerArguments commonArguments = JpsKotlinCompilerSettings.getCommonCompilerArguments(project);
        commonArguments.verbose = true;
        Set<File> allCompiledFiles = KotlinBuilderKt.getAllCompiledFilesContainer(context);
        MultiMap<ModuleBuildTarget, File> filesToCompile = KotlinSourceFileCollector.getDirtySourceFiles(dirtyFilesHolder);
        long start = System.nanoTime();
        CommonCompilerArguments commonCompilerArguments = commonArguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCompilerArguments, (String)"commonArguments");
        MultiMap<ModuleBuildTarget, File> multiMap = filesToCompile;
        Intrinsics.checkExpressionValueIsNotNull(multiMap, (String)"filesToCompile");
        JpsProject jpsProject = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject, (String)"project");
        OutputItemsCollectorImpl outputItemCollector = this.doCompileModuleChunk(allCompiledFiles, chunk, commonCompilerArguments, context, dirtyFilesHolder, environment, multiMap, incrementalCaches, messageCollector, jpsProject);
        this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
        if (outputItemCollector == null) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        Boolean compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
        if (compilationErrors.booleanValue()) {
            Companion.getLOG().info("Compiled with errors");
        } else {
            Companion.getLOG().info("Compiled successfully");
        }
        List<GeneratedFile> generatedFiles = this.getGeneratedFiles(chunk, outputItemCollector);
        this.registerOutputItems(outputConsumer, generatedFiles);
        context.checkCanceled();
        boolean isJsModule = JpsUtils.isJsKotlinModule(chunk.representativeTarget());
        if (isJsModule) {
            object = ChangesInfo.Companion.getNO_CHANGES();
        } else {
            Iterable iterable = generatedFiles;
            void var24_29 = $receiver2;
            Collection collection = new ArrayList();
            for (Object element : $receiver) {
                if (!(element instanceof GeneratedJvmClass)) continue;
                destination.add(element);
            }
            List generatedClasses = (List)destination;
            info = this.updateKotlinIncrementalCache(compilationErrors, incrementalCaches, generatedFiles);
            boolean bl = compilationErrors;
            MultiMap<ModuleBuildTarget, File> multiMap2 = filesToCompile;
            Intrinsics.checkExpressionValueIsNotNull(multiMap2, (String)"filesToCompile");
            this.updateJavaMappings(chunk, bl, context, dirtyFilesHolder, multiMap2, generatedClasses);
            object = changesInfo = info;
        }
        if (compilationErrors.booleanValue()) {
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        if (isJsModule) {
            JpsProject jpsProject2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject2, (String)"project");
            this.copyJsLibraryFilesIfNeeded(chunk, jpsProject2);
        }
        if (!IncrementalCompilation.ENABLED) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        info = filesToCompile.keySet();
        $receiver = $receiver2;
        destination = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            IncrementalCacheImpl incrementalCacheImpl;
            void it;
            ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item;
            Collection collection = destination;
            if (incrementalCaches.get(it) == null) {
                Intrinsics.throwNpe();
            }
            collection.add(incrementalCacheImpl);
        }
        List caches2 = (List)destination;
        ChangesProcessor marker = new ChangesProcessor(context, chunk, allCompiledFiles, caches2);
        marker.processChanges(changesInfo);
        return ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED;
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl doCompileModuleChunk(Set<File> allCompiledFiles, ModuleChunk chunk, CommonCompilerArguments commonArguments, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, CompilerEnvironment environment, MultiMap<ModuleBuildTarget, File> filesToCompile, Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> incrementalCaches, MessageCollectorAdapter messageCollector, JpsProject project) {
        void destination;
        Object removedAndDirtyFiles;
        Object object;
        Collection<File> collection;
        Object object2;
        if (JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            Collection<String> collection2;
            void $receiver2;
            void $receiver3;
            Iterable iterable = filesToCompile.keySet();
            StringBuilder stringBuilder = new StringBuilder().append("Compiling to JS " + filesToCompile.values().size() + " files in ");
            Logger logger = Companion.getLOG();
            void var12_17 = $receiver3;
            Collection collection22 = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
            for (Object item : $receiver2) {
                void it;
                ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item;
                collection2 = collection22;
                String string = it.getPresentableName();
                collection2.add(string);
            }
            collection2 = (List)collection22;
            logger.debug(stringBuilder.append(KotlinPackage.join$default((Iterable)collection2, null, null, null, (int)0, null, (int)31)).toString());
            return this.compileToJs(chunk, commonArguments, environment, null, messageCollector, project);
        }
        if (IncrementalCompilation.ENABLED) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                IncrementalCacheImpl incrementalCacheImpl;
                void destination3;
                void $receiver4;
                void $receiver5;
                if (incrementalCaches.get(target) == null) {
                    Intrinsics.throwNpe();
                }
                Iterable item = dirtyFilesHolder.getRemovedFiles((BuildTarget)target);
                object2 = filesToCompile.get((Object)target);
                void it = $receiver5;
                Collection collection3 = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver5, (int)10));
                for (Object item2 : $receiver4) {
                    void it2;
                    String string = (String)item2;
                    collection = destination3;
                    object = new File((String)it2);
                    collection.add((File)object);
                }
                collection = (List)destination3;
                removedAndDirtyFiles = KotlinPackage.plus((Collection)object2, (Iterable)collection);
                incrementalCacheImpl.markOutputClassesDirty((List<? extends File>)removedAndDirtyFiles);
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        doCompileModuleChunk.2 concatenate$ = doCompileModuleChunk.2.INSTANCE$;
        for (KotlinJpsCompilerArgumentsProvider kotlinJpsCompilerArgumentsProvider : ServiceLoader.load(KotlinJpsCompilerArgumentsProvider.class)) {
            String[] stringArray = commonArguments.pluginOptions;
            ModuleBuildTarget moduleBuildTarget = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
            commonArguments.pluginOptions = concatenate$.invoke(stringArray, kotlinJpsCompilerArgumentsProvider.getExtraArguments(moduleBuildTarget, context));
            String[] stringArray2 = commonArguments.pluginClasspaths;
            ModuleBuildTarget moduleBuildTarget2 = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"representativeTarget");
            commonArguments.pluginClasspaths = concatenate$.invoke(stringArray2, kotlinJpsCompilerArgumentsProvider.getClasspath(moduleBuildTarget2, context));
            messageCollector.report(CompilerMessageSeverity.INFO, "Plugin loaded: " + kotlinJpsCompilerArgumentsProvider.getClass().getSimpleName(), CompilerMessageLocation.Companion.getNO_LOCATION());
        }
        Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> map = incrementalCaches;
        removedAndDirtyFiles = new HashMap(incrementalCaches.size());
        CompilerEnvironment compilerEnvironment = environment;
        DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder2 = dirtyFilesHolder;
        CompileContext compileContext = context;
        CommonCompilerArguments commonCompilerArguments = commonArguments;
        object = chunk;
        collection = allCompiledFiles;
        object2 = this;
        Iterator iterator = KotlinPackage.iterator(map);
        while (iterator.hasNext()) {
            Map.Entry e;
            Map.Entry it = e = (Map.Entry)iterator.next();
            TargetId newKey = ModulesUtilKt.TargetId((ModuleBuildTarget)it.getKey());
            destination.put(newKey, KotlinPackage.getValue((Map.Entry)e));
        }
        void var28_41 = destination;
        return super.compileToJvm((Set<File>)collection, (ModuleChunk)object, commonCompilerArguments, compileContext, dirtyFilesHolder2, compilerEnvironment, (Map<TargetId, IncrementalCache>)var28_41, filesToCompile, messageCollector);
    }

    private final CompilerEnvironment createCompileEnvironment(Map<ModuleBuildTarget, ? extends IncrementalCache> incrementalCaches, LookupTracker lookupTracker, CompileContext context) {
        Services compilerServices2 = new Services.Builder().register(IncrementalCompilationComponents.class, new IncrementalCompilationComponentsImpl(incrementalCaches, lookupTracker)).register(CompilationCanceledStatus.class, new CompilationCanceledStatus(context){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ CompileContext $context;

            static {
                $kotlinClass = Reflection.createKotlinClass(createCompileEnvironment.compilerServices.1.class);
            }

            public void checkCanceled() {
                if (this.$context.getCancelStatus().isCanceled()) {
                    throw (Throwable)((Object)new CompilationCanceledException());
                }
            }
            {
                this.$context = $captured_local_variable$0;
            }
        }).build();
        CompilerEnvironment compilerEnvironment = CompilerEnvironment.getEnvironmentFor(PathUtil.getKotlinPathsForJpsPluginOrJpsTests(), createCompileEnvironment.1.INSTANCE$, compilerServices2);
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerEnvironment, (String)"CompilerEnvironment.getE\u2026ompilerServices\n        )");
        return compilerEnvironment;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GeneratedFile> getGeneratedFiles(ModuleChunk chunk, OutputItemsCollectorImpl outputItemCollector) {
        HashMap<File, ModuleBuildTarget> sourceToTarget = new HashMap<File, ModuleBuildTarget>();
        if (chunk.getTargets().size() > 1) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                for (File file : KotlinSourceFileCollector.getAllKotlinSourceFiles(target)) {
                    sourceToTarget.put(file, target);
                }
            }
        }
        ArrayList<GeneratedFile> result = new ArrayList<GeneratedFile>();
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        for (SimpleOutputItem outputItem : outputItemCollector.getOutputs()) {
            File target;
            File file;
            File file2;
            File outputFile;
            Collection<File> sourceFiles;
            block13: {
                void destination;
                void $receiver;
                Object it;
                Iterable $receiver2;
                block12: {
                    sourceFiles = outputItem.getSourceFiles();
                    outputFile = outputItem.getOutputFile();
                    file2 = (File)KotlinPackage.firstOrNull((Iterable)sourceFiles);
                    if (file2 == null) break block12;
                    File file3 = file2;
                    it = (File)((Object)$receiver2);
                    file2 = (ModuleBuildTarget)sourceToTarget.get(it);
                    if (file2 != null) break block13;
                }
                $receiver2 = chunk.getTargets();
                it = $receiver2;
                Collection collection = new ArrayList();
                for (Object element : $receiver) {
                    boolean bl;
                    ModuleBuildTarget it2 = (ModuleBuildTarget)element;
                    if (it2.getOutputDir() != null) {
                        void $receiver3;
                        File it3;
                        File file4 = it3 = (File)$receiver3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"it");
                        bl = IoPackage.startsWith((File)outputFile, (File)file4);
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    destination.add(element);
                }
                file2 = file = (ModuleBuildTarget)KotlinPackage.singleOrNull((List)((List)destination));
            }
            if (file2 == null) {
                file = target = representativeTarget;
            }
            if (KotlinPackage.endsWith$default((String)outputFile.getName(), (String)".class", (boolean)false, (int)2)) {
                File file5 = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"target");
                Collection<File> collection = sourceFiles;
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sourceFiles");
                File file6 = outputFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"outputFile");
                result.add(new GeneratedJvmClass((ModuleBuildTarget)file5, collection, file6));
                continue;
            }
            File file7 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"target");
            Collection<File> collection = sourceFiles;
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sourceFiles");
            File file8 = outputFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"outputFile");
            result.add(new GeneratedFile((ModuleBuildTarget)file7, collection, file8));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateJavaMappings(ModuleChunk chunk, boolean compilationErrors, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MultiMap<ModuleBuildTarget, File> filesToCompile, List<? extends GeneratedJvmClass> generatedClasses) {
        Collection collection;
        Function2<GeneratedJvmClass, Mappings, Collection<? extends File>> getOldSourceFiles$ = new Function2<GeneratedJvmClass, Mappings, Collection<? extends File>>(filesToCompile, dirtyFilesHolder){
            final /* synthetic */ MultiMap $filesToCompile;
            final /* synthetic */ DirtyFilesHolder $dirtyFilesHolder;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<File> invoke(@NotNull GeneratedJvmClass generatedClass, @NotNull Mappings previousMappings) {
                List list;
                void destination;
                void $receiver;
                void $receiver2;
                Intrinsics.checkParameterIsNotNull((Object)generatedClass, (String)"generatedClass");
                Intrinsics.checkParameterIsNotNull((Object)previousMappings, (String)"previousMappings");
                if (!KotlinPackage.endsWith$default((String)generatedClass.getOutputFile().getName(), (String)(PackageClassUtils.PACKAGE_CLASS_NAME_SUFFIX + ".class"), (boolean)false, (int)2)) {
                    return KotlinPackage.emptySet();
                }
                LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
                if (!KotlinClassHeaderKt.isCompatiblePackageFacadeKind((KotlinClassHeader)kotlinClass.getClassHeader())) {
                    return KotlinPackage.emptySet();
                }
                String classInternalName = JvmClassName.byClassId((ClassId)kotlinClass.getClassId()).getInternalName();
                Collection oldClassSources = previousMappings.getClassSources(previousMappings.getName(classInternalName));
                if (oldClassSources == null) {
                    return KotlinPackage.emptySet();
                }
                THashSet sources = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                sources.addAll(oldClassSources);
                sources.removeAll(this.$filesToCompile.get((Object)generatedClass.getTarget()));
                Iterable iterable = this.$dirtyFilesHolder.getRemovedFiles((BuildTarget)generatedClass.getTarget());
                THashSet tHashSet = sources;
                void var8_9 = $receiver2;
                Collection collection = new ArrayList<E>(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                for (T item : $receiver) {
                    void it;
                    String string = (String)item;
                    list = destination;
                    File file = new File((String)it);
                    list.add(file);
                }
                list = (List)destination;
                tHashSet.removeAll((Collection)list);
                return (Collection)sources;
            }
            {
                this.$filesToCompile = multiMap;
                this.$dirtyFilesHolder = dirtyFilesHolder;
                super(2);
            }
        };
        if (!IncrementalCompilation.ENABLED) {
            return;
        }
        Mappings previousMappings = context.getProjectDescriptor().dataManager.getMappings();
        Mappings delta = previousMappings.createDelta();
        Callbacks.Backend callback = delta.getCallback();
        for (GeneratedJvmClass generatedJvmClass : generatedClasses) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            File outputFile = generatedJvmClass.getOutputFile();
            LocalFileKotlinClass outputClass = generatedJvmClass.getOutputClass();
            Mappings mappings = previousMappings;
            Intrinsics.checkExpressionValueIsNotNull((Object)mappings, (String)"previousMappings");
            List allSourcesIncludingOld = KotlinPackage.plus(getOldSourceFiles$.invoke(generatedJvmClass, mappings), (Iterable)generatedJvmClass.getSourceFiles());
            Iterable iterable = allSourcesIncludingOld;
            String string = FileUtil.toSystemIndependentName((String)outputFile.getAbsolutePath());
            Callbacks.Backend backend = callback;
            void var17_18 = $receiver2;
            Collection collection2 = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                File file = (File)item;
                list = destination;
                String string2 = FileUtil.toSystemIndependentName((String)it.getAbsolutePath());
                list.add(string2);
            }
            list = (List)destination;
            backend.associate(string, (Collection)list, new ClassReader(outputClass.getFileContents()));
        }
        Collection collection3 = filesToCompile.values();
        if (compilationErrors) {
            collection = KotlinPackage.listOf();
        } else {
            Collection collection4 = collection3;
            collection = collection4;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"allCompiled");
        }
        Collection compiledInThisRound = collection;
        JavaBuilderUtil.updateMappings((CompileContext)context, (Mappings)delta, dirtyFilesHolder, (ModuleChunk)chunk, (Collection)collection3, (Collection)compiledInThisRound);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerOutputItems(ModuleLevelBuilder.OutputConsumer outputConsumer, List<? extends GeneratedFile> generatedFiles) {
        for (GeneratedFile generatedFile : generatedFiles) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = generatedFile.getSourceFiles();
            File file = generatedFile.getOutputFile();
            BuildTarget buildTarget = (BuildTarget)generatedFile.getTarget();
            ModuleLevelBuilder.OutputConsumer outputConsumer2 = outputConsumer;
            void var6_6 = $receiver2;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                File file2 = (File)item;
                list = destination;
                String string = it.getPath();
                list.add(string);
            }
            list = (List)destination;
            outputConsumer2.registerOutputFile(buildTarget, file, (Collection)list);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ChangesInfo updateKotlinIncrementalCache(boolean compilationErrors, Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> incrementalCaches, List<? extends GeneratedFile> generatedFiles) {
        void changesInfo;
        Ref.ObjectRef $receiver;
        Iterable iterable = incrementalCaches.values();
        for (Object element : $receiver) {
            IncrementalCacheImpl it = (IncrementalCacheImpl)element;
            it.saveCacheFormatVersion();
        }
        if (!IncrementalCompilation.ENABLED) {
            return ChangesInfo.Companion.getNO_CHANGES();
        }
        $receiver = new Ref.ObjectRef();
        $receiver.element = ChangesInfo.Companion.getNO_CHANGES();
        for (GeneratedFile generatedFile : generatedFiles) {
            ChangesInfo changesInfo2;
            IncrementalCacheImpl ic;
            if (incrementalCaches.get(generatedFile.getTarget()) == null) {
                Intrinsics.throwNpe();
            }
            if (generatedFile instanceof GeneratedJvmClass) {
                changesInfo2 = ic.saveFileToCache((GeneratedJvmClass)generatedFile);
            } else {
                if (!this.isModuleMappingFile(generatedFile.getOutputFile())) continue;
                changesInfo2 = ic.saveModuleMappingToCache(generatedFile.getSourceFiles(), generatedFile.getOutputFile());
            }
            ChangesInfo newChangesInfo = changesInfo2;
            changesInfo.element = ((ChangesInfo)changesInfo.element).plus(newChangesInfo);
        }
        if (!compilationErrors) {
            Iterable iterable2 = incrementalCaches.values();
            for (GeneratedFile element : iterable2) {
                IncrementalCacheImpl it = (IncrementalCacheImpl)((Object)element);
                ChangesInfo newChangesInfo = it.clearCacheForRemovedClasses();
                changesInfo.element = ((ChangesInfo)changesInfo.element).plus(newChangesInfo);
            }
        }
        return (ChangesInfo)changesInfo.element;
    }

    private final boolean isModuleMappingFile(File $receiver) {
        return Intrinsics.areEqual((Object)IoPackage.getExtension((File)$receiver), (Object)ModuleMapping.Companion.getMAPPING_FILE_EXT()) && Intrinsics.areEqual((Object)$receiver.getParentFile().getName(), (Object)"META-INF");
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl compileToJs(ModuleChunk chunk, CommonCompilerArguments commonArguments, CompilerEnvironment environment, Map<TargetId, IncrementalCache> incrementalCaches, MessageCollectorAdapter messageCollector, JpsProject project) {
        OutputItemsCollectorImpl outputItemCollector = new OutputItemsCollectorImpl();
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        if (chunk.getModules().size() > 1) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = chunk.getModules();
            StringBuilder stringBuilder = new StringBuilder().append("Circular dependencies are not supported. The following JS modules depend on each other: ");
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.WARNING;
            MessageCollectorAdapter messageCollectorAdapter = messageCollector;
            void var10_14 = $receiver2;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                JpsModule jpsModule = (JpsModule)item;
                list = destination;
                String string = it.getName();
                list.add(string);
            }
            list = (List)destination;
            messageCollectorAdapter.report(compilerMessageSeverity, stringBuilder.append(KotlinPackage.joinToString$default((Iterable)list, (String)", ", null, null, (int)0, null, null, (int)62)).append(". ").append("Kotlin is not compiled for these modules").toString(), CompilerMessageLocation.Companion.getNO_LOCATION());
            return null;
        }
        List<File> sourceFiles = KotlinSourceFileCollector.getAllKotlinSourceFiles(representativeTarget);
        if (sourceFiles.isEmpty()) {
            return null;
        }
        File outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(representativeTarget);
        String moduleName = representativeTarget.getModule().getName();
        File file = outputDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
        String string = moduleName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleName");
        File outputFile = JpsJsModuleUtils.getOutputFile(file, string);
        ModuleBuildTarget moduleBuildTarget = representativeTarget;
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
        List<String> libraryFiles = JpsJsModuleUtils.INSTANCE$.getLibraryFilesAndDependencies(moduleBuildTarget);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        K2JSCompilerArguments k2JsArguments = JpsKotlinCompilerSettings.getK2JsCompilerArguments(project);
        KotlinCompilerRunner.runK2JsCompiler(commonArguments, k2JsArguments, compilerSettings, messageCollector, environment, incrementalCaches, outputItemCollector, (Collection<File>)sourceFiles, libraryFiles, outputFile);
        return outputItemCollector;
    }

    private final void copyJsLibraryFilesIfNeeded(ModuleChunk chunk, JpsProject project) {
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        File outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(representativeTarget);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        if (compilerSettings.getCopyJsLibraryFiles()) {
            String outputLibraryRuntimeDirectory = new File(outputDir, compilerSettings.getOutputDirectoryForJsLibraryFiles()).getAbsolutePath();
            ArrayList libraryFilesToCopy = KotlinPackage.arrayListOf((Object[])new String[0]);
            ModuleBuildTarget moduleBuildTarget = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
            JpsJsModuleUtils.INSTANCE$.getLibraryFiles(moduleBuildTarget, libraryFilesToCopy);
            List list = libraryFilesToCopy;
            String string = outputLibraryRuntimeDirectory;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputLibraryRuntimeDirectory");
            LibraryUtils.copyJsFilesFromLibraries(list, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl compileToJvm(Set<File> allCompiledFiles, ModuleChunk chunk, CommonCompilerArguments commonArguments, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, CompilerEnvironment environment, Map<TargetId, IncrementalCache> incrementalCaches, MultiMap<ModuleBuildTarget, File> filesToCompile, MessageCollectorAdapter messageCollector) {
        void destination;
        void $receiver;
        void $receiver2;
        List<File> removedFilesInTarget;
        Collection it;
        Object object;
        MessageCollectorAdapter messageCollectorAdapter;
        Object object2;
        Object object3;
        OutputItemsCollectorImpl outputItemCollector = new OutputItemsCollectorImpl();
        if (chunk.getModules().size() > 1) {
            void destination2;
            void $receiver3;
            void $receiver4;
            Iterable iterable = chunk.getModules();
            object3 = new StringBuilder().append("Circular dependencies are only partially supported. The following modules depend on each other: ");
            object2 = CompilerMessageSeverity.WARNING;
            messageCollectorAdapter = messageCollector;
            void var12_15 = $receiver4;
            Collection collection = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver4, (int)10));
            for (Object item : $receiver3) {
                JpsModule jpsModule = (JpsModule)item;
                object = destination2;
                String string = it.getName();
                object.add(string);
            }
            object = (List)destination2;
            messageCollectorAdapter.report((CompilerMessageSeverity)((Object)object2), ((StringBuilder)object3).append(KotlinPackage.joinToString$default((Iterable)((Iterable)object), (String)", ", null, null, (int)0, null, null, (int)62)).append(". ").append("Kotlin will compile them, but some strange effect may happen").toString(), CompilerMessageLocation.Companion.getNO_LOCATION());
        }
        Collection collection = filesToCompile.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"filesToCompile.values()");
        allCompiledFiles.addAll(collection);
        Set<ModuleBuildTarget> processedTargetsWithRemoved = KotlinBuilderKt.getProcessedTargetsWithRemovedFilesContainer(context);
        int totalRemovedFiles = 0;
        for (ModuleBuildTarget target : chunk.getTargets()) {
            removedFilesInTarget = KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, target);
            if (removedFilesInTarget.isEmpty()) continue;
            ModuleBuildTarget moduleBuildTarget = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            if (!processedTargetsWithRemoved.add(moduleBuildTarget)) continue;
            totalRemovedFiles += removedFilesInTarget.size();
        }
        File moduleFile = KotlinBuilderModuleScriptGenerator.generateModuleDescription(context, chunk, filesToCompile, totalRemovedFiles != 0);
        if (moduleFile == null) {
            void destination3;
            void $receiver5;
            void $receiver6;
            Iterable iterable = filesToCompile.keySet();
            object2 = new StringBuilder().append("Not compiling, because no files affected: ");
            messageCollectorAdapter = Companion.getLOG();
            removedFilesInTarget = $receiver6;
            it = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver6, (int)10));
            for (Object item : $receiver5) {
                void it2;
                ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item;
                object3 = destination3;
                object = it2.getPresentableName();
                object3.add(object);
            }
            object3 = (List)destination3;
            messageCollectorAdapter.debug(((StringBuilder)object2).append(KotlinPackage.join$default((Iterable)((Iterable)object3), null, null, null, (int)0, null, (int)31)).toString());
            return null;
        }
        JpsProject project = context.getProjectDescriptor().getProject();
        K2JVMCompilerArguments k2JvmArguments = JpsKotlinCompilerSettings.getK2JvmCompilerArguments(project);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        Iterable iterable = filesToCompile.keySet();
        object2 = new StringBuilder().append("Compiling to JVM " + filesToCompile.values().size() + " files").append(totalRemovedFiles == 0 ? "" : " (" + totalRemovedFiles + " removed files)").append(" in ");
        messageCollectorAdapter = Companion.getLOG();
        void item = $receiver2;
        Collection it2 = new ArrayList(KotlinPackage.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item2 : $receiver) {
            void it3;
            ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item2;
            object3 = destination;
            object = it3.getPresentableName();
            object3.add(object);
        }
        object3 = (List)destination;
        messageCollectorAdapter.debug(((StringBuilder)object2).append(KotlinPackage.join$default((Iterable)((Iterable)object3), null, null, null, (int)0, null, (int)31)).toString());
        KotlinCompilerRunner.runK2JvmCompiler(commonArguments, k2JvmArguments, compilerSettings, messageCollector, environment, incrementalCaches, moduleFile, outputItemCollector);
        moduleFile.delete();
        return outputItemCollector;
    }

    public void buildFinished(@Nullable CompileContext context) {
        this.statisticsLogger.reportTotal();
    }

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"X\u0006)I1i\\7qC:LwN\u001c\u0006\u000e\u0017>$H.\u001b8Ck&dG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015\u0015\u0011W/\u001b7e\u0015\r\te.\u001f\u0006\u0014\u0017>#F*\u0013(`\u0005VKE\nR#S?:\u000bU*\u0012\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\fhKR\\u\n\u0016'J\u001d~\u0013U+\u0013'E\u000bJ{f*Q'F\u0015\rauj\u0012\u0006\u0007\u0019><w-\u001a:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001dy\u0007/\u001a8ba&T!\u0002Z5bO:|7\u000f^5d\u0015]Yw\u000e\u001e7j]:Rg/\u001c\u0018QY\u0006$hm\u001c:n)f\u0004XM\u0003\u0004hKRduj\u0012\u0006\u000f\u0019>{5*\u0016)`)J\u000b5iS#S\u0015]Q\u0005o]#mK6,g\u000e^\"iS2$'k\u001c7f\u0005\u0006\u001cXMC\u0003n_\u0012,GN\u0003\u0002fq*\u0001\"\n]:TS6\u0004H.Z#mK6,g\u000e\u001e\u0006\u000e\u0019>|7.\u001e9Ue\u0006\u001c7.\u001a:\u000b\u0017%t7M]3nK:$\u0018\r\u001c\u0006\u000bG>l\u0007o\u001c8f]R\u001c(\"E4fi2{ujS+Q?R\u0013\u0016iQ&F%B\u000e!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001C\u0004\u0011\u000fa\u0001!B\u0002\u0005\b!%A\u0002A\u0003\u0002\u0011\u0015)!\u0001B\u0003\t\f\u0015\u0011A1\u0002E\u0005\u000b\u0005Ay!\u0002\u0002\u0005\u000e!AQA\u0001\u0003\b\u0011#)!\u0001b\u0004\t\u0013\u0015\u0019A\u0001\u0003\u0005\b\u0019\u0001)!\u0001\u0002\u0005\t\u000f\u0015\u0011A\u0011\u0001E\u0003\u000b\t!\u0019\u0002c\u0006\u0006\u0005\u0011Q\u0001\u0002D\u0003\u0004\t+A1\u0002\u0004\u0001\u0006\u0007\u0011Q\u0001\u0012\u0004\u0007\u0001\u000b\t!\u0011\u0001c\u0007\u0006\u0005\u0011a\u0001BD\u0003\u0004\t3AQ\u0002\u0004\u0001\u0006\u0005\u0011U\u0001b\u0003\u0003D\u00041\u0019\u0011dA\u0003\u0002\u0011\u0011AB!L\t\u0005GRAB!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\u0013\u0015!A\u0001B\u0005\u0002\u0011\u0019a\t!D\u0002\u0005\r%\t\u0001BB\u0017\u0018\t\r$\u0001TB\u0011\n\u000b\u0005A\t\u0002e\u0005\u0016\t\u0015\t\u0001\u0012\u0003G\u00011#A\n\"V\u0002\n\u000b\u0011!i!C\u0001\t\u00131\u0005Qb\u0001\u0003\u000b\u0013\u0005A\u0011\"\f\u000f\u0005G\u0012A*\"\t\b\u0006\u0003!Y\u0011BC\u0005\n\u000b\u0005A9\"C\u0003\u0005\u0002%\u0019Q!\u0001\u0005\u000e15A:\u0002G\u0006V\u0007%)A\u0001\"\u0006\n\u0003!mA\u0012A\u0007\u0004\t;I\u0011\u0001c\u00076\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final String getKOTLIN_BUILDER_NAME() {
            return KOTLIN_BUILDER_NAME;
        }

        @NotNull
        public final JpsElementChildRoleBase<JpsSimpleElement<? extends LookupTracker>> getLOOKUP_TRACKER() {
            return LOOKUP_TRACKER;
        }

        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"C\b)\u00012\t[1oO\u0016\u001c\bK]8dKN\u001cxN\u001d\u0006\u000e\u0017>$H.\u001b8Ck&dG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015\u0015\u0011W/\u001b7e\u0015\r\te.\u001f\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000f\r|g\u000e^3yi*q1i\\7qS2,7i\u001c8uKb$(bC5oGJ,W.\u001a8uC2TQa\u00195v].T1\"T8ek2,7\t[;oW*\u0001\u0012\r\u001c7D_6\u0004\u0018\u000e\\3e\r&dWm\u001d\u0006\u000b\u001bV$\u0018M\u00197f'\u0016$(\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\u0007G\u0006\u001c\u0007.Z:\u000b\t1K7\u000f\u001e\u0006\u0015\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7\u000b\tU$\u0018\u000e\u001c\u0006\u0004'\u0016$(bE4fi\u0006cGnQ8na&dW\r\u001a$jY\u0016\u001c(\"C4fi\u000e\u000b7\r[3t\u0015!9W\r^\"ik:\\'BC4fi\u000e{g\u000e^3yi*q\u0001O]8dKN\u001c8\t[1oO\u0016\u001c(bC2iC:<Wm]%oM>T1b\u00115b]\u001e,7/\u00138g_*!QK\\5u\u0015M\u0011XmY8na&dW-\u0012<fef$\b.\u001b8h\u0015A\u0011XmY8na&dW-\u00138mS:,GMC\u000esK\u000e|W\u000e]5mK>#\b.\u001a:B]\u0012$U\r]3oI\u0016tGo\u001d\u0006\u001ce\u0016\u001cw.\u001c9jY\u0016|E\u000f[3s\u0017>$H.\u001b8J]\u000eCWO\\6\u000b!\u0011|\u0007K]8dKN\u001c8\t[1oO\u0016\u001c\b8\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0005\u0011\u0005\u0001RA\u0003\u0003\t\u0013AY!B\u0002\u0005\u000b!)A\u0002A\u0003\u0004\t\u0013Ai\u0001\u0004\u0001\u0006\u0007\u0011\u001d\u0001r\u0002\u0007\u0001\u000b\u0005A\t\"\u0002\u0002\u0005\u000f!IQa\u0001C\b\u0011!a\u0001!B\u0002\u0005\b!QA\u0002A\u0003\u0003\t\u0007AY!B\u0002\u0005\u0013!UA\u0002A\u0003\u0003\t\u0015AQ!\u0002\u0002\u0005\n!5QA\u0001\u0003\b\u0011-)!\u0001B\u0006\t\u0018\u0015\u0011Aa\u0003\u0005\u000b\u000b\r!\u0011\u0002C\b\r\u0001\u0015\u0019Aq\u0001E\u0010\u0019\u0001)!\u0001B\u0005\t\u001f\u0011\u0019AbA\r\u0004\u000b\u0005AA\u0001\u0007\u0003.+\u0011\u0019G\u0001G\u0004\"\u0011\u0015\t\u0001RB\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011a5Qk\u0001\u0005\u0006\u0007\u00119\u0011\"\u0001E\f\u001b\r!A\"C\u0001\t\u00185*Ba\u0019\u0003\u0019\u0014\u0005BQ!\u0001E\t\u0013\u0011I1!B\u0001\t\u0014aM\u0001\u0014C+\u0004\u0011\u0015\u0019A1C\u0005\u0002\u00111i1\u0001\"\u0007\n\u0003!aQ\u0006\u0005\u0003d\ta1\u0011eA\u0003\u0002\u0011\u0019Ab!V\u0002\t\u000b\r!a!C\u0001\t\u00165\u0019A!D\u0005\u0002\u0011+i\u0003\u0003B2\u00051\u0013\t3!B\u0001\t\fa-Qk\u0001\u0005\u0006\u0007\u0011%\u0011\"\u0001\u0005\u000b\u001b\r!Y\"C\u0001\t\u00155*Ba\u0001\r\u000f;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u0001\u0012\u0004M\r!\u000e\u0001\u0011eA\u0003\u0002\u00115AR\"U\u0002\u0006\t9I\u0011\u0001\u0002\u0001\u000e\u0003!mQV\u0003\u0003\u00021A\t3!B\u0001\t\u001bai\u0011kA\u0002\u0005!%\tA\u0001AW\u000b\t\u0005A\n#I\u0002\u0006\u0003!i\u0001$D)\u0004\u0007\u0011\u0005\u0012\"\u0001\u0003\u0001[+!\u0011\u0001G\t\"\u0007\u0015\t\u0001\"\u0004\r\u000e#\u000e\u0019A!E\u0005\u0002\t\u0001i+\u0002B\u0001\u0019$\u0005\u001aQ!\u0001\u0005\u000e15\t6a\u0001C\u0012\u0013\u0005!\u0001!,\t\u0005\u0003U\u0019Q!\u0001E\r13A\"#I\u0002\u0006\u0003!i\u0001$D)\u0004\u000b\u0011\u0011\u0012\"\u0001\u0003\u0001\u001b\u0005AY\"\u000ea\u0001\u000b}\"1\u001d\u0001\r\u0005;\u001f!\u0001\u0001#\u0003\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\ra1\u0001k!\u0001\u001e\u001a\u0011\u0001\u0001bB\u0007\t\u000b\u0005Ai!\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0003\r\t1\u001b\u00016!AO\r\t\u0001A\u0019\"\u0004\u0005\u0006\u0003!E\u0011\u0002B\u0005\u0004\u000b\u0005A\u0019\u0002g\u0005\u0019\u0012A\u001b\u0019!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u0017\u0011!\u0011\"\u0001\u0003\u0001\u001b\u0005A!\"D\u0001\t\u00165\t\u0001rC\u0007\u0002\u00111\u0001"})
    public static final class ChangesProcessor {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final CompileContext context;
        @NotNull
        private final ModuleChunk chunk;
        @NotNull
        private final Set<File> allCompiledFiles;
        @NotNull
        private final List<? extends IncrementalCacheImpl> caches;

        static {
            $kotlinClass = Reflection.createKotlinClass(ChangesProcessor.class);
        }

        public final void processChanges(@NotNull ChangesInfo changesInfo) {
            Intrinsics.checkParameterIsNotNull((Object)changesInfo, (String)"changesInfo");
            this.doProcessChanges(changesInfo);
        }

        private final void doProcessChanges(ChangesInfo $receiver) {
            if ($receiver.getInlineAdded()) {
                this.recompileEverything();
                return;
            }
            if ($receiver.getConstantsChanged()) {
                this.recompileOtherAndDependents();
            } else if ($receiver.getProtoChanged()) {
                this.recompileOtherKotlinInChunk();
            }
            if ($receiver.getInlineChanged()) {
                this.recompileInlined();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void recompileInlined() {
            for (IncrementalCacheImpl incrementalCacheImpl : this.caches) {
                void $receiver;
                Collection<File> filesToReinline = incrementalCacheImpl.getFilesToReinline();
                Iterable iterable = filesToReinline;
                for (Object element : $receiver) {
                    File it = (File)element;
                    FSOperations.markDirty((CompileContext)this.getContext(), (CompilationRound)CompilationRound.NEXT, (File)it);
                }
            }
        }

        private final void recompileEverything() {
            this.allCompiledFiles.clear();
            FSOperations.markDirtyRecursively((CompileContext)this.context, (ModuleChunk)this.chunk);
        }

        private final void recompileOtherAndDependents() {
            try {
                Class.forName("org.jetbrains.jps.incremental.fs.CompilationRound");
                FSOperations.markDirtyRecursively((CompileContext)this.context, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.chunk, (FileFilter)new FileFilter(this){
                    final /* synthetic */ ChangesProcessor this$0;

                    public final boolean accept(File file) {
                        return this.this$0.getAllCompiledFiles().contains(file) ^ true;
                    }
                    {
                        this.this$0 = changesProcessor;
                    }
                });
            }
            catch (ClassNotFoundException e) {
                this.recompileEverything();
            }
        }

        private final void recompileOtherKotlinInChunk() {
            FSOperations.markDirty((CompileContext)this.context, (ModuleChunk)this.chunk, (FileFilter)new FileFilter(this){
                final /* synthetic */ ChangesProcessor this$0;

                public final boolean accept(File file) {
                    return KotlinSourceFileCollector.isKotlinSourceFile(file) && this.this$0.getAllCompiledFiles().contains(file) ^ true;
                }
                {
                    this.this$0 = changesProcessor;
                }
            });
        }

        @NotNull
        public final CompileContext getContext() {
            return this.context;
        }

        @NotNull
        public final ModuleChunk getChunk() {
            return this.chunk;
        }

        @NotNull
        public final Set<File> getAllCompiledFiles() {
            return this.allCompiledFiles;
        }

        @NotNull
        public final List<IncrementalCacheImpl> getCaches() {
            return this.caches;
        }

        public ChangesProcessor(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull Set<File> allCompiledFiles, @NotNull List<? extends IncrementalCacheImpl> caches2) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
            Intrinsics.checkParameterIsNotNull(allCompiledFiles, (String)"allCompiledFiles");
            Intrinsics.checkParameterIsNotNull(caches2, (String)"caches");
            this.context = context;
            this.chunk = chunk;
            this.allCompiledFiles = allCompiledFiles;
            this.caches = caches2;
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"Z\u0006)9R*Z:tC\u001e,7i\u001c7mK\u000e$xN]!eCB$XM\u001d\u0006\u000e\u0017>$H.\u001b8Ck&dG-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015\u0015\u0011W/\u001b7e\u0015AiUm]:bO\u0016\u001cu\u000e\u001c7fGR|'OC\u0002dY&TaaY8n[>t'\u0002C7fgN\fw-Z:\u000b\rqJg.\u001b;?\u0015\u001d\u0019wN\u001c;fqRTabQ8na&dWmQ8oi\u0016DHOC\u0006j]\u000e\u0014X-\\3oi\u0006d'\u0002B6j]\u0012T\u0001b]3wKJLG/\u001f\u0006\u0018\u0007>l\u0007/\u001b7fe6+7o]1hKN+g/\u001a:jifTAaS5oI*a!)^5mI6+7o]1hK*\t\")^5mI6+7o]1hK\u0012Z\u0015N\u001c3\u000b-I,g\u000eZ3s\u0019>\u001c\u0017\r^5p]&3g*Z3eK\u0012T\u0001\u0002\\8dCRLwN\u001c\u0006\u0018\u0007>l\u0007/\u001b7fe6+7o]1hK2{7-\u0019;j_:Taa\u0015;sS:<'\u0002\u00026bm\u0006TA\u0001\\1oO*1!/\u001a9peRTq!\\3tg\u0006<WM\u0003\u0003V]&$H8\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\u0011A!\u0001\u0005\u0005\u000b\t!9\u0001#\u0003\u0006\u0005\u0011!\u0001\"B\u0003\u0004\t\u0013A9\u0001\u0004\u0001\u0006\u0005\u0011\u0005\u0001RA\u0003\u0003\t\u0017Aq!B\u0002\u0005\r!5A\u0002A\u0003\u0003\t\u0019Ai!B\u0002\u0005\n!EA\u0002A\u0003\u0003\t\u0019AQ!B\u0002\u0005\u0011!MA\u0002A\u0003\u0004\t#A\u0011\u0002\u0004\u0001\u0006\u0005\u0011A\u0001BC\u0003\u0003\t\u0013A\t\"B\u0002\u0005\n!]A\u0002A\u0003\u0002\u0011\t)1\u0001B\u0006\t\u00191\u0001Q!\u0001E\r\u000b\t!A\u0002C\u0007\u0006\u0005\u0011e\u0001\u0002D\u0003\u0003\t\u0013A9\"B\u0002\u0005\u0017!uA\u0002\u0001\u0003\u0004\u0019\rI2!B\u0001\t\u000ba)Q\u0006\u0004\u0003b\ta1\u0011eA\u0003\u0002\u0011\u001bAj!V\u0002\u0005\u000b\r!a!C\u0001\t\u000f5*B!\u0001M\b;\u001f!\u0001\u0001\u0003\u0005\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\u0001\u0011eA\u0003\u0002\u0011%A\u0012\"U\u0002\u0006\t\u001fI\u0011\u0001c\u0005\u000e\u0003!QQ&\u0006\u0003\u00021+iz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001E\u000b1+\u00016\u0001A\u0011\u0004\u000b\u0005A9\u0002g\u0006R\u0007\u0015!)\"C\u0001\t\u001b5\t\u00012D\u0017+\t-AZ\"h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011\u001fAz\u0001U\u0002\u0001;\u001f!\u0001\u0001\u0003\b\u000e\u0007\u0015\t\u0001r\u0003M\f!\u000e\u0005Qt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0016aU\u0001kA\u0001\"\u0007\u0015\t\u0001B\u0004\r\u000f#\u000eIA1D\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0006\u000e\u0003!iQ\"\u0001E\u000ek[)Y\u0003Br\u00011\u0017iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001E\u00071\u001b\u00016\u0001A\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007\u0015!Y!C\u0001\u0005\u00015\t\u0001b\u0002"})
    public static final class MessageCollectorAdapter
    implements MessageCollector {
        public static final /* synthetic */ KClass $kotlinClass;
        private final CompileContext context;

        static {
            $kotlinClass = Reflection.createKotlinClass(MessageCollectorAdapter.class);
        }

        @Override
        public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            String prefix = "";
            if (Intrinsics.areEqual((Object)((Object)severity), (Object)((Object)CompilerMessageSeverity.EXCEPTION))) {
                prefix = CompilerRunnerConstants.INTERNAL_ERROR_PREFIX;
            }
            this.context.processMessage((BuildMessage)new CompilerMessage(CompilerRunnerConstants.KOTLIN_COMPILER_NAME, this.kind(severity), prefix + message + this.renderLocationIfNeeded(location), location.getPath(), (long)(-1), (long)(-1), (long)(-1), (long)location.getLine(), (long)location.getColumn()));
        }

        private final String renderLocationIfNeeded(CompilerMessageLocation location) {
            if (Intrinsics.areEqual((Object)location, (Object)CompilerMessageLocation.Companion.getNO_LOCATION())) {
                return "";
            }
            String pathname = "" + location.getPath();
            return new File(pathname).exists() ? "" : " (" + location + ")";
        }

        private final BuildMessage.Kind kind(CompilerMessageSeverity severity) {
            BuildMessage.Kind kind;
            CompilerMessageSeverity compilerMessageSeverity = severity;
            if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.INFO))) {
                kind = BuildMessage.Kind.INFO;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.ERROR)) || Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.EXCEPTION))) {
                kind = BuildMessage.Kind.ERROR;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.WARNING))) {
                kind = BuildMessage.Kind.WARNING;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.LOGGING))) {
                kind = BuildMessage.Kind.PROGRESS;
            } else {
                throw (Throwable)new IllegalArgumentException("Unsupported severity: " + (Object)((Object)severity));
            }
            return kind;
        }

        public MessageCollectorAdapter(@NotNull CompileContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }
}

