/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.io.IoPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.java.JpsAnnotationRootType;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.modules.KotlinModuleXmlBuilder;

public class KotlinBuilderModuleScriptGenerator {
    @Nullable
    public static File generateModuleDescription(CompileContext context, ModuleChunk chunk, MultiMap<ModuleBuildTarget, File> sourceFiles, boolean hasRemovedFiles) throws IOException, ProjectBuildException {
        KotlinModuleXmlBuilder builder = new KotlinModuleXmlBuilder();
        boolean noSources = true;
        HashSet<File> outputDirs = new HashSet<File>();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            outputDirs.add(KotlinBuilderModuleScriptGenerator.getOutputDirSafe(target));
        }
        ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(target);
            ArrayList<File> moduleSources = new ArrayList<File>(IncrementalCompilation.ENABLED ? sourceFiles.get((Object)target) : KotlinSourceFileCollector.getAllKotlinSourceFiles(target));
            if (moduleSources.size() > 0 || hasRemovedFiles) {
                noSources = false;
                if (logger.isEnabled()) {
                    logger.logCompiledFiles(moduleSources, "Kotlin Builder", "Compiling files:");
                }
            }
            BuildTargetType targetType = target.getTargetType();
            assert (targetType instanceof JavaModuleBuildTargetType);
            builder.addModule(target.getId(), outputDir.getAbsolutePath(), moduleSources, KotlinBuilderModuleScriptGenerator.findSourceRoots(context, target), KotlinBuilderModuleScriptGenerator.findClassPathRoots(target), KotlinBuilderModuleScriptGenerator.findAnnotationRoots(target), (JavaModuleBuildTargetType)targetType, outputDirs);
        }
        if (noSources) {
            return null;
        }
        File scriptFile = File.createTempFile("kjps", StringUtil.sanitizeJavaIdentifier((String)chunk.getName()) + ".script.xml");
        FileUtil.writeToFile((File)scriptFile, (String)((Object)builder.asText()).toString());
        return scriptFile;
    }

    @NotNull
    public static File getOutputDirSafe(@NotNull ModuleBuildTarget target) throws ProjectBuildException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "getOutputDirSafe"));
        }
        File outputDir = target.getOutputDir();
        if (outputDir == null) {
            throw new ProjectBuildException("No output directory found for " + target);
        }
        File file = outputDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "getOutputDirSafe"));
        }
        return file;
    }

    @NotNull
    private static Collection<File> findClassPathRoots(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findClassPathRoots"));
        }
        List list = ContainerUtil.filter((Collection)JpsUtils.getAllDependencies(target).classes().getRoots(), (Condition)new Condition<File>(){

            public boolean value(File file) {
                String extension;
                return file.exists() || (extension = IoPackage.getExtension((File)file)).equals("class") || extension.equals("jar");
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findClassPathRoots"));
        }
        return list;
    }

    @NotNull
    private static List<File> findSourceRoots(@NotNull CompileContext context, @NotNull ModuleBuildTarget target) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findSourceRoots"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findSourceRoots"));
        }
        List roots = context.getProjectDescriptor().getBuildRootIndex().getTargetRoots((BuildTarget)target, context);
        ArrayList result = ContainerUtil.newArrayList();
        for (JavaSourceRootDescriptor root : roots) {
            File file = root.getRootFile();
            if (!file.exists()) continue;
            result.add(file);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findSourceRoots"));
        }
        return arrayList;
    }

    @NotNull
    private static List<File> findAnnotationRoots(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findAnnotationRoots"));
        }
        LinkedHashSet<File> annotationRootFiles = new LinkedHashSet<File>();
        JpsModule module = target.getModule();
        JpsSdk sdk = module.getSdk(KotlinBuilderModuleScriptGenerator.getSdkType(module));
        if (sdk != null) {
            annotationRootFiles.addAll(sdk.getParent().getFiles((JpsOrderRootType)JpsAnnotationRootType.INSTANCE));
        }
        for (JpsLibrary library : JpsUtils.getAllDependencies(target).getLibraries()) {
            annotationRootFiles.addAll(library.getFiles((JpsOrderRootType)JpsAnnotationRootType.INSTANCE));
        }
        String extraAnnotationsPaths = System.getProperty("jps.kotlin.extra.annotation.paths");
        if (extraAnnotationsPaths != null) {
            String[] paths;
            for (String path : paths = extraAnnotationsPaths.split(";")) {
                annotationRootFiles.add(new File(path));
            }
        }
        List list = KotlinPackage.toList(annotationRootFiles);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "findAnnotationRoots"));
        }
        return list;
    }

    @NotNull
    private static JpsSdkType getSdkType(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "getSdkType"));
        }
        for (JpsDependencyElement dependency : module.getDependenciesList().getDependencies()) {
            if (!(dependency instanceof JpsSdkDependency)) continue;
            JpsSdkType jpsSdkType = ((JpsSdkDependency)dependency).getSdkType();
            if (jpsSdkType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "getSdkType"));
            }
            return jpsSdkType;
        }
        JpsJavaSdkType jpsJavaSdkType = JpsJavaSdkType.INSTANCE;
        if (jpsJavaSdkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/jps/build/KotlinBuilderModuleScriptGenerator", "getSdkType"));
        }
        return jpsJavaSdkType;
    }

    private KotlinBuilderModuleScriptGenerator() {
    }
}

