/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataOutput;
import java.io.File;
import java.util.Collection;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jps.incremental.storage.StorageHolder;
import org.jetbrains.kotlin.jps.incremental.storage.StoragePackage$sam$ValueDataAppender$ee535a34;
import org.jetbrains.kotlin.utils.Printer;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"+\n)A!)Y:jG6\u000b\u0007OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\rQ\u0007o\u001d\u0006\fS:\u001c'/Z7f]R\fGNC\u0004ti>\u0014\u0018mZ3\u000b\u0003-S!bQ8na\u0006\u0014\u0018M\u00197f\u0015\u00051&bA!os*1A(\u001b8jizR1b\u001d;pe\u0006<WMR5mK*!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'\"D6fs\u0012+7o\u0019:jaR|'OC\u0007LKf$Um]2sSB$xN\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\tU$\u0018\u000e\u001c\u0006\u0012m\u0006dW/Z#yi\u0016\u0014h.\u00197ju\u0016\u0014(\u0002\u0005#bi\u0006,\u0005\u0010^3s]\u0006d\u0017N_3s\u0015a\tG\u000e\\&fsN,\u00050[:uS:<\u0017J\\*u_J\fw-\u001a\u0006\u000b\u0007>dG.Z2uS>t'bG4fi\u0006cGnS3zg\u0016C\u0018n\u001d;j]\u001eLen\u0015;pe\u0006<WMC\u0007ti>\u0014\u0018mZ3I_2$WM\u001d\u0006\u000e'R|'/Y4f\u0011>dG-\u001a:\u000b'\u0005\u0004\b/\u001a8e\t\u0006$\u0018\rV8Ti>\u0014\u0018mZ3\u000b\u0007-,\u0017P\u0003\u0004baB,g\u000e\u001a\u0006\n\rVt7\r^5p]FR!\u0002R1uC>+H\u000f];u\u0015\u0011)f.\u001b;\u000b\t1\fgn\u001a\u0006\u0004UZl'\"\u00034v]\u000e$\u0018n\u001c8t\u0015\u0015\u0019G.Z1o\u0015\u0015\u0019Gn\\:f\u0015\u0011!W/\u001c9\u000b\rM#(/\u001b8h\u0015\u001d!W/\u001c9LKfT\u0011\u0002Z;naZ\u000bG.^3\u000b\u000bY\fG.^3\u000b\r=\u0013'.Z2u\u0015\u00151G.^:i\u0015AiW-\\8ss\u000e\u000b7\r[3t\u001f:d\u0017PC\u0004C_>dW-\u00198\u000b\u001d\u001d,GO\u0012:p[N#xN]1hK*a\u0001/\u001e;U_N#xN]1hK*\t\"/Z7pm\u00164%o\\7Ti>\u0014\u0018mZ3\u000b\u001fM$xN]1hK\u000e{g\u000e^1j]Nd A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0003\t\tA1!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\u0007)1\u0001b\u0002\t\t1\u0001Qa\u0001C\u0004\u0011\u0015a\u0001!B\u0001\t\u000f\u0015\u0011A!\u0002E\b\u000b\r!Y\u0001#\u0004\r\u0001\u0015\t\u0001\"C\u0003\u0003\t\u001bA\u0019\"\u0002\u0002\u0005\u000f!QQA\u0001C\b\u0011\u001f)1\u0001\u0002\u0005\t\u00121\u0001Qa\u0001\u0003\t\u0011-a\u0001!\u0002\u0002\u0005\f!5QA\u0001\u0003\t\u0011#)!\u0001\u0002\u0005\t\u0017\u0015\u0019Aq\u0001\u0005\r\u0019\u0001)!\u0001B\u0003\t\u0015\u0015\u0011Aq\u0003\u0005\r\u000b\r!)\u0001c\u0007\r\u0001\u0015\u0011AQ\u0001E\u000e\u000b\r!9\u0001c\b\r\u0001\u0015\u0019A1\u0002\u0005\u0011\u0019\u0001)1\u0001b\u0002\t\"1\u0001QA\u0001\u0003\u0006\u0011E)!\u0001B\b\t\t\u0015\u0011Aq\u0001E\u0012\u000b\t!\u0001\u0003\u0003\n\u0006\u0005\u0011\u0005\u0002rD\u0003\u0004\t\u000fAA\u0003\u0004\u0001\u0006\u0005\u0011y\u0001\u0002F\u0003\u0003\t=Aa#B\u0002\u0005\b!=B\u0002\u0001\u0003\u0014\u0019\r)B\u0002\u0002\u0001\t\bUIQ!\u0001\u0005\u0005\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001\r\u0005+\u001d!\t\u0001#\u0003\u0016\t\u0015\t\u0001\u0012\u0002G\u00011\u0013I2!B\u0001\t\na%Qf\u0005\u0003c\ta]\u0011%C\u0003\u0002\u0011-IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011-!#%V\u0002\u0005\u001b\r!I\"C\u0001\t\u00195BB!\u0019\u0003\u0019\u001b\u0005zQ!\u0001E\r\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004A\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0002q\u0005\u0001\u0014D+\u0004\t\u0015\u0019A!D\u0005\u0002\u00115i+\u0006\u0002\u0002\u0019\u001duEA\u0001\u0001E\u000f\u001b\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001k\u0001\u0001\u001e$\u0011\u0001\u0001bD\u0007\u000e\u000b\u0005AY\"\u0003\u0003\n\u0007\u0015\t\u0001B\u0004\r\u000f\u0013\u0011I1!B\u0001\t\u001eau\u00014\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\u000f1;\t6a\u0002\u0003\u000f\u0013\u0005!\u0001!D\u0001\t 5\t\u0001\"EW\u000b\t\rA*#I\u0002\u0006\u0003!u\u0001TD)\u0004\u0007\u0011\u0015\u0012\"\u0001\u0003\u0001[+!1\u0001G\n\"\u0007\u0015\t\u0001R\u0004M\u000f#\u000e\u0019AaE\u0005\u0002\t\u0001i+\u0002b\u0002\u0019(\u0005\u001aQ!\u0001E\u00121G\t6a\u0001C\u0014\u0013\u0005A!#\f\f\u0005%a%R\u0014\u0003\u0003\u0001\u0011;iA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001)\u0004\u0001\u0005\u001aQ!\u0001E\u00121G\t6!\u0002C\u0015\u0013\u0005A!#D\u0001\t 52BA\u0005\r\u0016;#!\u0001\u0001c\u000b\u000e\t\u0015\u0011A\u0011\u0001E\u00019\u0003\u00016\u0001A\u0011\u0004\u000b\u0005A\u0019\u0003g\tR\u0007\u0015!Q#C\u0001\t%5\t\u0001RE\u0017\u0016\t\rAj#h\u0004\u0005\u0001!9RbA\u0003\u0002\u0011MA2\u0003U\u0002\u0001C\r)\u0011\u0001#\b\u0019\u001eE\u001bQ\u0001\"\f\n\u0003\u0011\u0001Q\"\u0001C\u0001[a!!\u0001\u0007\r\u001e\u0012\u0011\u0001\u0001RD\u0007\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001A\u001b\u0001!I\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001G\u00019\u0003\t6!\u0002\u0003\u0019\u0013\u0005A)#D\u0001\t 5\u000eCA\u0001M\u0019;#!\u0001\u0001#\b\u000e\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001\u00016\u0001AO\t\t\u0001AY#\u0004\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u0001!\u000e\u0005\u0011eA\u0003\u0002\u0011;Aj\"U\u0002\b\tcI\u0011\u0001\u0002\u0001\u000e\u0003!}Q\"\u0001E\u0013[Y!!\u0001G\r\u001e\u0012\u0011\u0001\u0001RD\u0007\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001A\u001b\u0001!I\u0002\u0006\u0003!u\u0001TD)\u0004\u000b\u0011I\u0012\"\u0001\u0003\u0001\u001b\u0005Ay\"\f\f\u0005\u0005aMR\u0014\u0003\u0003\u0001\u0011;iA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u00141M\t6!\u0002C\u001a\u0013\u0005!\t!D\u0001\t UJ\u000e!bl\u0001\t\r\b\u0011\u0003\u0004\u0003\u0001\u0011\u000f)\u0012\"B\u0001\t\t%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\tE9A\u0011\u0001E\u0005+\u0011)\u0011\u0001#\u0003\r\u0002a%\u00014BO\b\t\u0001Aa!D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0001umA\u0001\u0001\u0005\t\u001b%)\u0011\u0001#\u0005\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002\u0001'\u0005Q\u0007\u0003iZ\u0002\u0002\u0001\t\u00165IQ!\u0001\u0005\n\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0005A\u0014\u0001\r\n!\u000e\t\u0011eD\u0003\u0002\u0011\rIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u0001\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0005A\u0014\u0001\r\u0004#\u000eIA1B\u0005\u0002\t\u0001i\u0011\u0001c\u0005\u000e\u0003!QQ\"\u0001E\u000b"})
public abstract class BasicMap<K extends Comparable<? super K>, V> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final StorageHolder<K, V> storageHolder;

    static {
        $kotlinClass = Reflection.createKotlinClass(BasicMap.class);
    }

    public final void clean() {
        this.storageHolder.clean();
    }

    public final void flush(boolean memoryCachesOnly) {
        this.storageHolder.flush(memoryCachesOnly);
    }

    public final void close() {
        this.storageHolder.close();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump() {
        void var2_2;
        StringBuilder receiver = new StringBuilder();
        StringBuilder $receiver = receiver;
        Printer receiver2 = new Printer($receiver);
        Printer $receiver2 = receiver2;
        $receiver2.println(this.getClass().getSimpleName());
        $receiver2.pushIndent();
        for (Comparable key : KotlinPackage.sort((Iterable)this.getAllKeysExistingInStorage())) {
            Object[] objectArray = new Object[1];
            StringBuilder stringBuilder = new StringBuilder().append(this.dumpKey(key)).append(" -> ");
            V v = this.getFromStorage(key);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            objectArray[0] = stringBuilder.append(this.dumpValue(v)).toString();
            $receiver2.println(objectArray);
        }
        $receiver2.popIndent();
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"with(StringBuilder()) {\n\u2026this\n        }.toString()");
        return string;
    }

    @NotNull
    protected abstract String dumpKey(@NotNull K var1);

    @NotNull
    protected abstract String dumpValue(V var1);

    @NotNull
    protected final Collection<K> getAllKeysExistingInStorage() {
        Object object = this.storageHolder.getStorageIfExists();
        if (object == null || (object = object.getAllKeysWithExistingMapping()) == null) {
            object = KotlinPackage.listOf();
        }
        return object;
    }

    protected final boolean storageContains(@NotNull K key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        PersistentHashMap<K, V> persistentHashMap = this.storageHolder.getStorageIfExists();
        return persistentHashMap != null ? persistentHashMap.containsMapping(key) : false;
    }

    @Nullable
    protected final V getFromStorage(@NotNull K key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        PersistentHashMap<K, V> persistentHashMap = this.storageHolder.getStorageIfExists();
        return (V)(persistentHashMap != null ? persistentHashMap.get(key) : null);
    }

    protected final void putToStorage(@NotNull K key, V value) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        this.storageHolder.getStorageOrCreateNew().put(key, value);
    }

    protected final void removeFromStorage(@NotNull K key) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        PersistentHashMap<K, V> persistentHashMap = this.storageHolder.getStorageIfExists();
        if (persistentHashMap != null) {
            persistentHashMap.remove(key);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }

    protected final void appendDataToStorage(@NotNull K key, @NotNull Function1<? super DataOutput, ? extends Unit> append) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(append, (String)"append");
        Function1<? super DataOutput, ? extends Unit> function1 = append;
        this.storageHolder.getStorageOrCreateNew().appendData(key, (PersistentHashMap.ValueDataAppender)(function1 == null ? null : new StoragePackage$sam$ValueDataAppender$ee535a34(function1)));
    }

    public BasicMap(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        Intrinsics.checkParameterIsNotNull(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkParameterIsNotNull(valueExternalizer, (String)"valueExternalizer");
        this.storageHolder = new StorageHolder<K, V>(storageFile, keyDescriptor, valueExternalizer);
    }
}

