/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.IOException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"J\u0006)i1\u000b^8sC\u001e,\u0007j\u001c7eKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004UB\u001c(bC5oGJ,W.\u001a8uC2Tqa\u001d;pe\u0006<WMC\u0001L\u0015\r\te.\u001f\u0006\u0002-*1A(\u001b8jizR1b\u001d;pe\u0006<WMR5mK*!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'\"D6fs\u0012+7o\u0019:jaR|'OC\u0007LKf$Um]2sSB$xN\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\tU$\u0018\u000e\u001c\u0006\u0012m\u0006dW/Z#yi\u0016\u0014h.\u00197ju\u0016\u0014(\u0002\u0005#bi\u0006,\u0005\u0010^3s]\u0006d\u0017N_3s\u0015E\u0001VM]:jgR,g\u000e\u001e%bg\"l\u0015\r\u001d\u0006\u0006G2,\u0017M\u001c\u0006\u0005+:LGOC\u0003dY>\u001cXMC\u0005de\u0016\fG/Z'ba*)a\r\\;tQ*\u0001R.Z7pef\u001c\u0015m\u00195fg>sG.\u001f\u0006\b\u0005>|G.Z1o\u0015I9W\r^*u_J\fw-Z%g\u000bbL7\u000f^:\u000b+\u001d,Go\u0015;pe\u0006<Wm\u0014:De\u0016\fG/\u001a(foz\r!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aq\u0001\u0005\u0005\u0019\u0001)\u0011\u0001#\u0004\u0006\u0005\u0011%\u0001bB\u0003\u0004\t\u0015Aa\u0001\u0004\u0001\u0006\u0003!EQA\u0001\u0003\u0007\u0011%)!\u0001\"\u0004\t\u0014\u0015\u0011Aa\u0002\u0005\b\u000b\r!y\u0001\u0003\u0005\r\u0001\u0015\u0019Aq\u0002E\u000b\u0019\u0001)!\u0001B\u0003\t\r\u0015\u0011Aq\u0002\u0005\t\u000b\t!y\u0001#\u0006\u0006\u0007\u0011=\u0001b\u0003\u0007\u0001\u000b\t!y\u0001C\u0006\u0006\u0007\u0011\u001d\u0001\u0002\u0004\u0007\u0001\u000b\r!9\u0001#\b\r\u0001\u0011\u0001AbA\u000b\b\t\u0001A9!\u0006\u0003\u0006\u0003!!A\u0012\u0001\r\u0005+\u001d!\t\u0001#\u0003\u0016\t\u0015\t\u0001\u0002\u0002G\u00011\u0011I2!B\u0001\t\ta!QF\u0005\u0003b\ta=\u0011%C\u0003\u0002\u0011!IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011!)6\u0001B\u0003\u0004\t\u001fI\u0011\u0001c\u0005.3\u0011\tM\u0002G\u0002\"!\u0015\t\u0001RC\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0011\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u00021\u0005\u0001TC+\u0004\t\u0015\u0019AaA\u0005\u0002\u0011-iC\u0002B1\u00051\u0017\t3!B\u0001\t\fa-Qk\u0001\u0003\u0006\u0007\u0011-\u0011\"\u0001\u0005\n[I!\u0011\r\u0002\r\u000bC%)\u0011\u0001#\u0005\n\u000b%!QA\u0001C\u0001\u0011\u0003a\n\u0001'\u0005V\u0007\u0011)1\u0001\u0002\u0006\n\u0003!QQV\u0003\u0003\u00041/\t3!B\u0001\t\u0018a]\u0011kA\u0002\u0005\u0018%\tA\u0001AW\u000b\t\rAJ\"I\u0002\u0006\u0003!]\u0001tC)\u0004\u0007\u0011e\u0011\"\u0001\u0003\u0001[[!\u0011\u0001G\u0007\"\u001f\u0015\t\u0001RC\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0011\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002aU\u0011kA\u0002\u0005\u001b%\t\u0001bC\u0017\u0016\t\rAZ\"h\u0004\u0005\u0001!qQbA\u0003\u0002\u00111AB\u0002U\u0002\u0001C\r)\u0011\u0001c\u0006\u0019\u0018E\u001bQ\u0001b\u0007\n\u0003\u0011\u0001Q\"\u0001C\u0001[_!1\u0001G\b\"!\u0015\t\u0001RC\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0011\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u00021\u0005\u0001TC)\u0004\u0007\u0011y\u0011\"\u0001\u0005\f[[!1\u0001g\b\"\u001f\u0015\t\u0001RC\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0011\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002aU\u0011kA\u0002\u0005 %\t\u0001bC\u001bU\u0002\u0015\u0015\u000e\u0001Br\u0001#\u001d!\u0001\u0001c\u0002\u0016\t\u0015\t\u0001\u0002\u0002G\u00011\u0011\tr\u0001\"\u0001\t\nU!Q!\u0001\u0005\u0005\u0019\u0003AB\u0001G\u0003\u001e\u0010\u0011\u0001\u00012B\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0001iZ\u0002\u0002\u0001\t\u00105IQ!\u0001\u0005\t\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001\r\t!\u000e\u0005Q4\u0004\u0003\u0001\u0011)i\u0011\"B\u0001\t\u0012%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\u0012A\u001b\u0011!I\b\u0006\u0003!\u0019\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\u0007E\u001b\u0011\u0002B\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\n\u001b\u0005A\u0019\"D\u0001\t\u0015\u0001"})
public final class StorageHolder<K, V> {
    public static final /* synthetic */ KClass $kotlinClass;
    private PersistentHashMap<K, V> storage;
    private final File storageFile;
    private final KeyDescriptor<K> keyDescriptor;
    private final DataExternalizer<V> valueExternalizer;

    static {
        $kotlinClass = Reflection.createKotlinClass(StorageHolder.class);
    }

    @Nullable
    public final PersistentHashMap<K, V> getStorageIfExists() {
        if (this.storage != null) {
            return this.storage;
        }
        if (this.storageFile.exists()) {
            this.storage = this.createMap();
            return this.storage;
        }
        return null;
    }

    @NotNull
    public final PersistentHashMap<K, V> getStorageOrCreateNew() {
        if (this.storage == null) {
            this.storage = this.createMap();
        }
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            Intrinsics.throwNpe();
        }
        return persistentHashMap;
    }

    public final void clean() {
        try {
            Unit unit;
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap != null) {
                persistentHashMap.close();
                unit = Unit.INSTANCE$;
            } else {
                unit = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PersistentHashMap.deleteFilesStartingWith((File)this.storageFile);
        this.storage = null;
    }

    public final void flush(boolean memoryCachesOnly) {
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            return;
        }
        PersistentHashMap<K, V> existingStorage = persistentHashMap;
        if (memoryCachesOnly) {
            if (existingStorage.isDirty()) {
                existingStorage.dropMemoryCaches();
            }
        } else {
            existingStorage.force();
        }
    }

    public final void close() {
        Unit unit;
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap != null) {
            persistentHashMap.close();
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }

    private final PersistentHashMap<K, V> createMap() {
        return new PersistentHashMap(this.storageFile, this.keyDescriptor, this.valueExternalizer);
    }

    public StorageHolder(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        Intrinsics.checkParameterIsNotNull(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkParameterIsNotNull(valueExternalizer, (String)"valueExternalizer");
        this.storageFile = storageFile;
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
    }
}

