/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.modules;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.utils.Printer;

public class KotlinModuleXmlBuilder {
    private final StringBuilder xml = new StringBuilder();
    private final Printer p = new Printer(this.xml);
    private boolean done = false;

    public KotlinModuleXmlBuilder() {
        KotlinModuleXmlBuilder.openTag(this.p, "modules");
    }

    public KotlinModuleXmlBuilder addModule(String moduleName, String outputDir, List<File> sourceFiles, List<File> javaSourceRoots, Collection<File> classpathRoots, List<File> annotationRoots, JavaModuleBuildTargetType targetType, Set<File> directoriesToFilterOut) {
        assert (!this.done) : "Already done";
        if (targetType.isTests()) {
            this.p.println("<!-- Module script for tests -->");
        } else {
            this.p.println("<!-- Module script for production -->");
        }
        this.p.println("<", "module", " ", "name", "=\"", StringUtil.escapeXml((String)moduleName), "\" ", "type", "=\"", StringUtil.escapeXml((String)targetType.getTypeId()), "\" ", "outputDir", "=\"", KotlinModuleXmlBuilder.getEscapedPath(new File(outputDir)), "\">");
        this.p.pushIndent();
        for (File sourceFile : sourceFiles) {
            this.p.println("<", "sources", " ", "path", "=\"", KotlinModuleXmlBuilder.getEscapedPath(sourceFile), "\"/>");
        }
        this.processJavaSourceRoots(javaSourceRoots);
        this.processClasspath(classpathRoots, directoriesToFilterOut);
        this.processAnnotationRoots(annotationRoots);
        KotlinModuleXmlBuilder.closeTag(this.p, "module");
        return this;
    }

    private void processClasspath(@NotNull Collection<File> files, @NotNull Set<File> directoriesToFilterOut) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/modules/KotlinModuleXmlBuilder", "processClasspath"));
        }
        if (directoriesToFilterOut == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoriesToFilterOut", "org/jetbrains/kotlin/modules/KotlinModuleXmlBuilder", "processClasspath"));
        }
        this.p.println("<!-- Classpath -->");
        for (File file : files) {
            boolean isOutput;
            boolean bl = isOutput = directoriesToFilterOut.contains(file) && !IncrementalCompilation.ENABLED;
            if (isOutput) {
                this.p.println("<!-- Output directory, commented out -->");
                this.p.println("<!-- ");
                this.p.pushIndent();
            }
            this.p.println("<", "classpath", " ", "path", "=\"", KotlinModuleXmlBuilder.getEscapedPath(file), "\"/>");
            if (!isOutput) continue;
            this.p.popIndent();
            this.p.println("-->");
        }
    }

    private void processAnnotationRoots(@NotNull List<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/modules/KotlinModuleXmlBuilder", "processAnnotationRoots"));
        }
        this.p.println("<!-- External annotations -->");
        for (File file : files) {
            this.p.println("<", "externalAnnotations", " ", "path", "=\"", KotlinModuleXmlBuilder.getEscapedPath(file), "\"/>");
        }
    }

    private void processJavaSourceRoots(@NotNull List<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/modules/KotlinModuleXmlBuilder", "processJavaSourceRoots"));
        }
        this.p.println("<!-- Java source roots -->");
        for (File file : files) {
            this.p.println("<", "javaSourceRoots", " ", "path", "=\"", KotlinModuleXmlBuilder.getEscapedPath(file), "\"/>");
        }
    }

    public CharSequence asText() {
        if (!this.done) {
            KotlinModuleXmlBuilder.closeTag(this.p, "modules");
            this.done = true;
        }
        return this.xml;
    }

    private static void openTag(Printer p, String tag) {
        p.println("<" + tag + ">");
        p.pushIndent();
    }

    private static void closeTag(Printer p, String tag) {
        p.popIndent();
        p.println("</" + tag + ">");
    }

    private static String getEscapedPath(File sourceFile) {
        return StringUtil.escapeXml((String)FileUtil.toSystemIndependentName((String)sourceFile.getPath()));
    }
}

