/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.IndexedValue;
import kotlin.KotlinPackage;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.reflect.ReflectPackage;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.reflect.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.load.kotlin.reflect.ReflectPackage__ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.reflect.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;

public final class ReflectClassStructure {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final ReflectClassStructure INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(ReflectClassStructure.class);
        new ReflectClassStructure();
    }

    public final void loadClassAnnotations(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        Annotation[] annotationArray = klass.getDeclaredAnnotations();
        for (int i = 0; i < annotationArray.length; ++i) {
            Annotation annotation;
            Annotation annotation2 = annotation = annotationArray[i];
            Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
            this.processAnnotation(visitor2, annotation2);
        }
        visitor2.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(memberVisitor, "memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations(klass, memberVisitor);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadMethodAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Method method = methodArray[i];
            Name name = Name.identifier(method.getName());
            Method method2 = method;
            Intrinsics.checkExpressionValueIsNotNull(method2, "method");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE$.methodDesc(method2)) == null) {
                continue;
            }
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation = annotationArray[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Intrinsics.checkExpressionValueIsNotNull(annotationVisitor, "visitor");
                Annotation annotation2 = annotation;
                Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            for (IndexedValue<Object> indexedValue : KotlinPackage.withIndex((Object[])method.getParameterAnnotations())) {
                int parameterIndex = indexedValue.component1();
                Annotation[] annotations2 = (Annotation[])indexedValue.component2();
                for (int j = 0; j < annotations2.length; ++j) {
                    Unit unit;
                    Annotation annotation = annotations2[j];
                    Class<Annotation> annotationType = KotlinPackage.annotationType(annotation);
                    ClassId classId = ReflectPackage.getClassId(annotationType);
                    Annotation annotation3 = annotation;
                    Intrinsics.checkExpressionValueIsNotNull(annotation3, "annotation");
                    if (visitor2.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation3)) != null) {
                        void $receiver;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = it = (KotlinJvmBinaryClass.AnnotationArgumentVisitor)$receiver;
                        Intrinsics.checkExpressionValueIsNotNull(annotationArgumentVisitor, "it");
                        Annotation annotation4 = annotation;
                        Intrinsics.checkExpressionValueIsNotNull(annotation4, "annotation");
                        ReflectClassStructure.INSTANCE$.processAnnotationArguments(annotationArgumentVisitor, annotation4, annotationType);
                        unit = Unit.INSTANCE$;
                        continue;
                    }
                    unit = null;
                }
            }
            visitor2.visitEnd();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadConstructorAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Constructor<?>[] constructorArray = klass.getDeclaredConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Constructor<?> constructor = constructorArray[i];
            Name name = Name.special("<init>");
            Constructor<?> constructor2 = constructor;
            Intrinsics.checkExpressionValueIsNotNull(constructor2, "constructor");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE$.constructorDesc(constructor2)) == null) {
                continue;
            }
            Annotation[] annotationArray = constructor.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation = annotationArray[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Intrinsics.checkExpressionValueIsNotNull(annotationVisitor, "visitor");
                Annotation annotation2 = annotation;
                Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            if (KotlinPackage.isNotEmpty((Object[])parameterAnnotations)) {
                int shift = ((Object[])constructor.getParameterTypes()).length - ((Object[])parameterAnnotations).length;
                for (IndexedValue<Object> indexedValue : KotlinPackage.withIndex((Object[])parameterAnnotations)) {
                    int parameterIndex = indexedValue.component1();
                    Annotation[] annotations2 = (Annotation[])indexedValue.component2();
                    for (int j = 0; j < annotations2.length; ++j) {
                        Unit unit;
                        Annotation annotation = annotations2[j];
                        Class<Annotation> annotationType = KotlinPackage.annotationType(annotation);
                        ClassId classId = ReflectPackage.getClassId(annotationType);
                        Annotation annotation3 = annotation;
                        Intrinsics.checkExpressionValueIsNotNull(annotation3, "annotation");
                        if (visitor2.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation3)) != null) {
                            void $receiver;
                            KotlinJvmBinaryClass.AnnotationArgumentVisitor it;
                            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = it = (KotlinJvmBinaryClass.AnnotationArgumentVisitor)$receiver;
                            Intrinsics.checkExpressionValueIsNotNull(annotationArgumentVisitor, "it");
                            Annotation annotation4 = annotation;
                            Intrinsics.checkExpressionValueIsNotNull(annotation4, "annotation");
                            ReflectClassStructure.INSTANCE$.processAnnotationArguments(annotationArgumentVisitor, annotation4, annotationType);
                            unit = Unit.INSTANCE$;
                            continue;
                        }
                        unit = null;
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            KotlinJvmBinaryClass.AnnotationVisitor visitor2;
            Field field = fieldArray[i];
            Name name = Name.identifier(field.getName());
            Field field2 = field;
            Intrinsics.checkExpressionValueIsNotNull(field2, "field");
            if (memberVisitor.visitField(name, SignatureSerializer.INSTANCE$.fieldDesc(field2), null) == null) {
                continue;
            }
            Annotation[] annotationArray = field.getDeclaredAnnotations();
            for (int j = 0; j < annotationArray.length; ++j) {
                Annotation annotation = annotationArray[j];
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Intrinsics.checkExpressionValueIsNotNull(annotationVisitor, "visitor");
                Annotation annotation2 = annotation;
                Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            visitor2.visitEnd();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation) {
        Unit unit;
        Class<Annotation> annotationType = KotlinPackage.annotationType(annotation);
        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(ReflectPackage.getClassId(annotationType), new ReflectAnnotationSource(annotation));
        if (annotationArgumentVisitor != null) {
            void $receiver;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = annotationArgumentVisitor;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor3 = it = (KotlinJvmBinaryClass.AnnotationArgumentVisitor)$receiver;
            Intrinsics.checkExpressionValueIsNotNull(annotationArgumentVisitor3, "it");
            ReflectClassStructure.INSTANCE$.processAnnotationArguments(annotationArgumentVisitor3, annotation, annotationType);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation, Class<?> annotationType) {
        Method[] methodArray = annotationType.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            Name name = Name.identifier(method.getName());
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(method.getName())");
            Object object = method.invoke((Object)annotation, new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull(object, "method(annotation)");
            this.processAnnotationArgumentValue(visitor2, name, object);
        }
        visitor2.visitEnd();
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name, Object value) {
        Class<?> clazz = value.getClass();
        if (ReflectPackage__ReflectKotlinClassKt.getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT().contains(clazz)) {
            visitor2.visit(name, value);
        } else if (ReflectPackage.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            ClassId classId = ReflectPackage.getClassId(clazz.isEnum() ? clazz : clazz.getEnclosingClass());
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            visitor2.visitEnum(name, classId, Name.identifier(((Enum)object).name()));
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v;
            Class annotationClass = (Class)KotlinPackage.single((Object[])clazz.getInterfaces());
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name, ReflectPackage.getClassId(annotationClass));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = v = annotationArgumentVisitor;
            Intrinsics.checkExpressionValueIsNotNull(annotationArgumentVisitor2, "v");
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Annotation");
            }
            Annotation annotation = (Annotation)object;
            Class clazz2 = annotationClass;
            Intrinsics.checkExpressionValueIsNotNull(clazz2, "annotationClass");
            this.processAnnotationArguments(annotationArgumentVisitor2, annotation, clazz2);
        } else if (clazz.isArray()) {
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = visitor2.visitArray(name);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = annotationArrayArgumentVisitor;
            Class<?> componentType = clazz.getComponentType();
            if (componentType.isEnum()) {
                ClassId enumClassId = ReflectPackage.getClassId(componentType);
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object element;
                    Object object2 = element = objectArray[i];
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
                    }
                    v.visitEnum(enumClassId, Name.identifier(((Enum)object2).name()));
                }
            } else {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object element = objectArray[i];
                    v.visit(element);
                }
            }
            v.visitEnd();
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value);
        }
    }

    ReflectClassStructure() {
        INSTANCE$ = this;
    }
}

