/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.InferencePackage;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.TypeBounds;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.TypeBounds$$TImpl;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.constraintPosition.ConstraintPosition;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueTypeConstructor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilPackage;
import kotlin.reflect.jvm.internal.impl.types.CommonSupertypes;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeIntersector;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypesPackage;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.JetTypeChecker;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeBoundsImpl
implements TypeBounds {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final ArrayList<TypeBounds.Bound> bounds;
    private Collection<? extends JetType> resultValues;
    private boolean isFixed;
    @NotNull
    private final TypeParameterDescriptor typeVariable;
    @NotNull
    private final Variance varianceOfPosition;

    static {
        $kotlinClass = Reflection.createKotlinClass(TypeBoundsImpl.class);
    }

    @NotNull
    public ArrayList<TypeBounds.Bound> getBounds() {
        return this.bounds;
    }

    public final boolean getIsFixed() {
        return this.isFixed;
    }

    private final void setIsFixed(boolean bl) {
        this.isFixed = bl;
    }

    public final void setFixed() {
        this.isFixed = true;
    }

    public final void addBound(@NotNull TypeBounds.Bound bound) {
        Intrinsics.checkParameterIsNotNull(bound, "bound");
        this.resultValues = null;
        boolean value = Intrinsics.areEqual(bound.getTypeVariable(), this.getTypeVariable());
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = bound + " is added for incorrect type variable " + bound.getTypeVariable().getName() + ". Expected: " + this.getTypeVariable().getName();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        ((ArrayList)this.getBounds()).add(bound);
    }

    private final Set<JetType> filterBounds(Collection<? extends TypeBounds.Bound> bounds, TypeBounds.BoundKind kind) {
        return this.filterBounds(bounds, kind, null);
    }

    private final Set<JetType> filterBounds(Collection<? extends TypeBounds.Bound> bounds, TypeBounds.BoundKind kind, Collection<JetType> errorValues) {
        LinkedHashSet<JetType> result = new LinkedHashSet<JetType>();
        for (TypeBounds.Bound bound : bounds) {
            if (!Intrinsics.areEqual((Object)bound.getKind(), (Object)kind)) continue;
            if (!ErrorUtils.containsErrorType(bound.getConstrainingType())) {
                result.add(bound.getConstrainingType());
                continue;
            }
            Collection<JetType> collection = errorValues;
            Boolean bl = collection != null ? Boolean.valueOf(collection.add(bound.getConstrainingType())) : null;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeBoundsImpl filter(@NotNull Function1<? super ConstraintPosition, ? extends Boolean> condition) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        TypeBoundsImpl result = new TypeBoundsImpl(this.getTypeVariable(), this.getVarianceOfPosition());
        Iterable iterable = this.getBounds();
        Collection collection = result.getBounds();
        void var5_5 = $receiver2;
        Collection collection2 = new ArrayList();
        for (Object element : $receiver) {
            TypeBounds.Bound it = (TypeBounds.Bound)element;
            if (!condition.invoke(it.getPosition()).booleanValue()) continue;
            destination.add(element);
        }
        List list = (List)destination;
        ((ArrayList)collection).addAll(list);
        return result;
    }

    @Override
    @NotNull
    public Collection<JetType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<JetType> collection = this.resultValues;
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<JetType> computeValues() {
        JetType superTypeOfAllLowerBounds;
        void numberLowerBounds;
        void generalLowerBounds;
        void $receiver;
        boolean hasStrongBound;
        Object it;
        Object element3;
        List bounds;
        Object it2;
        LinkedHashSet values;
        block14: {
            boolean bl;
            Iterator destination;
            Iterable $receiver2;
            values = new LinkedHashSet();
            Iterable $receiver3 = this.getBounds();
            Iterable iterable = $receiver3;
            Collection collection = new ArrayList();
            for (Object element2 : $receiver2) {
                it2 = (TypeBounds.Bound)element2;
                if (!((TypeBounds.Bound)it2).getIsProper()) continue;
                destination.add(element2);
            }
            bounds = (List)((Object)destination);
            if (bounds.isEmpty()) {
                return KotlinPackage.listOf();
            }
            $receiver2 = bounds;
            for (Object element3 : $receiver2) {
                it = (TypeBounds.Bound)element3;
                if (!((TypeBounds.Bound)it).getPosition().isStrong()) continue;
                bl = true;
                break block14;
            }
            bl = hasStrongBound = false;
        }
        if (!hasStrongBound) {
            return KotlinPackage.listOf();
        }
        Set<JetType> exactBounds = this.filterBounds(bounds, TypeBounds.BoundKind.EXACT_BOUND, values);
        JetType bestFit = TypesPackage.singleBestRepresentative((Collection<? extends JetType>)exactBounds);
        if (bestFit != null && this.tryPossibleAnswer(bounds, bestFit)) {
            return KotlinPackage.listOf(bestFit);
        }
        values.addAll(exactBounds);
        Iterable iterable = this.filterBounds(bounds, TypeBounds.BoundKind.LOWER_BOUND, values);
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        for (Object element4 : $receiver) {
            JetType it3 = (JetType)element4;
            if (it3.getConstructor() instanceof IntegerValueTypeConstructor) {
                first.add(element4);
                continue;
            }
            second.add(element4);
        }
        it2 = new Pair(first, second);
        element3 = (List)((Pair)it2).component1();
        it = (List)((Pair)it2).component2();
        it2 = null;
        JetType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection)generalLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfLowerBounds)) {
            JetType jetType = superTypeOfLowerBounds;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return KotlinPackage.setOf(jetType);
        }
        UtilsPackage.addIfNotNull(values, superTypeOfLowerBounds);
        JetType superTypeOfNumberLowerBounds = TypeUtils.commonSupertypeForNumberTypes((Collection)numberLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfNumberLowerBounds)) {
            JetType jetType = superTypeOfNumberLowerBounds;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return KotlinPackage.setOf(jetType);
        }
        UtilsPackage.addIfNotNull(values, superTypeOfNumberLowerBounds);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.tryPossibleAnswer(bounds, superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection<JetType>)KotlinPackage.listOf(superTypeOfLowerBounds, superTypeOfNumberLowerBounds)))) {
            JetType jetType = superTypeOfAllLowerBounds;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return KotlinPackage.setOf(jetType);
        }
        Set<JetType> upperBounds = this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND, values);
        JetType intersectionOfUpperBounds = new TypeIntersector(DescriptorUtilPackage.getBuiltIns(this.getTypeVariable())).intersect(JetTypeChecker.DEFAULT, upperBounds);
        if (!upperBounds.isEmpty() && intersectionOfUpperBounds != null && this.tryPossibleAnswer(bounds, intersectionOfUpperBounds)) {
            return KotlinPackage.setOf(intersectionOfUpperBounds);
        }
        values.addAll(this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND));
        return values;
    }

    private final boolean tryPossibleAnswer(Collection<? extends TypeBounds.Bound> bounds, JetType possibleAnswer) {
        if (possibleAnswer == null) {
            return false;
        }
        if (!possibleAnswer.getConstructor().isDenotable() && !InferencePackage.isCaptured(possibleAnswer)) {
            return false;
        }
        for (TypeBounds.Bound bound : bounds) {
            TypeBounds.BoundKind boundKind = bound.getKind();
            if (!(Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.LOWER_BOUND) ? !JetTypeChecker.DEFAULT.isSubtypeOf(bound.getConstrainingType(), possibleAnswer) : (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.UPPER_BOUND) ? !JetTypeChecker.DEFAULT.isSubtypeOf(possibleAnswer, bound.getConstrainingType()) : Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.EXACT_BOUND) && !JetTypeChecker.DEFAULT.equalTypes(bound.getConstrainingType(), possibleAnswer)))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getTypeVariable() {
        return this.typeVariable;
    }

    @Override
    @NotNull
    public Variance getVarianceOfPosition() {
        return this.varianceOfPosition;
    }

    public TypeBoundsImpl(@NotNull TypeParameterDescriptor typeVariable, @NotNull Variance varianceOfPosition) {
        Intrinsics.checkParameterIsNotNull(typeVariable, "typeVariable");
        Intrinsics.checkParameterIsNotNull((Object)varianceOfPosition, "varianceOfPosition");
        this.typeVariable = typeVariable;
        this.varianceOfPosition = varianceOfPosition;
        this.bounds = new ArrayList();
    }

    @Override
    @Nullable
    public JetType getValue() {
        return TypeBounds$$TImpl.getValue(this);
    }
}

