/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage;
import org.jetbrains.annotations.NotNull;

public final class ClassData {
    private final NameResolver nameResolver;
    private final ProtoBuf.Class classProto;

    @NotNull
    public static ClassData read(@NotNull byte[] bytes, @NotNull ExtensionRegistryLite registry) {
        ClassData classData;
        block4: {
            if (bytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "kotlin/reflect/jvm/internal/impl/serialization/ClassData", "read"));
            }
            if (registry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "kotlin/reflect/jvm/internal/impl/serialization/ClassData", "read"));
            }
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                NameResolver nameResolver = NameResolver.read(in);
                ProtoBuf.Class classProto = ProtoBuf.Class.parseFrom(in, registry);
                classData = new ClassData(nameResolver, classProto);
                if (classData != null) break block4;
            }
            catch (IOException e) {
                throw UtilsPackage.rethrow(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/ClassData", "read"));
        }
        return classData;
    }

    public ClassData(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Class classProto) {
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "kotlin/reflect/jvm/internal/impl/serialization/ClassData", "<init>"));
        }
        if (classProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProto", "kotlin/reflect/jvm/internal/impl/serialization/ClassData", "<init>"));
        }
        this.nameResolver = nameResolver;
        this.classProto = classProto;
    }

    @NotNull
    public NameResolver getNameResolver() {
        NameResolver nameResolver = this.nameResolver;
        if (nameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/ClassData", "getNameResolver"));
        }
        return nameResolver;
    }

    @NotNull
    public ProtoBuf.Class getClassProto() {
        ProtoBuf.Class clazz = this.classProto;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/ClassData", "getClassProto"));
        }
        return clazz;
    }
}

