/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ResourceBundlePropertiesUpdateManager {
    private static final Logger LOG = Logger.getInstance(ResourceBundlePropertiesUpdateManager.class);
    private final ResourceBundle myResourceBundle;
    private boolean myOrdered;
    private boolean myAlphaSorted;
    private List<String> myKeysOrder;

    public ResourceBundlePropertiesUpdateManager(ResourceBundle bundle) {
        this.myResourceBundle = bundle;
        this.reload();
    }

    public void insertNewProperty(String key, String value) {
        if (ApplicationManager.getApplication().isUnitTestMode() && this.myKeysOrder != null) {
            LOG.assertTrue(!this.myKeysOrder.contains(key));
        }
        PropertiesFile propertiesFile = this.myResourceBundle.getDefaultPropertiesFile();
        if (this.myAlphaSorted) {
            propertiesFile.addProperty(key, value);
        } else {
            this.insertPropertyLast(key, value, propertiesFile);
            if (this.myOrdered) {
                this.myKeysOrder.add(key);
            }
        }
    }

    public void insertOrUpdateTranslation(String key, String value, PropertiesFile propertiesFile) throws IncorrectOperationException {
        IProperty property = propertiesFile.findPropertyByKey(key);
        if (property != null) {
            property.setValue(value);
            return;
        }
        if (this.myOrdered) {
            if (this.myAlphaSorted) {
                propertiesFile.addProperty(key, value);
                return;
            }
            Pair<IProperty, Integer> propertyAndPosition = this.findExistedPrevSiblingProperty(key, propertiesFile);
            propertiesFile.addPropertyAfter(key, value, propertyAndPosition == null ? null : (Property)propertyAndPosition.getFirst());
        } else {
            this.insertPropertyLast(key, value, propertiesFile);
        }
    }

    private Pair<IProperty, Integer> findExistedPrevSiblingProperty(String key, PropertiesFile file) {
        int prevPosition;
        if (this.myKeysOrder.isEmpty()) {
            return null;
        }
        for (int i = prevPosition = this.myKeysOrder.indexOf(key); i >= 0; --i) {
            String prevKey = this.myKeysOrder.get(i);
            IProperty property = file.findPropertyByKey(prevKey);
            if (property == null) continue;
            return Pair.create((Object)property, (Object)(prevPosition + 1));
        }
        return null;
    }

    public void insertPropertyLast(String key, String value, PropertiesFile propertiesFile) {
        List<IProperty> properties = propertiesFile.getProperties();
        IProperty lastProperty = properties.isEmpty() ? null : properties.get(properties.size() - 1);
        propertiesFile.addPropertyAfter(key, value, lastProperty);
    }

    public void reload() {
        Pair<List<String>, Boolean> keysOrder = ResourceBundlePropertiesUpdateManager.keysOrder(this.myResourceBundle);
        boolean bl = this.myOrdered = keysOrder != null;
        if (this.myOrdered) {
            this.myAlphaSorted = (Boolean)keysOrder.getSecond();
            this.myKeysOrder = this.myAlphaSorted ? null : (List)keysOrder.getFirst();
        } else {
            this.myKeysOrder = null;
        }
    }

    @Nullable
    private static Pair<List<String>, Boolean> keysOrder(final ResourceBundle resourceBundle) {
        final boolean[] isEdgesProperlyDirection = new boolean[]{true};
        GraphGenerator generator = GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<String>(){

            public Collection<String> getNodes() {
                LinkedHashSet<String> nodes = new LinkedHashSet<String>();
                for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                    for (IProperty property : propertiesFile.getProperties()) {
                        String key = property.getKey();
                        if (key == null) continue;
                        nodes.add(key);
                    }
                }
                return nodes;
            }

            public Iterator<String> getIn(String n) {
                LinkedHashSet<String> siblings = new LinkedHashSet<String>();
                for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
                    for (IProperty property : propertiesFile.findPropertiesByKey(n)) {
                        String key;
                        PsiElement sibling = property.getPsiElement().getNextSibling();
                        while (sibling instanceof PsiWhiteSpace || sibling instanceof PsiComment) {
                            sibling = sibling.getNextSibling();
                        }
                        if (!(sibling instanceof IProperty) || (key = ((IProperty)sibling).getKey()) == null) continue;
                        if (isEdgesProperlyDirection[0] && n.compareTo(key) > 0) {
                            isEdgesProperlyDirection[0] = false;
                        }
                        siblings.add(key);
                    }
                }
                return siblings.iterator();
            }
        }));
        DFSTBuilder dfstBuilder = new DFSTBuilder((Graph)generator);
        boolean acyclic = dfstBuilder.isAcyclic();
        if (acyclic) {
            if (isEdgesProperlyDirection[0]) {
                ArrayList sortedNodes = new ArrayList(generator.getNodes());
                Collections.sort(sortedNodes, String.CASE_INSENSITIVE_ORDER);
                return Pair.create(sortedNodes, (Object)true);
            }
            List dfsNodes = dfstBuilder.getSortedNodes();
            Collections.reverse(dfsNodes);
            return Pair.create((Object)dfsNodes, (Object)false);
        }
        return null;
    }

    public boolean isAlphaSorted() {
        return this.myAlphaSorted;
    }
}

