/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kotlin

/**
 * Represents a 16-bit Unicode character.
 * On the JVM, non-nullable values of this type are represented as values of the primitive type `char`.
 */
public class Char private () : Comparable<Char> {
    companion object {}

    /**
     * Compares this value with the specified value for order.
     * Returns zero if this value is equal to the specified other value, a negative number if its less than other,
     * or a positive number if its greater than other.
     */
    public override fun compareTo(other: Char): Int

    /** Adds the other Int value to this value resulting a Char. */
    public fun plus(other: Int): Char

    /** Subtracts the other Char value from this value resulting an Int. */
    public fun minus(other: Char): Int
    /** Subtracts the other Int value from this value resulting a Char. */
    public fun minus(other: Int): Char

    /** Increments this value. */
    public fun inc(): Char
    /** Decrements this value. */
    public fun dec(): Char

    /** Creates a range from this value to the specified [other] value. */
    public fun rangeTo(other: Char): CharRange

    /** Returns the value of this character as a `Byte`. */
    public override fun toByte(): Byte
    /** Returns the value of this character as a `Char`. */
    public override fun toChar(): Char
    /** Returns the value of this character as a `Short`. */
    public override fun toShort(): Short
    /** Returns the value of this character as a `Int`. */
    public override fun toInt(): Int
    /** Returns the value of this character as a `Long`. */
    public override fun toLong(): Long
    /** Returns the value of this character as a `Float`. */
    public override fun toFloat(): Float
    /** Returns the value of this character as a `Double`. */
    public override fun toDouble(): Double
}

