/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.tools.idea.editors.gfxtrace.controllers.FrameBufferController;
import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GfxTraceViewPanel
implements Disposable {
    private JPanel mainPanel;
    private JBPanel myColorBuffer;
    private JBPanel myDepthBuffer;
    private JPanel myMemoryPanel;
    private JPanel myImagePanel;
    private JBList myScrubberList;
    private JBScrollPane myStateScrollPane;
    private JBScrollPane myScrubberScrollPane;
    private ThreeComponentsSplitter myThreePanes;
    private JPanel myHiddenComponents;
    private JBScrollPane myAtomScrollPane;
    private ComboBox myDeviceList;
    private ComboBox myCapturesList;
    private JBPanel myTopPanel;
    private ComboBox myGfxContextList;
    private JBScrollPane myColorScrollPane;
    private JBScrollPane myWireframeScrollPane;
    private JBScrollPane myDepthScrollPane;
    private JBScrollPane myStencilScrollPane;
    private JBPanel myDocsPanel;
    private JBScrollPane myDocsScrollPane;
    private JTextPane myDocsPane;
    private JBPanel myWireframeBuffer;
    private JBRunnerTabs myBufferTabs;

    public GfxTraceViewPanel() {
        this.$$$setupUI$$$();
    }

    @NotNull
    public JPanel getRootComponent() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/GfxTraceViewPanel", "getRootComponent"));
        }
        return jPanel;
    }

    public JPanel getImagePanel() {
        return this.myImagePanel;
    }

    public JPanel getMemoryPanel() {
        return this.myMemoryPanel;
    }

    public JBScrollPane getAtomScrollPane() {
        return this.myAtomScrollPane;
    }

    public JBList getScrubberList() {
        return this.myScrubberList;
    }

    public JBScrollPane getStateScrollPane() {
        return this.myStateScrollPane;
    }

    public ThreeComponentsSplitter getThreePanes() {
        return this.myThreePanes;
    }

    public JPanel getHiddenComponents() {
        return this.myHiddenComponents;
    }

    private void setHiddenComponents(@Nullable JPanel hiddenComponents) {
        this.myHiddenComponents = hiddenComponents;
    }

    public JBRunnerTabs getBufferTabs() {
        return this.myBufferTabs;
    }

    public void setBufferTabs(@NotNull JBRunnerTabs bufferTabs) {
        if (bufferTabs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bufferTabs", "com/android/tools/idea/editors/gfxtrace/GfxTraceViewPanel", "setBufferTabs"));
        }
        this.myBufferTabs = bufferTabs;
    }

    public JBScrollPane getScrubberScrollPane() {
        return this.myScrubberScrollPane;
    }

    public ComboBox getDeviceList() {
        return this.myDeviceList;
    }

    public ComboBox getCapturesList() {
        return this.myCapturesList;
    }

    public JBPanel getTopPanel() {
        return this.myTopPanel;
    }

    public ComboBox getGfxContextList() {
        return this.myGfxContextList;
    }

    public JBScrollPane getColorScrollPane() {
        return this.myColorScrollPane;
    }

    public JBScrollPane getWireframeScrollPane() {
        return this.myWireframeScrollPane;
    }

    public JBScrollPane getDepthScrollPane() {
        return this.myDepthScrollPane;
    }

    public JBScrollPane getStencilScrollPane() {
        return this.myStencilScrollPane;
    }

    public JBScrollPane getDocsScrollPane() {
        return this.myDocsScrollPane;
    }

    public JBPanel getDocsPanel() {
        return this.myDocsPanel;
    }

    public JTextPane getDocsPane() {
        return this.myDocsPane;
    }

    public void dispose() {
    }

    public void setupViewHierarchy(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/gfxtrace/GfxTraceViewPanel", "setupViewHierarchy"));
        }
        JPanel rootPanel = this.getRootComponent();
        rootPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ThreeComponentsSplitter threePane = this.getThreePanes();
        threePane.setDividerWidth(5);
        this.getTopPanel().setBorder(BorderFactory.createLineBorder(JBColor.border()));
        this.getScrubberScrollPane().setViewportView((Component)this.getScrubberList());
        this.getHiddenComponents().removeAll();
        rootPanel.remove(this.getHiddenComponents());
        this.setHiddenComponents(null);
        JBRunnerTabs bufferTabs = new JBRunnerTabs(project, ActionManager.getInstance(), IdeFocusManager.findInstance(), (Disposable)this);
        bufferTabs.setPaintBorder(0, 0, 0, 0).setTabSidePaintBorder(1).setPaintFocus(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()).setAlwaysPaintSelectedTab(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
        JBPanel[] frameBuffers = new JBPanel[]{this.myColorBuffer, this.myWireframeBuffer, this.myDepthBuffer};
        for (int i = 0; i < frameBuffers.length; ++i) {
            bufferTabs.addTab(new TabInfo((JComponent)frameBuffers[i]).setText(FrameBufferController.BufferType.values()[i].getName()));
        }
        bufferTabs.setBorder((Border)new EmptyBorder(0, 2, 0, 0));
        this.setBufferTabs(bufferTabs);
        Wrapper bufferWrapper = new Wrapper();
        bufferWrapper.setLayout((LayoutManager)new BorderLayout());
        bufferWrapper.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        bufferWrapper.setContent((JComponent)bufferTabs);
        Wrapper atomTreeWrapper = new Wrapper();
        atomTreeWrapper.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        atomTreeWrapper.setContent((JComponent)this.myAtomScrollPane);
        JBSplitter middleSplitter = new JBSplitter(false);
        middleSplitter.setMinimumSize(new Dimension(100, 10));
        middleSplitter.setFirstComponent((JComponent)atomTreeWrapper);
        middleSplitter.setSecondComponent((JComponent)bufferWrapper);
        threePane.setInnerComponent((JComponent)middleSplitter);
        JBRunnerTabs miscTabs = new JBRunnerTabs(project, ActionManager.getInstance(), IdeFocusManager.findInstance(), (Disposable)this);
        miscTabs.setPaintBorder(0, 0, 0, 0).setTabSidePaintBorder(1).setPaintFocus(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()).setAlwaysPaintSelectedTab(UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
        miscTabs.addTab(new TabInfo((JComponent)this.getMemoryPanel()).setText("Memory"));
        miscTabs.addTab(new TabInfo((JComponent)this.getImagePanel()).setText("Image"));
        miscTabs.addTab(new TabInfo((JComponent)this.getDocsPanel()).setText("Docs"));
        miscTabs.setBorder((Border)new EmptyBorder(0, 2, 0, 0));
        this.getDocsScrollPane().setViewportView((Component)this.getDocsPane());
        Wrapper miscWrapper = new Wrapper();
        miscWrapper.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        miscWrapper.setContent((JComponent)miscTabs);
        Wrapper stateWrapper = new Wrapper();
        stateWrapper.setContent((JComponent)this.getStateScrollPane());
        stateWrapper.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        JBSplitter bottomSplitter = new JBSplitter(false);
        bottomSplitter.setMinimumSize(new Dimension(100, 10));
        bottomSplitter.setFirstComponent((JComponent)stateWrapper);
        bottomSplitter.setSecondComponent((JComponent)miscWrapper);
        threePane.setLastComponent((JComponent)bottomSplitter);
        threePane.setHonorComponentsMinimumSize(true);
        threePane.addHierarchyBoundsListener((HierarchyBoundsListener)new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                super.ancestorResized(hierarchyEvent);
                GfxTraceViewPanel.this.resize();
            }
        });
    }

    public void resize() {
        ThreeComponentsSplitter threePane = this.getThreePanes();
        assert (threePane.getLastComponent() instanceof JBSplitter);
        JBSplitter bottomSplitter = (JBSplitter)threePane.getLastComponent();
        assert (threePane.getInnerComponent() instanceof JBSplitter);
        JBSplitter middleSplitter = (JBSplitter)threePane.getInnerComponent();
        int scrubberHeight = this.getScrubberScrollPane().getMinimumSize().height;
        if (threePane.getFirstSize() < scrubberHeight) {
            int totalHeight = threePane.getHeight();
            int residualHeightAfter = Math.max(0, totalHeight - scrubberHeight);
            threePane.setFirstSize(scrubberHeight);
            int middleSize = middleSplitter.getPreferredSize().height;
            int bottomSize = bottomSplitter.getPreferredSize().height;
            if (bottomSize + middleSize > 0) {
                threePane.setLastSize(residualHeightAfter * bottomSize / (bottomSize + middleSize));
            } else {
                threePane.setLastSize(residualHeightAfter / 2);
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBScrollPane jBScrollPane;
        JBPanel jBPanel;
        JBScrollPane jBScrollPane2;
        JBPanel jBPanel2;
        JBScrollPane jBScrollPane3;
        JBPanel jBPanel3;
        JPanel jPanel;
        JPanel jPanel2;
        JTextPane jTextPane;
        JBScrollPane jBScrollPane4;
        JBPanel jBPanel4;
        JBList jBList;
        JBScrollPane jBScrollPane5;
        JBScrollPane jBScrollPane6;
        JPanel jPanel3;
        JBScrollPane jBScrollPane7;
        JBPanel jBPanel5;
        ThreeComponentsSplitter threeComponentsSplitter;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPanel jPanel4;
        this.mainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Wrapper wrapper = new Wrapper();
        wrapper.setLayout(new FlowLayout(0, 5, 0));
        jPanel4.add((Component)wrapper, new GridConstraints(0, 0, 1, 1, 8, 2, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Captures:");
        Component component = wrapper.add((Component)jBLabel);
        this.myCapturesList = comboBox3 = new ComboBox();
        Component component2 = wrapper.add((Component)comboBox3);
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Devices:");
        Component component3 = wrapper.add((Component)jBLabel2);
        this.myDeviceList = comboBox2 = new ComboBox();
        Component component4 = wrapper.add((Component)comboBox2);
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Graphics Context:");
        Component component5 = wrapper.add((Component)jBLabel3);
        this.myGfxContextList = comboBox = new ComboBox();
        Component component6 = wrapper.add((Component)comboBox);
        this.myThreePanes = threeComponentsSplitter = new ThreeComponentsSplitter();
        threeComponentsSplitter.setLayout(new FlowLayout(1, 5, 5));
        threeComponentsSplitter.setOrientation(true);
        jPanel4.add((Component)threeComponentsSplitter, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTopPanel = jBPanel5 = new JBPanel();
        jBPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Component component7 = threeComponentsSplitter.add((Component)jBPanel5);
        this.myScrubberScrollPane = jBScrollPane7 = new JBScrollPane();
        jBScrollPane7.setVerticalScrollBarPolicy(21);
        jBScrollPane7.setHorizontalScrollBarPolicy(32);
        jBPanel5.add((Component)jBScrollPane7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JViewport jViewport = new JViewport();
        jViewport.setLayout(new FlowLayout(0, 5, 5));
        jBScrollPane7.setViewportView(jViewport);
        this.myHiddenComponents = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setEnabled(true);
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(0, 0)));
        this.myAtomScrollPane = jBScrollPane6 = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myStateScrollPane = jBScrollPane5 = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myScrubberList = jBList = new JBList();
        jBList.setLayoutOrientation(2);
        jBList.setSelectionMode(0);
        jPanel3.add((Component)jBList, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDocsPanel = jBPanel4 = new JBPanel();
        jBPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jBPanel4, new GridConstraints(3, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myDocsScrollPane = jBScrollPane4 = new JBScrollPane();
        jBPanel4.add((Component)jBScrollPane4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDocsPane = jTextPane = new JTextPane();
        ((Component)jTextPane).setEnabled(true);
        jTextPane.setEditable(false);
        jPanel3.add((Component)jTextPane, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        this.myMemoryPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setEnabled(true);
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myImagePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        jPanel3.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myColorBuffer = jBPanel3 = new JBPanel();
        jBPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jBPanel3, new GridConstraints(6, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myColorScrollPane = jBScrollPane3 = new JBScrollPane();
        jBPanel3.add((Component)jBScrollPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWireframeBuffer = jBPanel2 = new JBPanel();
        jBPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jBPanel2, new GridConstraints(7, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myWireframeScrollPane = jBScrollPane2 = new JBScrollPane();
        jBPanel2.add((Component)jBScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDepthBuffer = jBPanel = new JBPanel();
        jBPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jBPanel, new GridConstraints(8, 0, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myDepthScrollPane = jBScrollPane = new JBScrollPane();
        jBPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)comboBox3);
        jBLabel2.setLabelFor((Component)comboBox2);
        jBLabel3.setLabelFor((Component)comboBox);
        threeComponentsSplitter.setFirstComponent((JComponent)jBPanel5);
        jViewport.setView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

