/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.RenderParamsFlags;
import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.AssetRepositoryImpl;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderSecurityManagerFactory;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.swing.layoutlib.FakeImageFactory;
import com.android.tools.swing.layoutlib.InitializationException;
import com.android.tools.swing.layoutlib.UnsupportedLayoutlibException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.uipreview.RenderingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphicsLayoutRenderer {
    private static final Logger LOG = Logger.getInstance(GraphicsLayoutRenderer.class);
    private static final int MIN_LAYOUTLIB_API_VERSION = 15;
    private final LayoutLibrary myLayoutLibrary;
    private final SessionParams mySessionParams;
    private final FakeImageFactory myImageFactory;
    private final DynamicHardwareConfig myHardwareConfig;
    private final Object myCredential;
    private final RenderSecurityManager mySecurityManager;
    private boolean myInvalidate;
    private final List<ResourceValue> myResourceLookupChain;
    private RenderSession myRenderSession;
    private double myScale;

    private GraphicsLayoutRenderer(@NotNull LayoutLibrary layoutLib, @NotNull SessionParams sessionParams, @NotNull RenderSecurityManager securityManager, @NotNull DynamicHardwareConfig hardwareConfig, @NotNull List<ResourceValue> resourceLookupChain, @NotNull Object credential) {
        if (layoutLib == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutLib", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        if (sessionParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionParams", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        if (securityManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "securityManager", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        if (hardwareConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hardwareConfig", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        if (resourceLookupChain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceLookupChain", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        if (credential == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credential", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "<init>"));
        }
        this.myScale = 1.0;
        this.myLayoutLibrary = layoutLib;
        this.mySecurityManager = securityManager;
        this.myHardwareConfig = hardwareConfig;
        this.mySessionParams = sessionParams;
        this.myImageFactory = new FakeImageFactory();
        this.myResourceLookupChain = resourceLookupChain;
        this.myCredential = credential;
        sessionParams.setFlag(RenderParamsFlags.FLAG_KEY_DISABLE_BITMAP_CACHING, (Object)Boolean.TRUE);
        this.mySessionParams.setImageFactory((IImageFactory)this.myImageFactory);
    }

    @NotNull
    protected static GraphicsLayoutRenderer create(@NotNull AndroidFacet facet, @NotNull AndroidPlatform platform, @NotNull IAndroidTarget target, @NotNull Project project, @NotNull Configuration configuration, @NotNull ILayoutPullParser parser, @NotNull SessionParams.RenderingMode renderingMode) throws InitializationException {
        LayoutLibrary layoutLib;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (renderingMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderingMode", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        Module module = facet.getModule();
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        try {
            layoutLib = platform.getSdkData().getTargetData(target).getLayoutLibrary(project);
            if (layoutLib == null) {
                throw new InitializationException("getLayoutLibrary() returned null");
            }
        }
        catch (RenderingException e) {
            throw new InitializationException(e);
        }
        catch (IOException e) {
            throw new InitializationException(e);
        }
        if (layoutLib.getApiLevel() < 15) {
            throw new UnsupportedLayoutlibException("GraphicsLayoutRenderer requires at least layoutlib version 15");
        }
        AppResourceRepository appResources = AppResourceRepository.getAppResources(facet, true);
        Object credential = new Object();
        RenderLogger logger = new RenderLogger("theme_editor", module, credential);
        final ActionBarCallback actionBarCallback = new ActionBarCallback();
        LayoutlibCallbackImpl layoutlibCallback = new LayoutlibCallbackImpl(null, layoutLib, appResources, module, facet, logger, credential, null){

            @Override
            public ActionBarCallback getActionBarCallback() {
                return actionBarCallback;
            }
        };
        layoutlibCallback.loadAndParseRClass();
        HardwareConfigHelper hardwareConfigHelper = new HardwareConfigHelper(configuration.getDevice());
        DynamicHardwareConfig hardwareConfig = new DynamicHardwareConfig(hardwareConfigHelper.getConfig());
        ArrayList<ResourceValue> resourceLookupChain = new ArrayList<ResourceValue>();
        ResourceResolver resourceResolver = configuration.getResourceResolver().createRecorder(resourceLookupChain);
        SessionParams params = new SessionParams(parser, renderingMode, (Object)module, (HardwareConfig)hardwareConfig, (RenderResources)resourceResolver, (LayoutlibCallback)layoutlibCallback, moduleInfo.getMinSdkVersion().getApiLevel(), moduleInfo.getTargetSdkVersion().getApiLevel(), (LayoutLog)logger, target instanceof CompatibilityRenderTarget ? target.getVersion().getApiLevel() : 0);
        params.setForceNoDecor();
        params.setAssetRepository((AssetRepository)new AssetRepositoryImpl(facet));
        RenderSecurityManager mySecurityManager = RenderSecurityManagerFactory.create(module, platform);
        GraphicsLayoutRenderer graphicsLayoutRenderer = new GraphicsLayoutRenderer(layoutLib, params, mySecurityManager, hardwareConfig, resourceLookupChain, credential);
        if (graphicsLayoutRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        return graphicsLayoutRenderer;
    }

    @NotNull
    public static GraphicsLayoutRenderer create(@NotNull Configuration configuration, @NotNull ILayoutPullParser parser, boolean hasHorizontalScroll, boolean hasVerticalScroll) throws InitializationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(configuration.getModule());
        if (facet == null) {
            throw new InitializationException("Unable to get AndroidFacet");
        }
        Module module = facet.getModule();
        IAndroidTarget target = configuration.getTarget();
        if (target == null) {
            throw new InitializationException("Unable to get IAndroidTarget");
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            throw new InitializationException("Unable to get AndroidPlatform");
        }
        SessionParams.RenderingMode renderingMode = hasVerticalScroll && hasHorizontalScroll ? SessionParams.RenderingMode.FULL_EXPAND : (hasVerticalScroll ? SessionParams.RenderingMode.V_SCROLL : (hasHorizontalScroll ? SessionParams.RenderingMode.H_SCROLL : SessionParams.RenderingMode.NORMAL));
        GraphicsLayoutRenderer graphicsLayoutRenderer = GraphicsLayoutRenderer.create(facet, platform, target, module.getProject(), configuration, parser, renderingMode);
        if (graphicsLayoutRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "create"));
        }
        return graphicsLayoutRenderer;
    }

    @NotNull
    private Dimension modelToView(int width, int height) {
        Dimension dimension = new Dimension((int)((double)width * this.myScale), (int)((double)height * this.myScale));
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "modelToView"));
        }
        return dimension;
    }

    @NotNull
    private Dimension modelToView(@NotNull Dimension d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "modelToView"));
        }
        Dimension dimension = this.modelToView(d.width, d.height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "modelToView"));
        }
        return dimension;
    }

    @NotNull
    private Dimension viewToModel(int width, int height) {
        Dimension dimension = new Dimension((int)((double)width / this.myScale), (int)((double)height / this.myScale));
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "viewToModel"));
        }
        return dimension;
    }

    @NotNull
    private Dimension viewToModel(@NotNull Dimension d) {
        if (d == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "viewToModel"));
        }
        Dimension dimension = this.viewToModel(d.width, d.height);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "viewToModel"));
        }
        return dimension;
    }

    @NotNull
    private Point viewToModel(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "viewToModel"));
        }
        Point point = new Point((int)((double)p.x / this.myScale), (int)((double)p.y / this.myScale));
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "viewToModel"));
        }
        return point;
    }

    public void setScale(double scale) {
        this.myScale = scale;
        this.setSize(new Dimension(this.myHardwareConfig.getScreenWidth(), this.myHardwareConfig.getScreenHeight()));
    }

    public void setSize(int width, int height) {
        Dimension dimen = this.viewToModel(width, height);
        this.myHardwareConfig.setScreenSize(Math.max(dimen.width, 1), Math.max(dimen.height, 1));
        this.myInvalidate = true;
    }

    public void setSize(Dimension dimen) {
        this.setSize(dimen.width, dimen.height);
    }

    public boolean render(@NotNull Graphics2D graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "render"));
        }
        if (!SystemInfo.isMac) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.myImageFactory.setGraphics(graphics);
        AffineTransform oldTransform = graphics.getTransform();
        if (this.myScale != 1.0) {
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            AffineTransform scaleTransform = new AffineTransform(oldTransform);
            scaleTransform.scale(this.myScale, this.myScale);
            graphics.setTransform(scaleTransform);
        }
        Result result = null;
        try {
            result = RenderService.runRenderAction(new Callable<Result>(){

                @Override
                public Result call() {
                    GraphicsLayoutRenderer.this.mySecurityManager.setActive(true, GraphicsLayoutRenderer.this.myCredential);
                    try {
                        if (GraphicsLayoutRenderer.this.myRenderSession == null) {
                            GraphicsLayoutRenderer.this.myResourceLookupChain.clear();
                            GraphicsLayoutRenderer.this.myRenderSession = GraphicsLayoutRenderer.this.initRenderSession();
                            Result result = GraphicsLayoutRenderer.this.myRenderSession != null ? GraphicsLayoutRenderer.this.myRenderSession.getResult() : null;
                            return result;
                        }
                        Result result = GraphicsLayoutRenderer.this.myRenderSession.render(250L, GraphicsLayoutRenderer.this.myInvalidate);
                        return result;
                    }
                    finally {
                        GraphicsLayoutRenderer.this.mySecurityManager.setActive(false, GraphicsLayoutRenderer.this.myCredential);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("Exception running render action", (Throwable)e);
        }
        if (this.myScale != 1.0) {
            graphics.setTransform(oldTransform);
        }
        if (result != null && result.getStatus() != Result.Status.SUCCESS) {
            if (result.getException() != null) {
                LOG.error(result.getException());
            } else {
                LOG.error("Render error (no exception). Status=" + result.getStatus().name());
            }
            return false;
        }
        this.myInvalidate = false;
        return true;
    }

    @Nullable
    private RenderSession initRenderSession() {
        return (RenderSession)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderSession>(){

            public RenderSession compute() {
                return GraphicsLayoutRenderer.this.myLayoutLibrary.createSession(GraphicsLayoutRenderer.this.mySessionParams);
            }
        });
    }

    @NotNull
    public Set<String> getUsedAttrs() {
        HashSet<String> usedAttrs = new HashSet<String>();
        for (ResourceValue value : this.myResourceLookupChain) {
            if (!(value instanceof ItemResourceValue) || value.getName() == null) continue;
            ItemResourceValue itemValue = (ItemResourceValue)value;
            usedAttrs.add((itemValue.isFrameworkAttr() ? "android:" : "") + itemValue.getName());
        }
        Set<String> set = Collections.unmodifiableSet(usedAttrs);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "getUsedAttrs"));
        }
        return set;
    }

    @Nullable
    private static ViewInfo viewAtPoint(@NotNull Point parentPosition, @NotNull ViewInfo view, @NotNull Point p) {
        int y;
        if (parentPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPosition", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "viewAtPoint"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "viewAtPoint"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "viewAtPoint"));
        }
        int x = parentPosition.x + view.getLeft();
        Rectangle rect = new Rectangle(x, y = parentPosition.y + view.getTop(), view.getRight() - view.getLeft(), view.getBottom() - view.getTop());
        if (rect.contains(p)) {
            for (ViewInfo childView : view.getChildren()) {
                ViewInfo hitView;
                if (childView.getCookie() == null || (hitView = GraphicsLayoutRenderer.viewAtPoint(rect.getLocation(), childView, p)) == null) continue;
                return hitView;
            }
            return view;
        }
        return null;
    }

    @Nullable
    public ViewInfo findViewAtPoint(@NotNull Point p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/android/tools/swing/layoutlib/GraphicsLayoutRenderer", "findViewAtPoint"));
        }
        if (this.myRenderSession == null) {
            return null;
        }
        p = this.viewToModel(p);
        Point base = new Point();
        for (ViewInfo view : this.myRenderSession.getRootViews()) {
            ViewInfo hitView = GraphicsLayoutRenderer.viewAtPoint(base, view, p);
            if (hitView == null) continue;
            return hitView;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return this.modelToView(this.myImageFactory.getRequestedWidth(), this.myImageFactory.getRequestedHeight());
    }

    public void dispose() {
        if (this.myRenderSession != null) {
            this.myRenderSession.dispose();
            this.myRenderSession = null;
        }
    }

    static class DynamicHardwareConfig
    extends HardwareConfig {
        private int myWidth;
        private int myHeight;

        public DynamicHardwareConfig(HardwareConfig delegate) {
            super(delegate.getScreenWidth(), delegate.getScreenHeight(), delegate.getDensity(), delegate.getXdpi(), delegate.getYdpi(), delegate.getScreenSize(), delegate.getOrientation(), delegate.getScreenRoundness(), delegate.hasSoftwareButtons());
            this.myWidth = delegate.getScreenWidth();
            this.myHeight = delegate.getScreenHeight();
        }

        public void setScreenSize(int width, int height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public int getScreenWidth() {
            return this.myWidth;
        }

        public int getScreenHeight() {
            return this.myHeight;
        }
    }
}

