/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.MethodBrowser;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit2.configuration.JUnitConfigurationModel;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.ui.AlternativeJREPanel;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class JUnitConfigurable<T extends JUnitConfiguration>
extends SettingsEditor<T>
implements PanelWithAnchor {
    private static final List<TIntArrayList> ourEnabledFields = Arrays.asList(new TIntArrayList(new int[]{0}), new TIntArrayList(new int[]{1}), new TIntArrayList(new int[]{1, 2}), new TIntArrayList(new int[]{3}), new TIntArrayList(new int[]{4}), new TIntArrayList(new int[]{5}));
    private static final String[] FORK_MODE_ALL = new String[]{"none", "method", "class"};
    private static final String[] FORK_MODE = new String[]{"none", "method"};
    private final ConfigurationModuleSelector myModuleSelector;
    private final LabeledComponent[] myTestLocations = new LabeledComponent[6];
    private final JUnitConfigurationModel myModel;
    private final BrowseModuleValueActionListener[] myBrowsers;
    private JComponent myPackagePanel;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myPackage;
    private LabeledComponent<TextFieldWithBrowseButton> myDir;
    private LabeledComponent<JPanel> myPattern;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myClass;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myMethod;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myCategory;
    private JPanel myWholePanel;
    private LabeledComponent<ModulesComboBox> myModule;
    private CommonJavaParametersPanel myCommonJavaParameters;
    private JRadioButton myWholeProjectScope;
    private JRadioButton mySingleModuleScope;
    private JRadioButton myModuleWDScope;
    private TextFieldWithBrowseButton myPatternTextField;
    private AlternativeJREPanel myAlternativeJREPanel;
    private JComboBox myForkCb;
    private JBLabel myTestLabel;
    private JComboBox myTypeChooser;
    private JBLabel mySearchForTestsLabel;
    private JPanel myScopesPanel;
    private JComboBox myRepeatCb;
    private JTextField myRepeatCountField;
    private Project myProject;
    private JComponent anchor;

    public JUnitConfigurable(final Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myModel = new JUnitConfigurationModel(project);
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.getModulesComponent());
        this.myCommonJavaParameters.setModuleContext(this.myModuleSelector.getModule());
        this.myCommonJavaParameters.setHasModuleMacro();
        ((ModulesComboBox)this.myModule.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUnitConfigurable.this.myCommonJavaParameters.setModuleContext(JUnitConfigurable.this.myModuleSelector.getModule());
            }
        });
        this.myBrowsers = new BrowseModuleValueActionListener[]{new PackageChooserActionListener(project), new TestClassBrowser(project), new MethodBrowser(project){

            protected Condition<PsiMethod> getFilter(PsiClass testClass) {
                return new JUnitUtil.TestMethodFilter(testClass);
            }

            protected String getClassName() {
                return JUnitConfigurable.this.getClassName();
            }

            protected ConfigurationModuleSelector getModuleSelector() {
                return JUnitConfigurable.this.myModuleSelector;
            }
        }, new TestsChooserActionListener(project), new BrowseModuleValueActionListener(project){

            protected String showDialog() {
                VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)project, null);
                if (virtualFile != null) {
                    return FileUtil.toSystemDependentName((String)virtualFile.getPath());
                }
                return null;
            }
        }, new CategoryBrowser(project)};
        DefaultComboBoxModel<Integer> aModel = new DefaultComboBoxModel<Integer>();
        aModel.addElement(0);
        aModel.addElement(4);
        aModel.addElement(3);
        aModel.addElement(1);
        aModel.addElement(2);
        aModel.addElement(5);
        this.myTypeChooser.setModel(aModel);
        this.myTypeChooser.setRenderer(new ListCellRendererWrapper<Integer>(){

            public void customize(JList list, Integer value, int index, boolean selected, boolean hasFocus) {
                switch (value) {
                    case 0: {
                        this.setText("All in package");
                        break;
                    }
                    case 4: {
                        this.setText("All in directory");
                        break;
                    }
                    case 3: {
                        this.setText("Pattern");
                        break;
                    }
                    case 1: {
                        this.setText("Class");
                        break;
                    }
                    case 2: {
                        this.setText("Method");
                        break;
                    }
                    case 5: {
                        this.setText("Category");
                    }
                }
            }
        });
        this.myTestLocations[0] = this.myPackage;
        this.myTestLocations[1] = this.myClass;
        this.myTestLocations[2] = this.myMethod;
        this.myTestLocations[4] = this.myDir;
        this.myTestLocations[5] = this.myCategory;
        this.myRepeatCb.setModel(new DefaultComboBoxModel<String>(RepeatCount.REPEAT_TYPES));
        this.myRepeatCb.setSelectedItem("Once");
        this.myRepeatCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUnitConfigurable.this.myRepeatCountField.setEnabled("N Times".equals(JUnitConfigurable.this.myRepeatCb.getSelectedItem()));
            }
        });
        JPanel panel = (JPanel)this.myPattern.getComponent();
        panel.setLayout(new BorderLayout());
        this.myPatternTextField = new TextFieldWithBrowseButton();
        this.myPatternTextField.setButtonIcon(IconUtil.getAddIcon());
        panel.add((Component)this.myPatternTextField, "Center");
        FixedSizeButton editBtn = new FixedSizeButton();
        editBtn.setIcon(AllIcons.Actions.ShowViewer);
        editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Messages.showTextAreaDialog((JTextField)JUnitConfigurable.this.myPatternTextField.getTextField(), (String)"Configure suite tests", (String)"EditParametersPopupWindow");
            }
        });
        panel.add((Component)editBtn, "East");
        this.myTestLocations[3] = this.myPattern;
        FileChooserDescriptor dirFileChooser = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        dirFileChooser.setHideIgnored(false);
        JTextField textField = ((TextFieldWithBrowseButton)this.myDir.getComponent()).getTextField();
        InsertPathAction.addTo((JTextComponent)textField, (FileChooserDescriptor)dirFileChooser);
        FileChooserFactory.getInstance().installFileCompletion(textField, dirFileChooser, true, null);
        this.myModel.setListener(this);
        this.myTypeChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = JUnitConfigurable.this.myTypeChooser.getSelectedItem();
                JUnitConfigurable.this.myModel.setType((Integer)selectedItem);
                JUnitConfigurable.this.changePanel();
            }
        });
        this.myModel.setType(1);
        this.installDocuments();
        JUnitConfigurable.addRadioButtonsListeners(new JRadioButton[]{this.myWholeProjectScope, this.mySingleModuleScope, this.myModuleWDScope}, null);
        this.myWholeProjectScope.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JUnitConfigurable.this.onScopeChanged();
            }
        });
        UIUtil.setEnabled((Component)this.myCommonJavaParameters.getProgramParametersComponent(), (boolean)false, (boolean)true);
        this.setAnchor((JComponent)this.mySearchForTestsLabel);
        this.myAlternativeJREPanel.setAnchor((JComponent)this.myModule.getLabel());
        this.myCommonJavaParameters.setAnchor((JComponent)this.myModule.getLabel());
    }

    private static void addRadioButtonsListeners(JRadioButton[] radioButtons, ChangeListener listener) {
        ButtonGroup group = new ButtonGroup();
        for (JRadioButton radioButton : radioButtons) {
            radioButton.getModel().addChangeListener(listener);
            group.add(radioButton);
        }
        if (group.getSelection() == null) {
            group.setSelected(radioButtons[0].getModel(), true);
        }
    }

    public void applyEditorTo(JUnitConfiguration configuration) {
        this.myModel.apply(this.getModuleSelector().getModule(), configuration);
        this.applyHelpersTo(configuration);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        if (this.myWholeProjectScope.isSelected()) {
            data.setScope(TestSearchScope.WHOLE_PROJECT);
        } else if (this.mySingleModuleScope.isSelected()) {
            data.setScope(TestSearchScope.SINGLE_MODULE);
        } else if (this.myModuleWDScope.isSelected()) {
            data.setScope(TestSearchScope.MODULE_WITH_DEPENDENCIES);
        }
        configuration.setAlternativeJrePath(this.myAlternativeJREPanel.getPath());
        configuration.setAlternativeJrePathEnabled(this.myAlternativeJREPanel.isPathEnabled());
        this.myCommonJavaParameters.applyTo((CommonJavaRunConfigurationParameters)configuration);
        configuration.setForkMode((String)this.myForkCb.getSelectedItem());
        configuration.setRepeatMode((String)this.myRepeatCb.getSelectedItem());
        try {
            configuration.setRepeatCount(Integer.parseInt(this.myRepeatCountField.getText()));
        }
        catch (NumberFormatException e) {
            configuration.setRepeatCount(1);
        }
    }

    public void resetEditorFrom(JUnitConfiguration configuration) {
        this.myModel.reset(configuration);
        this.myCommonJavaParameters.reset((CommonJavaRunConfigurationParameters)configuration);
        this.getModuleSelector().reset((ModuleBasedConfiguration)configuration);
        TestSearchScope scope = configuration.getPersistentData().getScope();
        if (scope == TestSearchScope.SINGLE_MODULE) {
            this.mySingleModuleScope.setSelected(true);
        } else if (scope == TestSearchScope.MODULE_WITH_DEPENDENCIES) {
            this.myModuleWDScope.setSelected(true);
        } else {
            this.myWholeProjectScope.setSelected(true);
        }
        this.myAlternativeJREPanel.init(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        this.myForkCb.setSelectedItem(configuration.getForkMode());
        int count = configuration.getRepeatCount();
        this.myRepeatCountField.setText(String.valueOf(count));
        this.myRepeatCountField.setEnabled(count > 1);
        this.myRepeatCb.setSelectedItem(configuration.getRepeatMode());
    }

    private void changePanel() {
        Integer selectedType;
        String selectedItem = (String)this.myForkCb.getSelectedItem();
        if (selectedItem == null) {
            selectedItem = "none";
        }
        if ((selectedType = (Integer)this.myTypeChooser.getSelectedItem()) == 0) {
            this.myPackagePanel.setVisible(true);
            this.myScopesPanel.setVisible(true);
            this.myPattern.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(false);
            this.myMethod.setVisible(false);
            this.myDir.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        } else if (selectedType == 4) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(false);
            this.myDir.setVisible(true);
            this.myPattern.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(false);
            this.myMethod.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        } else if (selectedType == 1) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(false);
            this.myPattern.setVisible(false);
            this.myDir.setVisible(false);
            this.myClass.setVisible(true);
            this.myCategory.setVisible(false);
            this.myMethod.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE));
            this.myForkCb.setSelectedItem(selectedItem != "class" ? selectedItem : "method");
        } else if (selectedType == 2) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(false);
            this.myPattern.setVisible(false);
            this.myDir.setVisible(false);
            this.myClass.setVisible(true);
            this.myCategory.setVisible(false);
            this.myMethod.setVisible(true);
            this.myForkCb.setEnabled(false);
            this.myForkCb.setSelectedItem("none");
        } else if (selectedType == 5) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(true);
            this.myDir.setVisible(false);
            this.myPattern.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(true);
            this.myMethod.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        } else {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(true);
            this.myPattern.setVisible(true);
            this.myDir.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(false);
            this.myMethod.setVisible(true);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        }
    }

    public ModulesComboBox getModulesComponent() {
        return (ModulesComboBox)this.myModule.getComponent();
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    private void installDocuments() {
        for (int i = 0; i < this.myTestLocations.length; ++i) {
            PlainDocument document;
            TextFieldWithBrowseButton field;
            LabeledComponent testLocation = this.getTestLocation(i);
            JComponent component = testLocation.getComponent();
            if (component instanceof TextFieldWithBrowseButton) {
                field = (TextFieldWithBrowseButton)component;
                document = new PlainDocument();
                field.getTextField().setDocument(document);
            } else if (component instanceof EditorTextFieldWithBrowseButton) {
                field = (ComponentWithBrowseButton)component;
                document = ((EditorTextField)field.getChildComponent()).getDocument();
            } else {
                field = this.myPatternTextField;
                document = new PlainDocument();
                field.getTextField().setDocument(document);
            }
            this.myBrowsers[i].setField((ComponentWithBrowseButton)field);
            if (this.myBrowsers[i] instanceof MethodBrowser) {
                EditorTextField childComponent = (EditorTextField)field.getChildComponent();
                ((MethodBrowser)this.myBrowsers[i]).installCompletion(childComponent);
                document = childComponent.getDocument();
            }
            this.myModel.setJUnitDocument(i, document);
        }
    }

    public LabeledComponent getTestLocation(int index) {
        return this.myTestLocations[index];
    }

    private void createUIComponents() {
        this.myPackage = new LabeledComponent();
        this.myPackage.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.myProject, false));
        this.myClass = new LabeledComponent();
        final TestClassBrowser classBrowser = new TestClassBrowser(this.myProject);
        this.myClass.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.myProject, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                try {
                    if (declaration instanceof PsiClass && (classBrowser.getFilter().isAccepted((PsiClass)declaration) || classBrowser.findClass(((PsiClass)declaration).getQualifiedName()) != null && place.getParent() != null)) {
                        return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                    }
                }
                catch (ClassBrowser.NoFilterException e) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        }));
        this.myCategory = new LabeledComponent();
        this.myCategory.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.myProject, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                if (declaration instanceof PsiClass) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        }));
        this.myMethod = new LabeledComponent();
        EditorTextFieldWithBrowseButton textFieldWithBrowseButton = new EditorTextFieldWithBrowseButton(this.myProject, true, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE, (FileType)PlainTextLanguage.INSTANCE.getAssociatedFileType());
        this.myMethod.setComponent((JComponent)textFieldWithBrowseButton);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.mySearchForTestsLabel.setAnchor(anchor);
        this.myTestLabel.setAnchor(anchor);
        this.myClass.setAnchor(anchor);
        this.myDir.setAnchor(anchor);
        this.myMethod.setAnchor(anchor);
        this.myPattern.setAnchor(anchor);
        this.myPackage.setAnchor(anchor);
        this.myCategory.setAnchor(anchor);
    }

    public void onTypeChanged(int newType) {
        this.myTypeChooser.setSelectedItem(newType);
        TIntArrayList enabledFields = ourEnabledFields.get(newType);
        for (int i = 0; i < this.myTestLocations.length; ++i) {
            this.getTestLocation(i).setEnabled(enabledFields.contains(i));
        }
        if (newType != 0 && newType != 3 && newType != 5) {
            this.myModule.setEnabled(true);
        } else {
            this.onScopeChanged();
        }
    }

    private void onScopeChanged() {
        Integer selectedItem = (Integer)this.myTypeChooser.getSelectedItem();
        boolean allInPackageAllInProject = (selectedItem == 0 || selectedItem == 3 || selectedItem == 5) && this.myWholeProjectScope.isSelected();
        this.myModule.setEnabled(!allInPackageAllInProject);
        if (allInPackageAllInProject) {
            ((ModulesComboBox)this.myModule.getComponent()).setSelectedItem(null);
        }
    }

    private String getClassName() {
        return ((EditorTextFieldWithBrowseButton)this.getTestLocation(1).getComponent()).getText();
    }

    private void setPackage(PsiPackage aPackage) {
        if (aPackage == null) {
            return;
        }
        ((EditorTextFieldWithBrowseButton)this.getTestLocation(0).getComponent()).setText(aPackage.getQualifiedName());
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit2/configuration/JUnitConfigurable", "createEditor"));
        }
        return jPanel;
    }

    private void applyHelpersTo(JUnitConfiguration currentState) {
        this.myCommonJavaParameters.applyTo((CommonJavaRunConfigurationParameters)currentState);
        this.getModuleSelector().applyTo((ModuleBasedConfiguration)currentState);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JBLabel jBLabel;
        JPanel jPanel;
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        JComboBox jComboBox;
        JTextField jTextField;
        JComboBox jComboBox2;
        AlternativeJREPanel alternativeJREPanel;
        LabeledComponent labeledComponent3;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JComboBox jComboBox3;
        JBLabel jBLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myTestLabel = jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(2);
        jBLabel2.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.configure.junit.test.kind.label"));
        jBLabel2.setIconTextGap(4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)jBLabel2, gridBagConstraints);
        this.myTypeChooser = jComboBox3 = new JComboBox();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        jPanel3.add(jComboBox3, gridBagConstraints2);
        JPanel jPanel4 = new JPanel();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 2;
        jPanel3.add((Component)jPanel4, gridBagConstraints3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCommonJavaParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel5.add((Component)commonJavaParametersPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myModule = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("com.intellij.application.options.ModulesComboBox");
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setEnabled(true);
        labeledComponent3.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        jPanel5.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myAlternativeJREPanel = alternativeJREPanel = new AlternativeJREPanel();
        jPanel5.add((Component)alternativeJREPanel, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 7, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 1, 1, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Repeat:");
        jLabel.setDisplayedMnemonic('R');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jLabel, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Fork mode:");
        jBLabel3.setDisplayedMnemonic('F');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myForkCb = jComboBox2 = new JComboBox();
        jPanel6.add(jComboBox2, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myRepeatCountField = jTextField = new JTextField();
        jPanel6.add((Component)jTextField, new GridConstraints(0, 5, 1, 1, 8, 1, 2, 0, new Dimension(30, -1), new Dimension(50, -1), new Dimension(60, -1)));
        this.myRepeatCb = jComboBox = new JComboBox();
        jPanel6.add(jComboBox, new GridConstraints(0, 4, 1, 1, 8, 1, 2, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(2, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 1, 1, 3, 3, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent4 = this.myMethod;
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setEnabled(true);
        labeledComponent4.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.method.label"));
        jPanel7.add((Component)labeledComponent4, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        this.myPackagePanel = jPanel8;
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent5 = this.myPackage;
        labeledComponent5.setLabelLocation("West");
        labeledComponent5.setEnabled(true);
        labeledComponent5.setVisible(true);
        labeledComponent5.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.package.label"));
        jPanel8.add((Component)labeledComponent5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myPattern = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("javax.swing.JPanel");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setVisible(true);
        labeledComponent2.setText("Pattern");
        jPanel7.add((Component)labeledComponent2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent6 = this.myClass;
        labeledComponent6.setLabelLocation("West");
        labeledComponent6.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.class.label"));
        jPanel7.add((Component)labeledComponent6, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent7 = this.myCategory;
        labeledComponent7.setLabelLocation("West");
        labeledComponent7.setText("Category");
        jPanel7.add((Component)labeledComponent7, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDir = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Directory");
        jPanel7.add((Component)labeledComponent, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myScopesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySearchForTestsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.search.for.tests.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWholeProjectScope = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.in.whole.project.radio"));
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySingleModuleScope = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.in.single.module.radio"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myModuleWDScope = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.across.module.dependencies.radio"));
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        jBLabel2.setLabelFor(jComboBox3);
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class CategoryBrowser
    extends ClassBrowser {
        public CategoryBrowser(Project project) {
            super(project, "Category Interface");
        }

        protected PsiClass findClass(String className) {
            return JUnitConfigurable.this.myModuleSelector.findClass(className);
        }

        protected ClassFilter.ClassFilterWithScope getFilter() throws ClassBrowser.NoFilterException {
            Module module = JUnitConfigurable.this.myModuleSelector.getModule();
            final GlobalSearchScope scope = module == null ? GlobalSearchScope.allScope((Project)JUnitConfigurable.this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            return new ClassFilter.ClassFilterWithScope(){

                public GlobalSearchScope getScope() {
                    return scope;
                }

                public boolean isAccepted(PsiClass aClass) {
                    return true;
                }
            };
        }

        protected void onClassChoosen(PsiClass psiClass) {
            ((EditorTextFieldWithBrowseButton)JUnitConfigurable.this.getTestLocation(5).getComponent()).setText(psiClass.getQualifiedName());
        }
    }

    private class TestClassBrowser
    extends ClassBrowser {
        public TestClassBrowser(Project project) {
            super(project, ExecutionBundle.message((String)"choose.test.class.dialog.title", (Object[])new Object[0]));
        }

        protected void onClassChoosen(PsiClass psiClass) {
            JUnitConfigurable.this.setPackage(JUnitUtil.getContainingPackage((PsiClass)psiClass));
        }

        protected PsiClass findClass(String className) {
            return JUnitConfigurable.this.getModuleSelector().findClass(className);
        }

        protected ClassFilter.ClassFilterWithScope getFilter() throws ClassBrowser.NoFilterException {
            TestClassFilter classFilter;
            ConfigurationModuleSelector moduleSelector = JUnitConfigurable.this.getModuleSelector();
            Module module = moduleSelector.getModule();
            if (module == null) {
                throw ClassBrowser.NoFilterException.moduleDoesntExist((ConfigurationModuleSelector)moduleSelector);
            }
            try {
                JUnitConfiguration configurationCopy = new JUnitConfiguration(ExecutionBundle.message((String)"default.junit.configuration.name", (Object[])new Object[0]), this.getProject(), JUnitConfigurationType.getInstance().getConfigurationFactories()[0]);
                JUnitConfigurable.this.applyEditorTo(configurationCopy);
                classFilter = TestClassFilter.create(configurationCopy.getTestObject().getSourceScope(), ((JavaRunConfigurationModule)configurationCopy.getConfigurationModule()).getModule());
            }
            catch (JUnitUtil.NoJUnitException e) {
                throw ClassBrowser.NoFilterException.noJUnitInModule((Module)module);
            }
            return classFilter;
        }
    }

    private class TestsChooserActionListener
    extends TestClassBrowser {
        public TestsChooserActionListener(Project project) {
            super(project);
        }

        @Override
        protected void onClassChoosen(PsiClass psiClass) {
            JTextField textField = JUnitConfigurable.this.myPatternTextField.getTextField();
            String text = textField.getText();
            textField.setText(text + (text.length() > 0 ? "||" : "") + psiClass.getQualifiedName());
        }

        @Override
        protected ClassFilter.ClassFilterWithScope getFilter() throws ClassBrowser.NoFilterException {
            try {
                return TestClassFilter.create(SourceScope.wholeProject((Project)this.getProject()), null);
            }
            catch (JUnitUtil.NoJUnitException ignore) {
                throw new ClassBrowser.NoFilterException(new MessagesEx.MessageInfo(this.getProject(), ignore.getMessage(), ExecutionBundle.message((String)"cannot.browse.test.inheritors.dialog.title", (Object[])new Object[0])));
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.showDialog();
        }
    }

    private static class PackageChooserActionListener
    extends BrowseModuleValueActionListener {
        public PackageChooserActionListener(Project project) {
            super(project);
        }

        protected String showDialog() {
            PackageChooserDialog dialog = new PackageChooserDialog(ExecutionBundle.message((String)"choose.package.dialog.title", (Object[])new Object[0]), this.getProject());
            dialog.show();
            PsiPackage aPackage = dialog.getSelectedPackage();
            return aPackage != null ? aPackage.getQualifiedName() : null;
        }
    }
}

