/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.BooleanEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.BooleanRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBooleanProperty<T extends RadComponent>
extends Property<T, Boolean> {
    private BooleanRenderer myRenderer;
    private BooleanEditor myEditor;
    private final boolean myDefaultValue;

    protected AbstractBooleanProperty(Property parent, @NonNls String name, boolean defaultValue) {
        super(parent, name);
        this.myDefaultValue = defaultValue;
    }

    @Override
    @NotNull
    public PropertyRenderer<Boolean> getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new BooleanRenderer();
        }
        BooleanRenderer booleanRenderer = this.myRenderer;
        if (booleanRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/AbstractBooleanProperty", "getRenderer"));
        }
        return booleanRenderer;
    }

    @Override
    public PropertyEditor<Boolean> getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new BooleanEditor();
        }
        return this.myEditor;
    }

    @Override
    public boolean isModified(T component) {
        Boolean intValue = (Boolean)this.getValue(component);
        return intValue != null && intValue.booleanValue() != this.getDefaultValue(component);
    }

    @Override
    public void resetValue(T component) throws Exception {
        this.setValue(component, this.getDefaultValue(component));
    }

    protected boolean getDefaultValue(T component) {
        return this.myDefaultValue;
    }
}

