/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.util.Map;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"c\u0006)i\u0001\n^7m\u000f\u0016tWM]1u_JT1a\u001c:h\u0015!Ig\u000e^3mY&T'\u0002C7be.$wn\u001e8\u000b\t!$X\u000e\u001c\u0006\u0004\u0003:L(BB6pi2LgN\u0003\u0004=S:LGO\u0010\u0006\r[\u0006\u00148\u000eZ8x]R+\u0007\u0010\u001e\u0006\u0007'R\u0014\u0018N\\4\u000b\tI|w\u000e\u001e\u0006\b\u0003N#fj\u001c3f\u0015\r\t7\u000f\u001e\u0006\bM2\fgo\\;s\u0015ei\u0015M]6e_^tg\t\\1w_V\u0014H)Z:de&\u0004Ho\u001c:\u000b\u0011\u0019d\u0017M^8veNTq\u0001\\5oW6\u000b\u0007OC\u0004MS:\\W*\u00199\u000b\rA\f'o]3s\u0015MIgn\u00197vI\u0016\u001c&o\u0019)pg&$\u0018n\u001c8t\u0015\u001d\u0011un\u001c7fC:TAA[1wC*!A.\u00198h\u0015)AG/\u001c7TiJLgn\u001a\u0006\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\u000b\u0013A\u0014xN^5eKJ\u001c(bA'ba*a\u0011*\u00127f[\u0016tG\u000fV=qK*\u0011r)\u001a8fe\u0006$\u0018N\\4Qe>4\u0018\u000eZ3s\u0015\u0011)H/\u001b7\u000b\u0019\u001d,g.\u001a:bi\u0016DE/\u001c7\u000b\u0013\r{W\u000e]1oS>t'\"\u0006%u[2<UM\\3sCRLgn\u001a,jg&$xN\u001d]\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)1\u0001b\u0001\t\u00011\u0001Q!\u0001\u0005\u0004\u000b\r!)\u0001#\u0002\r\u0001\u0015\u0019AQ\u0001E\u0005\u0019\u0001)!\u0001B\u0001\t\r\u0015\u0019A\u0001\u0002E\u0006\u0019\u0001)!\u0001B\u0001\t\u0010\u0015\u0019A!\u0002\u0005\b\u0019\u0001)!\u0001B\u0001\t\u0013\u0015\u0019AA\u0002E\t\u0019\u0001)1\u0001\"\u0002\t\u00151\u0001Q!\u0001E\u000b\u000b\t!y\u0001C\u0006\u0006\u0005\u0011A\u0001\u0012B\u0003\u0003\t\u0011AY!\u0002\u0002\u0005\u000b!9QA\u0001\u0003\u0007\u0011#)1\u0001\u0002\u0005\t\u00191\u0001QA\u0001\u0003\t\u00111)1\u0001\"\u0002\t\u001b1\u0001Qa\u0001\u0003\u0002\u00117a\u0001!B\u0002\u0005\u0004!qA\u0002A\u0003\u0003\t\u001fAi\"\u0002\u0002\u0005\u001b!iAa\u0001\u0007\u0003!?I2!B\u0001\t\u0007a\u0019Q$a\b\u0011[1!\u0011\r\u0002M\fC\r)\u0011\u0001#\u0006\u0019\u0016U\u001bA!B\u0002\u0005\u0018%\t\u0001bC\u0017\r\t\u0005$\u00014C\u0011\u0004\u000b\u0005Aq\u0001G\u0004V\u0007\u0011)1\u0001b\u0005\n\u0003\u0011\u0005Q\u0006\u0004\u0003b\ta!\u0011eA\u0003\u0002\u0011\u000fA:!V\u0002\u0005\u000b\r!A!C\u0001\t\u001252B!\u0019\u0003\u0019\u001a\u0005jQ!\u0001E\f\u0013\u0011I1!B\u0001\t\u0019aa\u0011\u0002B\u0005\u0004\u000b\u0005AI\u0002'\u0007\u0019\u0018U\u001bA!B\u0002\u0005\u001a%\t\u00012D\u0017\r\t\u0005$\u0001$B\u0011\u0004\u000b\u0005AI\u0001'\u0003V\u0007\u0011)1\u0001B\u0003\n\u0003!IQV\u0003\u0003\u00041=\t3!B\u0001\t\ba\u001d\u0011kA\u0002\u0005\u001f%\t\u0001\u0012C[A\u0002\u0015}Da9\u0001\u0019\bu=A\u0001\u0001\u0005\u0005\u001b\r)\u0011\u0001c\u0002\u0019\bA\u001b\u0001!h\u0004\u0005\u0001!)QbA\u0003\u0002\u0011\u0013AJ\u0001UB\u0001;\u001f!\u0001\u0001#\u0004\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\tQt\u0002\u0003\u0002\u0011!i1!B\u0001\t\u000ea5\u0001ka\u0001\u001e\u0010\u0011\t\u00012C\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\t\t3!B\u0001\t\u0005a\u0011\u0011kA\u0007\u0005\b%\tA\u0001A\u0007\u0002\u0011#i\u0011\u0001C\u0005\u000e\u0003!MQ\"\u0001\u0005\u000b\u001b\u0005!\t\u0001"})
public final class HtmlGenerator {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final String SRC_ATTRIBUTE_NAME = "md-src-pos";
    private final Map<IElementType, ? extends GeneratingProvider> providers;
    private final StringBuilder htmlString;
    private final String markdownText;
    private final ASTNode root;
    private final boolean includeSrcPositions;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(HtmlGenerator.class);
        Companion companion = Companion = new Companion(null);
        SRC_ATTRIBUTE_NAME = SRC_ATTRIBUTE_NAME;
    }

    @NotNull
    public final String generateHtml() {
        new HtmlGeneratingVisitor().visitNode(this.root);
        String string = this.htmlString.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"htmlString.toString()");
        return string;
    }

    public HtmlGenerator(@NotNull String markdownText, @NotNull ASTNode root, @NotNull MarkdownFlavourDescriptor flavour, @NotNull LinkMap linkMap, boolean includeSrcPositions) {
        Intrinsics.checkParameterIsNotNull((Object)markdownText, (String)"markdownText");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)flavour, (String)"flavour");
        Intrinsics.checkParameterIsNotNull((Object)linkMap, (String)"linkMap");
        this.markdownText = markdownText;
        this.root = root;
        this.includeSrcPositions = includeSrcPositions;
        this.providers = flavour.createHtmlGeneratingProviders(linkMap);
        this.htmlString = new StringBuilder();
    }

    public /* synthetic */ HtmlGenerator(String string, ASTNode aSTNode, MarkdownFlavourDescriptor markdownFlavourDescriptor, LinkMap linkMap, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            linkMap = LinkMap.Builder.buildLinkMap(aSTNode, string);
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(string, aSTNode, markdownFlavourDescriptor, linkMap, bl);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u001a\u0006))\u0002\n^7m\u000f\u0016tWM]1uS:<g+[:ji>\u0014(\"\u0004%u[2<UM\\3sCR|'OC\u0002pe\u001eT\u0001\"\u001b8uK2d\u0017N\u001b\u0006\t[\u0006\u00148\u000eZ8x]*!\u0001\u000e^7m\u0015A\u0011VmY;sg&4XMV5tSR|'OC\u0002bgRT\u0001B^5tSR|'o\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0017\r|gn];nK\"#X\u000e\u001c\u0006\r\u0007\"\f'oU3rk\u0016t7-\u001a\u0006\u0007W>$H.\u001b8\u000b\tUs\u0017\u000e\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'bD2p]N,X.\u001a+bO\u000ecwn]3\u000b\u000fQ\fwMT1nK*q1m\u001c8tk6,G+Y4Pa\u0016t'\u0002\u00028pI\u0016Tq!Q*U\u001d>$WM\u0003\u0006biR\u0014\u0018NY;uKNTQ!\u0011:sCfT\u0011\"Y;u_\u000ecwn]3\u000b\u000f\t{w\u000e\\3b]*Ia/[:ji2+\u0017M\u001a\u0006\nm&\u001c\u0018\u000e\u001e(pI\u0016\u0014\u0019A\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0007\u0011\r\u0001\u0012\u0001\u0007\u0001\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\u0011A!\u0001E\u0004\u000b\t!1\u0001\u0003\u0003\u0006\u0007\u0011\u001d\u0001b\u0001\u0007\u0001\u000b\t!\u0019\u0001#\u0001\u0006\u0003!1Qa\u0001\u0003\u0006\u0011\u0017a\u0001!B\u0002\u0005\u000b!5A\u0002A\u0003\u0002\u0011\u001d)!\u0001\"\u0004\t\u0010\u0015\u0011Aa\u0002E\u0006\u000b\r!1\u0001\u0003\u0006\r\u0001\u0015\u0019A!\u0002\u0005\f\u0019\u0001)1\u0001B\u0003\t\u00191\u0001QA\u0001\u0003\u0004\u0011)!1I\u0001G\u00033\r)\u0011\u0001\u0003\u0003\u0019\t5*Ba\u0001\r\u0006;\u001f!\u0001\u0001#\u0002\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0019Ab!U\u0002\u0006\t\u0015I\u0011\u0001\u0002\u0001\u000e\u0003!=Q&\u0006\u0003\u00041!iz\u0001\u0002\u0001\t\u00125\u0019Q!\u0001E\u00061\u0017\u00016\u0001A\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004R\u0007\u0015!\u0001\"C\u0001\u0005\u00015\t\u0001rBWB\u0002\u0011\u0019\u0001$CO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0001u=A\u0001\u0001E\t\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\t!h\n\u0005\u0001!UQBC\u0003\u0002\u0011#Ia\u0001\"\u0001\n\t\u0015\t\u00012\u0002G\u00011\u0017A\n\"\u0005\u0003\u0006\u0003!-A\u0012\u0001M\u0006!\u000e\tQt\u0002\u0003\u0002\u0011/i1!B\u0001\t\u0013aI\u0001ka\u0001\"\u0007\u0015\t\u0001B\u0002\r\u0007#\u000eaA!C\u0005\u0002\t\u0001i\u0011\u0001c\u0005\u000e\u0003!=QB\u0001E\b\u0019\u0003i\u0011\u0001\"\u0001.+\u0011\u0019\u0001\u0014DO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u00071\u0019\t6!\u0002C\r\u0013\u0005!\u0001!D\u0001\t\u00145*Ba\u0003\r\u000e;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\u0002\u0003\r\t!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0019Ab!U\u0002\u0006\t5I\u0011\u0001\u0002\u0001\u000e\u0003!MQGD\u0003\u000e\t\r\b\u0001\u0014B\u0011\u0004\u000b\u0005A)\u0001'\u0002R\u0007\u0015!I!C\u0001\u0005\u00015\t\u0001\u0012\u0002"})
    public final class HtmlGeneratingVisitor
    extends RecursiveVisitor {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(HtmlGeneratingVisitor.class);
        }

        @Override
        public void visitNode(@NotNull ASTNode node) {
            block3: {
                GeneratingProvider generatingProvider;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    generatingProvider = HtmlGenerator.this.providers.get(node.getType());
                    if (generatingProvider == null) break block2;
                    generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
                    generatingProvider = Unit.INSTANCE$;
                    if (generatingProvider != null) break block3;
                }
                node.acceptChildren(this);
                generatingProvider = Unit.INSTANCE$;
            }
        }

        public final void visitLeaf(@NotNull ASTNode node) {
            block3: {
                GeneratingProvider generatingProvider;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    generatingProvider = HtmlGenerator.this.providers.get(node.getType());
                    if (generatingProvider == null) break block2;
                    generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
                    generatingProvider = Unit.INSTANCE$;
                    if (generatingProvider != null) break block3;
                }
                this.consumeHtml(org.intellij.markdown.html.HtmlGenerator$Companion.leafText$default(Companion, HtmlGenerator.this.markdownText, node, false, 4));
                generatingProvider = Unit.INSTANCE$;
            }
        }

        public final void consumeTagOpen(@NotNull ASTNode node, @NotNull CharSequence tagName, @NotNull CharSequence[] attributes, boolean autoClose) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            HtmlGenerator.this.htmlString.append("<" + tagName);
            for (int i = 0; i < attributes.length; ++i) {
                CharSequence attribute = attributes[i];
                if (attribute == null) continue;
                HtmlGenerator.this.htmlString.append(" " + attribute);
            }
            if (HtmlGenerator.this.includeSrcPositions) {
                HtmlGenerator.this.htmlString.append(" " + Companion.getSrcPosAttribute(node));
            }
            if (autoClose) {
                HtmlGenerator.this.htmlString.append(" />");
            } else {
                HtmlGenerator.this.htmlString.append(">");
            }
        }

        public static /* synthetic */ void consumeTagOpen$default(HtmlGeneratingVisitor htmlGeneratingVisitor, ASTNode aSTNode, CharSequence charSequence, CharSequence[] charSequenceArray, boolean bl, int n) {
            if ((n & 8) != 0) {
                bl = false;
            }
            htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray, bl);
        }

        public final void consumeTagClose(@NotNull CharSequence tagName) {
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            HtmlGenerator.this.htmlString.append("</" + tagName + ">");
        }

        public final void consumeHtml(@NotNull CharSequence html) {
            Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
            HtmlGenerator.this.htmlString.append(html);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\n\u0006)I1i\\7qC:LwN\u001c\u0006\u000e\u0011RlGnR3oKJ\fGo\u001c:\u000b\u0007=\u0014xM\u0003\u0005j]R,G\u000e\\5k\u0015!i\u0017M]6e_^t'\u0002\u00025u[2T1!\u00118z\u0015\u0019Yw\u000e\u001e7j]*\u00112KU\"`\u0003R#&+\u0013\"V)\u0016{f*Q'F\u0015\u0019\u0019FO]5oO*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b+\u001d,Go\u0015*D?\u0006#FKU%C+R+uLT!N\u000b*\u0011r-\u001a;Te\u000e\u0004vn]!uiJL'-\u001e;f\u0015\u0011qw\u000eZ3\u000b\u000f\u0005\u001bFKT8eK*\u0019\u0011m\u001d;\u000b\u0019\rC\u0017M]*fcV,gnY3\u000b\u00111,\u0017M\u001a+fqRTA\u0001^3yi*I\"/\u001a9mC\u000e,Wi]2ba\u0016\u001c\u0018I\u001c3F]RLG/[3t\u0015\u001d\u0011un\u001c7fC:T1\u0002\u001e:j[&sG-\u001a8ug*1\u0011N\u001c3f]RT1!\u00138uy*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015Qa\u0001C\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\u000f)1\u0001B\u0002\t\u00071\u0001Qa\u0001\u0003\u0004\u0011\u0013a\u0001!B\u0001\t\u000b\u0015\u0011A\u0011\u0002E\u0006\u000b\t!Q\u0001#\u0003\u0006\u0005\u0011\t\u0001\u0002C\u0003\u0004\t\u0019Ay\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0012\u0003\u0007\u0001\u000b\t!Q\u0001#\u0005\u0006\u0005\u00111\u0001rB\u0003\u0004\t\rA)\u0002\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0002\u0004\u0007\u0001\t\r\u000fARA\r\u0004\u000b\u0005A9\u0001g\u0002.#\u0011\u0019G\u0003\u0007\u0003\"\u0007\u0015\t\u0001\u0002\u0002\r\u0005+\u000eIQ\u0001\u0002\u0003\u0005\u0013\u0005AY\u0001$\u0001\u000e\u0007\u00111\u0011\"\u0001E\u0006[U!1\u0001'\u0004\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0001\t3!B\u0001\t\u000fa9\u0011kA\u0003\u0005\u000e%\t\u0001rB\u0007\u0002\u0011!i#\u0006B\u0002\u0019\u0013u=A\u0001\u0001E\n\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0001!h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u001bAj\u0001UB\u0001;\u001f!\u0011\u0001\u0003\u0006\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\t\u0011eA\u0003\u0002\u0011\u001dAr!U\u0002\n\t%I\u0011\u0001c\u0004\u000e\u0003!-Q\"\u0001\u0005\t\u001b\u0005!\t!l\u0010\u0005\u0007aYQt\u0002\u0003\u0001\u0011'i1!B\u0001\t\u000fa9\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001rC\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0003\t3!B\u0001\t\u000fa9\u0011kA\u0004\u0005\u0017%\t\u0001rB\u0007\u0002\u0011\u001fi\u0011\u0001\"\u00026\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final String getSRC_ATTRIBUTE_NAME() {
            return SRC_ATTRIBUTE_NAME;
        }

        @NotNull
        public final CharSequence leafText(@NotNull String text, @NotNull ASTNode node, boolean replaceEscapesAndEntities) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.Companion.getBLOCK_QUOTE())) {
                return "";
            }
            return EntityConverter.INSTANCE$.replaceEntities(ASTUtilKt.getTextInNode(node, text), replaceEscapesAndEntities, replaceEscapesAndEntities);
        }

        @NotNull
        public static /* synthetic */ CharSequence leafText$default(Companion companion, String string, ASTNode aSTNode, boolean bl, int n) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.leafText(string, aSTNode, bl);
        }

        @NotNull
        public final CharSequence getSrcPosAttribute(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.getSRC_ATTRIBUTE_NAME() + "=" + "\"" + node.getStartOffset() + ".." + node.getEndOffset() + "\"";
        }

        @NotNull
        public final CharSequence trimIndents(@NotNull CharSequence text, int indent) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (indent == 0) {
                return text;
            }
            StringBuilder buffer = new StringBuilder();
            int lastFlushed = 0;
            for (int offset = 0; offset < text.length(); ++offset) {
                if (offset != 0 && StringsKt.get((CharSequence)text, (int)(offset - 1)) != '\n') continue;
                buffer.append(text.subSequence(lastFlushed, offset));
                int indentEaten = 0;
                block5: while (indentEaten < indent && offset < text.length()) {
                    switch (StringsKt.get((CharSequence)text, (int)offset)) {
                        case ' ': {
                            ++indentEaten;
                            break;
                        }
                        case '\t': {
                            indentEaten += 4 - indentEaten % 4;
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    ++offset;
                }
                if (indentEaten > indent) {
                    buffer.append(StringsKt.repeat((String)" ", (int)(indentEaten - indent)));
                }
                lastFlushed = offset;
            }
            buffer.append(text.subSequence(lastFlushed, text.length()));
            return buffer;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

