/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MyBuilder;
import org.intellij.markdown.parser.MyRawBuilder;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.sequentialparsers.LexerBasedTokensCache;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"?\u0006)qQ*\u0019:lI><h\u000eU1sg\u0016\u0014(bA8sO*A\u0011N\u001c;fY2L'N\u0003\u0005nCJ\\Gm\\<o\u0015\u0019\u0001\u0018M]:fe*\u0019\u0011I\\=\u000b\r-|G\u000f\\5o\u0015\u0019a\u0014N\\5u})9a\r\\1w_V\u0014(\"G'be.$wn\u001e8GY\u00064x.\u001e:EKN\u001c'/\u001b9u_JT\u0001B\u001a7bm>,(o\u001d\u0006\u001cEVLG\u000eZ'be.$wn\u001e8Ue\u0016,gI]8n'R\u0014\u0018N\\4\u000b\tQ,\u0007\u0010\u001e\u0006\u0007'R\u0014\u0018N\\4\u000b\u000f\u0005\u001bFKT8eK*\u0019\u0011m\u001d;\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\u0003qCJ\u001cXM\u0003\u0003s_>$(\u0002D%FY\u0016lWM\u001c;UsB,'\u0002\u00049beN,\u0017J\u001c7j]\u0016\u001c(b\u0002\"p_2,\u0017M\u001c\u0006\fa\u0006\u00148/Z%oY&tWM\u0003\u0007DQ\u0006\u00148+Z9vK:\u001cWMC\u0005uKb$8\u000b^1si*\u0019\u0011J\u001c;\u000b\u000fQ,\u0007\u0010^#oI*i\u0012J\u001c7j]\u0016,\u0005\u0010]1oI&tw-Q*U\u001d>$WMQ;jY\u0012,'Of\u0001\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0019A1\u0001\u0005\u0001\u0019\u0001)\u0011\u0001C\u0002\u0006\u0007\u0011\u0015\u0001R\u0001\u0007\u0001\u000b\t!\u0011\u0001C\u0003\u0006\u0007\u0011\u001d\u0001\u0012\u0002\u0007\u0001\u000b\t!9\u0001#\u0003\u0006\u0007\u0011\u0015\u0001R\u0002\u0007\u0001\u000b\t!\u0011\u0001c\u0004\u0006\u0007\u0011-\u0001b\u0002\u0007\u0001\u000b\t!Y\u0001C\u0004\u0006\u0003!AQA\u0001\u0003\b\u0011#)!\u0001b\u0004\t\u000e\u0015\u0019A!\u0001\u0005\u000b\u0019\u0001)1\u0001\"\u0002\t\u00171\u0001QA\u0001\u0003\u0002\u0011))1\u0001\"\u0002\t\u00191\u0001Qa\u0001C\u0003\u00115a\u0001!\u0002\u0002\u0005\u0010!aAa\u0001\u0007\u00033\r)\u0011\u0001C\u0002\u0019\u0007u\u0005a\"\f\u0007\u0005C\u0012AB!I\u0002\u0006\u0003!!\u0001\u0004B+\u0004\t\u0015\u0019A\u0001B\u0005\u0002\u0011\u0013iS\u0003B\u0002\u0019\fu=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\u0001!I\u0002\u0006\u0003!1\u0001DB)\u0004\u000b\u0011-\u0011\"\u0001E\u0007\u001b\u0005A\u0001\"\f\u0016\u0005\u0007aIQt\u0002\u0003\u0001\u0011'i1!B\u0001\t\u0012aE\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BB\u0007\u0004\u000b\u0005AQ\u0001G\u0003Q\u0007\u0003iz\u0001B\u0001\t\u00165\u0019Q!\u0001\u0005\n1%\u00016!A\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004R\u0007%!\u0011\"C\u0001\t\u000e5\t\u00012C\u0007\u0002\u0011!i\u0011\u0001\"\u0001.j\u0011\u0019\u0001tCO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!E\u0001\u0014\u0003)\u0004\u0001u=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001\u0003\u0006\u0019\u0015A\u001b\t!h\u0004\u0005\u0001!eQbA\u0003\u0002\u0011+A*\u0002U\u0002\u0002;\u001f!\u0001\u0001c\u0007\u000e\u0007\u0015\t\u0001R\u0003M\u000b!\u000e\r\u0011eA\u0003\u0002\u0011\u0019Ab!U\u0002\f\t/I\u0011\u0001#\u0004\u000e\u0003!MQ\"\u0001\u0005\f\u001b\u0005!)!D\u0001\u0005\u0006U6R1\u0006\u0003d\u0002a\u001dQt\u0002\u0003\u0001\u0011\u0011i1!B\u0001\t\ta!\u0001k\u0001\u0001\"\u0007\u0015\t\u0001B\u0001\r\u0003#\u000e)AqA\u0005\u0002\t\u0001i\u0011\u0001#\u0003"})
public final class MarkdownParser {
    public static final /* synthetic */ KClass $kotlinClass;
    private final MarkdownFlavourDescriptor flavour;

    static {
        $kotlinClass = Reflection.createKotlinClass(MarkdownParser.class);
    }

    @NotNull
    public final ASTNode buildMarkdownTreeFromString(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.parse(MarkdownElementTypes.Companion.getMARKDOWN_FILE(), text, true);
    }

    @NotNull
    public final ASTNode parse(@NotNull IElementType root, @NotNull String text, boolean parseInlines) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        ProductionHolder productionHolder = new ProductionHolder();
        MarkerProcessor<?> markerProcessor = this.flavour.getMarkerProcessorFactory().createMarkerProcessor(productionHolder);
        ProductionHolder.Marker rootMarker = productionHolder.mark();
        LookaheadText textHolder = new LookaheadText(text);
        LookaheadText.Position pos = textHolder.getStartPosition();
        while (pos != null) {
            productionHolder.updatePosition(pos.getOffset());
            pos = markerProcessor.processPosition(pos);
        }
        productionHolder.updatePosition(text.length());
        markerProcessor.flushMarkers();
        rootMarker.done(root);
        ASTNodeBuilder nodeBuilder = parseInlines ? (ASTNodeBuilder)new InlineExpandingASTNodeBuilder(text) : new ASTNodeBuilder(text);
        MyRawBuilder builder = new MyRawBuilder(nodeBuilder);
        return builder.buildTree(productionHolder.getProduction());
    }

    @NotNull
    public static /* synthetic */ ASTNode parse$default(MarkdownParser markdownParser, IElementType iElementType, String string, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return markdownParser.parse(iElementType, string, bl);
    }

    @NotNull
    public final ASTNode parseInline(@NotNull IElementType root, @NotNull CharSequence text, int textStart, int textEnd) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        MarkdownLexer lexer = this.flavour.createInlinesLexer();
        lexer.start(text, textStart, textEnd);
        LexerBasedTokensCache tokensCache = new LexerBasedTokensCache(lexer);
        IntRange wholeRange = new IntRange(0, tokensCache.getFilteredTokens().size());
        Collection<SequentialParser.Node> nodes = this.flavour.getSequentialParserManager().runParsingSequence(tokensCache, SequentialParserUtil.Companion.filterBlockquotes(tokensCache, (Range<Integer>)((Range)wholeRange)));
        return new MyBuilder(new ASTNodeBuilder(text), tokensCache).buildTree(CollectionsKt.plus(nodes, (Iterable)CollectionsKt.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)wholeRange), root))));
    }

    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour) {
        Intrinsics.checkParameterIsNotNull((Object)flavour, (String)"flavour");
        this.flavour = flavour;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"m\u0004)i\u0012J\u001c7j]\u0016,\u0005\u0010]1oI&tw-Q*U\u001d>$WMQ;jY\u0012,'O\u0003\bNCJ\\Gm\\<o!\u0006\u00148/\u001a:\u000b\u0007=\u0014xM\u0003\u0005j]R,G\u000e\\5k\u0015!i\u0017M]6e_^t'B\u00029beN,'O\u0003\bB'Rsu\u000eZ3Ck&dG-\u001a:\u000b\u0007\u0005\u001cHO\u0003\u0004=S:LGO\u0010\u0006\u0005i\u0016DHO\u0003\u0007DQ\u0006\u00148+Z9vK:\u001cWM\u0003\u0004l_Rd\u0017N\u001c\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'bD2sK\u0006$X\rT3bM:{G-Z:\u000b\tQL\b/\u001a\u0006\r\u0013\u0016cW-\\3oiRK\b/\u001a\u0006\fgR\f'\u000f^(gMN,GOC\u0002J]RT\u0011\"\u001a8e\u001f\u001a47/\u001a;\u000b\t1K7\u000f\u001e\u0006\b\u0003N#fj\u001c3f\u0015\u0011)H/\u001b7\t\u0004)\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015Qa\u0001C\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0003\t\u0005A9!B\u0002\u0005\u0007!\u0019A\u0002A\u0003\u0002\u0011\u0017)1\u0001\u0002\u0003\t\u000b1\u0001QA\u0001C\u0002\u0011\u0003)\u0011\u0001\u0003\u0004\u0006\u0005\u0011-\u0001RB\u0003\u0003\t\u0019AQ!B\u0002\u0005\u0003!AA\u0002A\u0003\u0004\t\u0011A\u0011\u0002\u0004\u0001\u0006\u0007\u0011!\u0001B\u0003\u0007\u0001\u000b\r!1\u0001#\u0006\r\u0001\u0015\u0011A1\u0002\u0005\f\u000b\t!\u0011\u0002\u0003\u0006\u0006\u0005\u0011\t\u0001\u0002\u0003\u0003B\u00051\u0015\u0011dA\u0003\u0002\u0011\u000fA:!L\u0018\u0005\u0017a9Qt\u0002\u0003\u0001\u0011\u001fi1!B\u0001\t\u000fa9\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005Ay\u0001g\u0004Q\u0007\u0003iz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001E\b1\u001f\u00016!A\u0011\t\u000b\u0005A\u0001\"\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0003M\t1!\t6!\u0003\u0003\b\u0013\u0005A\u0019\"D\u0001\t\u00155\tAQA\u0007\u0002\t\u000b)\f$b\f\u0005G\u0004AB!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u0013AJ\u0001UB\u0001C\r)\u0011\u0001#\u0002\u0019\u0006E\u001bq\u0001\u0002\u0003\n\u0003\u0011\u0001Q\"\u0001\u0005\u0006\u001b\u0005Ai\u0001"})
    private final class InlineExpandingASTNodeBuilder
    extends ASTNodeBuilder {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(InlineExpandingASTNodeBuilder.class);
        }

        @Override
        @NotNull
        public List<ASTNode> createLeafNodes(@NotNull IElementType type, int startOffset, int endOffset) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            IElementType iElementType = type;
            return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.Companion.getPARAGRAPH()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getATX_CONTENT()) || Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.Companion.getSETEXT_CONTENT()) ? CollectionsKt.listOf((Object)MarkdownParser.this.parseInline(type, this.getText(), startOffset, endOffset)) : super.createLeafNodes(type, startOffset, endOffset);
        }

        public InlineExpandingASTNodeBuilder(CharSequence text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            super(text);
        }
    }
}

