/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.CompilerOutputParser;
import org.jetbrains.kotlin.compilerRunner.CompilerRunnerUtil;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.rmi.CompileService;
import org.jetbrains.kotlin.rmi.CompilerId;
import org.jetbrains.kotlin.rmi.DaemonJVMOptions;
import org.jetbrains.kotlin.rmi.DaemonOptions;
import org.jetbrains.kotlin.rmi.DaemonParamsKt;
import org.jetbrains.kotlin.rmi.kotlinr.CompilationServices;
import org.jetbrains.kotlin.rmi.kotlinr.DaemonReportCategory;
import org.jetbrains.kotlin.rmi.kotlinr.DaemonReportMessage;
import org.jetbrains.kotlin.rmi.kotlinr.DaemonReportingTargets;
import org.jetbrains.kotlin.rmi.kotlinr.KotlinCompilerClient;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"5\u0010)!2j\u001c;mS:\u001cu.\u001c9jY\u0016\u0014(+\u001e8oKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u000fG>l\u0007/\u001b7feJ+hN\\3s\u0015\r\te.\u001f\u0006\u000f\u0013:#VI\u0015(B\u0019~+%KU(S\u0015\u0019\u0019FO]5oO*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b\u001b-\u0013$jU0D\u001f6\u0003\u0016\nT#S\u00159Y%G\u0013,N?\u000e{U\nU%M\u000bJS1cY8mY\u0016\u001cGOR5fY\u0012\u001cHk\\\"pafTQa\u00197bujTQa\u00117bgNTA\u0001T5ti*)a)[3mI*9!/\u001a4mK\u000e$(\u0002B;uS2TqcZ3u%\u0016$XO\u001d8D_\u0012,gI]8n\u001f\nTWm\u0019;\u000b\u0005I\u001c'BB(cU\u0016\u001cGOC\u0001U\u0015]\u0019u.\\7p]\u000e{W\u000e]5mKJ\f%oZ;nK:$8OC\u0002dY&TaaY8n[>t'\"C1sOVlWM\u001c;t\u0015)iWM]4f\u0005\u0016\fgn\u001d\u0006\u0005MJ|WN\u0003\u0002u_*)\u0002O]8dKN\u001c8i\\7qS2,'oT;uaV$(\u0002E7fgN\fw-Z\"pY2,7\r^8s\u0015AiUm]:bO\u0016\u001cu\u000e\u001c7fGR|'O\u0003\u0005nKN\u001c\u0018mZ3t\u0015%\u0019w\u000e\u001c7fGR|'O\u0003\u000bPkR\u0004X\u000f^%uK6\u001c8i\u001c7mK\u000e$xN\u001d\u0006\u0007gR\u0014X-Y7\u000b+\tKH/Z!se\u0006Lx*\u001e;qkR\u001cFO]3b[*\u0011\u0011n\u001c\u0006\tKbLGoQ8eK*!QK\\5u\u0015m\u0011X\r]8si&sG/\u001a:oC2\u001cu.\u001c9jY\u0016\u0014XI\u001d:pe*Y!/\u001e8D_6\u0004\u0018\u000e\\3s\u0015E\u0019w.\u001c9jY\u0016\u00148\t\\1tg:\u000bW.\u001a\u0006\u0014C\u0012$\u0017\u000e^5p]\u0006d\u0017I]4v[\u0016tGo\u001d\u0006\fK:4\u0018N]8o[\u0016tGOC\nD_6\u0004\u0018\u000e\\3s\u000b:4\u0018N]8o[\u0016tGOC\bsk:\\%GS:D_6\u0004\u0018\u000e\\3s\u0015=\u0019w.\\7p]\u0006\u0013x-^7f]R\u001c(\"D63UN\f%oZ;nK:$8OC\u000bLe)\u001b6i\\7qS2,'/\u0011:hk6,g\u000e^:\u000b!\r|W\u000e]5mKJ\u001cV\r\u001e;j]\u001e\u001c(\u0002E\"p[BLG.\u001a:TKR$\u0018N\\4t\u0015\u0019\u0019wN\u001c4jO*Y1o\\;sG\u00164\u0015\u000e\\3t\u0015)\u0019u\u000e\u001c7fGRLwN\u001c\u0006\u0005\r&dWM\u0003\u0007mS\n\u0014\u0018M]=GS2,7O\u0003\u0006pkR\u0004X\u000f\u001e$jY\u0016T\u0001C];o\u0017JRe/\\\"p[BLG.\u001a:\u000b\u001d-\u0014$N^7Be\u001e,X.\u001a8ug*12J\r&W\u001b\u000e{W\u000e]5mKJ\f%oZ;nK:$8O\u0003\u0006n_\u0012,H.\u001a$jY\u0016T!c]3ukB\\%GS:Be\u001e,X.\u001a8ug*Yql\\;uaV$h)\u001b7f\u00155yF.\u001b2sCJLh)\u001b7fg*A1/\u001a;uS:<7OC\ntKR,\bo\u0013\u001aKm6\f%oZ;nK:$8O\u0003\u000buef\u001cu.\u001c9jY\u0016<\u0016\u000e\u001e5EC\u0016lwN\u001c\u0006\nCJ<7/\u0011:sCfTQ!\u0011:sCfTqAQ8pY\u0016\fg\u000e1\u0002\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0019A1\u0001\u0005\u0001\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u0011\u0015\u0001R\u0001\u0007\u0001\u000b\r!)\u0001c\u0002\r\u0001\u0015\t\u0001\u0002B\u0003\u0003\t\u0011AI!\u0002\u0002\u0005\n!\u001dQa\u0001C\u0005\u0011\u001da\u0001!B\u0002\u0005\u0006!=A\u0002A\u0003\u0003\t\u0013A\t\"B\u0002\u0005\u000e!AA\u0002A\u0003\u0003\t\u0011A\u0011\"\u0002\u0002\u0005\u0010!=QA\u0001C\u0005\u0011\u001d)!\u0001\"\u0003\t\u0016\u0015\u0011A!\u0001\u0005\r\u000b\t!\u0019\u0002#\u0007\u0006\u0005\u0011Q\u0001\"D\u0003\u0004\t+A9\u0002\u0004\u0001\u0006\u0005\u0011U\u0001rC\u0003\u0003\t)A\t#B\u0002\u0005\u0019!\u0001B\u0002A\u0003\u0004\t\u0007A\u0019\u0003\u0004\u0001\u0006\u0005\u0011!\u0001bE\u0003\u0004\t7A)\u0003\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0006\u0007\u0001\u000b\t!A\u0002\u0003\t\u0006\u0005\u0011\r\u00012E\u0003\u0003\t7A)#B\u0002\u0005\u0004!9B\u0002A\u0003\u0003\t\u0007Aq#B\u0002\u0005\u0016!IB\u0002A\u0003\u0003\t\u0005A)$B\u0002\u0005%!QB\u0002A\u0003\u0004\t\u000bA9\u0004\u0004\u0001\u0006\u0007\u0011m\u0001\u0002\b\u0007\u0001\u000b\t!)\u0002C\r\u0006\u0005\u0011\u0011\u0002BG\u0003\u0003\t\u001fA9$\u0002\u0002\u0005\u001c!aRa\u0001C\u000b\u0011{a\u0001!\u0002\u0002\u0005\u0016!uRa\u0001C\u0003\u0011\rb\u0001!B\u0002\u0005\u0006!\u001dC\u0002\u0001\u0003d\u00031\u0011\u0011dA\u0003\u0002\u0011\rA2!\f\u0007\u0005C\u0012A2!I\u0002\u0006\u0003!\u001d\u0001tA+\u0004\t\u0015\u0019AaA\u0005\u0002\u0011\u0015iC\u0002B1\u00151\u0015\t3!B\u0001\t\ba\u001dQk\u0001\u0003\u0006\u0007\u0011)\u0011\"\u0001\u0005\u0006[1!\u0011\r\u0006M\u0006C\r)\u0011\u0001c\u0002\u0019\bU\u001bA!B\u0002\u0005\f%\t\u0001\"B\u0017\u001d\t\u0005Ab!h\u0005\u0005\u0001!5Q\"B\u0003\u0002\u0011\u0017I\u0011\u0001b\u0001\u0019\fA\u001b\u0001!\t\u0005\u0006\u0003!1\u0011\u0002B\u0005\u0004\u000b\u0005Aq\u0001G\u0004\u0019\rE\u001bQ\u0001\u0002\u0004\n\u0003!AQ\"\u0001E\t[Y!\u0011\u0001g\u0005\u001e\u0012\u0011\u0001\u0001BC\u0007\u0005\u000b\u0005A1\u0001$\u0001\u0019\u0007A\u001b\u0001!I\u0002\u0006\u0003!\u001d\u0001tA)\u0004\u000b\u0011M\u0011\"\u0001\u0005\u0006\u001b\u0005A\u0011\",\u0015\u0005\u0003E1A\u0001\u0001\u0005\f+\r)\u0011\u0001C\u0006\u0019\u0017amQt\u0002\u0003\u0001\u00119i1!B\u0001\t\u0017aY\u0001k\u0001\u0001\u001e\u0012\u0011\u0001\u0001RD\u0007\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001A\u001b\t!\t\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u0001#\u000e9A1D\u0005\u0002\u0011/i\u0011\u0001c\u0006\u000e\u0003!]Q\u0016\u000e\u0003\u00021=iz\u0001\u0002\u0001\t 5\u0019Q!\u0001E\r13\u00016\u0001AO\b\t\u0001A\u0011#D\u0002\u0006\u0003!i\u0001$\u0004)\u0004\u0002u=A\u0001\u0001\u0005\u0013\u001b\r)\u0011\u0001\u0003\b\u0019\u001dA\u001b\u0011!h\u0004\u0005\u0001!\u001dRbA\u0003\u0002\u0011\u000fA:\u0001UB\u0002C\r)\u0011\u0001#\b\u0019\u001eE\u001b1\u0002B\b\n\u0003\u0011\u0001Q\"\u0001\u0005\u0010\u001b\u0005Ay\"D\u0001\t!5\t\u0001\"B\u0017\u0016\t\u0005AJ#h\u0004\u0005\u0001!}QbA\u0003\u0002\u00113AJ\u0002U\u0002\u0001C\r)\u0011\u0001#\b\u0019\u001eE\u001bQ\u0001\"\u000b\n\u0003\u0011\u0001Q\"\u0001\u0005\u0010['\u0007A!\u0001\r\u0016;\u001f!\u0001\u0001c\u000b\u000e\u0007\u0015\t\u0001r\u0001M\u0004!\u000e\u0001Qt\u0002\u0003\u0001\u00115i1!B\u0001\t\u0017aY\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001BF\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0005iz\u0001\u0002\u0001\t 5\u0019Q!\u0001E\r13\u000161AO\b\t\u0001A\u0011#D\u0002\u0006\u0003!i\u0001$\u0004)\u0004\u0005u=A\u0001\u0001E\u0017\u001b\r)\u0011\u0001#\t\u0019\"A\u001b)!I\u0002\u0006\u0003!u\u0001TD)\u0004\u001f\u0011)\u0012\"\u0001\u0003\u0001\u001b\u0005AQ!D\u0001\t\u00185\t\u0001\"B\u0007\u0002\u0011=i\u0011\u0001c\b\u000e\u0003!\tRf=\u0001\u0005\u0007a=Rt\u0002\u0003\u0001\u0011ai1!B\u0001\t\u0017aY\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012G\u0007\u0004\u000b\u0005A\u0019\u0003g\tQ\u0007\u0003iz\u0001\u0002\u0001\t45\u0019Q!\u0001E\u00131K\u00016!AO\b\t\u0001Ay\"D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0004u=A\u0001\u0001E\u0017\u001b\r)\u0011\u0001#\t\u0019\"A\u001b!!h\u0004\u0005\u0001!\tRbA\u0003\u0002\u00115AR\u0002UB\u0003;3!\u0001\u0001C\u000e\u000e\u0011\u0015\t\u0001bE\u0005\u0005\u0013\r)\u0011\u0001c\n\u0019(a\u0019\u0002kA\u0002\u001e\u001a\u0011\u0001\u0001\u0012H\u0007\t\u000b\u0005Aa!\u0003\u0003\n\u0007\u0015\t\u0001r\u0001M\u00041\u0019\u00016qAO\b\t\u0001AQ$D\u0002\u0006\u0003!\u001d\u0002t\u0005)\u0004\t\u0005\u001aQ!\u0001E\u000f1;\t6!\u0006C\u0018\u0013\u0005!\u0001!D\u0001\t\u00185\t\u0001\u0002F\u0007\u0002\u0011Si\u0011\u0001C\b\u000e\u0003!\tR\"\u0001E\u0010\u001b\u0005AQ#D\u0001\t\u00115\t\u00012F\u0017U\u0002\u0011\u0019\u00014HO\b\t\u0001A\u0001$D\u0002\u0006\u0003!Y\u0001d\u0003)\u0004\u0001u=A\u0001\u0001\u0005\u001f\u001b\r)\u0011\u0001\u0003\f\u0019-A\u001b\t!h\u0004\u0005\u0001!MRbA\u0003\u0002\u0011KA*\u0003U\u0002\u0002;\u001f!\u0001\u0001c\b\u000e\u0007\u0015\t\u0001\u0012\u0004M\r!\u000e\rQt\u0002\u0003\u0001\u0011[i1!B\u0001\t\"a\u0005\u0002k\u0001\u0002\u001e\u0010\u0011\u0001\u0001bH\u0007\u0004\u000b\u0005A9\u0003g\nQ\u0007\u000biz\u0001\u0002\u0001\t#5\u0019Q!\u0001\u0005\u000e15\u00016aA\u0011\u0004\u000b\u0005Ai\u0002'\bR\u0007E!Y$C\u0001\u0005\u00015\t\u0001rC\u0007\u0002\u0011[i\u0011\u0001#\u000b\u000e\u0003!yQ\"\u0001\u0005\u0012\u001b\u0005AY#D\u0001\t 5vD!\u0001M ;\u001f!\u0001\u0001\u0003\u0011\u000e\u0007\u0015\t\u0001r\u0005M\u0014!\u000e\u0001Q\u0014\u0004\u0003\u0001\u0011mi\u0001\"B\u0001\t'%!\u0011bA\u0003\u0002\u0011OA:\u0003G\nQ\u0007\u0003iJ\u0002\u0002\u0001\tB5AQ!\u0001\u0005\u0007\u0013\u0011I1!B\u0001\t\ba\u001d\u0001D\u0002)\u0004\u0003u=A\u0001\u0001\u0005\"\u001b\r)\u0011\u0001c\t\u0019$A\u001b\u0019!I\u0002\u0006\u0003!u\u0001TD)\u0004\u0017\u0011}\u0012\"\u0001\u0003\u0001\u001b\u0005AY#D\u0001\t+5\t\u0001\u0002C\u0007\u0002\u0011Qi{\u0004B\u0001\u0019Du=A\u0001\u0001\u0005 \u001b\r)\u0011\u0001c\n\u0019(A\u001b\u0001!h\u0004\u0005\u0001!\tSbA\u0003\u0002\u0011YAb\u0003UB\u0001C\r)\u0011\u0001#\b\u0019\u001eE\u001bq\u0001b\u0011\n\u0003\u0011\u0001Q\"\u0001E\u0016\u001b\u0005Ai#,\u001e\u0005\u0003a\u0011St\u0002\u0003\u0001\u0011?i1!B\u0001\t\u001aae\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"E\u0007\u0004\u000b\u0005AQ\u0002G\u0007Q\u0007\u0003iz\u0001\u0002\u0001\t.5\u0019Q!\u0001E\u00111C\u00016!AO\r\t\u0001A)%\u0004\u0005\u0006\u0003!9\u0012\u0002B\u0005\u0004\u000b\u0005A9\u0001g\u0002\u0019/A\u001b\u0019!I\u0002\u0006\u0003!=\u0002tF)\u0004\u0019\u0011\u0011\u0013\"\u0001C\u0001\u001b\u0005Aq\"D\u0001\t 5\t\u0001\"E\u0007\u0003\u0011\u0015a\t!\u000e\u0001"})
public final class KotlinCompilerRunner {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final String K2JVM_COMPILER = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    private static final String K2JS_COMPILER = "org.jetbrains.kotlin.cli.js.K2JSCompiler";
    private static final String INTERNAL_ERROR;
    public static final KotlinCompilerRunner INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinCompilerRunner.class);
        new KotlinCompilerRunner();
    }

    public final void runK2JvmCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JVMCompilerArguments k2jvmArguments, @NotNull CompilerSettings compilerSettings, @NotNull MessageCollector messageCollector, @NotNull CompilerEnvironment environment, @NotNull File moduleFile, @NotNull OutputItemsCollector collector) {
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)k2jvmArguments, (String)"k2jvmArguments");
        Intrinsics.checkParameterIsNotNull((Object)compilerSettings, (String)"compilerSettings");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)moduleFile, (String)"moduleFile");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        K2JVMCompilerArguments arguments = (K2JVMCompilerArguments)this.mergeBeans(commonArguments, (CommonCompilerArguments)k2jvmArguments);
        this.setupK2JvmArguments(moduleFile, arguments);
        this.runCompiler(K2JVM_COMPILER, arguments, compilerSettings.getAdditionalArguments(), messageCollector, collector, environment);
    }

    public final void runK2JsCompiler(@NotNull CommonCompilerArguments commonArguments, @NotNull K2JSCompilerArguments k2jsArguments, @NotNull CompilerSettings compilerSettings, @NotNull MessageCollector messageCollector, @NotNull CompilerEnvironment environment, @NotNull OutputItemsCollector collector, @NotNull Collection<? extends File> sourceFiles, @NotNull List<? extends String> libraryFiles, @NotNull File outputFile) {
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)k2jsArguments, (String)"k2jsArguments");
        Intrinsics.checkParameterIsNotNull((Object)compilerSettings, (String)"compilerSettings");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)collector, (String)"collector");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull(libraryFiles, (String)"libraryFiles");
        Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
        K2JSCompilerArguments arguments = (K2JSCompilerArguments)this.mergeBeans(commonArguments, (CommonCompilerArguments)k2jsArguments);
        this.setupK2JsArguments(outputFile, sourceFiles, libraryFiles, arguments);
        this.runCompiler(K2JS_COMPILER, arguments, compilerSettings.getAdditionalArguments(), messageCollector, collector, environment);
    }

    private final void processCompilerOutput(MessageCollector messageCollector, OutputItemsCollector collector, ByteArrayOutputStream stream, String exitCode) {
        BufferedReader reader = new BufferedReader(new StringReader(stream.toString()));
        CompilerOutputParser.parseCompilerMessagesFromReader(messageCollector, reader, collector);
        if (Intrinsics.areEqual((Object)INTERNAL_ERROR, (Object)exitCode)) {
            this.reportInternalCompilerError(messageCollector);
        }
    }

    private final void reportInternalCompilerError(MessageCollector messageCollector) {
        messageCollector.report(CompilerMessageSeverity.ERROR, "Compiler terminated with internal error", CompilerMessageLocation.Companion.getNO_LOCATION());
    }

    /*
     * WARNING - void declaration
     */
    private final void runCompiler(String compilerClassName, CommonCompilerArguments arguments, String additionalArguments, MessageCollector messageCollector, OutputItemsCollector collector, CompilerEnvironment environment) {
        try {
            void $receiver;
            messageCollector.report(CompilerMessageSeverity.INFO, "Using kotlin-home = " + environment.getKotlinPaths().getHomePath(), CompilerMessageLocation.Companion.getNO_LOCATION());
            List<String> argumentsList = ArgumentUtils.convertArgumentsToStringList(arguments);
            argumentsList.addAll(StringsKt.split$default((String)additionalArguments, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6));
            Collection collection = argumentsList;
            void v0 = $receiver;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection = (Collection)v0;
            String[] stringArray = thisCollection.toArray(new String[thisCollection.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] argsArray = (String[])((Object[])stringArray);
            if (!this.tryCompileWithDaemon(messageCollector, collector, environment, argsArray)) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(stream);
                Object rc = CompilerRunnerUtil.invokeExecMethod(compilerClassName, argsArray, environment, messageCollector, out);
                this.processCompilerOutput(messageCollector, collector, stream, this.getReturnCodeFromObject(rc));
            }
        }
        catch (Throwable e) {
            MessageCollectorUtil.reportException(messageCollector, e);
            this.reportInternalCompilerError(messageCollector);
        }
    }

    private final boolean tryCompileWithDaemon(MessageCollector messageCollector, OutputItemsCollector collector, CompilerEnvironment environment, String[] argsArray) {
        if (DaemonParamsKt.isDaemonEnabled()) {
            File libPath = CompilerRunnerUtil.getLibPath(environment.getKotlinPaths(), messageCollector);
            CompilerId compilerId = CompilerId.Companion.makeCompilerId(new File(libPath, "kotlin-compiler.jar"));
            DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
            DaemonJVMOptions daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions(true, new String[0]);
            ArrayList daemonReportMessages = new ArrayList();
            CompileService daemon = KotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, new DaemonReportingTargets(null, daemonReportMessages), true, true);
            for (DaemonReportMessage msg : daemonReportMessages) {
                if (msg.getCategory() == DaemonReportCategory.EXCEPTION && daemon == null) {
                    messageCollector.report(CompilerMessageSeverity.INFO, "Falling  back to compilation without daemon due to error: " + msg.getMessage(), CompilerMessageLocation.Companion.getNO_LOCATION());
                    continue;
                }
                messageCollector.report(CompilerMessageSeverity.INFO, msg.getMessage(), CompilerMessageLocation.Companion.getNO_LOCATION());
            }
            if (daemon != null) {
                ByteArrayOutputStream compilerOut = new ByteArrayOutputStream();
                ByteArrayOutputStream daemonOut = new ByteArrayOutputStream();
                CompilationServices services = new CompilationServices(environment.getServices().get(IncrementalCompilationComponents.class), environment.getServices().get(CompilationCanceledStatus.class));
                int res = KotlinCompilerClient.incrementalCompile(daemon, argsArray, services, compilerOut, daemonOut);
                this.processCompilerOutput(messageCollector, collector, compilerOut, String.valueOf(res));
                TextStreamsKt.forEachLine((Reader)new BufferedReader(new StringReader(daemonOut.toString())), (Function1)((Function1)new Function1<String, Unit>(messageCollector){
                    final /* synthetic */ MessageCollector $messageCollector;

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$messageCollector.report(CompilerMessageSeverity.INFO, it, CompilerMessageLocation.Companion.getNO_LOCATION());
                    }
                    {
                        this.$messageCollector = messageCollector;
                        super(1);
                    }
                }));
                return true;
            }
        }
        return false;
    }

    private final String getReturnCodeFromObject(Object rc) {
        if (rc == null) {
            return INTERNAL_ERROR;
        }
        if (Intrinsics.areEqual((Object)ExitCode.class.getName(), (Object)rc.getClass().getName())) {
            return rc.toString();
        }
        throw (Throwable)new IllegalStateException("Unexpected return: " + rc);
    }

    private final <T extends CommonCompilerArguments> T mergeBeans(CommonCompilerArguments from, T to) {
        CommonCompilerArguments copy = (CommonCompilerArguments)XmlSerializerUtil.createCopy(to);
        List<Field> fromFields = this.collectFieldsToCopy(from.getClass());
        for (Field fromField : fromFields) {
            Field toField = copy.getClass().getField(fromField.getName());
            toField.set(copy, fromField.get(from));
        }
        CommonCompilerArguments commonCompilerArguments = copy;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCompilerArguments, (String)"copy");
        return (T)commonCompilerArguments;
    }

    private final List<Field> collectFieldsToCopy(Class<?> clazz) {
        ArrayList<Field> fromFields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fieldArray = currentClass.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                fromFields.add(field);
            }
        }
        return fromFields;
    }

    private final void setupK2JvmArguments(File moduleFile, K2JVMCompilerArguments settings) {
        K2JVMCompilerArguments $receiver = settings;
        $receiver.module = moduleFile.getAbsolutePath();
        $receiver.noStdlib = true;
        $receiver.noJdkAnnotations = true;
        $receiver.noJdk = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void setupK2JsArguments(File _outputFile, Collection<? extends File> sourceFiles, List<? extends String> _libraryFiles, K2JSCompilerArguments settings) {
        Object[] objectArray;
        void destination;
        void $receiver;
        Collection $receiver2;
        K2JSCompilerArguments $receiver3 = settings;
        $receiver3.noStdlib = true;
        Iterable iterable = sourceFiles;
        K2JSCompilerArguments k2JSCompilerArguments = $receiver3;
        void var8_8 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            File file = (File)item;
            objectArray = destination;
            String string = it.getPath();
            objectArray.add(string);
        }
        k2JSCompilerArguments.freeArgs = objectArray = (Object[])destination;
        $receiver3.outputFile = _outputFile.getPath();
        $receiver3.metaInfo = true;
        $receiver2 = _libraryFiles;
        k2JSCompilerArguments = $receiver3;
        Collection collection2 = $receiver2;
        if (collection2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection = collection2;
        String[] stringArray = thisCollection.toArray(new String[thisCollection.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = stringArray;
        k2JSCompilerArguments.libraryFiles = (String[])objectArray;
    }

    KotlinCompilerRunner() {
        INSTANCE$ = this;
        K2JVM_COMPILER = K2JVM_COMPILER;
        K2JS_COMPILER = K2JS_COMPILER;
        INTERNAL_ERROR = ExitCode.INTERNAL_ERROR.toString();
    }
}

