/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.StringsKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"n\u0006)AB+Z1nG&$\u0018p\u0015;bi&\u001cH/[2t\u0019><w-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015\u0015\u0011W/\u001b7e\u0015\r\te.\u001f\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0019%\u001cxJ\u001c+fC6\u001c\u0017\u000e^=\u000b\u000f\t{w\u000e\\3b]*IAo\u001c;bYRKW.\u001a\u0006\u000b\u0003R|W.[2M_:<'\u0002\u00026bm\u0006TA!\u001e;jY*Q1m\u001c8dkJ\u0014XM\u001c;\u000b\r\u0005$x.\\5d\u0015\u0019)7oY1qK*!A/\u001a=u\u0015\u0019\u0019FO]5oO*!A.\u00198h\u0015-)7oY1qK\u0012\u001c\u0005.\u0019:\u000b\u0003\rTAa\u00115be*9\u0002O]5oiB+'o\u00115v].\u001cF/\u0019;jgRL7m\u001d\u0006\f[>$W\u000f\\3DQVt7NC\u0006N_\u0012,H.Z\"ik:\\'b\u0004;j[\u0016$vnQ8na&dWMT:\u000b\t1{gn\u001a\u0006\u0005+:LGOC\u000bqe&tGo\u0015;bi&\u001cH/[2NKN\u001c\u0018mZ3\u000b\u0007-,\u0017PC\u0003wC2,XMC\tsK\u001eL7\u000f^3s'R\fG/[:uS\u000eT1B]3q_J$Hk\u001c;bY*ia.\u00198pgR{W*\u001b7mSNd\u001aA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\u0004\u0011\ra\u0001!B\u0002\u0005\u0007!%A\u0002A\u0003\u0002\u0011\u0019)!\u0001\"\u0003\t\u000e\u0015\u0011A!\u0002\u0005\b\u000b\t!Y\u0001c\u0004\u0006\u0007\u00111\u00012\u0002\u0007\u0001\u000b\t!a\u0001c\u0003\u0006\u0007\u0011\u0019\u0001\"\u0003\u0007\u0001\u000b\t!I\u0001c\u0005\u0006\u0005\u0011A\u0001\"C\u0003\u0004\t\rA1\u0002\u0004\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0004\t'AI\u0002\u0004\u0001\u0006\u0007\u0011\u0019\u00012\u0004\u0007\u0001\u000b\r!1\u0001\u0003\b\r\u0001\u0015\u0011A1\u0003E\r\t\ra)!G\u0002\u0006\u0003!\u001d\u0001tA\u0017\r\t\u0005$\u0001\u0004B\u0011\u0004\u000b\u0005AA\u0001\u0007\u0003V\u0007\u0011)1\u0001\u0002\u0003\n\u0003\u0011\u0005Q\u0006\u0004\u0003b\ta)\u0011eA\u0003\u0002\u0011\u001bAj!V\u0002\u0005\u000b\r!Q!C\u0001\t\u000f5*B!\u0001\r\t;\u001f!\u0001\u0001#\u0005\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\u0001\u0011eA\u0003\u0002\u0011\u001fAz!U\u0002\u0006\t!I\u0011\u0001#\u0005\u000e\u0003!EQ&\u0006\u0003\u00021)iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001\u0005\n1%\u00016\u0001A\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005R\u0007\u0015!!\"C\u0001\u0005\u00035\tA!AW \t\u0005A:\"h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011)A\"\u0002U\u0002\u0001;\u001f!\u0001\u0001C\u0007\u000e\u0007\u0015\t\u0001R\u0003M\u000b!\u000e\u0005\u0011eA\u0003\u0002\u0011-A2\"U\u0002\b\t/I\u0011\u0001\u0002\u0001\u000e\u0003!]Q\"\u0001C\u0004[\u007f!\u0011\u0001'\b\u001e\u0010\u0011\u0001\u0001bD\u0007\u0004\u000b\u0005Ay\u0001g\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t 5\u0019Q!\u0001E\b1\u001f\u00016\u0011A\u0011\u0004\u000b\u0005A1\u0002G\u0006R\u0007\u001d!i\"C\u0001\u0005\u00015\t\u0001\u0012C\u0007\u0002\u0011#i{\u0004B\u0002\u0019!u=A\u0001\u0001\u0005\r\u001b\r)\u0011\u0001\u0003\u0006\u0019\u0015A\u001b\u0001!h\u0004\u0005\u0001!iQbA\u0003\u0002\u0011+A*\u0002UB\u0001C\r)\u0011\u0001C\u0006\u0019\u0017E\u001bq\u0001\u0002\t\n\u0003\u0011\u0001Q\"\u0001E\f\u001b\u0005!9!,\u0006\u0005\u0007a\u0005\u0012eA\u0003\u0002\u0011-A2\"U\u0002\u0004\tCI\u0011\u0001\u0002\u0001.\"\u0011\tQcA\u0003\u0002\u0011+A*\u0002G\t\"\u0007\u0015\t\u0001R\u0003M\u000b#\u000e)A!E\u0005\u0002\t\u000fi\u0011\u0001b\u00026\u0019\u0015YAa9\u0001\u0019\b\u0005\u001aQ!\u0001E\u00031\u000b\t6a\u0001C\u0004\u0013\u0005!\u0001\u0001"})
public final class TeamcityStatisticsLogger {
    public static final /* synthetic */ KClass $kotlinClass;
    private final boolean isOnTeamcity = System.getenv("TEAMCITY_VERSION") != null;
    private final AtomicLong totalTime = new AtomicLong();

    static {
        $kotlinClass = Reflection.createKotlinClass(TeamcityStatisticsLogger.class);
    }

    private final char escapedChar(char c) {
        char c2;
        switch (c) {
            case '\n': {
                c2 = 110;
                break;
            }
            case '\r': {
                c2 = 114;
                break;
            }
            case '\u0085': {
                c2 = 120;
                break;
            }
            case '\u2028': {
                c2 = 108;
                break;
            }
            case '\u2029': {
                c2 = 112;
                break;
            }
            case '|': {
                c2 = 124;
                break;
            }
            case '\'': {
                c2 = 39;
                break;
            }
            case '[': {
                c2 = 91;
                break;
            }
            case ']': {
                c2 = 93;
                break;
            }
            default: {
                c2 = (char)0;
            }
        }
        return c2;
    }

    private final String escape(String text) {
        StringBuilder escaped = new StringBuilder();
        char[] cArray = StringsKt.toCharArray((String)text);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            char escChar = this.escapedChar(c);
            if (escChar == (char)0) {
                escaped.append(c);
                continue;
            }
            escaped.append('|').append(escChar);
        }
        String string = escaped.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"escaped.toString()");
        return string;
    }

    public final void registerStatistic(@NotNull ModuleChunk moduleChunk, long timeToCompileNs) {
        Intrinsics.checkParameterIsNotNull((Object)moduleChunk, (String)"moduleChunk");
        if (!this.isOnTeamcity) {
            return;
        }
        this.totalTime.addAndGet(timeToCompileNs);
        this.printPerChunkStatistics(moduleChunk, timeToCompileNs);
    }

    private final void printPerChunkStatistics(ModuleChunk moduleChunk, long timeToCompileNs) {
        this.printStatisticMessage(KotlinBuilder.Companion.getKOTLIN_BUILDER_NAME() + " for " + moduleChunk.getPresentableShortName() + " compilation time, ms", String.valueOf(this.nanosToMillis(timeToCompileNs)));
    }

    public final void reportTotal() {
        if (!this.isOnTeamcity) {
            return;
        }
        this.printStatisticMessage(KotlinBuilder.Companion.getKOTLIN_BUILDER_NAME() + " total compilation time, ms", String.valueOf(this.nanosToMillis(this.totalTime.get())));
    }

    private final void printStatisticMessage(String key, String value) {
        ConsoleKt.println((Object)("##teamcity[buildStatisticValue key='" + this.escape(key) + "' value='" + this.escape(value) + "']"));
    }

    private final long nanosToMillis(long $receiver) {
        return TimeUnit.NANOSECONDS.toMillis($receiver);
    }
}

