/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;
import org.jetbrains.jps.incremental.storage.StorageOwner;
import org.jetbrains.kotlin.jps.build.GeneratedJvmClass;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.incremental.CacheFormatVersion;
import org.jetbrains.kotlin.jps.incremental.ChangesInfo;
import org.jetbrains.kotlin.jps.incremental.DifferenceKind;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl$ConstantsMapExternalizer$WhenMappings;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.jps.incremental.PathCollectionExternalizer;
import org.jetbrains.kotlin.jps.incremental.PathFunctionPair;
import org.jetbrains.kotlin.jps.incremental.PathFunctionPairKeyDescriptor;
import org.jetbrains.kotlin.jps.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.jps.incremental.ProtoMapValue;
import org.jetbrains.kotlin.jps.incremental.ProtoMapValueExternalizer;
import org.jetbrains.kotlin.jps.incremental.StringListExternalizer;
import org.jetbrains.kotlin.jps.incremental.StringToLongMapExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.BasicMap;
import org.jetbrains.kotlin.jps.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.jps.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeaderKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"V\u001a)!\u0012J\\2sK6,g\u000e^1m\u0007\u0006\u001c\u0007.Z%na2T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004UB\u001c(bC5oGJ,W.\u001a8uC2TAb\u0015;pe\u0006<WmT<oKJTqa\u001d;pe\u0006<WM\u0003\tJ]\u000e\u0014X-\\3oi\u0006d7)Y2iK*!An\\1e\u0015)\u0019w.\u001c9p]\u0016tGo\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b\u001dQ\f'oZ3u\t\u0006$\u0018MU8pi*!a)\u001b7f\u0015\u0011Q\u0017M^1\u000b\u0005%|'B\u0002;be\u001e,GOC\tN_\u0012,H.\u001a\"vS2$G+\u0019:hKRTqAY1tK\u0012K'O\u0003\ndC\u000eDWMR8s[\u0006$h+\u001a:tS>t'BE\"bG\",gi\u001c:nCR4VM]:j_:TAbY8ogR\fg\u000e^:NCBTAbQ8ogR\fg\u000e^:NCBT\u0011%\u00138de\u0016lWM\u001c;bY\u000e\u000b7\r[3J[BdGeQ8ogR\fg\u000e^:NCBT!\u0002Z3qK:$WM\u001c;t\u0015%\t%O]1z\u0019&\u001cHO\u0003\u0003vi&d'b\u00063jeRL\u0018J\u001c7j]\u00164UO\\2uS>t7/T1q\u0015]!\u0015N\u001d;z\u0013:d\u0017N\\3Gk:\u001cG/[8og6\u000b\u0007O\u0003\u0017J]\u000e\u0014X-\\3oi\u0006d7)Y2iK&k\u0007\u000f\u001c\u0013ESJ$\u00180\u00138mS:,g)\u001e8di&|gn]'ba*)B-\u001b:us>+H\u000f];u\u00072\f7o]3t\u001b\u0006\u0004(\"\u0006#jeRLx*\u001e;qkR\u001cE.Y:tKNl\u0015\r\u001d\u0006+\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7%\t&\u0014H/_(viB,Ho\u00117bgN,7/T1q\u0015IIg\u000e\\5oK\u001a+hn\u0019;j_:\u001cX*\u00199\u000b%%sG.\u001b8f\rVt7\r^5p]Nl\u0015\r\u001d\u0006(\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7%\u0013:d\u0017N\\3Gk:\u001cG/[8og6\u000b\u0007OC\u0005j]2Lg.\u001a3U_*9\u0012J\u001c7j]\u00164UO\\2uS>t7OR5mKNl\u0015\r\u001d\u0006-\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7%\u0013:d\u0017N\\3Gk:\u001cG/[8og\u001aKG.Z:NCBTA!\\1qg*A!)Y:jG6\u000b\u0007OC\u0005pkR\u0004X\u000f\u001e#je*Aa*\u001e7mC\ndWMC\u0006b]:|G/\u0019;j_:\u001c(B\u00049bG.\fw-\u001a)beRl\u0015\r\u001d\u0006\u000f!\u0006\u001c7.Y4f!\u0006\u0014H/T1q\u0015\rJen\u0019:f[\u0016tG/\u00197DC\u000eDW-S7qY\u0012\u0002\u0016mY6bO\u0016\u0004\u0016M\u001d;NCBT\u0001\u0002\u001d:pi>l\u0015\r\u001d\u0006\t!J|Go\\'ba*i\u0012J\\2sK6,g\u000e^1m\u0007\u0006\u001c\u0007.Z%na2$\u0003K]8u_6\u000b\u0007O\u0003\nt_V\u00148-\u001a+p\u00072\f7o]3t\u001b\u0006\u0004(BE*pkJ\u001cW\rV8DY\u0006\u001c8/Z:NCBTq%\u00138de\u0016lWM\u001c;bY\u000e\u000b7\r[3J[BdGeU8ve\u000e,Gk\\\"mCN\u001cXm]'ba*11\u000b\u001e:j]\u001eT1b\u001d;pe\u0006<WMR5mK*qq-\u001a;Ti>\u0014\u0018mZ3GS2,'\u0002\u00027b]\u001eT\u0011#\u00193e\t\u0016\u0004XM\u001c3f]R\u001c\u0015m\u00195f\u0015\u0015\u0019\u0017m\u00195f\u0015\u0011)f.\u001b;\u000b\u000b\rdW-\u00198\u000b7\rdW-\u0019:DC\u000eDWMR8s%\u0016lwN^3e\u00072\f7o]3t\u0015-\u0019\u0005.\u00198hKNLeNZ8\u000b\u000b\rdwn]3\u000b\t\u0011,X\u000e\u001d\u0006\u0006M2,8\u000f\u001b\u0006\u0011[\u0016lwN]=DC\u000eDWm](oYfTqAQ8pY\u0016\fgN\u0003\thKR\u001cE.Y:t\r&dW\rU1uQ*\t\u0012N\u001c;fe:\fGn\u00117bgNt\u0015-\\3\u000b%\u001d,GOR5mKN$vNU3j]2Lg.\u001a\u0006\u000b\u0007>dG.Z2uS>t'\u0002F4fi6{G-\u001e7f\u001b\u0006\u0004\b/\u001b8h\t\u0006$\u0018MC\u0005CsR,\u0017I\u001d:bs*9r-\u001a;PEN|G.\u001a;f!\u0006\u001c7.Y4f!\u0006\u0014Ho\u001d\u0006\u0013O\u0016$\b+Y2lC\u001e,\u0007+\u0019:u\t\u0006$\u0018M\u0003\u0004gc:\u000bW.\u001a\u0006\u0017[\u0006\u00148nT;uaV$8\t\\1tg\u0016\u001cH)\u001b:us*I\"/Z7pm\u0016$\u0017I\u001c3D_6\u0004\u0018\u000e\\3e'>,(oY3t\u0015\u0011a\u0015n\u001d;\u000b\u001dI,w-[:uKJLe\u000e\\5oK*AaM]8n!\u0006$\bN\u0003\u0007km6\u001c\u0016n\u001a8biV\u0014XM\u0003\u0004u_B\u000bG\u000f\u001b\u0006\u0002\u0017*\u0019\u0011I\\=\u000b\u0003YS\u0011!\u0014\u0006\fe\u0016<\u0017n\u001d;fe6\u000b\u0007OC\u0002nCBTac]1wK\u000e\u000b7\r[3G_Jl\u0017\r\u001e,feNLwN\u001c\u0006\u0010g\u00064XMR5mKR{7)Y2iK*qq-\u001a8fe\u0006$X\rZ\"mCN\u001c(\"E$f]\u0016\u0014\u0018\r^3e\u0015Zl7\t\\1tg*)!-^5mI*A2/\u0019<f\u001b>$W\u000f\\3NCB\u0004\u0018N\\4U_\u000e\u000b7\r[3\u000b\u0017M|WO]2f\r&dWm\u001d\u0006\u0005M&dWMC\u000bm_\u001eLemU8nKRD\u0017N\\4DQ\u0006tw-\u001a3\u000b\u0013\rd\u0017m]:OC6,'\u0002\u0004&w[\u000ec\u0017m]:OC6,'b\u0002:fg>dg/\u001a\u0006\u0004UZl'\"C\"p[B\fg.[8o\u0015a\u0019uN\\:uC:$8/T1q\u000bb$XM\u001d8bY&TXM\u001dh\u0004\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)!\u0001\"\u0001\t\u0005\u0015\u0011Aa\u0001E\u0003\u000b\t!9\u0001c\u0002\u0006\u0007\u0011!\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001#\u0003\u0006\u0005\u0011)\u00012A\u0003\u0003\t\u0017A)!\u0002\u0002\u0005\r!)Qa\u0001C\u0007\u0011\u0011a\u0001!B\u0001\t\u000f\u0015\u0011Aq\u0002E\b\u000b\r!\u0001\u0002#\u0004\r\u0001\u0015\u0019Aq\u0001E\t\u0019\u0001)!\u0001\u0002\u0005\t\u000e\u0015\u0011Aq\u0001E\t\u000b\r!!\u0001\u0003\u0006\r\u0001\u0015\u0011AA\u0001\u0005\u000b\u000b\r!)\u0001C\u0006\r\u0001\u0015\u0011AA\u0001E\f\u000b\t!y\u0001C\u0007\u0006\u0007\u0011e\u0001\u0012\u0004\u0007\u0001\u000b\t!I\u0002#\u0007\u0006\u0007\u0011\u0015\u0001B\u0004\u0007\u0001\u000b\t!!\u0001#\b\u0006\u0007\u0011\u0015\u0001r\u0004\u0007\u0001\u000b\t!!\u0001\u0003\t\u0006\u0007\u0011\u0015\u0001\"\u0005\u0007\u0001\u000b\t!!\u0001c\t\u0006\u0007\u0011\u0015\u0001R\u0005\u0007\u0001\u000b\t!!\u0001C\n\u0006\u0005\u0011\u0011\u0001rA\u0003\u0004\tIAA\u0003\u0004\u0001\u0006\u0005\u0011\u0005\u00012F\u0003\u0004\tMAQ\u0003\u0004\u0001\u0006\u0007\u0011\u0015\u0001R\u0006\u0007\u0001\u000b\t!!\u0001C\f\u0006\u0007\u0011\u0015\u0001\u0002\u0007\u0007\u0001\u000b\t!!\u0001#\r\u0006\u0007\u0011\u0015\u00012\u0007\u0007\u0001\u000b\t!!\u0001\u0003\u000e\u0006\u0003!\rQa\u0001\u0003\u0018\u0011ka\u0001!\u0002\u0002\u0005\u0010!aRA\u0001\u0003\u0019\u0011k)1\u0001B\f\t<1\u0001QA\u0001\u0003\u0003\u0011\u0001)1\u0001\u0002\u0002\t?1\u0001QA\u0001\u0003\u0003\u0011})1\u0001B\f\tD1\u0001Qa\u0001\u0003\u0018\u0011\u000fb\u0001!\u0002\u0002\u0005\u001a!\u001dSa\u0001\u0003\u0018\u0011\u0013b\u0001!B\u0002\u0005/!=C\u0002A\u0003\u0003\t3Ay%B\u0002\u0005/!UC\u0002A\u0003\u0003\tIAA#\u0002\u0002\u0005\u0004!ySa\u0001\u0003 \u0011;b\u0001!\u0002\u0002\u0005?!uSA\u0001\u0003\u0002\u0011K*!\u0001\"\u0011\tg\u0015\u0019A!\t\u00053\u0019\u0001)!\u0001B\u0011\te\u0011\u0019AR\u0001I43\r)\u0011\u0001#\u0003\u0019\ne\u0019Q!\u0001\u0005\b1\u001diRqM\u00065\u001d?\u0015\u0012S\u0006M\u001a[1!\u0011\r\u0002\r\nC\r)\u0011\u0001#\u0005\u0019\u0012U\u001bA!B\u0002\u0005\u0013%\t\u00012C\u0017\r\t\u0005$\u00014C\u0011\u0004\u000b\u0005A)\u0002'\u0006V\u0007\u0011)1\u0001b\u0005\n\u0003!YQ\u0006\u0004\u0003b\taU\u0011eA\u0003\u0002\u0011/A:\"V\u0002\u0005\u000b\r!)\"C\u0001\t\u00195\nB!\u0019\u0003\u0019\u0019\u0005BQ!\u0001\u0005\u000e\u0013\u0011I1!B\u0001\t\u0006a\u0015\u0001$D+\u0004\t\u0015\u0019A\u0001D\u0005\u0002\u00117iC\u0002B1\u000517\t3!B\u0001\t\u001daqQk\u0001\u0003\u0006\u0007\u0011m\u0011\"\u0001E\u000f[1!\u0011\r\u0002\r\u0010C\r)\u0011\u0001C\b\u0019\u001fU\u001bA!B\u0002\u0005\u001f%\t\u0001rD\u0017\r\t\u0005$\u0001\u0014E\u0011\u0004\u000b\u0005A\u0001\u0003\u0007\tV\u0007\u0011)1\u0001\"\t\n\u0003!\u0005R\u0006\u0004\u0003b\ta\u0011\u0012eA\u0003\u0002\u0011EA\u0012#V\u0002\u0005\u000b\r!!#C\u0001\t$5*B!\u0019\u0003\u0019(\u0005bQ!\u0001\u0005\u000e\u0013!Iq!B\u0001\t&%\tA1A\u0005\u0002\t\u0007A*\u0003G\u0007V\u0007\u0011)1\u0001b\n\n\u0003!mQV\u0004\u0003b\ta%\u00125B\u0003\u0002\u0011#A\n\"U\u0002\u0002\tO)6\u0001B\u0003\u0004\tSI\u0011\u0001c\u0005.\u0019\u0011\tG\u0001\u0007\f\"\u0007\u0015\t\u0001\u0002\u0006\r\u0015+\u000e!Qa\u0001\u0003\u0017\u0013\u0005AI#\f\u0007\u0005C\u0012Az#I\u0002\u0006\u0003!)\u0002$F+\u0004\t\u0015\u0019AqF\u0005\u0002\u0011WiC\u0002B1\u00051e\t3!B\u0001\t-a1Rk\u0001\u0003\u0006\u0007\u0011I\u0012\"\u0001E\u0017[1!\u0011\r\u0002\r\tC\r)\u0011\u0001C\u0005\u0019\u0013U\u001bA!B\u0002\u0005\u0011%\t\u0001BC\u0017\u0014\t\u0005$QcA\u0003\u0002\u0011_Az\u0003G\u000e\"\u0007\u0015\t\u0001\u0012\u0003M\tI\u0005*6AB\u0007\u0006\toI\u0011\u0001c\u0005\u000e\u0003!ER&\u0006\u0003\u00041siz\u0001\u0002\u0001\t;5\u0019Q!\u0001E\u00031\u000b\u00016\u0001A\u0011\u0004\u000b\u0005A\u0011\u0004G\rR\u0007\u0015!I$C\u0001\u0005\u00015\t\u00012GW\u000b\t-Ab$I\u0002\u0006\u0003!I\u0002$G)\u0004\u0007\u0011q\u0012\"\u0001\u0003\u0001[+!1\u0001'\u0010\"\u0007\u0015\t\u0001B\u0007\r\u001b#\u000e\u0019AQH\u0005\u0002\u0011ki+\u0002B\u0006\u0019@\u0005\u001aQ!\u0001\u0005\u001a1e\t6a\u0001C \u0013\u0005!\u0001!,\u0006\u0005\ba\u0001\u0013eA\u0003\u0002\u0011_Az#U\u0002\u0004\t\u0001J\u0011\u0001#\r.+\u0011Y\u0001\u0014IO\b\t\u0001A\u0011%D\u0002\u0006\u0003!Y\u0002d\u0007)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u001a1e\t6!\u0002C!\u0013\u0005!\u0001!D\u0001\u0005\u00025*Ba\u0003\r#;\u001f!\u0001\u0001#\u0012\u000e\u0007\u0015\t\u0001r\u0006M\u0018!\u000e\u0001\u0011eA\u0003\u0002\u0011_Az#U\u0002\u0006\t\tJ\u0011\u0001#\r\u000e\u0003!ERv\u0004\u0003\u00041\r\n\u0003\"B\u0001\t8%!\u0011bA\u0003\u0002\u0011#A\n\u0002g\u000eR\u0007\r!1%C\u0001\t95fAa\u0003\r%C\u0011)\u0011\u0001#\u000f\r\u0002ae\u0012k\u0001\u0003\u0005I%\u0011A1\u0001G\u0001[?!1\u0002G\u0013\"\u0011\u0015\t\u0001rG\u0005\u0005\u0013\r)\u0011\u0001c\f\u00190a]\u0012kA\u0002\u0005K%\t\u0001\u0002H\u0017\u0018\t-AZ%h\u0004\u0005\u0001!1SbA\u0003\u0002\u0011_Az\u0003U\u0002\u0001C\u0011)\u0011\u0001#\u000f\r\u0002ae\u0012k\u0001\u0004\u0005L%\u0011A1\u0001G\u0001\u001b\u0005A\t$\f\u000e\u0005\u0007a5S\u0014\u0004\u0003\u0001\u0011\u001dj\u0001\"B\u0001\t;%!\u0011bA\u0003\u0002\u0011#A\n\u0002G\u000fQ\u0007\u0001\t3!B\u0001\t3aI\u0012kA\u0003\u0005N%\tA\u0001A\u0007\u0002\u0011wi#\u0006B\u0006\u0019Qu=A\u0001\u0001E)\u001b\r)\u0011\u0001c\f\u00190A\u001b\u0001!h\u0004\u0005\u0001!ISbA\u0003\u0002\u0011_Az\u0003UB\u0001;\u001f!\u0001\u0001c\u0015\u000e\u0007\u0015\t\u0001r\u0006M\u0018!\u000e\t\u0011eA\u0003\u0002\u0011eA\u0012$U\u0002\n\t!J\u0011\u0001\u0002\u0001\u000e\u0003!ER\"\u0001E\u0019\u001b\u0005A\t$\f\u001e\u0005\u0003E9A\u0001\u0001\u0005++\u0011)\u0011\u0001\u0003\u0010\r\u0002aq\u0012c\u0002C\u0001\u0011-*B!B\u0001\t=1\u0005\u0001DH\t\u0013\t\u0005A9&F\b\u0006\u0003!\u0015\u0012\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019&aaS\u0014\u0003\u0003\u0001\u00113jA!\u0002\u0002\u0005\u0002!\tA$\u0001)\u0004\u0001\u0005\"QA\u0001C\u0001\u0011\u0005a\u0012!U\u0002\u0006\t1J\u0011\u0001#\u0010\u000e\u0003!uRV\u0003\u0003\u000415\n3!B\u0001\t3aI\u0012kA\u0002\u0005[%\tA\u0001A\u0017\u0016\t\rAZ&h\u0004\u0005\u0001!qSbA\u0003\u0002\u0011\u007fAz\u0004U\u0002\u0001C\r)\u0011\u0001\u0003\u000e\u00195E\u001bQ\u0001b\u0017\n\u0003!UR\"\u0001\u0005![\u0013\"1\u0001g\u0018\u001e\u001a\u0011\u0001\u0001\u0002M\u0007\t\u000b\u0005A9$\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0003M\t1o\u00016\u0001AO\b\t\u0001A\t'D\u0002\u0006\u0003!E\u0001\u0014\u0003)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u001b1i\t6a\u0002C0\u0013\u0005A)$D\u0001\t95\t\u00012C\u0017\u001c\t\u0005)2!B\u0001\t5aQ\u0002$MO\b\t\u0001A\u0019'D\u0002\u0006\u0003!\r\u00034\t)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u001a1e\t6a\u0002\u00032\u0013\u0005!\u0001!D\u0001\t65\t\u0001BI\u001b\"\u000b\u0001\"1\u001d\u0001M\u0006;\u001f!\u0001\u0001\u0003\u0004\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\u0001Qt\u0002\u0003\u0001\u0011!i1!B\u0001\t\u0013aI\u0001k!\u0001\"\u0007\u0015\t\u0001R\u0001M\u0003#\u000e9A1B\u0005\u0002\t\u0001i\u0011\u0001c\u0005\u000e\u0003!Q\u0001"})
public final class IncrementalCacheImpl
implements StorageOwner,
IncrementalCache {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final String CACHE_EXTENSION = "tab";
    private static final String PROTO_MAP = "proto";
    private static final String CONSTANTS_MAP = "constants";
    private static final String INLINE_FUNCTIONS = "inline-functions";
    private static final String PACKAGE_PARTS = "package-parts";
    private static final String SOURCE_TO_CLASSES = "source-to-classes";
    private static final String DIRTY_OUTPUT_CLASSES = "dirty-output-classes";
    private static final String DIRTY_INLINE_FUNCTIONS = "dirty-inline-functions";
    private static final String INLINED_TO = "inlined-to";
    private static final String MODULE_MAPPING_FILE_NAME = ".kotlin_module";
    private final File baseDir;
    private final ArrayList<BasicMap<?, ?>> maps;
    private final ProtoMap protoMap;
    private final ConstantsMap constantsMap;
    private final InlineFunctionsMap inlineFunctionsMap;
    private final PackagePartMap packagePartMap;
    private final SourceToClassesMap sourceToClassesMap;
    private final DirtyOutputClassesMap dirtyOutputClassesMap;
    private final DirtyInlineFunctionsMap dirtyInlineFunctionsMap;
    private final InlineFunctionsFilesMap inlinedTo;
    private final CacheFormatVersion cacheFormatVersion;
    private final ArrayList<IncrementalCacheImpl> dependents;
    private final File outputDir;
    private final ModuleBuildTarget target;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(IncrementalCacheImpl.class);
        Companion companion = Companion = new Companion(null);
        CACHE_EXTENSION = CACHE_EXTENSION;
        PROTO_MAP = PROTO_MAP;
        CONSTANTS_MAP = CONSTANTS_MAP;
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        PACKAGE_PARTS = PACKAGE_PARTS;
        SOURCE_TO_CLASSES = SOURCE_TO_CLASSES;
        DIRTY_OUTPUT_CLASSES = DIRTY_OUTPUT_CLASSES;
        DIRTY_INLINE_FUNCTIONS = DIRTY_INLINE_FUNCTIONS;
        INLINED_TO = INLINED_TO;
        MODULE_MAPPING_FILE_NAME = "." + ModuleMapping.Companion.getMAPPING_FILE_EXT();
    }

    private final File getStorageFile(String $receiver) {
        return new File(this.baseDir, $receiver + "." + Companion.getCACHE_EXTENSION());
    }

    private final <K, V, M extends BasicMap<K, V>> M registerMap(M map) {
        this.maps.add(map);
        return map;
    }

    public void registerInline(@NotNull String fromPath, @NotNull String jvmSignature, @NotNull String toPath) {
        Intrinsics.checkParameterIsNotNull((Object)fromPath, (String)"fromPath");
        Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
        Intrinsics.checkParameterIsNotNull((Object)toPath, (String)"toPath");
        this.inlinedTo.add(fromPath, jvmSignature, toPath);
    }

    public final void addDependentCache(@NotNull IncrementalCacheImpl cache) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.dependents.add(cache);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dump() {
        void var3_3;
        void $receiver;
        Iterable $receiver2 = this.maps;
        Iterable iterable = $receiver2;
        Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            BasicMap basicMap = (BasicMap)item;
            Collection collection = destination;
            String string = it.dump();
            collection.add(string);
        }
        return StringsKt.join$default((Iterable)((List)var3_3), (String)"\n\n", null, null, (int)0, null, (int)30);
    }

    /*
     * WARNING - void declaration
     */
    public final void markOutputClassesDirty(@NotNull List<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, (String)"removedAndCompiledSources");
        for (File file : removedAndCompiledSources) {
            void $receiver;
            Collection<JvmClassName> classes2 = this.sourceToClassesMap.get(file);
            Iterable iterable = classes2;
            for (Object element : $receiver) {
                JvmClassName it = (JvmClassName)element;
                DirtyOutputClassesMap dirtyOutputClassesMap = this.dirtyOutputClassesMap;
                String string = it.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.internalName");
                dirtyOutputClassesMap.markDirty(string);
            }
            this.sourceToClassesMap.clearOutputsForSource(file);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> getFilesToReinline() {
        void destination;
        void $receiver;
        String classFilePath;
        Object className2;
        THashSet result = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        Object object = MapsKt.iterator(this.dirtyInlineFunctionsMap.getEntries());
        while (object.hasNext()) {
            void $receiver2;
            String internalName;
            String string;
            Map.Entry entry = (Map.Entry)object.next();
            className2 = (JvmClassName)MapsKt.component1((Map.Entry)entry);
            List functions2 = (List)MapsKt.component2((Map.Entry)entry);
            if (this.packagePartMap.isPackagePart((JvmClassName)className2)) {
                String packageInternalName = PackageClassUtils.getPackageClassInternalName((FqName)className2.getPackageFqName());
                JvmClassName packageJvmName = JvmClassName.byInternalName((String)packageInternalName);
                string = packageJvmName.getInternalName();
            } else {
                string = className2.getInternalName();
            }
            String string2 = internalName = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"internalName");
            classFilePath = this.getClassFilePath(string2);
            Function1<IncrementalCacheImpl, Unit> addFilesAffectedByChangedInlineFuns$ = new Function1<IncrementalCacheImpl, Unit>(functions2, classFilePath, result){
                final /* synthetic */ List $functions;
                final /* synthetic */ String $classFilePath;
                final /* synthetic */ THashSet $result;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull IncrementalCacheImpl cache) {
                    void destination;
                    void $receiver;
                    Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
                    Iterable $receiver2 = this.$functions;
                    Iterable iterable = $receiver2;
                    Collection collection = new ArrayList<E>();
                    for (T element : $receiver) {
                        String it = (String)element;
                        Iterable list = IncrementalCacheImpl.access$getInlinedTo$16(cache).get(this.$classFilePath, it);
                        CollectionsKt.addAll((Collection)destination, (Iterable)list);
                    }
                    List targetFiles = (List)destination;
                    this.$result.addAll((Collection)targetFiles);
                }
                {
                    this.$functions = list;
                    this.$classFilePath = string;
                    this.$result = tHashSet;
                    super(1);
                }
            };
            addFilesAffectedByChangedInlineFuns$.invoke(this);
            Iterable iterable = this.dependents;
            for (Object element : $receiver2) {
                IncrementalCacheImpl p1 = (IncrementalCacheImpl)element;
                addFilesAffectedByChangedInlineFuns$.invoke(p1);
            }
        }
        this.dirtyInlineFunctionsMap.clean();
        Iterable $receiver3 = (Iterable)result;
        object = $receiver3;
        className2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item : $receiver) {
            void it;
            classFilePath = (String)item;
            void var13_13 = destination;
            File file = new File((String)it);
            var13_13.add(file);
        }
        return (List)destination;
    }

    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        String string = new File(this.outputDir, internalClassName + ".class").getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File(outputDir, \"$intern\u2026ame.class\").canonicalPath");
        return string;
    }

    public final void saveCacheFormatVersion() {
        this.cacheFormatVersion.saveIfNeeded();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesInfo saveModuleMappingToCache(@NotNull Collection<? extends File> sourceFiles, @NotNull File file) {
        void $receiver;
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName((String)IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        this.protoMap.process(jvmClassName2, FilesKt.readBytes((File)file), false, false);
        this.dirtyOutputClassesMap.notDirty(IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Iterable iterable = sourceFiles;
        for (Object element : $receiver) {
            File it = (File)element;
            SourceToClassesMap sourceToClassesMap = this.sourceToClassesMap;
            JvmClassName jvmClassName3 = jvmClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"jvmClassName");
            sourceToClassesMap.add(it, jvmClassName3);
        }
        return ChangesInfo.Companion.getNO_CHANGES();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesInfo saveFileToCache(@NotNull GeneratedJvmClass generatedClass) {
        String message;
        ChangesInfo changesInfo;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)generatedClass, (String)"generatedClass");
        Collection<File> sourceFiles = generatedClass.getSourceFiles();
        LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
        JvmClassName className2 = JvmClassName.byClassId((ClassId)kotlinClass.getClassId());
        String string = className2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
        this.dirtyOutputClassesMap.notDirty(string);
        Iterable iterable = sourceFiles;
        for (Object element : $receiver) {
            File it = (File)element;
            SourceToClassesMap sourceToClassesMap = this.sourceToClassesMap;
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            sourceToClassesMap.add(it, jvmClassName);
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (KotlinClassHeaderKt.isCompatiblePackageFacadeKind((KotlinClassHeader)header)) {
            changesInfo = ProtoMap.process$default(this.protoMap, kotlinClass, true, false, 4);
        } else if (KotlinClassHeaderKt.isCompatibleFileFacadeKind((KotlinClassHeader)header)) {
            void value;
            boolean element = sourceFiles.size() == 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && value == false) {
                message = "Package part from several source files: " + sourceFiles;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            this.packagePartMap.addPackagePart(jvmClassName);
            changesInfo = ProtoMap.process$default(this.protoMap, kotlinClass, true, false, 4).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass));
        } else if (KotlinClassHeaderKt.isCompatibleClassKind((KotlinClassHeader)header) && Intrinsics.areEqual((Object)JvmAnnotationNames.KotlinClass.Kind.CLASS, (Object)header.getClassKind())) {
            changesInfo = ProtoMap.process$default(this.protoMap, kotlinClass, false, false, 4).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass));
        } else if (Intrinsics.areEqual((Object)header.getSyntheticClassKind(), (Object)JvmAnnotationNames.KotlinSyntheticClass.Kind.PACKAGE_PART)) {
            boolean value = sourceFiles.size() == 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
                message = "Package part from several source files: " + sourceFiles;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            this.packagePartMap.addPackagePart(jvmClassName);
            changesInfo = this.constantsMap.process(kotlinClass).plus(this.inlineFunctionsMap.process(kotlinClass));
        } else {
            changesInfo = ChangesInfo.Companion.getNO_CHANGES();
        }
        ChangesInfo changesInfo2 = changesInfo;
        JvmClassName jvmClassName = className2;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
        this.logIfSomethingChanged(changesInfo2, jvmClassName);
        return changesInfo2;
    }

    private final void logIfSomethingChanged(ChangesInfo $receiver, JvmClassName className2) {
        if (Intrinsics.areEqual((Object)$receiver, (Object)ChangesInfo.Companion.getNO_CHANGES())) {
            return;
        }
        KotlinBuilder.Companion.getLOG().debug(className2 + " is changed: " + $receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ChangesInfo clearCacheForRemovedClasses() {
        void initial;
        ChangesInfo destination;
        Iterable $receiver;
        Iterable $receiver2 = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void p1;
            String string = (String)item;
            void var11_7 = destination;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)p1);
            var11_7.add(jvmClassName);
        }
        List dirtyClasses = CollectionsKt.toList((Iterable)((List)((Object)destination)));
        $receiver = dirtyClasses;
        destination = ChangesInfo.Companion.getNO_CHANGES();
        ChangesInfo accumulator = initial;
        for (Object element : $receiver) {
            void className2;
            JvmClassName jvmClassName = (JvmClassName)element;
            ChangesInfo info = accumulator;
            ProtoMap protoMap = this.protoMap;
            void v1 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"className");
            boolean bl = protoMap.contains((JvmClassName)v1);
            ConstantsMap constantsMap = this.constantsMap;
            void v4 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"className");
            ChangesInfo newInfo = new ChangesInfo(bl, constantsMap.contains((JvmClassName)v4), false, false, 12, null);
            void v5 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"className");
            this.logIfSomethingChanged(newInfo, (JvmClassName)v5);
            accumulator = info.plus(newInfo);
        }
        ChangesInfo changesInfo = accumulator;
        $receiver = dirtyClasses;
        for (Object element : $receiver) {
            JvmClassName it = (JvmClassName)element;
            ProtoMap protoMap = this.protoMap;
            JvmClassName jvmClassName = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"it");
            protoMap.remove(jvmClassName);
            PackagePartMap packagePartMap = this.packagePartMap;
            JvmClassName jvmClassName2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"it");
            packagePartMap.remove(jvmClassName2);
            ConstantsMap constantsMap = this.constantsMap;
            JvmClassName jvmClassName3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"it");
            constantsMap.remove(jvmClassName3);
            InlineFunctionsMap inlineFunctionsMap = this.inlineFunctionsMap;
            JvmClassName jvmClassName4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"it");
            inlineFunctionsMap.remove(jvmClassName4);
        }
        this.dirtyOutputClassesMap.clean();
        return changesInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void destination;
        void $receiver;
        Iterable $receiver2 = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            String it = (String)element;
            PackagePartMap packagePartMap = this.packagePartMap;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(it)");
            if (!packagePartMap.isPackagePart(jvmClassName)) continue;
            destination.add(element);
        }
        List obsoletePackageParts = (List)destination;
        KotlinBuilder.Companion.getLOG().debug("Obsolete package parts: " + obsoletePackageParts);
        return obsoletePackageParts;
    }

    @Nullable
    public byte[] getPackagePartData(@NotNull String fqName) {
        Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)fqName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(fqName)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        return (byte[])(protoMapValue != null ? protoMapValue.getBytes() : null);
    }

    @Nullable
    public byte[] getModuleMappingData() {
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026MODULE_MAPPING_FILE_NAME)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        return (byte[])(protoMapValue != null ? protoMapValue.getBytes() : null);
    }

    public void flush(boolean memoryCachesOnly) {
        Iterable $receiver = this.maps;
        for (Object element : $receiver) {
            BasicMap it = (BasicMap)element;
            it.flush(memoryCachesOnly);
        }
    }

    public void clean() {
        Iterable $receiver = this.maps;
        for (Object element : $receiver) {
            BasicMap it = (BasicMap)element;
            it.clean();
        }
        this.cacheFormatVersion.clean();
    }

    public void close() {
        Iterable $receiver = this.maps;
        for (Object element : $receiver) {
            BasicMap it = (BasicMap)element;
            it.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public IncrementalCacheImpl(@NotNull File targetDataRoot, @NotNull ModuleBuildTarget target) {
        File file;
        void value;
        Intrinsics.checkParameterIsNotNull((Object)targetDataRoot, (String)"targetDataRoot");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.target = target;
        this.baseDir = new File(targetDataRoot, IncrementalCacheImplKt.getCACHE_DIRECTORY_NAME());
        this.maps = CollectionsKt.arrayListOf((Object[])new BasicMap[0]);
        this.protoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(IncrementalCacheImpl.Companion.getPROTO_MAP())));
        this.constantsMap = (ConstantsMap)this.registerMap((BasicMap)new ConstantsMap(this.getStorageFile(IncrementalCacheImpl.Companion.getCONSTANTS_MAP())));
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(IncrementalCacheImpl.Companion.getINLINE_FUNCTIONS())));
        this.packagePartMap = (PackagePartMap)this.registerMap((BasicMap)new PackagePartMap(this.getStorageFile(IncrementalCacheImpl.Companion.getPACKAGE_PARTS())));
        this.sourceToClassesMap = (SourceToClassesMap)this.registerMap((BasicMap)new SourceToClassesMap(this.getStorageFile(IncrementalCacheImpl.Companion.getSOURCE_TO_CLASSES())));
        this.dirtyOutputClassesMap = (DirtyOutputClassesMap)this.registerMap((BasicMap)new DirtyOutputClassesMap(this.getStorageFile(IncrementalCacheImpl.Companion.getDIRTY_OUTPUT_CLASSES())));
        this.dirtyInlineFunctionsMap = (DirtyInlineFunctionsMap)this.registerMap((BasicMap)new DirtyInlineFunctionsMap(this.getStorageFile(IncrementalCacheImpl.Companion.getDIRTY_INLINE_FUNCTIONS())));
        this.inlinedTo = (InlineFunctionsFilesMap)this.registerMap((BasicMap)new InlineFunctionsFilesMap(this.getStorageFile(IncrementalCacheImpl.Companion.getINLINED_TO())));
        this.cacheFormatVersion = new CacheFormatVersion(targetDataRoot);
        this.dependents = CollectionsKt.arrayListOf((Object[])new IncrementalCacheImpl[0]);
        File file2 = this.target.getOutputDir();
        IncrementalCacheImpl incrementalCacheImpl = this;
        if (value == null) {
            String message = "Target is expected to have output directory: " + this.target;
            throw (Throwable)new IllegalArgumentException(message.toString());
        }
        incrementalCacheImpl.outputDir = file = file2;
    }

    @NotNull
    public static final /* synthetic */ InlineFunctionsFilesMap access$getInlinedTo$16(IncrementalCacheImpl $this) {
        return $this.inlinedTo;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"i\b)I1i\\7qC:LwN\u001c\u0006\u0015\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015-Ign\u0019:f[\u0016tG/\u00197\u000b\u0007\u0005s\u0017PC\bD\u0003\u000eCUiX#Y)\u0016s5+S(O\u0015\u0019\u0019FO]5oO*!!.\u0019<b\u0015\u0011a\u0017M\\4\u000b%\u001d,GoQ!D\u0011\u0016{V\t\u0017+F\u001dNKuJ\u0014\u0006\u000e\u0007>s5\u000bV!O)N{V*\u0011)\u000b!\u001d,GoQ(O'R\u000be\nV*`\u001b\u0006\u0003&B\u0006#J%RKv,\u0013(M\u0013:+uLR+O\u0007RKuJT*\u000b3\u001d,G\u000fR%S)f{\u0016J\u0014'J\u001d\u0016{f)\u0016(D)&{ej\u0015\u0006\u0015\t&\u0013F+W0P+R\u0003V\u000bV0D\u0019\u0006\u001b6+R*\u000b/\u001d,G\u000fR%S)f{v*\u0016+Q+R{6\tT!T'\u0016\u001b&BC%O\u0019&sU\tR0U\u001f*iq-\u001a;J\u001d2Ke*\u0012#`)>S\u0001#\u0013(M\u0013:+uLR+O\u0007RKuJT*\u000b'\u001d,G/\u0013(M\u0013:+uLR+O\u0007RKuJT*\u000b15{E)\u0016'F?6\u000b\u0005\u000bU%O\u000f~3\u0015\nT#`\u001d\u0006kUIC\u000ehKRlu\nR+M\u000b~k\u0015\t\u0015)J\u001d\u001e{f)\u0013'F?:\u000bU*\u0012\u0006\u000e!\u0006\u001b5*Q$F?B\u000b%\u000bV*\u000b!\u001d,G\u000fU!D\u0017\u0006;Ui\u0018)B%R\u001b&\"\u0003)S\u001fR{u,T!Q\u001519W\r\u001e)S\u001fR{u,T!Q\u0015E\u0019v*\u0016*D\u000b~#vjX\"M\u0003N\u001bVi\u0015\u0006\u0015O\u0016$8kT+S\u0007\u0016{FkT0D\u0019\u0006\u001b6+R*Q\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0019AA\u0001E\u0001\u0019\u0001)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!9\u0001c\u0002\r\u0001\u0015\u0019Aq\u0001E\u0005\u0019\u0001)\u0011\u0001C\u0003\u0006\u0005\u0011)\u00012B\u0003\u0003\t\u0017AI\u0001Bb\u0002\u0019\rI2!B\u0001\t\ta!Q&\u0005\u0003d)a!\u0011eA\u0003\u0002\u0011\u0013AJ!V\u0002\n\u000b\u0011!A!C\u0001\t\r1\u0005Qb\u0001\u0003\u0007\u0013\u0005Aa!L\t\u0005CRAj!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\u0013\u0015!AQB\u0005\u0002\u0011\u0019a\t!D\u0002\u0005\u000f%\t\u0001BB\u0017\u0012\t\u0005$\u0002tB\u0011\u0004\u000b\u0005AI\u0001'\u0003V\u0007%)A\u0001b\u0004\n\u0003!1A\u0012A\u0007\u0004\t!I\u0011\u0001\u0003\u0004.#\u0011\tG\u0003'\u0005\"\u0007\u0015\t\u0001\u0012\u0002M\u0005+\u000eIQ\u0001\u0002C\t\u0013\u0005Aa\u0001$\u0001\u000e\u0007\u0011I\u0011\"\u0001\u0005\u0007[E!\u0011\r\u0006M\nC\r)\u0011\u0001#\u0003\u0019\nU\u001b\u0011\"\u0002\u0003\u0005\u0014%\t\u0001B\u0002G\u0001\u001b\r!!\"C\u0001\t\r5\nB!\u0019\u000b\u0019\u0016\u0005\u001aQ!\u0001E\u00051\u0013)6!C\u0003\u0005\t+I\u0011\u0001\u0003\u0004\r\u00025\u0019AaC\u0005\u0002\u0011\u0019i\u0013\u0003B1\u00151/\t3!B\u0001\t\na%QkA\u0005\u0006\t\u0011]\u0011\"\u0001\u0005\u0007\u0019\u0003i1\u0001\u0002\u0007\n\u0003!1Q&\u0005\u0003b)ae\u0011eA\u0003\u0002\u0011\u0013AJ!V\u0002\n\u000b\u0011!I\"C\u0001\t\r1\u0005Qb\u0001\u0003\u000e\u0013\u0005Aa!L\t\u0005CRAZ\"I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\u0013\u0015!A1D\u0005\u0002\u0011\u0019a\t!D\u0002\u0005\u001d%\t\u0001BB\u0017\u0012\t\u0005$\u0002TD\u0011\u0004\u000b\u0005AI\u0001'\u0003V\u0007%)A\u0001\"\b\n\u0003!1A\u0012A\u0007\u0004\t=I\u0011\u0001\u0003\u00046\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @NotNull
        public final String getCACHE_EXTENSION() {
            return CACHE_EXTENSION;
        }

        private final String getPROTO_MAP() {
            return PROTO_MAP;
        }

        private final String getCONSTANTS_MAP() {
            return CONSTANTS_MAP;
        }

        private final String getINLINE_FUNCTIONS() {
            return INLINE_FUNCTIONS;
        }

        private final String getPACKAGE_PARTS() {
            return PACKAGE_PARTS;
        }

        private final String getSOURCE_TO_CLASSES() {
            return SOURCE_TO_CLASSES;
        }

        private final String getDIRTY_OUTPUT_CLASSES() {
            return DIRTY_OUTPUT_CLASSES;
        }

        private final String getDIRTY_INLINE_FUNCTIONS() {
            return DIRTY_INLINE_FUNCTIONS;
        }

        private final String getINLINED_TO() {
            return INLINED_TO;
        }

        private final String getMODULE_MAPPING_FILE_NAME() {
            return MODULE_MAPPING_FILE_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"~\u0006)A\u0001K]8u_6\u000b\u0007O\u0003\u000bJ]\u000e\u0014X-\\3oi\u0006d7)Y2iK&k\u0007\u000f\u001c\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*\u0019!\u000e]:\u000b\u0017%t7M]3nK:$\u0018\r\u001c\u0006\u000f\u0005\u0006\u001c\u0018nY*ue&tw-T1q\u0015\u001d\u0019Ho\u001c:bO\u0016TQ\u0002\u0015:pi>l\u0015\r\u001d,bYV,'B\u0002\u001fj]&$hHC\u0006ti>\u0014\u0018mZ3GS2,'\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\tG>tG/Y5og*I1\r\\1tg:\u000bW.\u001a\u0006\r\u0015Zl7\t\\1tg:\u000bW.\u001a\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\rQg/\u001c\u0006\b\u0005>|G.Z1o\u0015%!W/\u001c9WC2,XMC\u0003wC2,XM\u0003\u0004TiJLgn\u001a\u0006\u0005Y\u0006twMC\u0002hKRTq\u0001\u001d:pG\u0016\u001c8OC\u0006l_Rd\u0017N\\\"mCN\u001c(\u0002\u0006'pG\u0006dg)\u001b7f\u0017>$H.\u001b8DY\u0006\u001c8OC\u0005jgB\u000b7m[1hK*12\r[3dW\u000eC\u0017M\\4fg&\u001bx\n]3o!\u0006\u0014HOC\u0006DQ\u0006tw-Z:J]\u001a|'\u0002\u00023bi\u0006T\u0011BQ=uK\u0006\u0013(/Y=\u000b\u0007A,HOC\u0003csR,7O\u0003\u0004sK6|g/\u001a\u0006\u0005+:LG\u000ft\u0001\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)!\u0001\u0002\u0002\t\t\u0015\u0019Aq\u0001E\u0004\u0019\u0001)1\u0001\u0002\u0002\t\n1\u0001Q!\u0001E\u0007\u000b\t!Q\u0001C\u0004\u0006\u0007\u0011-\u0001B\u0002\u0007\u0001\u000b\t!!\u0001#\u0001\u0006\u0005\u0011-\u0001BB\u0003\u0003\t\u0005A\u0011\"\u0002\u0002\u0005\u0010!MQa\u0001\u0003\t\u0011#a\u0001!B\u0001\t\u0005\u0015\u0019A!\u0003\u0005\u000b\u0019\u0001)!\u0001\u0002\u0005\t\u0012\u0015\u0019A!\u0003E\f\u0019\u0001)!\u0001B\u0003\t\u0019\u0015\u0011Aa\u0003E\f\u000b\t!!\u0001#\u0003\u0006\u0007\u0011\u0011\u0001B\u0004\u0007\u0001\u000b\r!!\u0001c\b\r\u0001\u0015\u0011AA\u0001E\u0010\u000b\t!!\u0001\u0003\b\u0006\u0007\u0011I\u0001\u0012\u0005\u0007\u0001\u000b\r!\u0011\u0002#\n\r\u0001\u0011\t%\u0001D\u0002\u001a\u0011\u0015\t\u0001\u0002B\u0005\u0005\u0013\r)\u0011\u0001#\u0003\u0019\na!Q&\u0006\u0003\u00041\u001fiz\u0001\u0002\u0001\t\u00115\u0019Q!\u0001E\t1#\u00016\u0001A\u0011\u0004\u000b\u0005A\u0019\u0002g\u0005R\u0007\u0015!y!C\u0001\u0005\u00025\t\u0001BC\u0017\u0016\t)A*\"h\u0004\u0005\u0001!YQbA\u0003\u0002\u0011\u0013AJ\u0001U\u0002\u0001C\r)\u0011\u0001#\u0006\u0019\u0016E\u001bQ\u0001\"\u0006\n\u0003!]Q\"\u0001\u0005\r[Y!1\u0001'\u0007\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0001\tC!B\u0001\t\n1\u0005\u0001\u0014B)\u0004\u000b\u0011e\u0011\"\u0001\u0005\r\u001b\u0005A!\"\f\u0016\u0005\u0007aiQt\u0002\u0003\u0001\u00117i1!B\u0001\t\u001aae\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005A\u0019\u0002g\u0005Q\u0007\u0003iz\u0001B\u0001\t\u001f5\u0019Q!\u0001E\n1'\u00016!A\u0011\u0004\u000b\u0005AQ\u0002G\u0007R\u0007%!Q\"C\u0001\t\u001c5\t\u0001BD\u0007\u0002\t\u0003i\u0011\u0001\"\u0001.l\u0011\u0019\u0001$DO\b\t\u0001A\u0001\"D\u0002\u0006\u0003!E\u0001\u0014\u0003)\u0004\u0001u=A\u0001\u0001\u0005\u0011\u001b\r)\u0011\u0001#\b\u0019\u001eA\u001b\t!h\u0004\u0005\u0001!uQbA\u0003\u0002\u0011'A\u001a\u0002U\u0002\u0002;\u001f!\u0001\u0001C\b\u000e\u0007\u0015\t\u00012\u0003M\n!\u000e\r\u0011eA\u0003\u0002\u00115AR\"U\u0002\r\t5I\u0011\u0001c\u0007\u000e\u0003!QQB\u0001C\u0002\u0019\u0003i\u0011\u0001\"\u0001\u000e\u0003\u0011\u0005Q6\u000e\u0003\u00021Eiz\u0001\u0002\u0001\t\u00115\u0019Q!\u0001E\t1#\u00016\u0001AO\b\t\u0001A\u0019#D\u0002\u0006\u0003!u\u0001T\u0004)\u0004\u0002u=A\u0001\u0001E\u000f\u001b\r)\u0011\u0001c\u0005\u0019\u0014A\u001b\u0011!h\u0004\u0005\u0001!yQbA\u0003\u0002\u0011'A\u001a\u0002UB\u0002C\r)\u0011\u0001C\u0007\u0019\u001bE\u001bA\u0002B\t\n\u0003!mQ\"\u0001\u0005\u000b\u001b\t!\u0019\u0001$\u0001\u000e\u0003\u0011\u0005Q\"\u0001C\u0001[U!1\u0001\u0007\n\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0001\t3!B\u0001\t\u001fay\u0011kA\u0003\u0005%%\tA\u0001A\u0007\u0002\u0011))\f$b\f\u0005G\u0004AR!h\u0004\u0005\u0001!-QbA\u0003\u0002\u0011\u0019Ab\u0001UB\u0001C\r)\u0011\u0001C\u0002\u0019\u0007E\u001bq\u0001B\u0003\n\u0003\u0011\u0001Q\"\u0001E\u0007\u001b\u0005Aq\u0001"})
    private final class ProtoMap
    extends BasicStringMap<ProtoMapValue> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(ProtoMap.class);
        }

        @NotNull
        public final ChangesInfo process(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage, boolean checkChangesIsOpenPart) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            KotlinClassHeader header = kotlinClass.getClassHeader();
            String[] stringArray = header.getAnnotationData();
            if (stringArray == null) {
                Intrinsics.throwNpe();
            }
            byte[] bytes = BitEncoding.decodeBytes((String[])stringArray);
            JvmClassName jvmClassName = kotlinClass.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"bytes");
            return this.put(jvmClassName, bytes, isPackage, checkChangesIsOpenPart);
        }

        @NotNull
        public static /* synthetic */ ChangesInfo process$default(ProtoMap protoMap, LocalFileKotlinClass localFileKotlinClass, boolean bl, boolean bl2, int n) {
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return protoMap.process(localFileKotlinClass, bl, bl2);
        }

        @NotNull
        public final ChangesInfo process(@NotNull JvmClassName className2, @NotNull byte[] data2, boolean isPackage, boolean checkChangesIsOpenPart) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            return this.put(className2, data2, isPackage, checkChangesIsOpenPart);
        }

        private final ChangesInfo put(JvmClassName className2, byte[] bytes, boolean isPackage, boolean checkChangesIsOpenPart) {
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            ProtoMapValue oldData = (ProtoMapValue)lazyStorage.get(string);
            ProtoMapValue data2 = new ProtoMapValue(isPackage, bytes);
            if (oldData == null || !Arrays.equals(bytes, oldData.getBytes()) || isPackage != oldData.getIsPackageFacade()) {
                LazyStorage<String, ProtoMapValue> lazyStorage2 = this.getStorage();
                String string2 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                lazyStorage2.set(string2, data2);
            }
            return new ChangesInfo(oldData == null || !checkChangesIsOpenPart || Intrinsics.areEqual((Object)ProtoDifferenceUtilsKt.difference(oldData, data2), (Object)DifferenceKind.NONE.INSTANCE$) ^ true, false, false, false, 14, null);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Nullable
        public final ProtoMapValue get(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return (ProtoMapValue)lazyStorage.get(string);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull ProtoMapValue value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return (value.getIsPackageFacade() ? "1" : "0") + Long.toHexString(IncrementalCacheImplKt.md5(value.getBytes()));
        }

        public ProtoMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ProtoMapValueExternalizer.INSTANCE$);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"t\u0006)a1i\u001c8ti\u0006tGo]'ba*!\u0012J\\2sK6,g\u000e^1m\u0007\u0006\u001c\u0007.Z%na2T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0004UB\u001c(bC5oGJ,W.\u001a8uC2TaBQ1tS\u000e\u001cFO]5oO6\u000b\u0007OC\u0004ti>\u0014\u0018mZ3\u000b\u00075\u000b\u0007O\u0003\u0004TiJLgn\u001a\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\u0006ti>\u0014\u0018mZ3GS2,'\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\tG>tG/Y5og*I1\r\\1tg:\u000bW.\u001a\u0006\r\u0015Zl7\t\\1tg:\u000bW.\u001a\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\rQg/\u001c\u0006\b\u0005>|G.Z1o\u0015%!W/\u001c9WC2,XMC\u0003wC2,XM\u0003\u0003mC:<'\u0002B;uS2TqbZ3u\u0007>t7\u000f^1oiNl\u0015\r\u001d\u0006\u0006Ef$Xm\u001d\u0006\n\u0005f$X-\u0011:sCfTq\u0001\u001d:pG\u0016\u001c8OC\u0006l_Rd\u0017N\\\"mCN\u001c(\u0002\u0006'pG\u0006dg)\u001b7f\u0017>$H.\u001b8DY\u0006\u001c8OC\u0006DQ\u0006tw-Z:J]\u001a|'b\u00019vi*a1m\u001c8ti\u0006tGo]'ba*1!/Z7pm\u0016TA!\u00168jij\u000f!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0002B\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001C\u0005\u0011\u0013a\u0001!B\u0002\u0005\n!)A\u0002A\u0003\u0004\t\u0013AY\u0001\u0004\u0001\u0006\u0003!=QA\u0001C\u0007\u0011!)1\u0001B\u0004\t\u000f1\u0001QA\u0001\u0003\u0003\u0011\u0003)!\u0001B\u0004\t\u000f\u0015\u0011A!\u0001\u0005\u000b\u000b\t!\u0011\u0002#\u0006\u0006\u0007\u0011M\u00012\u0003\u0007\u0001\u000b\r!I\u0001C\u0006\r\u0001\u0015\u0011A1\u0003E\n\u000b\t!i\u0001#\u0007\u0006\u0005\u0011]\u0001\"B\u0003\u0003\t\u001bAQ\"\u0002\u0002\u0005\u001a!%Qa\u0001C\u0005\u0011;a\u0001!B\u0002\u0005\u0005!\u0001B\u0002A\u0003\u0004\t\tA\t\u0003\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0012E\u0003\u0003\t\tA\u0001#B\u0002\u0005\n!\u0015B\u0002\u0001\u0003B\u00051\u0019\u0011DE\u0003\u0002\u0011\u0011Ia\"C\u0007\u0006\u0003!)\u0011\u0002B\u0005\u0004\u000b\u0005AY\u0001g\u0003\n\t%\u0019Q!\u0001\u0005\u00071\u0019AR\u0001\u0007\u0003.+\u0011\u0019\u0001\u0014CO\b\t\u0001A\u0011\"D\u0002\u0006\u0003!Q\u0001D\u0003)\u0004\u0001\u0005\u001aQ!\u0001E\u000b1+\t6!\u0002C\t\u0013\u0005!\t!D\u0001\t\u00175zBA\u0003M\f;G!\u0001\u0001\u0003\u0007\u000e\u001b\u0015\t\u0001\"B\u0005\u0005\u0013\r)\u0011\u0001c\u0003\u0019\f%!\u0011bA\u0003\u0002\u0011\u0019Ab\u0001G\u0003Q\u0007\u0001\t3!B\u0001\t\fa-\u0011kA\u0003\u0005\u0018%\t\u0001\u0002D\u0007\u0002\u00115i\u0013\u0005B\u0001\u0019\u001cu=A\u0001\u0001\u0005\u000f\u001b\r)\u0011\u0001c\u0007\u0019\u001cA\u001b\u0001!\t\b\u0006\u0003!)\u0011\u0002B\u0005\u0004\u000b\u0005AY\u0001g\u0003\n\t%\u0019Q!\u0001\u0005\u00071\u0019a\t\u0001G\u0003R\u0007\u0019!Y\"C\u0001\t\u001b5\u0011A1\u0001G\u0001[U!1\u0001G\b\u001e\u0010\u0011\u0001\u0001rD\u0007\u0004\u000b\u0005Aa\u0002\u0007\bQ\u0007\u0001\t3!B\u0001\t\u001eau\u0011kA\u0003\u0005\u001f%\t\u0001bD\u0007\u0002\u0011?i+\u0006B\u0001\u0019#u=A\u0001\u0001\u0005\n\u001b\r)\u0011\u0001\u0003\u0006\u0019\u0015A\u001b\u0001!(\n\u0005\u0001!\rRBD\u0003\u0002\u0011\u0015IA!C\u0002\u0006\u0003!-\u00014B\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0004\u0019\r1\u0005\u0001$\u0002)\u0004\u0002\u0005\u001aQ!\u0001E\u000f1;\t6a\u0002\u0003\u0012\u0013\u0005Aq\"D\u0001\t\u00175\t\u0001\"D\u0017\u0016\t\rA\"#h\u0004\u0005\u0001!IQbA\u0003\u0002\u0011)A\"\u0002U\u0002\u0001C\r)\u0011\u0001\u0003\t\u0019!E\u001bQ\u0001\u0002\n\n\u0003\u0011\u0001Q\"\u0001\u0005\fkc)y\u0003Br\u00011\u0019iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001E\b1\u001f\u00016\u0011A\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007\u001d!a!C\u0001\u0005\u00015\t\u0001\u0002C\u0007\u0002\u0011#\u0001"})
    private final class ConstantsMap
    extends BasicStringMap<Map<String, ? extends Object>> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(ConstantsMap.class);
        }

        private final Map<String, Object> getConstantsMap(byte[] bytes) {
            HashMap result = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result, Opcodes.ASM5){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ HashMap $result;

                static {
                    $kotlinClass = Reflection.createKotlinClass(getConstantsMap.1.class);
                }

                @Nullable
                public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    int staticFinal = Opcodes.ACC_STATIC | Opcodes.ACC_FINAL;
                    if (value != null && (access & staticFinal) == staticFinal) {
                        MapsKt.set((Map)this.$result, (Object)name, (Object)value);
                    }
                    return null;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, ClassReader.SKIP_CODE | ClassReader.SKIP_DEBUG | ClassReader.SKIP_FRAMES);
            return result.isEmpty() ? (HashMap)null : result;
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @NotNull
        public final ChangesInfo process(@NotNull LocalFileKotlinClass kotlinClass) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getConstantsMap(kotlinClass.getFileContents()));
        }

        private final ChangesInfo put(JvmClassName className2, Map<String, ? extends Object> constantsMap) {
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            Map oldMap = (Map)lazyStorage.get(string);
            if (Intrinsics.areEqual((Object)oldMap, constantsMap)) {
                return ChangesInfo.Companion.getNO_CHANGES();
            }
            if (constantsMap != null) {
                LazyStorage<String, Map<String, ? extends Object>> lazyStorage2 = this.getStorage();
                String string2 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                lazyStorage2.set(string2, constantsMap);
            } else {
                LazyStorage lazyStorage3 = this.getStorage();
                String string3 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"key");
                lazyStorage3.remove(string3);
            }
            return new ChangesInfo(false, true, false, false, 13, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.put(className2, null);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpMap(value, (Function1)Reflection.function((FunctionReference)dumpValue.1.INSTANCE$));
        }

        public ConstantsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ConstantsMapExternalizer.INSTANCE$);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"[\u0004)A2i\u001c8ti\u0006tGo]'ba\u0016CH/\u001a:oC2L'0\u001a:\u000b)%s7M]3nK:$\u0018\r\\\"bG\",\u0017*\u001c9m\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u00016qg*Y\u0011N\\2sK6,g\u000e^1m\u0015A!\u0015\r^1FqR,'O\\1mSj,'OC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0005kRLGN\u0003\u0002j_*\u0019Q*\u00199\u000b\rM#(/\u001b8h\u0015\r\te.\u001f\u0006\u0005e\u0016\fGM\u0003\u0002j]*IA)\u0019;b\u0013:\u0004X\u000f\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003tCZ,'bA8vi*QA)\u0019;b\u001fV$\b/\u001e;\u000b\u00075\f\u0007O\u0003\u0003V]&$(\u0002B&j]\u0012\u0004\u001bA\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0004\t\tA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005AA!\u0002\u0002\u0005\b!%QA\u0001\u0003\u0005\u0011\u0015)!\u0001\"\u0003\t\f\u0015\u0019A!\u0002E\u0004\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u00111\u0001B\u0002\u0007\u0001\u000b\r!a\u0001#\u0004\r\u0001\u0015\u0019AA\u0002\u0005\b\u0019\u0001)\u0011\u0001C\u0005\u0006\u0005\u0011A\u00012B\u0003\u0004\t#A\t\u0002\u0004\u0001\u0006\u0005\u0011A\u0001\"B\u0003\u0003\t'Aa!\u0002\u0002\u0005\u0012!EQa\u0001C\t\u0011+a\u0001!B\u0002\u0005\r!]A\u0002A\u0003\u0003\t#A)\u0002B1\u0002\u0019\rI\"#B\u0001\t\f%q\u0011\"D\u0003\u0002\u0011\u001bIA!C\u0002\u0006\u0003!9\u0001dB\u0005\u0005\u0013\r)\u0011\u0001c\u0004\u0019\u0010a5\u00014BO\u0001\u00195\u0002Ca\u0003M\b;\u001f!\u0001\u0001\u0003\u0005\u000e\u0007\u0015\t\u0001\"\u0003\r\n!\u000e\u0001\u0011ED\u0003\u0002\u0011\u001bIA!C\u0002\u0006\u0003!9\u0001dB\u0005\u0005\u0013\r)\u0011\u0001c\u0004\u0019\u00101\u0005\u0001TB)\u0004\u000b\u0011=\u0011\"\u0001\u0005\u000b\u001b\u0005A)\",\u0016\u0005\u0017aMQt\u0002\u0003\u0001\u0011)i1!B\u0001\t\u0017aY\u0001k\u0001\u0001\u001e&\u0011\u0001\u0001bC\u0007\u000f\u000b\u0005Ai!\u0003\u0003\n\u0007\u0015\t\u0001b\u0002\r\b\u0013\u0011I1!B\u0001\t\u0010a=A\u0012\u0001M\u0007!\u000e\u0005\u0011eA\u0003\u0002\u0011/A:\"U\u0002\b\t'I\u0011\u0001\u0002\u0001\u000e\u0003!aQ\"\u0001\u0005\u000bk\u0001\u0001"})
    private static final class ConstantsMapExternalizer
    implements DataExternalizer<Map<String, ? extends Object>> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final ConstantsMapExternalizer INSTANCE$;

        static {
            $kotlinClass = Reflection.createKotlinClass(ConstantsMapExternalizer.class);
            new ConstantsMapExternalizer();
        }

        public void save(@NotNull DataOutput out, @Nullable Map<String, ? extends Object> map) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            Map<String, ? extends Object> map2 = map;
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            out.writeInt(map2.size());
            for (String name : CollectionsKt.sorted((Iterable)map.keySet())) {
                Object value;
                Object object;
                IOUtil.writeString((String)name, (DataOutput)out);
                if (map.get(name) == null) {
                    Intrinsics.throwNpe();
                }
                if ((object = value) instanceof Integer) {
                    out.writeByte(Kind.INT.ordinal());
                    out.writeInt(((Number)value).intValue());
                    continue;
                }
                if (object instanceof Float) {
                    out.writeByte(Kind.FLOAT.ordinal());
                    out.writeFloat(((Number)value).floatValue());
                    continue;
                }
                if (object instanceof Long) {
                    out.writeByte(Kind.LONG.ordinal());
                    out.writeLong(((Number)value).longValue());
                    continue;
                }
                if (object instanceof Double) {
                    out.writeByte(Kind.DOUBLE.ordinal());
                    out.writeDouble(((Number)value).doubleValue());
                    continue;
                }
                if (object instanceof String) {
                    out.writeByte(Kind.STRING.ordinal());
                    IOUtil.writeString((String)((String)value), (DataOutput)out);
                    continue;
                }
                throw (Throwable)new IllegalStateException("Unexpected constant class: " + value.getClass());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public Map<String, Object> read(@NotNull DataInput in) {
            Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
            int size = in.readInt();
            HashMap map = new HashMap(size);
            int n = 0;
            int n2 = size - 1;
            if (n <= n2) {
                void index;
                do {
                    String name;
                    Comparable<Integer> comparable;
                    void it = ++index;
                    if (IOUtil.readString((DataInput)in) == null) {
                        Intrinsics.throwNpe();
                    }
                    Kind kind = Kind.values()[in.readByte()];
                    switch (IncrementalCacheImpl$ConstantsMapExternalizer$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                        case 1: {
                            comparable = in.readInt();
                            break;
                        }
                        case 2: {
                            comparable = Float.valueOf(in.readFloat());
                            break;
                        }
                        case 3: {
                            comparable = in.readLong();
                            break;
                        }
                        case 4: {
                            comparable = in.readDouble();
                            break;
                        }
                        case 5: {
                            String string = IOUtil.readString((DataInput)in);
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            comparable = (Comparable)((Object)string);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    Number value = comparable;
                    MapsKt.set((Map)map, (Object)name, (Object)value);
                } while (index != n2);
            }
            return map;
        }

        ConstantsMapExternalizer() {
            INSTANCE$ = this;
        }

        @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"%\u0004)!1*\u001b8e\u0015a\u0019uN\\:uC:$8/T1q\u000bb$XM\u001d8bY&TXM\u001d\u0006\u0015\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015-Ign\u0019:f[\u0016tG/\u00197\u000b\t\u0015sW/\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0004TiJLgn\u001a\u0006\u0004\u0013:#&\"\u0002$M\u001f\u0006#&\u0002\u0002'P\u001d\u001eSa\u0001R(V\u00052+%BB*U%&su\t\u0015\u0006\u0003!\rQA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0006\u0015\u0011A!\u0001\u0005\u0004\u000b\t!\u0019\u0001c\u0002\u0006\u0007\u0011\u0011\u0001\"\u0001\u0007\u0001\u000b\r!)\u0001#\u0001\r\u0001\u0015\u0019Aa\u0001\u0005\u0001\u0019\u0001)\u0011\u0001#\u0002\u0006\u0007\u0011!\u0001\u0002\u0002\u0007\u0001\u000b\u0005AQ!\u0002\u0002\u0005\u000b!-QA\u0001C\u0006\u0011\u0019!\u0011\u0019\u0001G\u00043!)\u0011\u0001#\u0003\n\t%\u0019Q!\u0001E\u00041\u000fAJ!-B\u0007\u000f\u001fA\t\"\u000e\t\u0006\u001f\u0011\t\u000f\u0001'\u0003\"\u0007\u0015\t\u0001r\u0001M\u0004#\u000e9A\u0011B\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0004\u000e\u0003\u0011\u0015\u0001"})
        private static final class Kind
        extends Enum<Kind> {
            public static final /* synthetic */ KClass $kotlinClass;
            public static final /* enum */ Kind INT;
            public static final /* enum */ Kind FLOAT;
            public static final /* enum */ Kind LONG;
            public static final /* enum */ Kind DOUBLE;
            public static final /* enum */ Kind STRING;
            private static final /* synthetic */ Kind[] $VALUES;

            static {
                $kotlinClass = Reflection.createKotlinClass(Kind.class);
                Kind[] kindArray = new Kind[5];
                Kind[] kindArray2 = kindArray;
                kindArray[0] = INT = new Kind();
                kindArray[1] = FLOAT = new Kind();
                kindArray[2] = LONG = new Kind();
                kindArray[3] = DOUBLE = new Kind();
                kindArray[4] = STRING = new Kind();
                $VALUES = kindArray;
            }

            public static Kind[] values() {
                return (Kind[])$VALUES.clone();
            }

            public static Kind valueOf(String string) {
                return Enum.valueOf(Kind.class, string);
            }
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"h\u0006)\u0011\u0012J\u001c7j]\u00164UO\\2uS>t7/T1q\u0015QIen\u0019:f[\u0016tG/\u00197DC\u000eDW-S7qY*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0002kaNT1\"\u001b8de\u0016lWM\u001c;bY*q!)Y:jGN#(/\u001b8h\u001b\u0006\u0004(bB:u_J\fw-\u001a\u0006\u0004\u001b\u0006\u0004(BB*ue&twM\u0003\u0003M_:<'B\u0002\u001fj]&$hHC\u0006ti>\u0014\u0018mZ3GS2,'\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\nIVl\u0007OV1mk\u0016TQA^1mk\u0016TA\u0001\\1oO*!Q\u000f^5m\u0015U9W\r^%oY&tWMR;oGRLwN\\:NCBTQAY=uKNT\u0011BQ=uK\u0006\u0013(/Y=\u000b\u000fA\u0014xnY3tg*Y1n\u001c;mS:\u001cE.Y:t\u0015QaunY1m\r&dWmS8uY&t7\t\\1tg*Y1\t[1oO\u0016\u001c\u0018J\u001c4p\u0015\r\u0001X\u000f\u001e\u0006\nG2\f7o\u001d(b[\u0016TAB\u0013<n\u00072\f7o\u001d(b[\u0016TqA]3t_24XMC\u0002km6TaA\\3x\u001b\u0006\u0004(B\u0002:f[>4XM\u0003\u0003V]&$(;\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0007\u0011\u0011\u0001\u0012\u0001\u0007\u0001\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\u0011AA\u0001\u0005\u0005\u000b\r!9\u0001c\u0002\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u0013AI\u0001\u0004\u0001\u0006\u0007\u0011%\u0001\"\u0002\u0007\u0001\u000b\r!I\u0001c\u0003\r\u0001\u0015\t\u0001rB\u0003\u0003\t\u001bA\u0001\"B\u0002\u0005\u000f!9A\u0002A\u0003\u0003\t\tA\t!\u0002\u0002\u0005\u000f!9QA\u0001C\u0007\u0011')!\u0001B\u0005\t\u000b\u0015\u0011AQ\u0002\u0005\u000b\u000b\t!!\u0002#\u0003\u0006\u0007\u0011%\u0001r\u0003\u0007\u0001\u000b\r!!\u0001C\u0007\r\u0001\u0015\u0019AA\u0001E\u000e\u0019\u0001)!\u0001\u0002\u0002\t\u001c\u0015\u0011AA\u0001\u0005\u000e\u000b\t!\u0011\u0001c\b\u0006\u0005\u0011m\u0001\u0002E\u0003\u0004\t9Aq\u0002\u0004\u0001\u0006\u0005\u0011q\u0001bD\u0003\u0004\t\u0013A\u0019\u0003\u0004\u0001\u0005\u0003\na1!\u0007\n\u0006\u0003!!\u0011BD\u0005\u000e\u000b\u0005AQ!\u0003\u0003\n\u0007\u0015\t\u00012\u0002M\u0006\u0013\u0011I1!B\u0001\t\ra1\u0001$\u0002\r\u0005[}!!\u0002'\u0005\u001e$\u0011\u0001\u0001\"C\u0007\u000e\u000b\u0005AQ!\u0003\u0003\n\u0007\u0015\t\u00012\u0002M\u0006\u0013\u0011I1!B\u0001\t\ra1\u0001$\u0002)\u0004\u0001\u0005\u001aQ!\u0001E\u00061\u0017\t6!\u0002C\t\u0013\u0005A\u0019\"D\u0001\t\u00165\u0002C!\u0001M\u000b;\u001f!\u0001\u0001C\u0006\u000e\u0007\u0015\t\u0001b\u0003\r\f!\u000e\u0001\u0011%D\u0003\u0002\u0011\u0015IA!C\u0002\u0006\u0003!-\u00014B\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0004\u0019\ra)\u0011k\u0001\u0004\u0005\u0016%\t\u0001RC\u0007\u0003\t\u0007a\t!L\u000b\u0005\u0007aaQt\u0002\u0003\u0001\u00113i1!B\u0001\t\u0018a]\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u0004\r\r#\u000e)A\u0001D\u0005\u0002\u00113i\u0011\u0001C\u0007.T\u0011\t\u0001DDO\b\t\u0001Ai\"D\u0002\u0006\u0003!u\u0001T\u0004)\u0004\u0001u\rB\u0001\u0001E\u0011\u001b5)\u0011\u0001C\u0003\n\t%\u0019Q!\u0001E\u00061\u0017IA!C\u0002\u0006\u0003!1\u0001D\u0002\r\u0006!\u000e\u0005\u0011eA\u0003\u0002\u00111AB\"U\u0002\b\t9I\u0011\u0001#\u0007\u000e\u0003!yQ\"\u0001E\u000b[U!1\u0001G\t\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005Ai\u0002'\bQ\u0007\u0001\t3!B\u0001\t a}\u0011kA\u0003\u0005#%\tA\u0001A\u0007\u0002\u0011=)\f$b\f\u0005G\u0004Ab!h\u0004\u0005\u0001!5QbA\u0003\u0002\u0011\u001fAz\u0001UB\u0001C\r)\u0011\u0001C\u0002\u0019\u0007E\u001bq\u0001\u0002\u0004\n\u0003\u0011\u0001Q\"\u0001\u0005\t\u001b\u0005A\t\u0002"})
    private final class InlineFunctionsMap
    extends BasicStringMap<Map<String, ? extends Long>> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(InlineFunctionsMap.class);
        }

        private final Map<String, Long> getInlineFunctionsMap(byte[] bytes) {
            HashMap result = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result, Opcodes.ASM5){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ HashMap $result;

                static {
                    $kotlinClass = Reflection.createKotlinClass(getInlineFunctionsMap.1.class);
                }

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    ClassWriter dummyClassWriter = new ClassWriter(Opcodes.ASM5);
                    return new MethodVisitor(this, dummyClassWriter, name, desc, Opcodes.ASM5, dummyClassWriter.visitMethod(0, name, desc, (String)null, exceptions)){
                        public static final /* synthetic */ KClass $kotlinClass;
                        private boolean hasInlineAnnotation;
                        final /* synthetic */ getInlineFunctionsMap.1 this$0;
                        final /* synthetic */ ClassWriter $dummyClassWriter;
                        final /* synthetic */ String $name;
                        final /* synthetic */ String $desc;

                        static {
                            $kotlinClass = Reflection.createKotlinClass(getInlineFunctionsMap.visitMethod.1.class);
                        }

                        public final boolean getHasInlineAnnotation() {
                            return this.hasInlineAnnotation;
                        }

                        public final void setHasInlineAnnotation(boolean bl) {
                            this.hasInlineAnnotation = bl;
                        }

                        @Nullable
                        public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                            Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                            if (Intrinsics.areEqual((Object)desc, (Object)IncrementalCacheImplKt.getINLINE_ANNOTATION_DESC())) {
                                this.hasInlineAnnotation = true;
                            }
                            return null;
                        }

                        public void visitEnd() {
                            if (this.hasInlineAnnotation) {
                                byte[] byArray = this.$dummyClassWriter.toByteArray();
                                if (byArray == null) {
                                    Intrinsics.throwNpe();
                                }
                                byte[] dummyBytes = byArray;
                                long hash = IncrementalCacheImplKt.md5(dummyBytes);
                                MapsKt.set((Map)this.this$0.$result, (Object)(this.$name + this.$desc), (Object)hash);
                            }
                        }
                        {
                            this.this$0 = $outer;
                            this.$dummyClassWriter = $captured_local_variable$1;
                            this.$name = $captured_local_variable$2;
                            this.$desc = $captured_local_variable$3;
                            super($super_call_param$4, $super_call_param$5);
                        }
                    };
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, 0);
            return result;
        }

        @NotNull
        public final ChangesInfo process(@NotNull LocalFileKotlinClass kotlinClass) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getInlineFunctionsMap(kotlinClass.getFileContents()));
        }

        private final ChangesInfo put(JvmClassName className2, Map<String, ? extends Long> newMap) {
            String internalName = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = internalName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"internalName");
            Map map = (Map)lazyStorage.get(string);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map oldMap = map;
            HashSet added = SetsKt.hashSetOf((Object[])new String[0]);
            HashSet changed = SetsKt.hashSetOf((Object[])new String[0]);
            Set allFunctions = SetsKt.plus(oldMap.keySet(), (Iterable)newMap.keySet());
            for (String fn : allFunctions) {
                Long oldHash = (Long)oldMap.get(fn);
                Long newHash = newMap.get(fn);
                if (oldHash == null) {
                    added.add(fn);
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)oldHash, (Object)newHash) ^ true)) continue;
                changed.add(fn);
            }
            if (MapsKt.isNotEmpty(newMap)) {
                LazyStorage<String, Map<String, ? extends Long>> lazyStorage2 = this.getStorage();
                String string2 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"internalName");
                lazyStorage2.set(string2, newMap);
            } else {
                LazyStorage lazyStorage3 = this.getStorage();
                String string3 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"internalName");
                lazyStorage3.remove(string3);
            }
            if (CollectionsKt.isNotEmpty((Collection)changed)) {
                IncrementalCacheImpl.this.dirtyInlineFunctionsMap.put(className2, CollectionsKt.toList((Iterable)changed));
            }
            return new ChangesInfo(false, false, CollectionsKt.isNotEmpty((Collection)changed), CollectionsKt.isNotEmpty((Collection)added), 3, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Long> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpMap(value, dumpValue.1.INSTANCE$);
        }

        public InlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringToLongMapExternalizer.INSTANCE$);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\f\u0006)q\u0001+Y2lC\u001e,\u0007+\u0019:u\u001b\u0006\u0004(\u0002F%oGJ,W.\u001a8uC2\u001c\u0015m\u00195f\u00136\u0004HNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\rQ\u0007o\u001d\u0006\fS:\u001c'/Z7f]R\fGN\u0003\bCCNL7m\u0015;sS:<W*\u00199\u000b\u000fM$xN]1hK*9!i\\8mK\u0006t'B\u0002\u001fj]&$hHC\u0006ti>\u0014\u0018mZ3GS2,'\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\u000fC\u0012$\u0007+Y2lC\u001e,\u0007+\u0019:u\u0015%\u0019G.Y:t\u001d\u0006lWM\u0003\u0007Km6\u001cE.Y:t\u001d\u0006lWMC\u0004sKN|GN^3\u000b\u0007)4XN\u0003\u0003V]&$(\"\u00033v[B4\u0016\r\\;f\u0015\u00151\u0018\r\\;f\u0015\u0019\u0019FO]5oO*!A.\u00198h\u00155I7\u000fU1dW\u0006<W\rU1si*1!/Z7pm\u0016T\u001aA\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0004\t\tA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\t!!\u0001\u0003\u0003\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\n!%A\u0002A\u0003\u0002\u0011\u001b)!\u0001b\u0003\t\u000f\u0015\u0019AA\u0002\u0005\u0007\u0019\u0001)!\u0001\u0002\u0002\t\u0002\u0015\u0011AA\u0002\u0005\u0007\u000b\t!\u0011\u0001C\u0005\u0006\u0005\u0011A\u00012C\u0003\u0004\t#A\t\u0002\u0004\u0001\u0006\u0007\u0011%\u0001B\u0003\u0007\u0001\u000b\t!\t\u0002#\u0005\u0006\u0007\u0011%\u0001r\u0003\u0007\u0001\u000b\t!Y\u0001\u0003\u0007\u0006\u0005\u0011Y\u0001r\u0003\u0003B\u00051\u0019\u0011\u0004C\u0003\u0002\u0011\u0011IA!C\u0002\u0006\u0003!)\u0001$\u0002\r\u0005[U!1\u0001g\u0004\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0001\t3!B\u0001\t\u0014aM\u0011kA\u0003\u0005\u0010%\tA\u0001A\u0007\u0002\u0011)iS\u0003\u0002\u0006\u0019\u0016u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\u0001!I\u0002\u0006\u0003!U\u0001TC)\u0004\u000b\u0011U\u0011\"\u0001E\f\u001b\u0005!\t!L\u000b\u0005\u0007aeQt\u0002\u0003\u0001\u0011!i1!B\u0001\t\u0013aI\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\"\u0002\r\u0006#\u000e)A\u0011D\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0006.+\u0011\u0019\u0001$DO\b\t\u0001A\u0001\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0001\u0005\u001aQ!\u0001E\n1'\t6!\u0002\u0003\u000e\u0013\u0005!\u0001!D\u0001\t\u0015UFRq\u0006\u0003d\u0002a)Qt\u0002\u0003\u0001\u0011\u0017i1!B\u0001\t\u000ea5\u0001k!\u0001\"\u0007\u0015\t\u0001b\u0001\r\u0004#\u000e9A!B\u0005\u0002\t\u0001i\u0011\u0001C\u0004\u000e\u0003!=\u0001"})
    private final class PackagePartMap
    extends BasicStringMap<Boolean> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(PackagePartMap.class);
        }

        public final void addPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage<String, Boolean> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, true);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        public final boolean isPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public PackagePartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"%\u0006)\u00112k\\;sG\u0016$vn\u00117bgN,7/T1q\u0015QIen\u0019:f[\u0016tG/\u00197DC\u000eDW-S7qY*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0002kaNT1\"\u001b8de\u0016lWM\u001c;bY*q!)Y:jGN#(/\u001b8h\u001b\u0006\u0004(bB:u_J\fw-\u001a\u0006\u0005\u0019&\u001cHO\u0003\u0004TiJLgn\u001a\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0017M$xN]1hK\u001aKG.\u001a\u0006\u0005\r&dWM\u0003\u0003kCZ\f'BA5p\u0015\r\tG\r\u001a\u0006\u000bg>,(oY3GS2,'\"C2mCN\u001ch*Y7f\u00151Qe/\\\"mCN\u001ch*Y7f\u0015\u001d\u0011Xm]8mm\u0016T1A\u001b<n\u0015\u0011)f.\u001b;\u000b+\rdW-\u0019:PkR\u0004X\u000f^:G_J\u001cv.\u001e:dK*IA-^7q-\u0006dW/\u001a\u0006\u0006m\u0006dW/\u001a\u0006\u0005Y\u0006twM\u0003\u0003vi&d'bA4fi*Q1i\u001c7mK\u000e$\u0018n\u001c85\u0004)\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)1\u0001\u0002\u0002\t\u00021\u0001Qa\u0001C\u0003\u0011\u0001a\u0001!\u0002\u0002\u0005\u0005!!Qa\u0001C\u0004\u0011\u000fa\u0001!B\u0001\t\u0005\u0015\u0019A\u0011\u0002E\u0005\u0019\u0001)1\u0001\"\u0003\t\u000b1\u0001Q!\u0001\u0005\b\u000b\t!a\u0001c\u0004\u0006\u0007\u00115\u0001R\u0002\u0007\u0001\u000b\t!!\u0001#\u0001\u0006\u0005\u00115\u0001RB\u0003\u0003\t\u0005A!\"\u0002\u0002\u0005\u0012!UQa\u0001\u0003\n\u0011'a\u0001!B\u0002\u0005\n!YA\u0002A\u0003\u0003\t%A\u0019\"\u0002\u0002\u0005\r!iQA\u0001\u0003\f\u0011\u0015)!\u0001\u0002\u0004\t\u001c\u0015\u0011A\u0001\u0004E\u0005\u000b\r!I\u0001#\b\r\u0001\u0015\u0011A\u0001\u0004E\u000f\t\u0005\u0013AbA\r\u000e\u000b\u0005AA!C\u0005\n\u0011\u0015\t\u0001\"B\u0005\u0005\u0013\r)\u0011\u0001c\u0003\u0019\fa)\u0001\u0004BW \t\rA\u0002\"h\u0004\u0005\u0001!EQbA\u0003\u0002\u0011\u001dAr\u0001U\u0002\u0001;\u001f!\u0001\u0001C\u0005\u000e\u0007\u0015\t\u00012\u0003M\n!\u000e\u0005\u0011eA\u0003\u0002\u0011)A\"\"U\u0002\b\t!I\u0011\u0001\u0002\u0001\u000e\u0003!AQ\"\u0001E\u000b[U!1\u0001g\u0006\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u0001\t3!B\u0001\t\u0015aQ\u0011kA\u0003\u0005\u0018%\tA\u0001A\u0007\u0002\u0011!i#\u0004\u0002\u0006\u0019\u0019ueA\u0001\u0001E\r\u001b!)\u0011\u0001C\u0003\n\t%\u0019Q!\u0001E\u00061\u0017AR\u0001U\u0002\u0001C\r)\u0011\u0001c\u0003\u0019\fE\u001bQ\u0001\u0002\u0007\n\u0003!]Q\"\u0001E\r[i!1\u0001\u0007\b\u001e\u0010\u0011\u0001\u0001\u0012C\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u0001\t\u0003\"B\u0001\t\u001b%!\u0011bA\u0003\u0002\u0011'A\u001a\u0002G\u0007R\u0007\u0015!a\"C\u0001\t\u001c5\t\u0001\u0002C[\u0019\u000b_!1\u001d\u0001M\u0006;\u001f!\u0001\u0001\u0003\u0004\u000e\u0007\u0015\t\u0001b\u0002\r\b!\u000e\u0005\u0011eA\u0003\u0002\u0011\rA2!U\u0002\b\t\u0017I\u0011\u0001\u0002\u0001\u000e\u0003!=Q\"\u0001\u0005\t"})
    private final class SourceToClassesMap
    extends BasicStringMap<List<? extends String>> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(SourceToClassesMap.class);
        }

        public final void clearOutputsForSource(@NotNull File sourceFile) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            lazyStorage.remove(string);
        }

        public final void add(@NotNull File sourceFile, @NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            lazyStorage.append(string, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(className2){
                final /* synthetic */ JvmClassName $className;

                public final void invoke(@NotNull DataOutput out) {
                    Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                    IOUtil.writeUTF((DataOutput)out, (String)this.$className.getInternalName());
                }
                {
                    this.$className = jvmClassName;
                    super(1);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<JvmClassName> get(@NotNull File sourceFile) {
            void destination;
            void $receiver;
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            Iterable $receiver2 = CollectionsKt.orEmpty((List)((List)lazyStorage.get(string)));
            Iterable iterable = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                String string2 = (String)item;
                void var8_8 = destination;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
                var8_8.add(jvmClassName);
            }
            return (List)destination;
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull List<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return value.toString();
        }

        public SourceToClassesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            KeyDescriptor keyDescriptor = (KeyDescriptor)PathStringDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyDescriptor, (String)"PathStringDescriptor.INSTANCE");
            super(storageFile, (KeyDescriptor<String>)keyDescriptor, (DataExternalizer)StringListExternalizer.INSTANCE$);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u000e\u0006))B)\u001b:us>+H\u000f];u\u00072\f7o]3t\u001b\u0006\u0004(\u0002F%oGJ,W.\u001a8uC2\u001c\u0015m\u00195f\u00136\u0004HNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\rQ\u0007o\u001d\u0006\fS:\u001c'/Z7f]R\fGN\u0003\bCCNL7m\u0015;sS:<W*\u00199\u000b\u000fM$xN]1hK*9!i\\8mK\u0006t'B\u0002\u001fj]&$hHC\u0006ti>\u0014\u0018mZ3GS2,'\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\nIVl\u0007OV1mk\u0016TQA^1mk\u0016Taa\u0015;sS:<'\u0002\u00027b]\u001eTQcZ3u\t&\u0014H/_(viB,Ho\u00117bgN,7O\u0003\u0006D_2dWm\u0019;j_:TA!\u001e;jY*IQ.\u0019:l\t&\u0014H/\u001f\u0006\nG2\f7o\u001d(b[\u0016TA!\u00168ji*Aan\u001c;ESJ$\u0018\u0010f\u0001\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)!\u0001\u0002\u0002\t\t\u0015\u0019Aq\u0001E\u0004\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u0011%\u0001\u0012\u0002\u0007\u0001\u000b\u0005Ai!\u0002\u0002\u0005\f!9Qa\u0001\u0003\u0007\u0011\u0019a\u0001!\u0002\u0002\u0005\u0005!\u0005QA\u0001\u0003\u0007\u0011\u0019)1\u0001\"\u0003\t\u00121\u0001QA\u0001C\u0006\u0011%)!\u0001\"\u0005\t\u0012\u0015\u0019A\u0011\u0002\u0005\u000b\u0019\u0001)!\u0001b\u0003\t\u0016\u0015\u0011AA\u0003\u0005\u000b\u000b\r!I\u0001\u0003\u0007\r\u0001\u0011\t%\u0001D\u0002\u001a\u0011\u0015\t\u0001\u0002B\u0005\u0005\u0013\r)\u0011\u0001C\u0003\u0019\u000ba!Q&\u0006\u0003\u000b1\u001fiz\u0001\u0002\u0001\t\u00115\u0019Q!\u0001\u0005\u00061\u0015\u00016\u0001A\u0011\u0004\u000b\u0005A\u0001\u0002\u0007\u0005R\u0007\u0015!y!C\u0001\t\u00135\tA\u0011AW\u0010\t\rA\u001a\"\t\u0005\u0006\u0003!M\u0011\u0002B\u0005\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0019\u0014E\u001b1\u0001b\u0005\n\u0003!UQ&\u0006\u0003\u00041-iz\u0001\u0002\u0001\t\u00185\u0019Q!\u0001\u0005\t1!\u00016\u0001A\u0011\u0004\u000b\u0005A1\u0002G\u0006R\u0007\u0015!1\"C\u0001\u0005\u00015\t\u0001\"C\u0017\u0016\t\rAJ\"h\u0004\u0005\u0001!]QbA\u0003\u0002\u0011!A\u0002\u0002U\u0002\u0001C\r)\u0011\u0001C\u0006\u0019\u0017E\u001bQ\u0001\"\u0007\n\u0003\u0011\u0001Q\"\u0001\u0005\nkc)y\u0003Br\u00011\u0015iz\u0001\u0002\u0001\t\f5\u0019Q!\u0001E\u00071\u001b\u00016\u0011A\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007\u001d!Q!C\u0001\u0005\u00015\t\u0001bB\u0007\u0002\u0011\u001f\u0001"})
    private final class DirtyOutputClassesMap
    extends BasicStringMap<Boolean> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(DirtyOutputClassesMap.class);
        }

        public final void markDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.getStorage().set(className2, true);
        }

        public final void notDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.getStorage().remove(className2);
        }

        @NotNull
        public final Collection<String> getDirtyOutputClasses() {
            return this.getStorage().getKeys();
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public DirtyOutputClassesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0019\u0006)9B)\u001b:us&sG.\u001b8f\rVt7\r^5p]Nl\u0015\r\u001d\u0006\u0015\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015-Ign\u0019:f[\u0016tG/\u00197\u000b\u001d\t\u000b7/[2TiJLgnZ'ba*91\u000f^8sC\u001e,'\u0002\u0002'jgRTaa\u0015;sS:<'B\u0002\u001fj]&$hHC\u0006ti>\u0014\u0018mZ3GS2,'\u0002\u0002$jY\u0016TAA[1wC*\u0011\u0011n\u001c\u0006\nIVl\u0007OV1mk\u0016TQA^1mk\u0016TA\u0001\\1oO*!Q\u000f^5m\u0015)9W\r^#oiJLWm\u001d\u0006\u0004\u001b\u0006\u0004(\u0002\u0004&w[\u000ec\u0017m]:OC6,'b\u0002:fg>dg/\u001a\u0006\u0004UZl'b\u00019vi*I1\r\\1tg:\u000bW.\u001a\u0006\u0011G\"\fgnZ3e\rVt7\r^5p]NTA!\u00168jiR\u000e!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0002B\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001C\u0005\u0011\u0013a\u0001!B\u0002\u0005\n!)A\u0002A\u0003\u0002\u0011\u001d)!\u0001\u0002\u0004\t\u0010\u0015\u0019AQ\u0002E\u0007\u0019\u0001)!\u0001\u0002\u0002\t\u0002\u0015\u0011AQ\u0002E\u0007\u000b\t!a\u0001C\u0005\u0006\u0005\u0011E\u0001\"B\u0003\u0003\t\u0019A\u0019\"\u0002\u0002\u0005\u0014!%Qa\u0001C\u0005\u0011+a\u0001!\u0002\u0002\u0005\u0003!]QA\u0001\u0003\f\u00111)1\u0001b\u0006\t\u00171\u0001QA\u0001C\n\u0011+)1\u0001\"\u0003\t\u001d1\u0001QA\u0001C\f\u0011-!\u0011I\u0001\u0007\u000435)\u0011\u0001\u0003\u0003\n\u0013%AQ!\u0001\u0005\u0006\u0013\u0011I1!B\u0001\t\fa-\u0001$\u0002\r\u0005[i!!\u0002\u0007\u0005\u001e\u001a\u0011\u0001\u0001\u0012C\u0007\t\u000b\u0005AQ!\u0003\u0003\n\u0007\u0015\t\u00012\u0002M\u00061\u0015\u00016\u0001A\u0011\u0004\u000b\u0005AY\u0001g\u0003R\u0007\u0015!\u0001\"C\u0001\t\u00135\t\u0001BCW\u001a\t\rA\"\"\t\n\u0006\u0003!U\u0011\u0002B\u0005\u0004\u000b\u0005AA\u0002\u0007\u0007\n\u0013%AQ!\u0001\u0005\u0006\u0013\u0011I1!B\u0001\t\fa-\u0001$\u0002M\u000b#\u000e\u0019AAC\u0005\u0002\u00113iK\u0005B\u0002\u0019\u001au=A\u0001\u0001\u0005\u000e\u001b\r)\u0011\u0001\u0003\u0007\u0019\u0019A\u001b\u0001!(\u0007\u0005\u0001!mQ\u0002C\u0003\u0002\u0011\u0015IA!C\u0002\u0006\u0003!-\u00014\u0002\r\u0006!\u000e\u0005\u0011eA\u0003\u0002\u00115AR\"U\u0002\b\t3I\u0011\u0001\u0002\u0001\u000e\u0003!mQ\"\u0001\u0005\u000bkc)y\u0003Br\u00011\u0017iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001\u0005\b1\u001d\u00016\u0011A\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007\u001d!Y!C\u0001\u0005\u00015\t\u0001rB\u0007\u0002\u0011!\u0001"})
    private final class DirtyInlineFunctionsMap
    extends BasicStringMap<List<? extends String>> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(DirtyInlineFunctionsMap.class);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<JvmClassName, List<? extends String>> getEntries() {
            Iterable $receiver = this.getStorage().getKeys();
            float capacity = (float)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver, (int)10) / 0.75f + 1.0f;
            LinkedHashMap<JvmClassName, List<? extends String>> result = new LinkedHashMap<JvmClassName, List<? extends String>>(Math.max((int)capacity, 16));
            for (Object element : $receiver) {
                List<? extends String> list;
                void it;
                String p1;
                String string = (String)element;
                LinkedHashMap<JvmClassName, List<? extends String>> linkedHashMap = result;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)p1);
                p1 = (String)element;
                if (this.getStorage().get((String)it) == null) {
                    Intrinsics.throwNpe();
                }
                linkedHashMap.put(jvmClassName, list);
            }
            return result;
        }

        public final void put(@NotNull JvmClassName className2, @NotNull List<? extends String> changedFunctions) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull(changedFunctions, (String)"changedFunctions");
            LazyStorage<String, List<? extends String>> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, changedFunctions);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull List<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection((Collection)value);
        }

        public DirtyInlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringListExternalizer.INSTANCE$);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u001a\u0006)9\u0012J\u001c7j]\u00164UO\\2uS>t7OR5mKNl\u0015\r\u001d\u0006\u0015\u0013:\u001c'/Z7f]R\fGnQ1dQ\u0016LU\u000e\u001d7\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1A\u001b9t\u0015-Ign\u0019:f[\u0016tG/\u00197\u000b\u0011\t\u000b7/[2NCBTqa\u001d;pe\u0006<WM\u0003\tQCRDg)\u001e8di&|g\u000eU1je*Q1i\u001c7mK\u000e$\u0018n\u001c8\u000b\rM#(/\u001b8h\u0015\u0019a\u0014N\\5u})Y1\u000f^8sC\u001e,g)\u001b7f\u0015\u00111\u0015\u000e\\3\u000b\t)\fg/\u0019\u0006\u0003S>T1!\u00193e\u0015)\u0019x.\u001e:dKB\u000bG\u000f\u001b\u0006\rUZl7+[4oCR,(/\u001a\u0006\u000bi\u0006\u0014x-\u001a;QCRD'\u0002B+oSRTA\u0001\\1oO*9A-^7q\u0017\u0016L(bA6fs*IA-^7q-\u0006dW/\u001a\u0006\u0006m\u0006dW/\u001a\u0006\u0005kRLGNC\u0002hKRT\u001aA\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0004\t\tA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\t!!\u0001\u0003\u0003\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\r!!\u0001#\u0003\r\u0001\u0015\t\u0001BA\u0003\u0004\t\u0015AQ\u0001\u0004\u0001\u0006\u0007\u0011)\u00012\u0002\u0007\u0001\u000b\u0005Ay!\u0002\u0002\u0005\u000e!AQa\u0001\u0003\b\u0011\u001da\u0001!\u0002\u0002\u0005\u0005!\u0005QA\u0001\u0003\b\u0011\u001d)1\u0001B\u0003\t\u00161\u0001QA\u0001C\u0007\u0011-)!\u0001b\u0005\t\f\u0015\u0011AA\u0001E\u0005\u000b\t!i\u0001c\u0007\u0006\u0005\u0011Y\u0001\"\u0002\u0003B\u00051\u0019\u0011DE\u0003\u0002\u0011\u0011IA!C\u0002\u0006\u0003!%\u0001\u0014B\u0005\n\u0013!)\u0011\u0001c\u0003\n\t%\u0019Q!\u0001\u0005\u00071\u0019AZ\u0001\u0007\u0003.U\u0011\u0019\u0001\u0014CO\b\t\u0001A\u0011\"D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0001u=A\u0001\u0001E\n\u001b\r)\u0011\u0001\u0003\u0004\u0019\rA\u001b\t!h\u0004\u0005\u0001!QQbA\u0003\u0002\u0011\u0019Ab\u0001U\u0002\u0002C\r)\u0011\u0001C\u0005\u0019\u0013E\u001b\u0011\u0002\"\u0005\n\u0003\u0011\u0001Q\"\u0001\u0005\u000b\u001b\u0005A!\"D\u0001\t\u00155*BA\u0003M\f;\u001f!\u0001\u0001\u0003\u0007\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0019Ab!U\u0002\u0006\t/I\u0011\u0001\u0003\u0006\u000e\u0003!UQF\u0007\u0003\u000b13iJ\u0002\u0002\u0001\t\u001b5AQ!\u0001E\u0006\u0013\u0011I1!B\u0001\t\ra1\u00014\u0002)\u0004\u0001\u0005\u001aQ!\u0001\u0005\u00071\u0019\t6!\u0002C\r\u0013\u0005A!\"D\u0001\t\u00185&Ca\u0001\r\u000f;\u001f!\u0001\u0001C\u0005\u000e\u0007\u0015\t\u0001B\u0002\r\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u0011'i1!B\u0001\t\ra1\u0001k!\u0001\"\u0011\u0015\t\u00012B\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0004\u0019\ra-\u0011kA\u0004\u0005\u001d%\t\u0001rC\u0007\u0002\u0011)i\u0011\u0001\u0003\u000662\u0015=Ba9\u0001\u0019\ru=A\u0001\u0001E\u0007\u001b\r)\u0011\u0001c\u0004\u0019\u0010A\u001b\t!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u000f\u00111\u0011\"\u0001\u0003\u0001\u001b\u0005A\u0001\"D\u0001\t\u0012\u0001"})
    private final class InlineFunctionsFilesMap
    extends BasicMap<PathFunctionPair, Collection<? extends String>> {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(InlineFunctionsFilesMap.class);
        }

        public final void add(@NotNull String sourcePath, @NotNull String jvmSignature, @NotNull String targetPath) {
            Intrinsics.checkParameterIsNotNull((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
            Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
            PathFunctionPair key = new PathFunctionPair(sourcePath, jvmSignature);
            this.getStorage().append(key, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(targetPath){
                final /* synthetic */ String $targetPath;

                public final void invoke(@NotNull DataOutput out) {
                    Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                    IOUtil.writeUTF((DataOutput)out, (String)this.$targetPath);
                }
                {
                    this.$targetPath = string;
                    super(1);
                }
            }));
        }

        @NotNull
        public final Collection<String> get(@NotNull String sourcePath, @NotNull String jvmSignature) {
            Intrinsics.checkParameterIsNotNull((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
            PathFunctionPair key = new PathFunctionPair(sourcePath, jvmSignature);
            Collection collection = (Collection)this.getStorage().get(key);
            if (collection == null) {
                collection = SetsKt.emptySet();
            }
            return collection;
        }

        @Override
        @NotNull
        protected String dumpKey(@NotNull PathFunctionPair key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return "(" + key.getPath() + ", " + key.getFunction() + ")";
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        public InlineFunctionsFilesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, PathFunctionPairKeyDescriptor.INSTANCE$, PathCollectionExternalizer.INSTANCE$);
        }
    }
}

