/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.utils.UtilsPackage;

public class NameResolver {
    private final ProtoBuf.StringTable strings;
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    @NotNull
    public static NameResolver read(@NotNull InputStream in) {
        NameResolver nameResolver;
        block3: {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "read"));
            }
            try {
                ProtoBuf.StringTable simpleNames = ProtoBuf.StringTable.parseDelimitedFrom(in);
                ProtoBuf.QualifiedNameTable qualifiedNames = ProtoBuf.QualifiedNameTable.parseDelimitedFrom(in);
                nameResolver = new NameResolver(simpleNames, qualifiedNames);
                if (nameResolver != null) break block3;
            }
            catch (IOException e) {
                throw UtilsPackage.rethrow(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "read"));
        }
        return nameResolver;
    }

    public NameResolver(@NotNull ProtoBuf.StringTable strings, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "<init>"));
        }
        if (qualifiedNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNames", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "<init>"));
        }
        this.strings = strings;
        this.qualifiedNames = qualifiedNames;
    }

    @NotNull
    public String getString(int index) {
        String string = this.strings.getString(index);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getString"));
        }
        return string;
    }

    @NotNull
    public Name getName(int index) {
        Name name = Name.guess((String)this.strings.getString(index));
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getName"));
        }
        return name;
    }

    @NotNull
    public ClassId getClassId(int index) {
        LinkedList<String> packageFqName = new LinkedList<String>();
        LinkedList<String> relativeClassName = new LinkedList<String>();
        boolean local = false;
        while (index != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName proto = this.qualifiedNames.getQualifiedName(index);
            String shortName = this.strings.getString(proto.getShortName());
            switch (proto.getKind()) {
                case CLASS: {
                    relativeClassName.addFirst(shortName);
                    break;
                }
                case PACKAGE: {
                    packageFqName.addFirst(shortName);
                    break;
                }
                case LOCAL: {
                    relativeClassName.addFirst(shortName);
                    local = true;
                }
            }
            index = proto.getParentQualifiedName();
        }
        ClassId classId = new ClassId(FqName.fromSegments(packageFqName), FqName.fromSegments(relativeClassName), local);
        if (classId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getClassId"));
        }
        return classId;
    }

    @NotNull
    public FqName getFqName(int index) {
        ProtoBuf.QualifiedNameTable.QualifiedName qualifiedName = this.qualifiedNames.getQualifiedName(index);
        Name shortName = this.getName(qualifiedName.getShortName());
        if (!qualifiedName.hasParentQualifiedName()) {
            FqName fqName = FqName.topLevel((Name)shortName);
            if (fqName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getFqName"));
            }
            return fqName;
        }
        FqName fqName = this.getFqName(qualifiedName.getParentQualifiedName()).child(shortName);
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/deserialization/NameResolver", "getFqName"));
        }
        return fqName;
    }
}

