/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"g\u0006)q\"+Z:pkJ\u001cW\rT8bI&twm\u00117bgN$\u0015\r^1GS:$WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*i1/\u001a:jC2L'0\u0019;j_:Tq\u0002Z3tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0010\u00072\f7o\u001d#bi\u00064\u0015N\u001c3fe*1A(\u001b8jizRq\u0003]1dW\u0006<WM\u0012:bO6,g\u000e\u001e)s_ZLG-\u001a:\u000b/A\u000b7m[1hK\u001a\u0013\u0018mZ7f]R\u0004&o\u001c<jI\u0016\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTqc]3sS\u0006d\u0017N_3e%\u0016\u001cx.\u001e:dKB\u000bG\u000f[:\u000b/M+'/[1mSj,GMU3t_V\u00148-\u001a)bi\"\u001c(\u0002\u00047pC\u0012\u0014Vm]8ve\u000e,'\"\u0003$v]\u000e$\u0018n\u001c82\u0015\u0019\u0019FO]5oO*Y\u0011J\u001c9viN#(/Z1n\u0015\u0011Q\u0017M^1\u000b\u0005%|'b\u00016w[*Ia-\u001e8di&|gn\u001d\u0006\u000eM&tGm\u00117bgN$\u0015\r^1\u000b\u000f\rd\u0017m]:JI*91\t\\1tg&#'\u0002\u00028b[\u0016T1c\u00117bgN$\u0015\r^1XSRD7k\\;sG\u0016D\u001bA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001C\u0003\u0006\u0007\u0011\u001d\u0001\u0012\u0002\u0007\u0001\u000b\r!\u0019\u0001\u0003\u0004\r\u0001\u0015\t\u00012A\u0003\u0004\t\u0015Aq\u0001\u0004\u0001\u0006\u0007\u0011)\u0001r\u0002\u0007\u0001\u000b\u0005A\t\"\u0002\u0002\u0005\u000e!IQa\u0001\u0003\b\u0011!a\u0001!\u0002\u0002\u0005\b!%QA\u0001C\u0002\u0011\u0019)!\u0001B\u0003\t\u0014\u0015\u0011A!\u0003\u0005\u000b\u000b\t!\u0019\u0002C\u0004\u0006\u0005\u0011\t\u0001\u0002D\u0003\u0004\t+A9\u0002\u0004\u0001\u0006\u0007\u0011\r\u0001\u0012\u0004\u0007\u0001\u000b\t!\u0019\u0001#\u0007\u0006\u0005\u0011U\u0001r\u0003\u0003\f\u0019\u000bI2!B\u0001\t\u0007a\u0019Qf\u0006\u0003b\ta5\u0011ED\u0003\u0002\u0011\u0017IA!C\u0002\u0006\u0003!1\u0001DB\u0005\u0006\u0013\u0011)\u0011\u0001c\u0004\r\u0002a=\u00014B+\u0004\t\u0015\u0019AQB\u0005\u0002\u0011)iC\u0002B1\u00051\u0011\t3!B\u0001\t\ta!Qk\u0001\u0003\u0006\u0007\u0011!\u0011\"\u0001\u0005\t[1!\u0011\r\u0002M\u0006C\r)\u0011\u0001#\u0003\u0019\nU\u001bA!B\u0002\u0005\f%\t\u0001\u0012C\u0017\u0017\t-A*\"h\u0004\u0005\u0001!YQbA\u0003\u0002\u0011-A2\u0002U\u0002\u0001C\u0011)\u0011\u0001c\u0006\r\u0002a]\u0011kA\u0003\u0005\u0016%\t\u0001\u0002D\u0007\u0002\u00113)l'b\u001b\u0005G\u0004A:!h\u0004\u0005\u0001!!QbA\u0003\u0002\u0011\u0011AB\u0001U\u0002\u0001;\u001f!\u0001\u0001c\u0003\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0005QT\u0005\u0003\u0001\u0011\u001bia\"B\u0001\t\f%!\u0011bA\u0003\u0002\u0011\u0019Ab!C\u0003\n\t\u0015\t\u0001r\u0002G\u00011\u001fAZ\u0001U\u0002\u0002C\r)\u0011\u0001#\u0002\u0019\u0006E\u001b\u0011\u0002b\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\t\u001b\u0005A\t\"D\u0001\t\u0015\u0001"})
public class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<? super String, ? extends InputStream> loadResource;

    static {
        $kotlinClass = Reflection.createKotlinClass(ResourceLoadingClassDataFinder.class);
    }

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        FqName fqName = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"classId.getPackageFqName()");
        Object object = CollectionsKt.singleOrNull((List)this.packageFragmentProvider.getPackageFragments(fqName));
        if (!(object instanceof DeserializedPackageFragment)) {
            object = null;
        }
        DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)((Object)object);
        if (deserializedPackageFragment == null) {
            return null;
        }
        DeserializedPackageFragment packageFragment = deserializedPackageFragment;
        InputStream inputStream = (InputStream)this.loadResource.invoke((Object)this.serializedResourcePaths.getClassMetadataPath(classId));
        if (inputStream == null) {
            return null;
        }
        InputStream stream = inputStream;
        NameResolver nameResolver = packageFragment.getNameResolver();
        Intrinsics.checkExpressionValueIsNotNull((Object)nameResolver, (String)"packageFragment.nameResolver");
        ProtoBuf.Class clazz = ProtoBuf.Class.parseFrom(stream, this.serializedResourcePaths.getExtensionRegistry());
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"ProtoBuf.Class.parseFrom\u2026ePaths.extensionRegistry)");
        ClassData classData = new ClassData(nameResolver, clazz);
        return new ClassDataWithSource(classData, null, 2, null);
    }

    public ResourceLoadingClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider, @NotNull SerializedResourcePaths serializedResourcePaths, @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull((Object)packageFragmentProvider, (String)"packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull((Object)serializedResourcePaths, (String)"serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, (String)"loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

