/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveClassUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.resolve.ResolveClassUtil");

    @Nullable
    public static PsiClass resolveClass(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/psi/impl/source/resolve/ResolveClassUtil", "resolveClass"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/resolve/ResolveClassUtil", "resolveClass"));
        }
        if (ref instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)ref).getKind(containingFile) == 6) {
            PsiElement parent = ref.getParent();
            if (parent instanceof PsiAnonymousClass) {
                parent = parent.getParent();
            }
            if (!(parent instanceof PsiNewExpression)) {
                if (parent instanceof PsiJavaCodeReferenceElement) {
                    return null;
                }
                LOG.assertTrue(false);
                return null;
            }
            PsiExpression qualifier2 = ((PsiNewExpression)parent).getQualifier();
            LOG.assertTrue(qualifier2 != null);
            PsiType qualifierType = qualifier2.getType();
            if (qualifierType == null) {
                return null;
            }
            if (!(qualifierType instanceof PsiClassType)) {
                return null;
            }
            PsiClass qualifierClass = PsiUtil.resolveClassInType(qualifierType);
            if (qualifierClass == null) {
                return null;
            }
            String name = ref.getText();
            return qualifierClass.findInnerClassByName(name, true);
        }
        PsiElement classNameElement = ref.getReferenceNameElement();
        if (!(classNameElement instanceof PsiIdentifier)) {
            return null;
        }
        String className = classNameElement.getText();
        ClassResolverProcessor processor = new ClassResolverProcessor(className, ref, containingFile);
        PsiScopesUtil.resolveAndWalk(processor, ref, null);
        return processor.getResult().length == 1 ? (PsiClass)processor.getResult()[0].getElement() : null;
    }
}

