/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamAdapterDescriptor;
import org.jetbrains.kotlin.synthetic.SamAdapterExtensionFunctionDescriptor;

public class SamCodegenUtil {
    @Nullable
    public static FunctionDescriptor getOriginalIfSamAdapter(@NotNull FunctionDescriptor fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/kotlin/codegen/SamCodegenUtil", "getOriginalIfSamAdapter"));
        }
        FunctionDescriptor original = fun.getOriginal();
        if (original instanceof SamAdapterDescriptor) {
            return ((SamAdapterDescriptor)original).getOriginForSam();
        }
        if (original instanceof SamAdapterExtensionFunctionDescriptor) {
            return ((SamAdapterExtensionFunctionDescriptor)original).getSourceFunction();
        }
        if (original.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            for (FunctionDescriptor functionDescriptor : original.getOverriddenDescriptors()) {
                FunctionDescriptor originalIfSamAdapter = SamCodegenUtil.getOriginalIfSamAdapter(functionDescriptor);
                if (originalIfSamAdapter == null) continue;
                return originalIfSamAdapter;
            }
        }
        return null;
    }

    public static <T extends FunctionDescriptor> T resolveSamAdapter(@NotNull T descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/SamCodegenUtil", "resolveSamAdapter"));
        }
        FunctionDescriptor original = SamCodegenUtil.getOriginalIfSamAdapter(descriptor);
        return (T)(original != null ? original : descriptor);
    }

    private SamCodegenUtil() {
    }
}

