/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNode;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.test.TestAssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.SideEffectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.LabelNameRefreshingVisitor;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u0014\u0006)1\u0012\r\\5bg\u0006\u0013x-^7f]R\u001c\u0018J\u001a(fK\u0012,GMC\u0004d_:$X\r\u001f;\u000b\u001b9\u000bW.\u001b8h\u0007>tG/\u001a=u\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'B\u00016t\u0015\u0019Ig\u000e\\5oK*I\u0011M]4v[\u0016tGo\u001d\u0006\u0005\u0019&\u001cHO\u0003\u0007Kg\u0016C\bO]3tg&|gNC\u0002d_6TaaZ8pO2,'\u0002\u00023beRT\u0001bY8na&dWM\u001d\u0006\bE\u0006\u001c7.\u001a8e\u0015\r\t7\u000f\u001e\u0006\u000ba\u0006\u0014\u0018-\\3uKJ\u001c(b\u0003&t!\u0006\u0014\u0018-\\3uKJTA!\u00168ji*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b\u001b9\u000bW.\u001b8h+RLGn]&u\u0015E\u0011XM\u001a:fg\"d\u0015MY3m\u001d\u0006lWm\u001d\u0006\tMVt7\r^5p]*Q!j\u001d$v]\u000e$\u0018n\u001c8\u000b!I,g.Y7f\u0019>\u001c\u0017\r\u001c(b[\u0016\u001c(4\u0001\u0006\u0003!\rQA\u0001\u0003\u0001\u0011\t)!\u0001\"\u0001\t\u0006\u0015\u0011A!\u0001\u0005\u0004\u000b\t!\u0019\u0001c\u0002\u0006\u0005\u0011\u0011\u0001\u0012A\u0003\u0004\t\u000bA\u0011\u0001\u0004\u0001\u0006\u0003!\u0015Qa\u0001C\u0004\u0011\u0013a\u0001!B\u0001\t\f\u0015\u0011A\u0011\u0002\u0005\u0007\u000b\t!Q\u0001#\u0004\u0006\u0005\u0011-\u0001bB\u0003\u0003\t\u0019Ay!\u0002\u0002\u0005\u000e!\u0019QA\u0001\u0003\b\u0011!)1\u0001b\u0004\t\u000b1\u0001Qa\u0001C\b\u0011%a\u0001!B\u0002\u0005\b!MA\u0002A\u0003\u0003\t\u000bA\u0011!B\u0001\t\u0015\u0015\u0011AA\u0003E\u000b\u000b\t!)\u0002#\u0003\u0006\u0007\u0011=\u0001\u0012\u0004\u0007\u0001\u000b\t!y\u0001#\u0007\u0006l\u0011\u0019\u0001\u0004AO\b\t\u0001A\t!D\u0002\u0006\u0003!\u0019\u0001d\u0001)\u0004\u0001ueA\u0001\u0001\u0005\u0005\u001b!)\u0011\u0001\u0003\u0003\n\t%\u0019Q!\u0001\u0005\t1!AB\u0001UB\u0001;3!\u0001\u0001#\u0005\u000e\u0011\u0015\t\u0001\u0002B\u0005\u0005\u0013\r)\u0011\u0001#\u0005\u0019\u0012a!\u0001kA\u0001\"\u0007\u0015\t\u0001\"\u0003\r\n#\u000eIA\u0001A\u0005\u0002\t\u0001i\u0011\u0001c\u0005\u000e\u0003!YQ\"\u0001\u0005\f1\u000eYQ!\t\u0003\u00041/iz\u0001\u0002\u0001\t\u00025\u0019Q!\u0001\u0005\u00041\r\u00016\u0001AO\b\t\u0001AA\"D\u0002\u0006\u0003!]\u0001t\u0003)\u0004\u0002\u0005\u001aQ!\u0001\u0005\n1%\t6a\u0002C\f\u0013\u0005!\u0001!D\u0001\t\u00145\t\u0001\u0002\u0004-\u0004\u0017\u0015\tCa\u0001\r\u000e;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u0001b\u0001\r\u0004!\u000e\u0001Qt\u0002\u0003\u0001\u00111i1!B\u0001\t\u0018a]\u0001k!\u0001\"\u0007\u0015\t\u0001\"\u0003\r\n#\u000e9A!D\u0005\u0002\t\u0001i\u0011\u0001c\u0005\u000e\u0003!a\u0001lA\u0006"})
public final class NamingUtilsKt {
    public static final void aliasArgumentsIfNeeded(@NotNull NamingContext context, @NotNull List<? extends JsExpression> arguments2, @NotNull List<? extends JsParameter> parameters2) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        TestAssertionsKt.assertTrue$default(null, new Function0<Boolean>(arguments2, parameters2){
            final /* synthetic */ List $arguments;
            final /* synthetic */ List $parameters;

            public final boolean invoke() {
                return this.$arguments.size() <= this.$parameters.size();
            }
            {
                this.$arguments = list;
                this.$parameters = list2;
                super(0);
            }
        }, 1);
        for (Pair pair : CollectionsKt.zip((Iterable)arguments2, (Iterable)parameters2)) {
            JsExpression jsExpression;
            JsExpression arg = (JsExpression)pair.component1();
            JsParameter param = (JsParameter)pair.component2();
            JsName paramName = param.getName();
            if (SideEffectUtilsKt.needToAlias(arg)) {
                JsName jsName = paramName;
                Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
                JsName freshName = context.getFreshName(jsName);
                context.newVar(freshName, arg);
                JsExpression jsExpression2 = freshName.makeRef();
                jsExpression = jsExpression2;
                Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "freshName.makeRef()");
            } else {
                jsExpression = arg;
            }
            JsExpression replacement = jsExpression;
            JsName jsName = paramName;
            Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
            context.replaceName(jsName, replacement);
        }
        List<? extends JsParameter> defaultParams = parameters2.subList(arguments2.size(), parameters2.size());
        for (JsParameter jsParameter : defaultParams) {
            JsName paramName;
            JsName jsName = paramName = jsParameter.getName();
            Intrinsics.checkExpressionValueIsNotNull(jsName, "paramName");
            JsName freshName = context.getFreshName(jsName);
            NamingContext.newVar$default(context, freshName, null, 2);
            JsName jsName2 = paramName;
            Intrinsics.checkExpressionValueIsNotNull(jsName2, "paramName");
            JsExpression jsExpression = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "freshName.makeRef()");
            context.replaceName(jsName2, jsExpression);
        }
    }

    public static final void renameLocalNames(@NotNull NamingContext context, @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(function, "function");
        for (JsName name : CollectUtilsKt.collectLocalNames(function)) {
            JsName freshName = context.getFreshName(name);
            JsExpression jsExpression = freshName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsExpression, "freshName.makeRef()");
            context.replaceName(name, jsExpression);
        }
    }

    public static final void refreshLabelNames(@NotNull NamingContext context, @NotNull JsFunction function) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(function, "function");
        JsFunctionScope scope2 = function.getScope();
        if (!(scope2 instanceof JsFunctionScope)) {
            throw (Throwable)((Object)new AssertionError((Object)"JsFunction is expected to have JsFunctionScope"));
        }
        JsFunctionScope jsFunctionScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull(jsFunctionScope, "scope");
        LabelNameRefreshingVisitor visitor2 = new LabelNameRefreshingVisitor(context, jsFunctionScope);
        visitor2.accept((JsNode)function.getBody());
        context.applyRenameTo(function);
    }
}

