/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoKt;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallCasesKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u0013\b)\t3m\\7qkR,W\t\u001f9mS\u000eLGOU3dK&4XM]:G_JLeN^8lK*91m\u001c8uKb$(B\u0005+sC:\u001cH.\u0019;j_:\u001cuN\u001c;fqRT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0003UNT\u0011\u0002\u001e:b]Nd\u0017\r^3\u000b\u0019I,7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b\u0019I+7o\u001c7wK\u0012\u001c\u0015\r\u001c7\u000b\u000fI,7o\u001c7wK*)1-\u00197mg*)Qn\u001c3fY*\u0011b)\u001e8di&|g\u000eR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b#\u0015D\b\u000f\\5dSR\u0014VmY3jm\u0016\u00148OC\tFqBd\u0017nY5u%\u0016\u001cW-\u001b<feNTabY1mYR\u0013\u0018M\\:mCR|'O\u0003\tDC2dGK]1og2\fGo\u001c:Li*iAO]1og2\fG/Z\"bY2TABS:FqB\u0014Xm]:j_:T1aY8n\u0015\u00199wn\\4mK*!A-\u0019:u\u0015!\u0019w.\u001c9jY\u0016\u0014(b\u00022bG.,g\u000e\u001a\u0006\u0004CN$(\"\u0006;sC:\u001cH.\u0019;f\rVt7\r^5p]\u000e\u000bG\u000e\u001c\u0006\u0013\u0007\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'OC\tfqB,7\r^3e%\u0016\u001cW-\u001b<feNTqAQ8pY\u0016\fg\u000ep\u0001\u000b\u0005A\u0019!\u0002\u0002\u0005\u0001!\u0011QA\u0001C\u0001\u0011\u000b)!\u0001B\u0001\t\u0007\u0015\u0011A1\u0001E\u0004\u000b\t!!\u0001#\u0001\u0006\u0007\u0011\u0015\u0001\"\u0001\u0007\u0001\u000b\t!\u0011\u0001C\u0003\u0006\u0005\u0011\u001d\u00012B\u0003\u0003\t\u0011Aa!B\u0002\u0005\n!%A\u0002A\u0003\u0003\t\u0005Aq!B\u0002\u0005\f!5A\u0002A\u0003\u0003\t\tA\t\"B\u0002\u0005\u000e!AA\u0002A\u0003\u0003\t\u001bA\u0001\"\u0002\u0002\u0005\u0006!\tQA\u0001C\u0005\u0011\u0013)\u0011\u0001#\u0006\u0006\u0005\u0011I\u0001bC\u0003\u0003\t'A9\"\u0002\u0002\u0005\u0015!aQA\u0001C\u000b\u00113)!\u0001B\u0006\t\u0007\u0015\u0011Aq\u0003\u0005\u000e\u000b\r!A\u0002\u0003\u0006\r\u0001\u0015\u0011A\u0001\u0004\u0005\u000b\u000b\r!Y\u0001\u0003\b\r\u0001\u0015\t\u0001RA\u0003\u0004\t9Aq\u0002\u0004\u0001\u0006d\u0011\u0019\u0001\u0004AO\b\t\u0001A\t!D\u0002\u0006\u0003!\u0019\u0001d\u0001)\u0004\u0001umA\u0001\u0001\u0005\u0005\u001b%)\u0011\u0001C\u0003\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0019Ab\u0001G\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u00105\u0019Q!\u0001\u0005\b1\u001d\u00016!A\u0011\u0004\u000b\u0005Aq\u0001G\u0004R\u0007%!\u0001!C\u0001\t\u00105\t\u0001\u0002C\u0007\u0002\u0011#i\u0011\u0001c\u0004Y\u0007%)\u0019\u0007B\u0001\u0019\u0014u=A\u0001\u0001E\u0001\u001b\r)\u0011\u0001C\u0002\u0019\u0007A\u001b\u0001!h\u0007\u0005\u0001!!Q\"C\u0003\u0002\u0011\u0015IQ\u0001\"\u0001\n\u0007\u0015\t\u0001B\u0002\r\u00071\u0015\u00016\u0011AO\b\t\u0001Ay!D\u0002\u0006\u0003!9\u0001d\u0002)\u0004\u0003\u0005\u001aQ!\u0001E\r13\t6!\u0003C\n\u0013\u0005AQ\"D\u0001\t\u00115\t\u0001\u0012C\u0007\u0002\u0011\u001fA6!CC2\t\u0005AZ\"h\u0004\u0005\u0001!\u0005QbA\u0003\u0002\u0011\rA2\u0001U\u0002\u0001;7!\u0001\u0001\u0003\u0003\u000e\u0013\u0015\t\u0001\"B\u0005\u0006\t\u0003I1!B\u0001\t\ra1\u0001$\u0002)\u0004\u0002u=A\u0001\u0001E\b\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0011!I\u0002\u0006\u0003!e\u0001\u0014D)\u0004\u0013\u0011m\u0011\"\u0001\u0005\u000e\u001b\u0005A\u0001\"D\u0001\t\u00125\t\u0001r\u0002-\u0004\u0013\u0015AB!A\u000b\n\u000b\u0005AQ!C\u0003\u0005\u0002%\u0019Q!\u0001E\u000e17AR\u0001'\b\"\u0007\u0015\t\u0001R\u0004M\u000f#\u000e)AQD\u0005\u0002\t\u0003i\u0011\u0001#\u0005Y\u0007%\u0001"})
public final class CallTranslatorKt {
    public static final boolean expectedReceivers(ResolvedCall<? extends CallableDescriptor> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Intrinsics.areEqual((Object)$receiver.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) ^ true;
    }

    @NotNull
    public static final JsExpression translateCall(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @NotNull ExplicitReceivers explicitReceivers) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            PreconditionsKt.assert(explicitReceivers.getExtensionReceiver() == null, "VariableAsFunctionResolvedCall must have one receiver");
            ResolvedCall<VariableDescriptor> variableCall = ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getVariableCall();
            if (CallTranslatorKt.expectedReceivers(variableCall)) {
                JsExpression newReceiver = CallTranslator.INSTANCE$.translateGet(context, variableCall, explicitReceivers.getExtensionOrDispatchReceiver());
                return CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(newReceiver, null, 2, null));
            }
            JsExpression dispatchReceiver = CallTranslator.INSTANCE$.translateGet(context, variableCall, null);
            if (explicitReceivers.getExtensionOrDispatchReceiver() == null) {
                return CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(dispatchReceiver, null, 2, null));
            }
            return CallTranslatorKt.translateFunctionCall(context, ((VariableAsFunctionResolvedCall)((Object)resolvedCall)).getFunctionCall(), new ExplicitReceivers(dispatchReceiver, explicitReceivers.getExtensionOrDispatchReceiver()));
        }
        Call call = resolvedCall.getCall();
        if (Intrinsics.areEqual((Object)call.getCallType(), (Object)Call.CallType.INVOKE)) {
            Call call2 = call;
            Intrinsics.checkExpressionValueIsNotNull(call2, "call");
            if (!CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
                ExplicitReceivers explicitReceiversForInvoke = CallTranslatorKt.computeExplicitReceiversForInvoke(context, resolvedCall, explicitReceivers);
                return CallTranslatorKt.translateFunctionCall(context, resolvedCall, explicitReceiversForInvoke);
            }
        }
        return CallTranslatorKt.translateFunctionCall(context, resolvedCall, explicitReceivers);
    }

    @NotNull
    public static final JsExpression translateFunctionCall(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @NotNull ExplicitReceivers explicitReceivers) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        return FunctionCallCasesKt.translateFunctionCall(CallInfoKt.getCallInfo(context, resolvedCall, explicitReceivers));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ExplicitReceivers computeExplicitReceiversForInvoke(@NotNull TranslationContext context, @NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall, @NotNull ExplicitReceivers explicitReceivers) {
        ExplicitReceivers explicitReceivers2;
        boolean value;
        void value2;
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(explicitReceivers, "explicitReceivers");
        JetElement callElement = resolvedCall.getCall().getCallElement();
        boolean bl = explicitReceivers.getExtensionReceiver() == null;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
            String message = "'Invoke' call must have one receiver: " + callElement;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        Function1<ReceiverValue, JsExpression> translateReceiverAsExpression$ = new Function1<ReceiverValue, JsExpression>(context){
            final /* synthetic */ TranslationContext $context;

            @Nullable
            public final JsExpression invoke(@NotNull ReceiverValue receiver) {
                JsExpression jsExpression;
                Intrinsics.checkParameterIsNotNull(receiver, "receiver");
                ReceiverValue receiverValue = receiver;
                if (!(receiverValue instanceof ExpressionReceiver)) {
                    receiverValue = null;
                }
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
                if (expressionReceiver != null) {
                    ExpressionReceiver $receiver = expressionReceiver;
                    ExpressionReceiver it = $receiver;
                    jsExpression = Translation.translateAsExpression(it.getExpression(), this.$context);
                } else {
                    jsExpression = null;
                }
                return jsExpression;
            }
            {
                this.$context = translationContext;
                super(1);
            }
        };
        ReceiverValue dispatchReceiver = resolvedCall.getDispatchReceiver();
        ReceiverValue extensionReceiver2 = resolvedCall.getExtensionReceiver();
        if (dispatchReceiver.exists() && extensionReceiver2.exists() && Intrinsics.areEqual((Object)resolvedCall.getExplicitReceiverKind(), (Object)ExplicitReceiverKind.BOTH_RECEIVERS)) {
            boolean bl2 = explicitReceivers.getExtensionOrDispatchReceiver() != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
                String message = "No explicit receiver for 'invoke' resolved call with both receivers: " + callElement + ", text: " + callElement.getText() + ("Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver2);
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
        } else {
            value = explicitReceivers.getExtensionOrDispatchReceiver() == null;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && !value) {
                String message = "Non trivial explicit receiver " + explicitReceivers.getExtensionOrDispatchReceiver() + "\n" + ("for 'invoke' resolved call: " + callElement + ", text: " + callElement.getText() + "\n") + ("Dispatch receiver: " + dispatchReceiver + " Extension receiver: " + extensionReceiver2);
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
        }
        ReceiverValue receiverValue = dispatchReceiver;
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "dispatchReceiver");
        JsExpression dispatchReceiverExpression = translateReceiverAsExpression$.invoke(receiverValue);
        Pair<Boolean, Boolean> pair = new Pair<Boolean, Boolean>(dispatchReceiver.exists(), extensionReceiver2.exists());
        if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, true))) {
            explicitReceivers2 = new ExplicitReceivers(dispatchReceiverExpression, explicitReceivers.getExtensionOrDispatchReceiver());
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(true, false))) {
            explicitReceivers2 = new ExplicitReceivers(dispatchReceiverExpression, null, 2, null);
        } else if (Intrinsics.areEqual(pair, new Pair<Boolean, Boolean>(false, true))) {
            ReceiverValue receiverValue2 = extensionReceiver2;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "extensionReceiver");
            explicitReceivers2 = new ExplicitReceivers(translateReceiverAsExpression$.invoke(receiverValue2), null, 2, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("'Invoke' resolved call without receivers: " + callElement)));
        }
        return explicitReceivers2;
    }
}

