/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.JetExpression;

public class AliasingContext {
    @Nullable
    private Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors;
    @Nullable
    private final Map<JetExpression, JsExpression> aliasesForExpressions;
    @Nullable
    private final AliasingContext parent;

    public static AliasingContext getCleanContext() {
        return new AliasingContext(null, null, null);
    }

    private AliasingContext(@Nullable AliasingContext parent, @Nullable Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors, @Nullable Map<JetExpression, JsExpression> aliasesForExpressions) {
        this.parent = parent;
        this.aliasesForDescriptors = aliasesForDescriptors;
        this.aliasesForExpressions = aliasesForExpressions;
    }

    @NotNull
    public AliasingContext inner() {
        AliasingContext aliasingContext = new AliasingContext(this, null, null);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "inner"));
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext inner(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "inner"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "inner"));
        }
        AliasingContext aliasingContext = new AliasingContext(this, Collections.singletonMap(descriptor, alias), null);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "inner"));
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext withExpressionsAliased(@NotNull Map<JetExpression, JsExpression> aliasesForExpressions) {
        if (aliasesForExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasesForExpressions", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "withExpressionsAliased"));
        }
        AliasingContext aliasingContext = new AliasingContext(this, null, aliasesForExpressions);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "withExpressionsAliased"));
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext withDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "withDescriptorsAliased"));
        }
        AliasingContext aliasingContext = new AliasingContext(this, aliases, null);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "withDescriptorsAliased"));
        }
        return aliasingContext;
    }

    @Nullable
    public final JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "getAliasForDescriptor"));
        }
        return this.getAliasForDescriptor(descriptor, false);
    }

    @Nullable
    protected JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor, boolean fromChild) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "getAliasForDescriptor"));
        }
        JsExpression alias = this.aliasesForDescriptors == null ? null : this.aliasesForDescriptors.get(descriptor.getOriginal());
        return alias != null || this.parent == null ? alias : this.parent.getAliasForDescriptor(descriptor, true);
    }

    @Nullable
    public JsExpression getAliasForExpression(@NotNull JetExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "getAliasForExpression"));
        }
        JsExpression alias = this.aliasesForExpressions == null ? null : this.aliasesForExpressions.get(element);
        return alias != null || this.parent == null ? alias : this.parent.getAliasForExpression(element);
    }

    public void registerAlias(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "registerAlias"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "registerAlias"));
        }
        if (this.aliasesForDescriptors == null) {
            this.aliasesForDescriptors = Collections.singletonMap(descriptor, alias);
        } else {
            if (this.aliasesForDescriptors.size() == 1) {
                Map<DeclarationDescriptor, JsExpression> singletonMap = this.aliasesForDescriptors;
                this.aliasesForDescriptors = new THashMap<DeclarationDescriptor, JsExpression>();
                this.aliasesForDescriptors.put(singletonMap.keySet().iterator().next(), singletonMap.values().iterator().next());
            }
            JsExpression prev = this.aliasesForDescriptors.put(descriptor, alias);
            assert (prev == null) : "Alias for descriptor already registered. Descriptor: " + descriptor + " prev alias: " + prev + " new alias: " + alias;
        }
    }
}

