/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsCatch;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import java.util.Iterator;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.JetCatchClause;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.JetType;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u001b\b)y1)\u0019;dQR\u0013\u0018M\\:mCR|'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\tQ7OC\u0005ue\u0006t7\u000f\\1uK*QQ\r\u001f9sKN\u001c\u0018n\u001c8\u000b%\u0005\u00137\u000f\u001e:bGR$&/\u00198tY\u0006$xN\u001d\u0006\bO\u0016tWM]1m\u0015\u0019a\u0014N\\5u})91-\u0019;dQ\u0016\u001c(\u0002\u0002'jgRTaBS3u\u0007\u0006$8\r[\"mCV\u001cXMC\u0002qg&TqaY8oi\u0016DHO\u0003\nUe\u0006t7\u000f\\1uS>t7i\u001c8uKb$(\u0002\u00026bm\u0006TA!\u001e;jY*Qq-\u001a;DCR\u001c\u0007.Z:\u000b!)+G\u000fV=qKJ+g-\u001a:f]\u000e,'bC5t)\"\u0014xn^1cY\u0016TqAQ8pY\u0016\fgN\u0003\bhKRL5\u000f\u00165s_^\f'\r\\3\u000b\u000f)\u001b8)\u0019;dQ*\u00191m\\7\u000b\r\u001d|wn\u001a7f\u0015\u0011!\u0017M\u001d;\u000b\u0011\r|W\u000e]5mKJTqAY1dW\u0016tGMC\u0002bgRT!\u0003\u001e:b]Nd\u0017\r^3DCR\u001c\u0007NQ8es*Y1-\u0019;dQ\u000ec\u0017-^:f\u0015\u001dQ5O\u00117pG.T\u0001\u0003\u001e:b]Nd\u0017\r^3DCR\u001c\u0007.Z:\u000b\u0019A\f'/Y7fi\u0016\u0014(+\u001a4\u000b\u0013)\u001bh*Y7f%\u00164'\u0002C%uKJ\fGo\u001c:\u000b\u0017)\u001b8\u000b^1uK6,g\u000e\u001eA\u0003\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\u0011AA\u0001\u0005\u0005\u000b\r!9\u0001c\u0002\r\u0001\u0015\t\u00012A\u0003\u0004\t\u0013AY\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001RB\u0003\u0004\t\u0017Aa\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001bB\u0003\u0004\t\u001bAy\u0001\u0004\u0001\u0006\u0003!AQA\u0001C\b\u0011#)!\u0001\u0002\u0005\t\f\u0015\u0011AQ\u0002E\b\u000b\r!Y\u0001c\u0005\r\u0001\u0015\u0019A\u0011\u0002E\u000b\u0019\u0001)!\u0001b\u0003\t\u0014\u0015\t\u0001\u0002D\u0003\u0003\t-AI\"\u0002\u0002\u0005\u0018!iQA\u0001\u0003\r\u00117)!\u0001\"\u0007\t\u001d\u0015\u0011A!\u0004\u0005\u0003\u000b\t!Y\u0002#\b\u0006\u0007\u0011q\u0001r\u0003\u0007\u0001\u000b\t!a\u0002c\u0006\u0006\u0007\u0011q\u0001\u0002\u0005\u0007\u0001\u000b\t!a\u0002\u0003\t\u0006\u0005\u0011-\u0001BB\u0003\u0004\t9A\u0019\u0003\u0004\u0001\u0006\u0007\u0011%\u0001B\u0005\u0007\u0001\u000b\r!a\u0002#\n\r\u0001\u0015\u0011AA\u0004E\u0013\u000b\t!a\u0002c\t\u0006\u0005\u0011A\u0001B\u0005\u0003\u0004\u0019\rI2!B\u0001\t\ta!Q&\u0006\u0003d\ta)\u0011\u0005C\u0003\u0002\u0011\u0015IA!C\u0002\u0006\u0003!1\u0001D\u0002\r\u0006+\u000eAQa\u0001\u0003\u0006\u0013\u0005A\t\"D\u0002\u0005\u0013%\t\u0001\u0012C\u0017\u0014\t\u0005$QcA\u0003\u0002\u0011'A\u001a\u0002\u0007\u0006\"\u0007\u0015\t\u0001B\u0003\r\u000bI\u0005*6AB\u0007\u0006\t-I\u0011\u0001\"\u0001\u000e\u0003!UQv\u0003\u0003\u00041\u000b\tC!B\u0001\t\u001e1\u0005\u0001TD)\u0004\u0007\u0011\u0015\u0011\"\u0001\u0005\u0010[\u007f!\u0011\u0001G\b\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t 5\u0019Q!\u0001\u0005\u00071\u0019\u00016\u0011A\u0011\u0004\u000b\u0005Ay\u0002g\bR\u0007\u001d!q\"C\u0001\t!5\t\u0001\"C\u0007\u0002\u0011CiK\u0005B\u0001\u0019\"u=A\u0001\u0001\u0005\u0012\u001b\r)\u0011\u0001C\t\u0019#A\u001b\u0001!(\u0007\u0005\u0001!)Q\u0002C\u0003\u0002\u0011GIA!C\u0002\u0006\u0003!1\u0001D\u0002M\u0012!\u000e\u0005\u0011eA\u0003\u0002\u0011IA\"#U\u0002\b\tCI\u0011\u0001#\n\u000e\u0003!\u0019R\"\u0001E\u0014k\u0019*Q\u0005Br\u00011\u0013iJ\u0002\u0002\u0001\t\u000b5AQ!\u0001\u0005\u0006\u0013\u0011I1!B\u0001\t\ra1\u0001$\u0002)\u0004\u0001u=A\u0001\u0001\u0005\b\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\t!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u000f\u0011%\u0011\"\u0001\u0003\u0001\u001b\u0005A\t\"D\u0001\t\u0013\u0001"})
public final class CatchTranslator
extends AbstractTranslator {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final List<? extends JetCatchClause> catches;

    static {
        $kotlinClass = Reflection.createKotlinClass(CatchTranslator.class);
    }

    @Nullable
    public final JsCatch translate() {
        if (this.catches.isEmpty()) {
            return null;
        }
        JetCatchClause firstCatch = CollectionsKt.first(this.catches);
        JetParameter catchParameter = firstCatch.getCatchParameter();
        TranslationContext translationContext = this.context();
        JetParameter jetParameter = catchParameter;
        if (jetParameter == null) {
            Intrinsics.throwNpe();
        }
        JsName parameterName = translationContext.getNameForElement(jetParameter);
        JsNameRef parameterRef = parameterName.makeRef();
        JsScope jsScope = this.context().scope();
        String string = parameterRef.getIdent();
        JsNameRef jsNameRef = parameterRef;
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "parameterRef");
        return new JsCatch(jsScope, string, this.translateCatches(jsNameRef, this.catches.iterator()));
    }

    /*
     * WARNING - void declaration
     */
    private final JsStatement translateCatches(JsNameRef parameterRef, Iterator<? extends JetCatchClause> catches) {
        void receiver;
        if (!catches.hasNext()) {
            return new JsThrow(parameterRef);
        }
        JetCatchClause jetCatchClause = catches.next();
        JetParameter jetParameter = jetCatchClause.getCatchParameter();
        if (jetParameter == null) {
            Intrinsics.throwNpe();
        }
        JetParameter param = jetParameter;
        JsName paramName = this.context().getNameForElement(param);
        JetTypeReference jetTypeReference = param.getTypeReference();
        if (jetTypeReference == null) {
            Intrinsics.throwNpe();
        }
        JetTypeReference paramType = jetTypeReference;
        TranslationContext translationContext = this.context();
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "context()");
        JsBlock thenBlock = this.translateCatchBody(translationContext, jetCatchClause);
        if (Intrinsics.areEqual(paramName.getIdent(), parameterRef.getIdent()) ^ true) {
            thenBlock.getStatements().add(0, JsAstUtils.newVar(paramName, parameterRef));
        }
        if (this.getIsThrowable(paramType)) {
            return thenBlock;
        }
        PatternTranslator patternTranslator = Translation.patternTranslator(this.context());
        PatternTranslator $receiver = (PatternTranslator)receiver;
        JsExpression typeCheck = $receiver.translateIsCheck(parameterRef, paramType);
        JsStatement elseBlock = this.translateCatches(parameterRef, catches);
        return new JsIf(typeCheck, thenBlock, elseBlock);
    }

    private final JsBlock translateCatchBody(TranslationContext context, JetCatchClause catchClause) {
        JetExpression catchBody = catchClause.getCatchBody();
        JsStatement jsCatchBody = catchBody != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(catchBody, context) : context.getEmptyExpression().makeStmt();
        JsBlock jsBlock = JsAstUtils.convertToBlock(jsCatchBody);
        Intrinsics.checkExpressionValueIsNotNull(jsBlock, "convertToBlock(jsCatchBody)");
        return jsBlock;
    }

    private final boolean getIsThrowable(JetTypeReference $receiver) {
        JetType jetType = (JetType)BindingContextUtils.getNotNull(this.bindingContext(), BindingContext.TYPE, $receiver);
        String jetTypeName = DescriptorUtilsKt.getJetTypeFqName(jetType, false);
        ClassDescriptor throwable = KotlinBuiltIns.getInstance().getThrowable();
        String throwableClassName = DescriptorUtils.getFqNameSafe(throwable).asString();
        return Intrinsics.areEqual(jetTypeName, throwableClassName);
    }

    @NotNull
    public final List<JetCatchClause> getCatches() {
        return this.catches;
    }

    public CatchTranslator(@NotNull List<? extends JetCatchClause> catches, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(catches, "catches");
        Intrinsics.checkParameterIsNotNull(context, "context");
        super(context);
        this.catches = catches;
    }
}

