/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.general;

import com.google.common.collect.Lists;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;

public class JetTestFunctionDetector {
    private JetTestFunctionDetector() {
    }

    private static boolean isTest(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector", "isTest"));
        }
        Annotations annotations2 = functionDescriptor.getAnnotations();
        for (AnnotationDescriptor annotation2 : annotations2) {
            JetType type2 = annotation2.getType();
            String name = type2.toString();
            if (!name.equals("Test")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<FunctionDescriptor> getTestFunctionDescriptors(@NotNull BindingContext bindingContext, @NotNull Collection<JetFile> files) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector", "getTestFunctionDescriptors"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector", "getTestFunctionDescriptors"));
        }
        ArrayList<FunctionDescriptor> answer = Lists.newArrayList();
        for (JetFile file : files) {
            answer.addAll(JetTestFunctionDetector.getTestFunctions(bindingContext, file.getDeclarations()));
        }
        ArrayList<FunctionDescriptor> arrayList = answer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector", "getTestFunctionDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    private static List<FunctionDescriptor> getTestFunctions(@NotNull BindingContext bindingContext, @NotNull List<JetDeclaration> declarations) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector", "getTestFunctions"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector", "getTestFunctions"));
        }
        ArrayList<FunctionDescriptor> answer = Lists.newArrayList();
        for (JetDeclaration declaration : declarations) {
            JetClass klass;
            ClassDescriptor classDescriptor;
            JetScope scope2 = null;
            if (declaration instanceof JetClass && (classDescriptor = BindingUtils.getClassDescriptor(bindingContext, klass = (JetClass)declaration)).getModality() != Modality.ABSTRACT) {
                scope2 = classDescriptor.getDefaultType().getMemberScope();
            }
            if (scope2 == null) continue;
            Collection<DeclarationDescriptor> allDescriptors2 = scope2.getAllDescriptors();
            List<FunctionDescriptor> testFunctions = ContainerUtil.mapNotNull(allDescriptors2, new Function<DeclarationDescriptor, FunctionDescriptor>(){

                @Override
                public FunctionDescriptor fun(DeclarationDescriptor descriptor) {
                    FunctionDescriptor functionDescriptor;
                    if (descriptor instanceof FunctionDescriptor && JetTestFunctionDetector.isTest(functionDescriptor = (FunctionDescriptor)descriptor)) {
                        return functionDescriptor;
                    }
                    return null;
                }
            });
            answer.addAll(testFunctions);
        }
        ArrayList<FunctionDescriptor> arrayList = answer;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/general/JetTestFunctionDetector", "getTestFunctions"));
        }
        return arrayList;
    }
}

