/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPropertyDelegate;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"_\u0006)!2i\u001c8ti6{G-\u001b4jKJ\u001c\u0005.Z2lKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015I!Um\u00197be\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u000b\u000b\rDWmY6\u000b\u0017\u0011,7\r\\1sCRLwN\u001c\u0006\u000f\u0015\u0016$H)Z2mCJ\fG/[8o\u0015\r\u00018/\u001b\u0006\u000bI\u0016\u001c8M]5qi>\u0014(\"\u0006#fG2\f'/\u0019;j_:$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148O\u0003\teS\u0006<gn\\:uS\u000eDu\u000e\u001c3fe*qA)[1h]>\u001cH/[2TS:\\'b\u00033jC\u001etwn\u001d;jGNTaBY5oI&twmQ8oi\u0016DHO\u0003\bCS:$\u0017N\\4D_:$X\r\u001f;\u000b\tUs\u0017\u000e\u001e\u0006\u0010G\",7m[\"b]\n+7i\u001c8ti*92m\u001c8ti6{G-\u001b4jKJ\u00046/[#mK6,g\u000e\u001e\u0006\u000b!NLW\t\\3nK:$(bA2p[*A\u0011N\u001c;fY2L'N\u0003\nWCJL\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(B\u0003#jC\u001etwn\u001d;jGZ\u000e!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0004\t\u0007A\u0001\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001R\u0001\u0007\u0001\u000b\t!\u0011\u0001#\u0003\u0006\u0007\u0011\u0019\u0001\u0002\u0002\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0004\u0006\u0007\u0011!\u00012\u0002\u0007\u0001\u000b\t!\u0011\u0001c\u0004\u0006\u0007\u0011)\u0001b\u0002\u0007\u0001\u000b\r!\u0019\u0001#\u0005\r\u0001\u0015\t\u00012A\u0003\u0004\t\u001bA\u0011\u0002\u0004\u0001\u0006\u0005\u0011\u0019\u0001\u0002B\u0003\u0003\t\u0011AY!\u0002\u0002\u0005\u000b!9QA\u0001C\u0002\u0011#)\u0011\u0001C\u0006\u0006\u0005\u0011M\u0001rC\u0003\u0003\t)AI!B\u0002\u0005\u0016!UA\u0002A\u0003\u0004\t\u0011AA\u0002\u0004\u0001\u0006\u0007\u0011)\u0001\u0012\u0004\u0007\u0001\u000b\t!Q\u0001#\u0007\u0006\u0005\u0011U\u0001RC\u0003\u0003\t\u0011AA\u0002B2\u0002\u0019\tI2!B\u0001\t\u0006a\u0015Q\u0016\u000e\u0003\f1\riz\u0001\u0002\u0001\t\b5\u0019Q!\u0001E\u00041\u000f\u00016\u0001AO\b\t\u0001AQ!D\u0002\u0006\u0003!%\u0001\u0014\u0002)\u0004\u0002u=A\u0001\u0001E\u0007\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0011!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011\u0019Ab\u0001UB\u0002C\r)\u0011\u0001C\u0004\u0019\u000fE\u001b1\u0002B\u0002\n\u0003\u0011\u0001Q\"\u0001E\b\u001b\u0005A\u0001\"D\u0001\t\u00125\t\u0001\"C\u0017,\t\rA\u001a\"h\u0004\u0005\u0001!\u001dQbA\u0003\u0002\u0011\u000fA:\u0001U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0006\u000e\u0007\u0015\t\u0001b\u0003\r\f!\u000e\u0005Qt\u0002\u0003\u0001\u0011\u0015i1!B\u0001\t\u0018a]\u0001kA\u0001\"\t\u0015\t\u0001\u0002\u0004G\u000111\t6!\u0003C\n\u0013\u0005AI\"D\u0001\t\u00105\t\u0001\"D\u0007\u0002\u00117)\u0004\u0001"})
public final class ConstModifierChecker
implements DeclarationChecker {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final ConstModifierChecker INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(ConstModifierChecker.class);
        new ConstModifierChecker();
    }

    @Override
    public void check(@NotNull JetDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        PsiElement constModifierPsiElement;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        if (!(descriptor instanceof VariableDescriptor) || !declaration.hasModifier(JetTokens.CONST_KEYWORD)) {
            return;
        }
        JetModifierList jetModifierList = declaration.getModifierList();
        if (jetModifierList == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement = jetModifierList.getModifier(JetTokens.CONST_KEYWORD);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement2 = constModifierPsiElement = psiElement;
        Intrinsics.checkExpressionValueIsNotNull(psiElement2, "constModifierPsiElement");
        Diagnostic diagnostic = this.checkCanBeConst(declaration, psiElement2, (VariableDescriptor)descriptor);
        if (diagnostic != null) {
            diagnosticHolder.report(diagnostic);
        }
    }

    @Nullable
    public final Diagnostic checkCanBeConst(@NotNull JetDeclaration declaration, @NotNull PsiElement constModifierPsiElement, @NotNull VariableDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(constModifierPsiElement, "constModifierPsiElement");
        Intrinsics.checkParameterIsNotNull(descriptor, "descriptor");
        if (descriptor.isVar()) {
            return Errors.WRONG_MODIFIER_TARGET.on(constModifierPsiElement, JetTokens.CONST_KEYWORD, "vars");
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor && Intrinsics.areEqual((Object)((ClassDescriptor)containingDeclaration).getKind(), (Object)ClassKind.OBJECT) ^ true) {
            return Errors.CONST_VAL_NOT_TOP_LEVEL_OR_OBJECT.on(constModifierPsiElement);
        }
        if (!(declaration instanceof JetProperty) || !(descriptor instanceof PropertyDescriptor)) {
            return null;
        }
        if (((JetProperty)declaration).hasDelegate()) {
            JetPropertyDelegate jetPropertyDelegate = ((JetProperty)declaration).getDelegate();
            if (jetPropertyDelegate == null) {
                Intrinsics.throwNpe();
            }
            return Errors.CONST_VAL_WITH_DELEGATE.on(jetPropertyDelegate);
        }
        if (descriptor instanceof PropertyDescriptor) {
            PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor).getGetter();
            if (propertyGetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            if (!propertyGetterDescriptor.isDefault()) {
                JetPropertyAccessor jetPropertyAccessor = ((JetProperty)declaration).getGetter();
                if (jetPropertyAccessor == null) {
                    Intrinsics.throwNpe();
                }
                return Errors.CONST_VAL_WITH_GETTER.on(jetPropertyAccessor);
            }
        }
        if (!ConstUtilKt.canBeUsedForConstVal(((PropertyDescriptor)descriptor).getType())) {
            return Errors.TYPE_CANT_BE_USED_FOR_CONST_VAL.on(constModifierPsiElement, ((PropertyDescriptor)descriptor).getType());
        }
        if (((JetProperty)declaration).getInitializer() == null) {
            return Errors.CONST_VAL_WITHOUT_INITIALIZER.on(constModifierPsiElement);
        }
        if (((PropertyDescriptor)descriptor).getCompileTimeInitializer() == null) {
            JetExpression jetExpression = ((JetProperty)declaration).getInitializer();
            if (jetExpression == null) {
                Intrinsics.throwNpe();
            }
            return Errors.CONST_VAL_WITH_NON_CONST_INITIALIZER.on((JetExpression)((PsiElement)jetExpression));
        }
        return null;
    }

    ConstModifierChecker() {
        INSTANCE$ = this;
    }
}

