/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

class InlineChecker
implements CallChecker {
    private final SimpleFunctionDescriptor descriptor;
    private final Set<CallableDescriptor> inlinableParameters;
    private final boolean isEffectivelyPublicApiFunction;

    public InlineChecker(@NotNull SimpleFunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "<init>"));
        }
        this.inlinableParameters = new LinkedHashSet<CallableDescriptor>();
        assert (InlineUtil.isInline(descriptor)) : "This extension should be created only for inline functions: " + descriptor;
        this.descriptor = descriptor;
        this.isEffectivelyPublicApiFunction = DescriptorUtilPackage.getIsEffectivelyPublicApi(descriptor);
        for (ValueParameterDescriptor param : descriptor.getValueParameters()) {
            if (!InlineChecker.isInlinableParameter(param)) continue;
            this.inlinableParameters.add(param);
        }
        ReceiverParameterDescriptor receiverParameter = descriptor.getExtensionReceiverParameter();
        if (receiverParameter != null && InlineChecker.isInlinableParameter(receiverParameter)) {
            this.inlinableParameters.add(receiverParameter);
        }
    }

    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "check"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "check"));
        }
        JetExpression expression = context.call.getCalleeExpression();
        if (expression == null) {
            return;
        }
        F targetDescriptor = resolvedCall.getResultingDescriptor();
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall.getDispatchReceiver(), expression);
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall.getExtensionReceiver(), expression);
        if (this.inlinableParameters.contains(targetDescriptor) && !InlineChecker.isInsideCall(expression)) {
            context.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(expression, expression, this.descriptor));
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall.getValueArguments().entrySet()) {
            ResolvedValueArgument value = entry.getValue();
            ValueParameterDescriptor valueDescriptor = entry.getKey();
            if (value instanceof DefaultValueArgument) continue;
            for (ValueArgument argument : value.getArguments()) {
                this.checkValueParameter(context, (CallableDescriptor)targetDescriptor, argument, valueDescriptor);
            }
        }
        this.checkVisibility((CallableDescriptor)targetDescriptor, expression, context);
        this.checkRecursion(context, (CallableDescriptor)targetDescriptor, expression);
    }

    private static boolean isInsideCall(JetExpression expression) {
        JetToken token;
        JetExpression parent = JetPsiUtil.getParentCallIfPresent(expression);
        if (parent instanceof JetBinaryExpression && ((token = JetPsiUtil.getOperationToken((JetOperationExpression)parent)) == JetTokens.EQ || token == JetTokens.ANDAND || token == JetTokens.OROR)) {
            return false;
        }
        return parent != null;
    }

    private void checkValueParameter(@NotNull BasicCallResolutionContext context, @NotNull CallableDescriptor targetDescriptor, @NotNull ValueArgument targetArgument, @NotNull ValueParameterDescriptor targetParameterDescriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetArgument", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        if (targetParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkValueParameter"));
        }
        JetExpression argumentExpression = targetArgument.getArgumentExpression();
        if (argumentExpression == null) {
            return;
        }
        CallableDescriptor argumentCallee = InlineChecker.getCalleeDescriptor(context, argumentExpression, false);
        if (argumentCallee != null && this.inlinableParameters.contains(argumentCallee)) {
            if (InlineUtil.isInline(targetDescriptor) && InlineChecker.isInlinableParameter(targetParameterDescriptor)) {
                if (InlineUtil.allowsNonLocalReturns(argumentCallee) && !InlineUtil.allowsNonLocalReturns(targetParameterDescriptor)) {
                    context.trace.report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(argumentExpression, argumentExpression, argumentCallee, this.descriptor));
                } else {
                    this.checkNonLocalReturn(context, argumentCallee, argumentExpression);
                }
            } else {
                context.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(argumentExpression, argumentExpression, this.descriptor));
            }
        }
    }

    private void checkCallWithReceiver(@NotNull BasicCallResolutionContext context, @NotNull CallableDescriptor targetDescriptor, @NotNull ReceiverValue receiver, @Nullable JetExpression expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkCallWithReceiver"));
        }
        if (!receiver.exists()) {
            return;
        }
        CallableDescriptor varDescriptor = null;
        JetExpression receiverExpression = null;
        if (receiver instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = InlineChecker.getCalleeDescriptor(context, receiverExpression, true);
        } else if (receiver instanceof ExtensionReceiver) {
            ExtensionReceiver extensionReceiver2 = (ExtensionReceiver)receiver;
            CallableDescriptor extension = extensionReceiver2.getDeclarationDescriptor();
            varDescriptor = extension.getExtensionReceiverParameter();
            assert (varDescriptor != null) : "Extension should have receiverParameterDescriptor: " + extension;
            receiverExpression = expression;
        }
        if (this.inlinableParameters.contains(varDescriptor)) {
            this.checkLambdaInvokeOrExtensionCall(context, varDescriptor, targetDescriptor, receiverExpression);
        }
    }

    @Nullable
    private static CallableDescriptor getCalleeDescriptor(@NotNull BasicCallResolutionContext context, @NotNull JetExpression expression, boolean unwrapVariableAsFunction) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "getCalleeDescriptor"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "getCalleeDescriptor"));
        }
        if (!(expression instanceof JetSimpleNameExpression) && !(expression instanceof JetThisExpression)) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilPackage.getResolvedCall(expression, context.trace.getBindingContext());
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        return thisCall != null ? thisCall.getResultingDescriptor() : null;
    }

    private void checkLambdaInvokeOrExtensionCall(@NotNull BasicCallResolutionContext context, @NotNull CallableDescriptor lambdaDescriptor, @NotNull CallableDescriptor callDescriptor, @NotNull JetExpression receiverExpression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (lambdaDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (callDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        if (receiverExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverExpression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkLambdaInvokeOrExtensionCall"));
        }
        boolean inlinableCall = InlineChecker.isInvokeOrInlineExtension(callDescriptor);
        if (!inlinableCall) {
            context.trace.report(Errors.USAGE_IS_NOT_INLINABLE.on(receiverExpression, receiverExpression, this.descriptor));
        } else {
            this.checkNonLocalReturn(context, lambdaDescriptor, receiverExpression);
        }
    }

    public void checkRecursion(@NotNull BasicCallResolutionContext context, @NotNull CallableDescriptor targetDescriptor, @NotNull JetElement expression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (targetDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkRecursion"));
        }
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context.trace.report(Errors.RECURSION_IN_INLINE.on(expression, expression, this.descriptor));
        }
    }

    private static boolean isInlinableParameter(@NotNull ParameterDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isInlinableParameter"));
        }
        return InlineUtil.isInlineLambdaParameter(descriptor) && !descriptor.getType().isMarkedNullable();
    }

    private static boolean isInvokeOrInlineExtension(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isInvokeOrInlineExtension"));
        }
        if (!(descriptor instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        boolean isInvoke = descriptor.getName().equals(OperatorConventions.INVOKE) && containingDeclaration instanceof ClassDescriptor && KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(((ClassDescriptor)containingDeclaration).getDefaultType());
        return isInvoke || InlineUtil.isInline(descriptor);
    }

    private void checkVisibility(@NotNull CallableDescriptor declarationDescriptor, @NotNull JetElement expression, @NotNull BasicCallResolutionContext context) {
        boolean declarationDescriptorIsPublicApi;
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibility"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibility"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkVisibility"));
        }
        boolean bl = declarationDescriptorIsPublicApi = DescriptorUtilPackage.getIsEffectivelyPublicApi(declarationDescriptor) || this.isDefinedInInlineFunction(declarationDescriptor);
        if (this.isEffectivelyPublicApiFunction && !declarationDescriptorIsPublicApi && declarationDescriptor.getVisibility() != Visibilities.LOCAL) {
            context.trace.report(Errors.INVISIBLE_MEMBER_FROM_INLINE.on(expression, declarationDescriptor, this.descriptor));
        }
    }

    private boolean isDefinedInInlineFunction(@NotNull DeclarationDescriptorWithVisibility startDescriptor) {
        if (startDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "isDefinedInInlineFunction"));
        }
        DeclarationDescriptorWithVisibility parent = startDescriptor;
        while (parent != null) {
            if (parent.getContainingDeclaration() == this.descriptor) {
                return true;
            }
            parent = DescriptorUtils.getParentOfType(parent, DeclarationDescriptorWithVisibility.class);
        }
        return false;
    }

    private void checkNonLocalReturn(@NotNull BasicCallResolutionContext context, @NotNull CallableDescriptor inlinableParameterDescriptor, @NotNull JetExpression parameterUsage) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (inlinableParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlinableParameterDescriptor", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (parameterUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterUsage", "org/jetbrains/kotlin/resolve/calls/checkers/InlineChecker", "checkNonLocalReturn"));
        }
        if (!InlineUtil.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineUtil.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context.trace)) {
            context.trace.report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on(parameterUsage, parameterUsage, inlinableParameterDescriptor, this.descriptor));
        }
    }
}

