/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetClassLiteralExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0011 )\u00113i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_J4\u0016n]5u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015%\u0019wN\\:uC:$8O\u0003\u0005fm\u0006dW/\u0019;f\u0015)QU\r\u001e,jg&$xN\u001d\u0006\u0004aNL'bE\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$(b\u0002&fiRK\b/\u001a\u0006\u0006if\u0004Xm\u001d\u0006\u0007y%t\u0017\u000e\u001e \u000b7\r|gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0015m\u0019uN\\:uC:$X\t\u001f9sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;pe*)AO]1dK*a!)\u001b8eS:<GK]1dK*9a-Y2u_JL(\u0002F\"p]N$\u0018M\u001c;WC2,XMR1di>\u0014\u0018PC\rtiJLgnZ#yaJ,7o]5p]\u00163\u0018\r\\;bi>\u0014(BP\"p]N$\u0018M\u001c;FqB\u0014Xm]:j_:,e/\u00197vCR|'OV5tSR|'\u000fJ:ue&tw-\u0012=qe\u0016\u001c8/[8o\u000bZ\fG.^1u_J$\u0013GC\u000bdC:\u0014U-V:fI&s\u0017I\u001c8pi\u0006$\u0018n\u001c8\u000b\u0015\u0015D\bO]3tg&|gNC\u0007KKR,\u0005\u0010\u001d:fgNLwN\u001c\u0006\b\u0005>|G.Z1o\u0015e\u0019'/Z1uK\u000e{W\u000e]5mKRKW.Z\"p]N$\u0018M\u001c;\u000b\u000bY\fG.^3\u000b\u0007\u0005s\u0017P\u0003\u0006qCJ\fW.\u001a;feNT!\u0002U1sC6,G/\u001a:t\u00151)\u0007\u0010]3di\u0016$G+\u001f9f\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0007\u001f\nTWm\u0019;\u000b=\r{W\u000e]5mKRKW.Z\"p]N$\u0018M\u001c;%!\u0006\u0014\u0018-\\3uKJ\u001c(BD2sK\u0006$XmQ8ogR\fg\u000e\u001e\u0006!GJ,\u0017\r^3J]R,w-\u001a:D_6\u0004\u0018\u000e\\3US6,7i\u001c8ti\u0006tGO\u0003\u0003M_:<'bF2sK\u0006$Xm\u00149fe\u0006$\u0018n\u001c8Be\u001e,X.\u001a8u\u00159)\u0007\u0010\u001d:fgNLwN\u001c+za\u0016TqbY8na&dW\rV5nKRK\b/\u001a\u0006\u0010\u0007>l\u0007/\u001b7f)&lW\rV=qK*\tr\n]3sCRLwN\\!sOVlWM\u001c;\u000bi\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s-&\u001c\u0018\u000e^8sI=\u0003XM]1uS>t\u0017I]4v[\u0016tGO\u0003\u0015de\u0016\fG/Z(qKJ\fG/[8o\u0003J<W/\\3oi\u001a{'OR5sgR\u0004\u0016M]1nKR,'O\u0003\u0005be\u001e,X.\u001a8u\u0015U\u0011Vm]8mm\u0016$g+\u00197vK\u0006\u0013x-^7f]RTQaY1mYNTQ!\\8eK2T\u0011\u0002]1sC6,G/\u001a:\u000b1Y\u000bG.^3QCJ\fW.\u001a;fe\u0012+7o\u0019:jaR|'OC\u0006eKN\u001c'/\u001b9u_J\u001c(BI2sK\u0006$Xm\u00149fe\u0006$\u0018n\u001c8Be\u001e,X.\u001a8u\r>\u0014(+Z2fSZ,'O\u0003\u0007sKN|GN^3e\u0007\u0006dGN\u0003\u0007SKN|GN^3e\u0007\u0006dGN\u0003\ffm\u0006dW/\u0019;f\u0005&t\u0017M]=B]\u0012\u001c\u0005.Z2l\u0015!\u0011XmY3jm\u0016\u0014(\u0002\u00028b[\u0016Taa\u0015;sS:<'BD2bY2,\u0005\u0010\u001d:fgNLwN\u001c\u0006\rKZ\fG.^1uK\u000e\u000bG\u000e\u001c\u0006\u0013e\u0016\u001cW-\u001b<fe\u0016C\bO]3tg&|gNC\u000bfm\u0006dW/\u0019;f+:\f'/_!oI\u000eCWmY6\u000b!%\u001cH)\u001b<jg&|gNQ=[KJ|'\"H5t!J|\u0007/\u001a:us\u000e{W\u000e]5mKRKW.Z\"p]N$\u0018M\u001c;\u000b\u0015\u0011,7o\u0019:jaR|'O\u0003\nWCJL\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(BD5t!V\u0014XmQ8ogR\fg\u000e\u001e\u0006\u0011e\u0016\u001cx\u000e\u001c<f\u0003J<W/\\3oiNTaB^1mk\u0016\f%oZ;nK:$8O\u0003\u0003MSN$(\"\u0004,bYV,\u0017I]4v[\u0016tGO\u0003\u0003vi&d'\"G;tKNtuN\\\"p]N$h+\u00197Bg\u000e{gn\u001d;b]RTa#^:fgZ\u000b'/[1cY\u0016\f5oQ8ogR\fg\u000e\u001e\u0006\u0016m&\u001c\u0018\u000e\u001e\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0015MQU\r\u001e\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0015\u00012\u0018n]5u\u0005&t\u0017M]=XSRDG+\u001f9f%\"\u001bV\t\u001f9sKN\u001c\u0018n\u001c8\u000b=)+GOQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8XSRDG+\u001f9f%\"\u001b&b\u0005<jg&$8)\u00197m\u000bb\u0004(/Z:tS>t'\"\u0005&fi\u000e\u000bG\u000e\\#yaJ,7o]5p]*Yb/[:ji\u000ec\u0017m]:MSR,'/\u00197FqB\u0014Xm]:j_:T\u0011DS3u\u00072\f7o\u001d'ji\u0016\u0014\u0018\r\\#yaJ,7o]5p]*9b/[:ji\u000e{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0016\u0015\u0016$8i\u001c8ti\u0006tG/\u0012=qe\u0016\u001c8/[8o\u0015=1\u0018n]5u\u0015\u0016$X\t\\3nK:$(bB3mK6,g\u000e\u001e\u0006\u000b\u0015\u0016$X\t\\3nK:$(B\u0006<jg&$H*\u00192fY\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u000b))+G\u000fT1cK2,G-\u0012=qe\u0016\u001c8/[8o\u0015q1\u0018n]5u!\u0006\u0014XM\u001c;iKNL'0\u001a3FqB\u0014Xm]:j_:T!DS3u!\u0006\u0014XM\u001c;iKNL'0\u001a3FqB\u0014Xm]:j_:T\u0001D^5tSR\fV/\u00197jM&,G-\u0012=qe\u0016\u001c8/[8o\u0015YQU\r^)vC2Lg-[3e\u000bb\u0004(/Z:tS>t'\"\u0007<jg&$8+[7qY\u0016t\u0015-\\3FqB\u0014Xm]:j_:TqCS3u'&l\u0007\u000f\\3OC6,W\t\u001f9sKN\u001c\u0018n\u001c8\u000b;YL7/\u001b;TiJLgn\u001a+f[Bd\u0017\r^3FqB\u0014Xm]:j_:T1DS3u'R\u0014\u0018N\\4UK6\u0004H.\u0019;f\u000bb\u0004(/Z:tS>t'\u0002\u0006<jg&$XK\\1ss\u0016C\bO]3tg&|gN\u0003\nKKR,f.\u0019:z\u000bb\u0004(/Z:tS>t'\"\u0001+\u000b\u001b\r{gn\u001d;b]R4\u0016\r\\;f\u0015\u00119(/\u00199\u000b\r%\u001c\b+\u001e:f\u0015a!\u0016\u0010]3e\u0007>l\u0007/\u001b7f)&lWmQ8ogR\fg\u000e\u001eW\u0005\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\u0011A!\u0001\u0005\u0005\u000b\r!9\u0001c\u0002\r\u0001\u0015\u0019AA\u0001E\u0005\u0019\u0001)!\u0001B\u0001\t\f\u0015\u0019A!\u0002\u0005\u0006\u0019\u0001)1\u0001\"\u0002\t\u000f1\u0001Qa\u0001C\u0002\u0011!a\u0001!\u0002\u0002\u0005\u0006!9QA\u0001C\u0002\u0011!)1\u0001\u0002\u0002\t\u00131\u0001QA\u0001\u0003\u0003\u0011%)!\u0001\u0003\u0006\r\u0003\u0015\u0011AQ\u0001\u0005\u000b\u000b\r!9\u0001c\u0006\r\u0001\u0015\t\u00012A\u0003\u0004\t+AA\u0002\u0004\u0001\u0006\u0005\u0011\u001d\u0001rC\u0003\u0004\t+AY\u0002\u0004\u0001\u0006\u0007\u0011%\u0001R\u0004\u0007\u0001\u000b\t!!\u0001#\u0003\u0006\u0003!}QA\u0001C\u000e\u0011A)!\u0001\u0002\b\t\"\u0015\u0011AA\u0001\u0005\u0012\u000b\t!Q\u0001C\u0003\u0006\u0007\u0011U\u0001R\u0005\u0007\u0001\u000b\r!)\u0001#\u000b\r\u0001\u0015\u0019Aa\u0001\u0005\u0016\u0019\u0001)!\u0001\"\u0002\t,\u0015\u0011AQ\u0001E\u0015\u000b\t!\u0019\u0001c\f\u0006\u0005\u0011\u0015\u0002\u0002G\u0003\u0004\tMAq\u0003\u0004\u0001\u0006\u0005\u0011\t\u00012G\u0003\u0004\tQA\u0011\u0004\u0004\u0001\u0006\u0005\u0011\u0019\u0002bF\u0003\u0003\tQA\u0011$B\u0002\u0005'!YB\u0002A\u0003\u0003\tMA1$B\u0002\u0005\u0016!iB\u0002A\u0003\u0003\t9AQ$B\u0002\u0005)!\tC\u0002A\u0003\u0003\tQA\u0011%B\u0002\u0005\u0016!\u0019C\u0002A\u0003\u0004\t\u000fA9\u0005\u0004\u0001\u0006\u0005\u0011m\u0001\u0002J\u0003\u0003\tiA1%B\u0002\u0005\b!1C\u0002A\u0003\u0003\t\u000fAa%B\u0002\u0005\b!9C\u0002A\u0003\u0003\t\u000fAq%B\u0002\u0005\b!AC\u0002A\u0003\u0003\t\u000fA\u0001&B\u0002\u0005\b!IC\u0002A\u0003\u0003\t\u000fA\u0011&B\u0002\u0005\b!QC\u0002A\u0003\u0003\t\u000fA!&B\u0002\u0005\b!]C\u0002A\u0003\u0003\t\u000fA9&B\u0002\u0005\b!eC\u0002A\u0003\u0003\t\u000fAI&B\u0002\u0005\b!mC\u0002A\u0003\u0003\t\u000fAY&B\u0002\u0005\b!uC\u0002A\u0003\u0003\t\u000fAi&B\u0002\u0005\b!}C\u0002A\u0003\u0003\t\u000fAy&B\u0002\u0005\b!\u0005D\u0002A\u0003\u0003\t\u000fA\t'B\u0002\u0005\b!\rD\u0002A\u0003\u0003\t\u000fA\u0019'B\u0002\u0005\u0005!\u0015D\u0002A\u0003\u0004\t\tAA\u0007\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0002N\u0003\u0003\t\tA)\u0007B\u0001\r\u0007e\u0001R!\u0001\u0005\u0005\u0013\u001dIa!B\u0001\t\n%\tA1\u0001G\u00011\u0013IA!C\u0002\u0006\u0003!-\u00014\u0002\r\u0005;\u0003)R\u0006\u0004\u0003b\ta5\u0011eA\u0003\u0002\u0011\u0019Ab!V\u0002\u0005\u000b\r!i!C\u0001\t\u000f5bA!\u0019\u0003\u0019\u0012\u0005\u001aQ!\u0001\u0005\t1!)6\u0001B\u0003\u0004\t#I\u0011\u0001#\u0005.\u0019\u0011\tG\u0001g\u0005\"\u0007\u0015\t\u0001\"\u0003\r\n+\u000e!Qa\u0001C\n\u0013\u0005A\u0019\"\f\u0007\u0005C\u0012Az!I\u0002\u0006\u0003!5\u0001TB+\u0004\t\u0015\u0019AqB\u0005\u0002\u0011\u001fiS\u0003B\u0001\u0019\u0016u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001\u0003\u0006\u0019\u0015A\u001b\u0001!I\u0002\u0006\u0003!Y\u0001dC)\u0004\u000b\u0011U\u0011\"\u0001C\u0001\u001b\u0005A9\"\f\u0018\u0005\u0003aeQ\u0014\u0003\u0003\u0001\u00115iA!B\u0001\t\u00191\u0005\u0001\u0004\u0004)\u0004\u0001u=A\u0001\u0001\u0005\u000f\u001b\r)\u0011\u0001#\u0007\u0019\u001aA\u001b\t!h\u0004\u0005\u0001!yQbA\u0003\u0002\u0011\u0017AZ\u0001U\u0002\u0002C\u0019)\u0011\u0001#\u0003\n\u0003\u0011\rA\u0012\u0001M\u0005#\u000eIA\u0011D\u0005\u0002\u00115i\u0011\u0001#\b\u000e\u0003!yQ\"\u0001E\u0010[=\"\u0011\u0001g\t\u001e\u0012\u0011\u0001\u0001\"D\u0007\u0005\u000b\u0005AA\u0002$\u0001\u0019\u0019A\u001b\u0001!(\u0005\u0005\u0001!yQ\u0002B\u0003\u0002\u0011\u0017a\t\u0001g\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u001d5\u0019Q!\u0001E\r13\u00016!A\u0011\u0007\u000b\u0005AI!C\u0001\u0005\u00041\u0005\u0001\u0014B)\u0004\u0013\u0011\r\u0012\"\u0001\u0005\u000e\u001b\u0005Ai\"D\u0001\t 5\t\u0001bD\u0017.\t\u0005A\"#h\u0004\u0005\u0001!iQbA\u0003\u0002\u0011AA\u0002\u0003U\u0002\u0001;\u001f!\u0001\u0001\u0003\b\u000e\u0007\u0015\t\u0001\u0012\u0004M\r!\u000e\u0005Qt\u0002\u0003\u0001\u0011=i1!B\u0001\t\fa-\u0001kA\u0001\"\r\u0015\t\u0001\u0012B\u0005\u0002\t\u0007a\t\u0001'\u0003R\u0007%!!#C\u0001\t\u001b5\tAqA\u0007\u0002\u0011=i\u0011\u0001c\b.[\u0011\t\u0001dEO\b\t\u0001A1\"D\u0002\u0006\u0003!Q\u0001D\u0003)\u0004\u0001u=A\u0001\u0001E\u0014\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\t!h\u0005\u0005\u0001!!R\"B\u0003\u0002\u0011CI\u0011\u0001b\u0001\u0019\"A\u001b\u0011!\t\u0003\u0006\u0003!\tB\u0012\u0001\r\u0012#\u000eIAaE\u0005\u0002\u0011Gi\u0011\u0001c\u0006\u000e\u0003!}Q\"\u0001\u0005\u0013[\u0003\"\u0011\u0001\u0007\f\u001e\u0010\u0011\u0001\u0001RF\u0007\u0004\u000b\u0005A9\u0003g\nQ\u0007\u0001iz\u0001\u0002\u0001\t25\u0019Q!\u0001E\u00151S\u00016\u0011A\u0011\u0005\u000b\u0005A\u0011\u0003$\u0001\u0019#E\u001bq\u0001\u0002\f\n\u0003!\rR\"\u0001\u0005\u0016\u001b\u0005AY#,\u0012\u0005\u0003aQR4\u0003\u0003\u0001\u0011kiQ!B\u0001\t-%\tA1\u0001\r\u0017!\u000e\u0001Qt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0015aQ\u0001k!\u0001\"\t\u0015\t\u0001\"\u0005G\u00011E\t6a\u0002\u0003\u001b\u0013\u0005A\u0019#D\u0001\t.5\t\u0001rCW$\t\rA2!h\u0004\u0005\u0001!YQbA\u0003\u0002\u0011)A\"\u0002U\u0002\u0001;#!\u0001\u0001C\b\u000e\t\u0015\t\u00012\u0002G\u00011\u0017\u00016\u0011A\u0011\u0007\u000b\u0005AI!C\u0001\u0005\u00041\u0005\u0001\u0014B)\u0004\u000f\u0011\u0019\u0011\"\u0001\u0005\u000e\u001b\u0005A9\"D\u0001\t 5.D!\u0001M\u001c;\u001f!\u0001\u0001\u0003\u000f\u000e\u0007\u0015\t\u0001\"\u0005\r\u0012!\u000e\u0001Qt\u0002\u0003\u0001\u0011ci1!B\u0001\t#a\t\u0002k!\u0001\u001e\u0010\u0011\u0001\u0001\u0012H\u0007\u0004\u000b\u0005Aq\u0003G\fQ\u0007\u0005iz\u0001\u0002\u0001\t<5\u0019Q!\u0001\u0005\u000b1)\u000161A\u0011\u0005\u000b\u0005AA\u0002$\u0001\u0019\u0019E\u001b1\u0002b\u000e\n\u0003!uQ\"\u0001E\u0012\u001b\u0005A\u0019#D\u0001\t05\t\u0001rC\u0017/\t\u0005Ab$h\u0004\u0005\u0001!mRbA\u0003\u0002\u0011)A\"\u0002U\u0002\u0001;\u001f!\u0001\u0001#\u0010\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e\u0005Q\u0014\u0003\u0003\u0001\u0011=iA!B\u0001\t\f1\u0005\u00014\u0002)\u0004\u0003\u00052Q!\u0001E\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\nE\u001b\u0011\u0002\u0002\u0010\n\u0003!iQ\"\u0001E\f\u001b\u0005A9\"D\u0001\t 5ZC!\u0001\r ;\u001f!\u0001\u0001\u0003\u000f\u000e\u0007\u0015\t\u0001\"\u0005\r\u0012!\u000e\u0001Qt\u0002\u0003\u0001\u0011si1!B\u0001\t/a9\u0002k!\u0001\u001e\u0010\u0011\u0001\u00012H\u0007\u0004\u000b\u0005A!\u0002\u0007\u0006Q\u0007\u0005\tC!B\u0001\t\u00191\u0005\u0001\u0004D)\u0004\u0013\u0011y\u0012\"\u0001E\u000f\u001b\u0005A\u0019#D\u0001\t05\t\u0001rCW!\t\u0005Az$h\u0004\u0005\u0001!eRbA\u0003\u0002\u0011]Ar\u0003U\u0002\u0001;#!\u0001\u0001#\r\u000e\t\u0015\t\u0001\u0002\u0004G\u000111\u00016\u0011A\u0011\u0004\u000b\u0005A1\u0002G\u0006R\u0007\u001d!y$C\u0001\u0005\u00025\t\u0001rF\u0007\u0002\u0011;iS\u0003B\u0001\u0019Au=A\u0001\u0001E!\u001b\r)\u0011\u0001\u0003\r\u00191A\u001b\u0001!I\u0002\u0006\u0003!Y\u0001dC)\u0004\u000b\u0011\u0001\u0013\"\u0001C\u0001\u001b\u0005A\t$L\u000b\u0005\u0003a\rSt\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0015aQ\u0001k\u0001\u0001\"\u0007\u0015\t\u0001b\u0003\r\f#\u000e)A1I\u0005\u0002\t\u0003i\u0011\u0001c\u0006.X\u0011\t\u0001DIO\r\t\u0001A)%\u0004\u0005\u0006\u0003!I\u0012\u0002B\u0005\u0004\u000b\u0005A\u0019\u0004g\r\u00193A\u001b\u0001!h\u0004\u0005\u0001!yQbA\u0003\u0002\u0011\u0017AZ\u0001UB\u0001C))\u0011\u0001C\r\n\r%)Q!\u0001E\u0005\u0013\u0005!\u0019\u0001'\u0003\u00193E\u001bq\u0001\u0002\u0012\n\u0003!UR\"\u0001E\u001b\u001b\u0005Ay\"L\u000b\u0005\u0003a%St\u0002\u0003\u0001\u0011-i1!B\u0001\t\u0015aQ\u0001k\u0001\u0001\"\u0007\u0015\t\u0001b\u0003\r\f#\u000e)A\u0011J\u0005\u0002\t\u0003i\u0011\u0001c\u0006.+\u0011\t\u0001$JO\b\t\u0001A1\"D\u0002\u0006\u0003!Q\u0001D\u0003)\u0004\u0001\u0005\u001aQ!\u0001\u0005\f1-\t6!\u0002\u0003&\u0013\u0005!\t!D\u0001\t\u00185\u001eCa\u0003M&;\u001f!\u0001\u0001C\u0006\u000e\u0007\u0015\t\u0001b\u0007\r\u001c!\u000e\u0001Q\u0014\u0003\u0003\u0001\u0011=iA!B\u0001\t\f1\u0005\u00014\u0002)\u0004\u0002\u00052Q!\u0001E\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\nE\u001bq\u0001b\u0013\n\u0003!iQ\"\u0001E\u001c\u001b\u0005Ay\"l\u0012\u0005\u0017a5St\u0002\u0003\u0001\u0011-i1!B\u0001\t9aa\u0002k\u0001\u0001\u001e\u0012\u0011\u0001\u0001bD\u0007\u0005\u000b\u0005AY\u0001$\u0001\u0019\fA\u001b\t!\t\u0004\u0006\u0003!%\u0011\"\u0001C\u0002\u0019\u0003AJ!U\u0002\b\t\u001bJ\u0011\u0001C\u0007\u000e\u0003!eR\"\u0001E\u0010[\u000f\"1\u0002g\u0014\u001e\u0010\u0011\u0001\u0001bC\u0007\u0004\u000b\u0005AQ\u0004G\u000fQ\u0007\u0001i\n\u0002\u0002\u0001\t\u001f5!Q!\u0001E\u0006\u0019\u0003AZ\u0001UB\u0001C\u0019)\u0011\u0001#\u0003\n\u0003\u0011\rA\u0012\u0001M\u0005#\u000e9AqJ\u0005\u0002\u00115i\u0011\u0001c\u000f\u000e\u0003!}Qv\t\u0003\f1#jz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001\u0005\u001f1y\u00016\u0001AO\t\t\u0001Aq\"\u0004\u0003\u0006\u0003!-A\u0012\u0001M\u0006!\u000e\u0005\u0011EB\u0003\u0002\u0011\u0013I\u0011\u0001b\u0001\r\u0002a%\u0011kA\u0004\u0005R%\t\u0001\"D\u0007\u0002\u0011{i\u0011\u0001c\b.H\u0011Y\u00014KO\b\t\u0001A1\"D\u0002\u0006\u0003!y\u0002d\b)\u0004\u0001uEA\u0001\u0001\u0005\u0010\u001b\u0011)\u0011\u0001c\u0003\r\u0002a-\u0001k!\u0001\"\r\u0015\t\u0001\u0012B\u0005\u0002\t\u0007a\t\u0001'\u0003R\u0007\u001d!\u0019&C\u0001\t\u001b5\t\u0001rH\u0007\u0002\u0011?i;\u0005B\u0006\u0019Vu=A\u0001\u0001\u0005,\u001b\r)\u0011\u0001\u0003\u0011\u0019AA\u001b\u0001!(\u0005\u0005\u0001!yQ\u0002B\u0003\u0002\u0011\u0017a\t\u0001g\u0003Q\u0007\u0003\tc!B\u0001\t\n%\tA1\u0001G\u00011\u0013\t6a\u0002C+\u0013\u0005AQ\"D\u0001\tB5\t\u0001rDW$\t-AB&h\u0004\u0005\u0001!YQbA\u0003\u0002\u0011\u0005B\u0012\u0005U\u0002\u0001;#!\u0001\u0001C\b\u000e\t\u0015\t\u00012\u0002G\u00011\u0017\u00016\u0011A\u0011\u0007\u000b\u0005AI!C\u0001\u0005\u00041\u0005\u0001\u0014B)\u0004\u000f\u0011a\u0013\"\u0001\u0005\u000e\u001b\u0005A\u0019%D\u0001\t 5\u001eCa\u0003\r.;\u001f!\u0001\u0001C\u0006\u000e\u0007\u0015\t\u0001B\t\r#!\u000e\u0001Q\u0014\u0003\u0003\u0001\u0011=iA!B\u0001\t\f1\u0005\u00014\u0002)\u0004\u0002\u00052Q!\u0001E\u0005\u0013\u0005!\u0019\u0001$\u0001\u0019\nE\u001bq\u0001B\u0017\n\u0003!iQ\"\u0001E#\u001b\u0005Ay\"l\u0012\u0005\u0017aqSt\u0002\u0003\u0001\u0011-i1!B\u0001\tGa\u0019\u0003k\u0001\u0001\u001e\u0012\u0011\u0001\u0001bD\u0007\u0005\u000b\u0005AY\u0001$\u0001\u0019\fA\u001b\t!\t\u0004\u0006\u0003!%\u0011\"\u0001C\u0002\u0019\u0003AJ!U\u0002\b\t9J\u0011\u0001C\u0007\u000e\u0003!\u001dS\"\u0001E\u0010[\u000f\"1\u0002G\u0018\u001e\u0010\u0011\u0001\u0001bC\u0007\u0004\u000b\u0005AA\u0005\u0007\u0013Q\u0007\u0001i\n\u0002\u0002\u0001\t\u001f5!Q!\u0001E\u0006\u0019\u0003AZ\u0001UB\u0001C\u0019)\u0011\u0001#\u0003\n\u0003\u0011\rA\u0012\u0001M\u0005#\u000e9AaL\u0005\u0002\u00115i\u0011\u0001#\u0013\u000e\u0003!}Qv\t\u0003\f1Ajz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001\u0005&1\u0015\u00026\u0001AO\t\t\u0001Aq\"\u0004\u0003\u0006\u0003!-A\u0012\u0001M\u0006!\u000e\u0005\u0011EB\u0003\u0002\u0011\u0013I\u0011\u0001b\u0001\r\u0002a%\u0011kA\u0004\u0005a%\t\u0001\"D\u0007\u0002\u0011\u0017j\u0011\u0001c\b.H\u0011Y\u0001$MO\b\t\u0001A1\"D\u0002\u0006\u0003!1\u0003D\n)\u0004\u0001uEA\u0001\u0001\u0005\u0010\u001b\u0011)\u0011\u0001c\u0003\r\u0002a-\u0001k!\u0001\"\r\u0015\t\u0001\u0012B\u0005\u0002\t\u0007a\t\u0001'\u0003R\u0007\u001d!\u0011'C\u0001\t\u001b5\t\u0001RJ\u0007\u0002\u0011?ik\u001a\u0001\u0003\u0002#\u001d!\u0001\u0001\u0003\u001a\u0016\t\u0015\t\u0001\u0002\u0004G\u000111)\u0012\"B\u0001\tO%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019Oa\u0019Tt\u0002\u0003\u0002\u0011+i1!B\u0001\t\u0017aY\u0001k!\u0001\u001e\u0010\u0011\t\u0001rM\u0007\u0004\u000b\u0005A1\u0002G\u0006Q\u0007\u0005iz\u0001B\u0001\tK5\u0019Q!\u0001\u0005\f1-\u000161AO\b\t\u0005AI%D\u0002\u0006\u0003!Y\u0001d\u0003)\u0004\u0005\u0005JQ!\u0001E(\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001M(#\u000eiAaM\u0005\u0002\u0011!j\u0011\u0001#\u0015\u000e\u0003\u0011\u0005Q\"\u0001C\u0001\u001b\u0005!\t!D\u0001\u0005\u00025zC!A\t\b\t\u0001A!'\u0006\u0003\u0006\u0003!aA\u0012\u0001\r\r+%)\u0011\u0001C\u0014\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002\u0001G\u0014\u0019gu=A\u0001\u0001\u0005\u000f\u001b\r)\u0011\u0001#\u0007\u0019\u001aA\u001b\t!I\u0005\u0006\u0003!=\u0013\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001a=\u0013kA\u0004\u0005g%\t\u0001\u0002K\u0007\u0002\u0011#j\u0011\u0001C\b6C\u0015\u0001Ca9\u0001\u0019\ru=A\u0001\u0001E\u0007\u001b\r)\u0011\u0001\u0003\u0004\u0019\rA\u001b\u0001!h\u0004\u0005\u0001!=QbA\u0003\u0002\u0011\u001bAj\u0001UB\u0001C\r)\u0011\u0001C\u0002\u0019\u0007E\u001bq\u0001\u0002\u0004\n\u0003\u0011\u0001Q\"\u0001\u0005\b\u001b\u0005Ay\u0001"})
public final class ConstantExpressionEvaluatorVisitor
extends JetVisitor<CompileTimeConstant<?>, JetType> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ConstantValueFactory factory;
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final BindingTrace trace;

    static {
        $kotlinClass = Reflection.createKotlinClass(ConstantExpressionEvaluatorVisitor.class);
    }

    @Nullable
    public final CompileTimeConstant<?> evaluate(@NotNull JetExpression expression, @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        CompileTimeConstant<?> recordedCompileTimeConstant = ConstantExpressionEvaluator.Companion.getPossiblyErrorConstant(expression, bindingContext);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        JetVisitor jetVisitor = this;
        JetType jetType = expectedType;
        if (jetType == null) {
            jetType = TypeUtils.NO_EXPECTED_TYPE;
        }
        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)expression.accept(jetVisitor, jetType);
        if (compileTimeConstant != null) {
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitConstantExpression(@NotNull JetConstantExpression expression, @Nullable JetType expectedType) {
        Object object;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        String string = expression.getText();
        if (string == null) {
            return null;
        }
        String text = string;
        IElementType nodeElementType = expression.getNode().getElementType();
        if (Intrinsics.areEqual(nodeElementType, JetNodeTypes.NULL)) {
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createNullValue(), false, false, false, false, 15);
        }
        IElementType iElementType = nodeElementType;
        if (Intrinsics.areEqual(iElementType, JetNodeTypes.INTEGER_CONSTANT)) {
            object = ConstantExpressionEvaluatorKt.parseLong(text);
        } else if (Intrinsics.areEqual(iElementType, JetNodeTypes.FLOAT_CONSTANT)) {
            object = ConstantExpressionEvaluatorKt.parseFloatingLiteral(text);
        } else if (Intrinsics.areEqual(iElementType, JetNodeTypes.BOOLEAN_CONSTANT)) {
            object = ConstantExpressionEvaluatorKt.parseBoolean(text);
        } else if (Intrinsics.areEqual(iElementType, JetNodeTypes.CHARACTER_CONSTANT)) {
            object = CompileTimeConstantChecker.parseChar(expression);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported constant: " + expression);
        }
        if (object == null) {
            return null;
        }
        Long result2 = object;
        Function0<Boolean> isLongWithSuffix$ = new Function0<Boolean>(nodeElementType, text){
            final /* synthetic */ IElementType $nodeElementType;
            final /* synthetic */ String $text;

            public final boolean invoke() {
                return Intrinsics.areEqual(this.$nodeElementType, JetNodeTypes.INTEGER_CONSTANT) && ConstantExpressionEvaluatorKt.hasLongSuffix(this.$text);
            }
            {
                this.$nodeElementType = iElementType;
                this.$text = string;
                super(0);
            }
        };
        return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, !isLongWithSuffix$.invoke(), false, false));
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression, @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression deparenthesizedExpression = JetPsiUtil.deparenthesize(expression);
        if (deparenthesizedExpression != null && Intrinsics.areEqual(deparenthesizedExpression, expression) ^ true) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitLabeledExpression(@NotNull JetLabeledExpression expression, @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression baseExpression = expression.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression, @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        StringBuilder sb = new StringBuilder();
        boolean interupted = false;
        boolean canBeUsedInAnnotation = true;
        boolean usesVariableAsConstant = false;
        boolean usesNonConstantVariableAsConstant = false;
        JetStringTemplateEntry[] jetStringTemplateEntryArray = expression.getEntries();
        for (int i = 0; i < jetStringTemplateEntryArray.length; ++i) {
            JetStringTemplateEntry entry;
            JetStringTemplateEntry jetStringTemplateEntry = entry = jetStringTemplateEntryArray[i];
            Intrinsics.checkExpressionValueIsNotNull(jetStringTemplateEntry, "entry");
            TypedCompileTimeConstant<String> constant = this.stringExpressionEvaluator.evaluate(jetStringTemplateEntry);
            if (constant == null) {
                interupted = true;
                break;
            }
            if (!constant.getCanBeUsedInAnnotations()) {
                canBeUsedInAnnotation = false;
            }
            if (constant.getUsesVariableAsConstant()) {
                usesVariableAsConstant = true;
            }
            if (constant.getUsesNonConstValAsConstant()) {
                usesNonConstantVariableAsConstant = true;
            }
            sb.append(constant.getConstantValue().getValue());
        }
        return !interupted ? this.createConstant(sb.toString(), expectedType, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, false, usesVariableAsConstant, usesNonConstantVariableAsConstant)) : (CompileTimeConstant<?>)null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression, @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression jetExpression = expression.getLeft();
        Intrinsics.checkExpressionValueIsNotNull(jetExpression, "expression.getLeft()");
        return this.evaluate(jetExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryExpression(@NotNull JetBinaryExpression expression, @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression jetExpression = expression.getLeft();
        if (jetExpression == null) {
            return null;
        }
        JetExpression leftExpression = jetExpression;
        IElementType operationToken = expression.getOperationToken();
        if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey(operationToken)) {
            boolean bl;
            JetExpression rightExpression;
            JetType booleanType = this.constantExpressionEvaluator.getBuiltIns().getBooleanType();
            JetExpression jetExpression2 = leftExpression;
            Intrinsics.checkExpressionValueIsNotNull(jetExpression2, "leftExpression");
            CompileTimeConstant<?> leftConstant = this.evaluate(jetExpression2, booleanType);
            if (leftConstant == null) {
                return null;
            }
            JetExpression jetExpression3 = expression.getRight();
            if (jetExpression3 == null) {
                return null;
            }
            JetExpression jetExpression4 = rightExpression = jetExpression3;
            Intrinsics.checkExpressionValueIsNotNull(jetExpression4, "rightExpression");
            CompileTimeConstant<?> compileTimeConstant = this.evaluate(jetExpression4, booleanType);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> rightConstant = compileTimeConstant;
            JetType jetType = booleanType;
            Intrinsics.checkExpressionValueIsNotNull(jetType, "booleanType");
            Object leftValue = leftConstant.getValue(jetType);
            JetType jetType2 = booleanType;
            Intrinsics.checkExpressionValueIsNotNull(jetType2, "booleanType");
            Object rightValue = rightConstant.getValue(jetType2);
            if (!(leftValue instanceof Boolean) || !(rightValue instanceof Boolean)) {
                return null;
            }
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.ANDAND)) {
                bl = ((Boolean)leftValue).booleanValue() && ((Boolean)rightValue).booleanValue();
            } else if (Intrinsics.areEqual(iElementType, JetTokens.OROR)) {
                bl = ((Boolean)leftValue).booleanValue() || ((Boolean)rightValue).booleanValue();
            } else {
                throw (Throwable)new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl;
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, false, leftConstant.getUsesVariableAsConstant() || rightConstant.getUsesVariableAsConstant(), leftConstant.getUsesNonConstValAsConstant() || rightConstant.getUsesNonConstValAsConstant()));
        }
        JetExpression jetExpression5 = expression.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(jetExpression5, "expression.getOperationReference()");
        JetExpression jetExpression6 = leftExpression;
        Intrinsics.checkExpressionValueIsNotNull(jetExpression6, "leftExpression");
        return this.evaluateCall(jetExpression5, jetExpression6, expectedType);
    }

    /*
     * WARNING - void declaration
     */
    private final CompileTimeConstant<?> evaluateCall(JetExpression callExpression, JetExpression receiverExpression, JetType expectedType) {
        JetElement jetElement = callExpression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(jetElement, bindingContext);
        if (resolvedCall == null) {
            return null;
        }
        Name resultingDescriptorName = resolvedCall.getResultingDescriptor().getName();
        OperationArgument argumentForReceiver = this.createOperationArgumentForReceiver(resolvedCall, receiverExpression);
        if (argumentForReceiver == null) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resultingDescriptorName.asString()");
            Object result2 = this.evaluateUnaryAndCheck(argumentForReceiver, string, callExpression);
            if (result2 == null) {
                return null;
            }
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, !isNumberConversionMethod && isArgumentPure, usesVariableAsConstant, usesNonConstValAsConstant));
        }
        if (argumentsEntrySet.size() == 1) {
            CompileTimeConstant compileTimeConstant;
            void parameter;
            void argument;
            Map.Entry canBeUsedInAnnotation = (Map.Entry)CollectionsKt.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor result2 = (ValueParameterDescriptor)MapsKt.component1(canBeUsedInAnnotation);
            ResolvedValueArgument isArgumentPure = (ResolvedValueArgument)MapsKt.component2(canBeUsedInAnnotation);
            canBeUsedInAnnotation = null;
            void v3 = argument;
            Intrinsics.checkExpressionValueIsNotNull(v3, "argument");
            void v4 = parameter;
            Intrinsics.checkExpressionValueIsNotNull(v4, "parameter");
            OperationArgument argumentForParameter = this.createOperationArgumentForFirstParameter((ResolvedValueArgument)v3, (ValueParameterDescriptor)v4);
            if (argumentForParameter == null) {
                return null;
            }
            String string = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "resultingDescriptorName.asString()");
            if (this.isDivisionByZero(string, argumentForParameter.getValue())) {
                JetExpression jetExpression = PsiTreeUtil.getParentOfType((PsiElement)receiverExpression, JetExpression.class);
                if (jetExpression == null) {
                    Intrinsics.throwNpe();
                }
                JetExpression parentExpression = jetExpression;
                this.trace.report(Errors.DIVISION_BY_ZERO.on((JetExpression)((PsiElement)parentExpression)));
                return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createErrorValue("Division by zero"), false, false, false, false, 15);
            }
            String string2 = resultingDescriptorName.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "resultingDescriptorName.asString()");
            Object result3 = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, string2, callExpression);
            if (result3 == null) {
                return null;
            }
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) && this.isPureConstant(argumentForParameter.getExpression());
            boolean canBeUsedInAnnotation2 = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) && this.canBeUsedInAnnotation(argumentForParameter.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression()) || this.usesVariableAsConstant(argumentForParameter.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression()) || this.usesNonConstValAsConstant(argumentForParameter.getExpression());
            CompileTimeConstant.Parameters parameters2 = new CompileTimeConstant.Parameters(canBeUsedInAnnotation2, areArgumentsPure, usesVariableAsConstant, usesNonConstValAsConstant);
            Name name = resultingDescriptorName;
            if (Intrinsics.areEqual(name, OperatorConventions.COMPARE_TO)) {
                ConstantValue<?> constantValue = ConstantExpressionEvaluatorKt.createCompileTimeConstantForCompareTo(result3, callExpression, this.factory);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else if (Intrinsics.areEqual(name, OperatorConventions.EQUALS)) {
                ConstantValue<?> constantValue = ConstantExpressionEvaluatorKt.createCompileTimeConstantForEquals(result3, callExpression, this.factory);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else {
                compileTimeConstant = this.createConstant(result3, expectedType, parameters2);
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final boolean usesVariableAsConstant(JetExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesVariableAsConstant() : false;
    }

    private final boolean usesNonConstValAsConstant(JetExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesNonConstValAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(JetExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getCanBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(JetExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getIsPure() : false;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateUnaryAndCheck(OperationArgument receiver, String name, JetExpression callExpression) {
        void check2;
        void function;
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> functions2 = OperationsMapGeneratedKt.getUnaryOperations().get(new UnaryOperationKey(receiver.getCtcType(), name));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>> pair = functions2;
        Function1<? super Object, ? extends Object> function1 = pair.component1();
        Function1<? super Long, ? extends Long> function12 = pair.component2();
        pair = null;
        Object result2 = function.invoke(receiver.getValue());
        if (Intrinsics.areEqual(check2, OperationsMapGeneratedKt.getEmptyUnaryFun())) {
            return result2;
        }
        PreconditionsKt.assert(ConstantExpressionEvaluatorKt.isIntegerType(receiver.getValue()), "Only integer constants should be checked for overflow");
        PreconditionsKt.assert(Intrinsics.areEqual(name, "minus"), "Only negation should be checked for overflow");
        if (Intrinsics.areEqual(receiver.getValue(), result2)) {
            void $receiver;
            PsiElement psiElement = callExpression;
            DiagnosticFactory0<JetExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            JetExpression jetExpression = PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetExpression.class, true);
            JetExpression jetExpression2 = jetExpression;
            if (jetExpression2 == null) {
                jetExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((JetExpression)((PsiElement)jetExpression2)));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Object evaluateBinaryAndCheck(OperationArgument receiver, OperationArgument parameter, String name, JetExpression callExpression) {
        void value;
        void checker;
        Object var9_9;
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> functions2 = OperationsMapGeneratedKt.getBinaryOperations().get(new BinaryOperationKey(receiver.getCtcType(), parameter.getCtcType(), name));
        if (functions2 == null) {
            return null;
        }
        Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> pair = functions2;
        Function2<? super Object, ? super Object, ? extends Object> function2 = pair.component1();
        Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> function22 = pair.component2();
        pair = null;
        try {
            void function;
            var9_9 = function.invoke(receiver.getValue(), parameter.getValue());
        }
        catch (Exception e) {
            var9_9 = null;
        }
        Object actualResult = var9_9;
        if (Intrinsics.areEqual(checker, OperationsMapGeneratedKt.getEmptyBinaryFun())) {
            return actualResult;
        }
        boolean bl = ConstantExpressionEvaluatorKt.isIntegerType(receiver.getValue()) && ConstantExpressionEvaluatorKt.isIntegerType(parameter.getValue());
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value == false) {
            String message = "Only integer constants should be checked for overflow";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        evaluateBinaryAndCheck.2 toBigInteger$ = evaluateBinaryAndCheck.2.INSTANCE$;
        Object object = toBigInteger$.invoke(receiver.getValue());
        Intrinsics.checkExpressionValueIsNotNull(object, "toBigInteger(receiver.value)");
        Object object2 = toBigInteger$.invoke(parameter.getValue());
        Intrinsics.checkExpressionValueIsNotNull(object2, "toBigInteger(parameter.value)");
        BigInteger resultInBigIntegers = (BigInteger)checker.invoke(object, object2);
        if (Intrinsics.areEqual(toBigInteger$.invoke((Object)actualResult), resultInBigIntegers) ^ true) {
            void $receiver;
            PsiElement psiElement = callExpression;
            DiagnosticFactory0<JetExpression> diagnosticFactory0 = Errors.INTEGER_OVERFLOW;
            BindingTrace bindingTrace = this.trace;
            JetExpression jetExpression = PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetExpression.class, true);
            JetExpression jetExpression2 = jetExpression;
            if (jetExpression2 == null) {
                jetExpression2 = callExpression;
            }
            bindingTrace.report(diagnosticFactory0.on((JetExpression)((PsiElement)jetExpression2)));
        }
        return actualResult;
    }

    private final boolean isDivisionByZero(String name, Object parameter) {
        Object v = OperatorConventions.BINARY_OPERATION_NAMES.get(JetTokens.DIV);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual(name, ((Name)v).asString())) {
            if (ConstantExpressionEvaluatorKt.isIntegerType(parameter)) {
                Object object = parameter;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
                }
                return ((Number)object).longValue() == (long)0;
            }
            if (parameter instanceof Float || parameter instanceof Double) {
                Object object = parameter;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
                }
                return ((Number)object).doubleValue() == 0.0;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitUnaryExpression(@NotNull JetUnaryExpression expression, @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression leftExpression = expression.getBaseExpression();
        if (leftExpression == null) {
            return null;
        }
        JetExpression jetExpression = expression.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull(jetExpression, "expression.getOperationReference()");
        return this.evaluateCall(jetExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression, @Nullable JetType expectedType) {
        CallableDescriptor callableDescriptor;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression);
        if (enumDescriptor != null && DescriptorUtils.isEnumEntry(enumDescriptor)) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, this.factory.createEnumValue((ClassDescriptor)declarationDescriptor), false, false, false, false, 15);
        }
        JetElement jetElement = expression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(jetElement, bindingContext);
        if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) instanceof VariableDescriptor) {
            ConstantValue<?> constantValue = ((VariableDescriptor)callableDescriptor).getCompileTimeInitializer();
            if (constantValue == null) {
                return null;
            }
            ConstantValue<?> variableInitializer = constantValue;
            Object obj = variableInitializer.getValue();
            VariableDescriptor variableDescriptor = (VariableDescriptor)callableDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "callableDescriptor");
            return this.createConstant(obj, expectedType, new CompileTimeConstant.Parameters(this.isPropertyCompileTimeConstant(variableDescriptor), false, true, !((VariableDescriptor)callableDescriptor).isConst()));
        }
        return null;
    }

    private final boolean isPropertyCompileTimeConstant(VariableDescriptor descriptor) {
        if (descriptor.isVar()) {
            return false;
        }
        if (DescriptorUtils.isObject(descriptor.getContainingDeclaration()) || DescriptorUtils.isStaticDeclaration(descriptor)) {
            return ConstUtilKt.canBeUsedForConstVal(descriptor.getType());
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitQualifiedExpression(@NotNull JetQualifiedExpression expression, @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression instanceof JetCallExpression) {
            JetExpression receiverExpression;
            CompileTimeConstant<?> qualifiedCallValue = this.evaluate(selectorExpression, expectedType);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            JetExpression calleeExpression = ((JetCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof JetSimpleNameExpression)) {
                return null;
            }
            JetExpression jetExpression = receiverExpression = expression.getReceiverExpression();
            Intrinsics.checkExpressionValueIsNotNull(jetExpression, "receiverExpression");
            return this.evaluateCall(calleeExpression, jetExpression, expectedType);
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCallExpression(@NotNull JetCallExpression expression, @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetElement jetElement = expression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.getBindingContext()");
        ResolvedCall<? extends CallableDescriptor> call = CallUtilKt.getResolvedCall(jetElement, bindingContext);
        if (call == null) {
            return null;
        }
        CallableDescriptor resultingDescriptor = call.getResultingDescriptor();
        if (CompileTimeConstantUtils.isArrayMethodCall(call)) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor;
            Object object;
            block11: {
                boolean bl5;
                CompileTimeConstant it;
                List arguments2;
                Iterable $receiver;
                block10: {
                    Collection collection;
                    Collection destination;
                    Object list;
                    ResolvedValueArgument it2;
                    Iterable $receiver2;
                    JetType jetType = CollectionsKt.first(resultingDescriptor.getValueParameters()).getVarargElementType();
                    if (jetType == null) {
                        Intrinsics.throwNpe();
                    }
                    JetType varargType = jetType;
                    Iterable iterable = call.getValueArguments().values();
                    Iterator iterator2 = $receiver;
                    Collection collection2 = new ArrayList();
                    for (Object element : $receiver2) {
                        it2 = (ResolvedValueArgument)element;
                        List<ValueArgument> list2 = it2.getArguments();
                        Intrinsics.checkExpressionValueIsNotNull(list2, "it.getArguments()");
                        JetType jetType2 = varargType;
                        Intrinsics.checkExpressionValueIsNotNull(jetType2, "varargType");
                        list = this.resolveArguments(list2, jetType2);
                        CollectionsKt.addAll(destination, list);
                    }
                    arguments2 = (List)destination;
                    $receiver = arguments2;
                    object = this.factory;
                    constantExpressionEvaluatorVisitor = this;
                    $receiver2 = $receiver;
                    destination = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver, 10));
                    for (Object item : $receiver2) {
                        list = (CompileTimeConstant)item;
                        collection = destination;
                        JetType jetType3 = varargType;
                        Intrinsics.checkExpressionValueIsNotNull(jetType3, "varargType");
                        ConstantValue constantValue = it2.toConstantValue(jetType3);
                        collection.add(constantValue);
                    }
                    collection = (List)destination;
                    JetType jetType4 = resultingDescriptor.getReturnType();
                    if (jetType4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(jetType4, "resultingDescriptor.getReturnType()!!");
                    $receiver = arguments2;
                    bl4 = false;
                    bl3 = false;
                    object = ((ConstantValueFactory)object).createArrayValue((List<? extends ConstantValue<?>>)collection, jetType4);
                    for (Object element : $receiver) {
                        it = (CompileTimeConstant)element;
                        if (!it.getUsesVariableAsConstant()) continue;
                        bl5 = true;
                        break block10;
                    }
                    bl5 = false;
                }
                bl2 = bl5;
                $receiver = arguments2;
                for (Object element : $receiver) {
                    it = (CompileTimeConstant)element;
                    if (!it.getUsesNonConstValAsConstant()) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            boolean bl6 = bl;
            return ConstantExpressionEvaluatorVisitor.wrap$default(constantExpressionEvaluatorVisitor, (ConstantValue)object, bl3, bl4, bl2, bl6, 3);
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "resultingDescriptor.getContainingDeclaration()");
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
                AnnotationDescriptorImpl descriptor = new AnnotationDescriptorImpl(classDescriptor2.getDefaultType(), this.constantExpressionEvaluator.resolveAnnotationArguments(call, this.trace), SourceElement.NO_SOURCE);
                return ConstantExpressionEvaluatorVisitor.wrap$default(this, new AnnotationValue(descriptor), false, false, false, false, 15);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitClassLiteralExpression(@NotNull JetClassLiteralExpression expression, @Nullable JetType expectedType) {
        JetType jetType;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        JetType jetType2 = this.trace.getType(expression);
        if (jetType2 == null) {
            Intrinsics.throwNpe();
        }
        if ((jetType = jetType2).isError()) {
            return null;
        }
        JetType jetType3 = jetType;
        Intrinsics.checkExpressionValueIsNotNull(jetType3, "jetType");
        return ConstantExpressionEvaluatorVisitor.wrap$default(this, new KClassValue(jetType3), false, false, false, false, 15);
    }

    private final List<CompileTimeConstant<?>> resolveArguments(List<? extends ValueArgument> valueArguments2, JetType expectedType) {
        ArrayList<CompileTimeConstant> constants = CollectionsKt.arrayListOf(new CompileTimeConstant[0]);
        for (ValueArgument valueArgument : valueArguments2) {
            CompileTimeConstant<?> compileTimeConstant;
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || (compileTimeConstant = this.evaluate(argumentExpression, expectedType)) == null) continue;
            constants.add(compileTimeConstant);
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitJetElement(@NotNull JetElement element, @Nullable JetType expectedType) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(ResolvedCall<?> resolvedCall, JetExpression expression) {
        JetType receiverExpressionType = ConstantExpressionEvaluatorKt.getReceiverExpressionType(resolvedCall);
        if (receiverExpressionType == null) {
            return null;
        }
        CompileTimeType<? extends Object> receiverCompileTimeType = ConstantExpressionEvaluatorKt.getCompileTimeType(receiverExpressionType);
        if (receiverCompileTimeType == null) {
            return null;
        }
        return this.createOperationArgument(expression, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(ResolvedValueArgument argument, ValueParameterDescriptor parameter) {
        JetType jetType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(jetType, "parameter.getType()");
        CompileTimeType<? extends Object> argumentCompileTimeType = ConstantExpressionEvaluatorKt.getCompileTimeType(jetType);
        if (argumentCompileTimeType == null) {
            return null;
        }
        List<ValueArgument> arguments2 = argument.getArguments();
        if (arguments2.size() != 1) {
            return null;
        }
        JetExpression argumentExpression = CollectionsKt.first(arguments2).getArgumentExpression();
        if (argumentExpression == null) {
            return null;
        }
        JetType jetType2 = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(jetType2, "parameter.getType()");
        return this.createOperationArgument(argumentExpression, jetType2, argumentCompileTimeType);
    }

    private final OperationArgument createOperationArgument(JetExpression expression, JetType expressionType, CompileTimeType<?> compileTimeType) {
        CompileTimeConstant<?> compileTimeConstant = this.constantExpressionEvaluator.evaluateExpression(expression, this.trace, expressionType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
        Object obj = compileTimeConstant2.getValue(expressionType);
        if (obj == null) {
            return null;
        }
        Object evaluationResult = obj;
        return new OperationArgument(evaluationResult, compileTimeType, expression);
    }

    private final CompileTimeConstant<?> createConstant(Object value, JetType expectedType, CompileTimeConstant.Parameters parameters2) {
        if (parameters2.getIsPure()) {
            JetType jetType = expectedType;
            if (jetType == null) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
            Intrinsics.checkExpressionValueIsNotNull(jetType, "expectedType ?: TypeUtils.NO_EXPECTED_TYPE");
            return this.createCompileTimeConstant(value, parameters2, jetType);
        }
        ConstantValue<?> constantValue = this.factory.createConstantValue(value);
        return constantValue != null ? this.wrap(constantValue, parameters2) : null;
    }

    private final CompileTimeConstant<?> createCompileTimeConstant(Object value, CompileTimeConstant.Parameters parameters2, JetType expectedType) {
        CompileTimeConstant compileTimeConstant;
        Object object = value;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            Object object2 = value;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
            }
            compileTimeConstant = this.createIntegerCompileTimeConstant(((Number)object2).longValue(), parameters2, expectedType);
        } else {
            ConstantValue<?> constantValue = this.factory.createConstantValue(value);
            compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
        }
        return compileTimeConstant;
    }

    private final CompileTimeConstant<?> createIntegerCompileTimeConstant(long value, CompileTimeConstant.Parameters parameters2, JetType expectedType) {
        if (TypeUtils.noExpectedType(expectedType) || expectedType.isError()) {
            return new IntegerValueTypeConstant(value, this.constantExpressionEvaluator.getBuiltIns(), parameters2);
        }
        ConstantValue<?> integerValue = this.factory.createIntegerConstantValue(value, expectedType);
        if (integerValue != null) {
            return this.wrap(integerValue, parameters2);
        }
        long l = value;
        return this.wrap(l == (long)((int)value) ? (IntegerValueConstant)this.factory.createIntValue((int)value) : (IntegerValueConstant)this.factory.createLongValue(value), parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $receiver, CompileTimeConstant.Parameters parameters2) {
        return new TypedCompileTimeConstant<T>($receiver, parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $receiver, boolean canBeUsedInAnnotation, boolean isPure, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant) {
        return this.wrap($receiver, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, isPure, usesVariableAsConstant, usesNonConstValAsConstant));
    }

    static /* synthetic */ TypedCompileTimeConstant wrap$default(ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor, ConstantValue constantValue, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        if ((n & 1) != 0) {
            boolean bl5 = bl = !(constantValue instanceof NullValue);
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        return constantExpressionEvaluatorVisitor.wrap(constantValue, bl, bl2, bl3, bl4);
    }

    public ConstantExpressionEvaluatorVisitor(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.trace = trace;
        this.factory = this.constantExpressionEvaluator.getConstantValueFactory();
        this.stringExpressionEvaluator = new JetVisitor<TypedCompileTimeConstant<? extends String>, Void>(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(stringExpressionEvaluator.1.class);
            }

            private final TypedCompileTimeConstant<String> createStringConstant(CompileTimeConstant<?> compileTimeConstant) {
                ConstantValue<?> constantValue;
                JetType jetType = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkExpressionValueIsNotNull(jetType, "TypeUtils.NO_EXPECTED_TYPE");
                ConstantValue<?> constantValue2 = constantValue = compileTimeConstant.toConstantValue(jetType);
                if (constantValue2 instanceof ErrorValue || constantValue2 instanceof EnumValue) {
                    return null;
                }
                return ConstantExpressionEvaluatorVisitor.access$wrap$2(this.this$0, constantValue2 instanceof NullValue ? ConstantExpressionEvaluatorVisitor.access$getFactory$0(this.this$0).createStringValue("null") : ConstantExpressionEvaluatorVisitor.access$getFactory$0(this.this$0).createStringValue(String.valueOf(constantValue.getValue())), compileTimeConstant.getParameters());
            }

            @Nullable
            public final TypedCompileTimeConstant<String> evaluate(@NotNull JetStringTemplateEntry entry) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                return (TypedCompileTimeConstant)entry.accept(this, null);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public TypedCompileTimeConstant<String> visitStringTemplateEntryWithExpression(@NotNull JetStringTemplateEntryWithExpression entry, @Nullable Void data2) {
                TypedCompileTimeConstant<String> typedCompileTimeConstant;
                JetExpression expression;
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                JetExpression jetExpression = entry.getExpression();
                if (jetExpression == null) {
                    return null;
                }
                JetExpression jetExpression2 = expression = jetExpression;
                Intrinsics.checkExpressionValueIsNotNull(jetExpression2, "expression");
                CompileTimeConstant<?> compileTimeConstant = this.this$0.evaluate(jetExpression2, ConstantExpressionEvaluatorVisitor.access$getConstantExpressionEvaluator$4(this.this$0).getBuiltIns().getStringType());
                if (compileTimeConstant != null) {
                    void $receiver;
                    CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
                    CompileTimeConstant it = (CompileTimeConstant)$receiver;
                    typedCompileTimeConstant = stringExpressionEvaluator.1.access$createStringConstant$0(this, it);
                } else {
                    typedCompileTimeConstant = null;
                }
                return typedCompileTimeConstant;
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitLiteralStringTemplateEntry(@NotNull JetLiteralStringTemplateEntry entry, @Nullable Void data2) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                ConstantValueFactory constantValueFactory = ConstantExpressionEvaluatorVisitor.access$getFactory$0(this.this$0);
                String string = entry.getText();
                Intrinsics.checkExpressionValueIsNotNull(string, "entry.getText()");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, constantValueFactory.createStringValue(string), false, false, false, false, 15);
            }

            @NotNull
            public TypedCompileTimeConstant<String> visitEscapeStringTemplateEntry(@NotNull JetEscapeStringTemplateEntry entry, @Nullable Void data2) {
                Intrinsics.checkParameterIsNotNull(entry, "entry");
                ConstantValueFactory constantValueFactory = ConstantExpressionEvaluatorVisitor.access$getFactory$0(this.this$0);
                String string = entry.getUnescapedValue();
                Intrinsics.checkExpressionValueIsNotNull(string, "entry.getUnescapedValue()");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, constantValueFactory.createStringValue(string), false, false, false, false, 15);
            }
            {
                this.this$0 = $outer;
            }

            @Nullable
            public static final /* synthetic */ TypedCompileTimeConstant<String> access$createStringConstant$0(stringExpressionEvaluator.1 $this, @NotNull CompileTimeConstant<?> compileTimeConstant) {
                return $this.createStringConstant(compileTimeConstant);
            }
        };
    }

    @NotNull
    public static final /* synthetic */ ConstantValueFactory access$getFactory$0(ConstantExpressionEvaluatorVisitor $this) {
        return $this.factory;
    }

    @NotNull
    public static final /* synthetic */ <T> TypedCompileTimeConstant<T> access$wrap$2(ConstantExpressionEvaluatorVisitor $this, ConstantValue<? extends T> $receiver, @NotNull CompileTimeConstant.Parameters parameters2) {
        return $this.wrap($receiver, parameters2);
    }

    @NotNull
    public static final /* synthetic */ <T> TypedCompileTimeConstant<T> access$wrap$3(ConstantExpressionEvaluatorVisitor $this, ConstantValue<? extends T> $receiver, boolean canBeUsedInAnnotation, boolean isPure, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant) {
        return $this.wrap($receiver, canBeUsedInAnnotation, isPure, usesVariableAsConstant, usesNonConstValAsConstant);
    }

    @NotNull
    public static final /* synthetic */ ConstantExpressionEvaluator access$getConstantExpressionEvaluator$4(ConstantExpressionEvaluatorVisitor $this) {
        return $this.constantExpressionEvaluator;
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"u\u0004)\tr\n]3sCRLwN\\!sOVlWM\u001c;\u000bE\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s-&\u001c\u0018\u000e^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\nG>t7\u000f^1oiNT\u0001\"\u001a<bYV\fG/\u001a\u0006\u0004\u0003:L(B\u0002\u001fj]&$hHC\u0003wC2,XMC\u0004di\u000e$\u0016\u0010]3\u000b\u001f\r{W\u000e]5mKRKW.\u001a+za\u0016T!\"\u001a=qe\u0016\u001c8/[8o\u00155QU\r^#yaJ,7o]5p]*\u0019\u0001o]5\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0004PE*,7\r\u001e\u0006\u000bO\u0016$8\t^2UsB,'\"D4fi\u0016C\bO]3tg&|gN\u0003\u0005hKR4\u0016\r\\;fa*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)!\u0001\u0002\u0002\t\b\u0015\u0019AQ\u0001E\u0001\u0019\u0001)1\u0001B\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!A\u0001\u0003\u0003\r\u0001\u0015\u0019AQ\u0001\u0005\u0007\u0019\u0001)!\u0001B\u0001\t\u0010\u0015\u0019A1\u0002\u0005\b\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u00115\u0001\u0012C\u0003\u0003\t\u001dA\u0011\"\u0002\u0002\u0005\u0006!1QA\u0001C\u0006\u0011\u001d!\u0011\u0001d\u0002\u001a\u0007\u0015\t\u0001\u0012\u0002M\u0005[I!1\r\u0002M\u0006C\u0015)\u0011\u0001C\u0003\n\u0003\u0011\r\u0001$B+\u0004\u0011\u0015\u0019A1B\u0005\u0002\u0011!i1\u0001b\u0005\n\u0003!AQ\u0006\u0005\u0003d\ta5\u0011eA\u0003\u0002\u0011\u0019Ab!V\u0002\t\u000b\r!i!C\u0001\t\u00125\u0019AAC\u0005\u0002\u0011#i\u0003\u0003B2\u00051\u0015\t3!B\u0001\t\na%Qk\u0001\u0005\u0006\u0007\u0011)\u0011\"\u0001E\b\u001b\r!)\"C\u0001\t\u0010UnS\u0011\f\u0003d\u0002a%Qt\u0002\u0003\u0001\u0011\u0015i1!B\u0001\t\na%\u0001k\u0001\u0001\u001e\u0014\u0011\u0001\u00012B\u0007\u0006\u000b\u0005AQ!C\u0001\u0005\u0004a)\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001RB\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0005\t3!B\u0001\t\ba\u001d\u0011kA\u0005\u0005\n%\tA\u0001A\u0007\u0002\u0011\u001fi\u0011\u0001\u0003\u0005\u000e\u0003!E\u0001"})
    private static final class OperationArgument {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType<?> ctcType;
        @NotNull
        private final JetExpression expression;

        static {
            $kotlinClass = Reflection.createKotlinClass(OperationArgument.class);
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final CompileTimeType<?> getCtcType() {
            return this.ctcType;
        }

        @NotNull
        public final JetExpression getExpression() {
            return this.expression;
        }

        public OperationArgument(@NotNull Object value, @NotNull CompileTimeType<?> ctcType, @NotNull JetExpression expression) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            Intrinsics.checkParameterIsNotNull(ctcType, "ctcType");
            Intrinsics.checkParameterIsNotNull(expression, "expression");
            this.value = value;
            this.ctcType = ctcType;
            this.expression = expression;
        }
    }
}

