/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetStubbedPsiUtil;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.DeclarationScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProvider;
import org.jetbrains.kotlin.resolve.lazy.LazyDeclarationResolver;
import org.jetbrains.kotlin.resolve.lazy.LazyFileScope;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

public class DeclarationScopeProviderImpl
implements DeclarationScopeProvider {
    private final LazyDeclarationResolver lazyDeclarationResolver;
    private final FileScopeProvider fileScopeProvider;

    public DeclarationScopeProviderImpl(@NotNull LazyDeclarationResolver lazyDeclarationResolver, @NotNull FileScopeProvider fileScopeProvider) {
        if (lazyDeclarationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lazyDeclarationResolver", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "<init>"));
        }
        if (fileScopeProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileScopeProvider", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "<init>"));
        }
        this.lazyDeclarationResolver = lazyDeclarationResolver;
        this.fileScopeProvider = fileScopeProvider;
    }

    @Override
    @NotNull
    public LexicalScope getResolutionScopeForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementOfDeclaration", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
        }
        JetDeclaration jetDeclaration = JetStubbedPsiUtil.getPsiOrStubParent(elementOfDeclaration, JetDeclaration.class, false);
        assert (!(elementOfDeclaration instanceof JetDeclaration) || jetDeclaration == elementOfDeclaration) : "For JetDeclaration element getParentOfType() should return itself.";
        assert (jetDeclaration != null) : "Should be contained inside declaration.";
        JetDeclaration parentDeclaration = JetStubbedPsiUtil.getContainingDeclaration(jetDeclaration);
        if (jetDeclaration instanceof JetPropertyAccessor) {
            parentDeclaration = JetStubbedPsiUtil.getContainingDeclaration(parentDeclaration, JetDeclaration.class);
        }
        if (parentDeclaration == null) {
            LazyFileScope lazyFileScope = this.fileScopeProvider.getFileScope((JetFile)elementOfDeclaration.getContainingFile());
            if (lazyFileScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
            }
            return lazyFileScope;
        }
        if (parentDeclaration instanceof JetClassOrObject) {
            JetClassOrObject classOrObject = (JetClassOrObject)parentDeclaration;
            LazyClassDescriptor classDescriptor = (LazyClassDescriptor)this.lazyDeclarationResolver.getClassDescriptor(classOrObject, NoLookupLocation.WHEN_GET_DECLARATION_SCOPE);
            if (jetDeclaration instanceof JetClassInitializer || jetDeclaration instanceof JetProperty) {
                LexicalScope lexicalScope = classDescriptor.getScopeForInitializerResolution();
                if (lexicalScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
                }
                return lexicalScope;
            }
            if (jetDeclaration instanceof JetObjectDeclaration || jetDeclaration instanceof JetClass && !((JetClass)jetDeclaration).isInner()) {
                LexicalScope lexicalScope = classDescriptor.getScopeForStaticMemberDeclarationResolution();
                if (lexicalScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
                }
                return lexicalScope;
            }
            LexicalScope lexicalScope = classDescriptor.getScopeForMemberDeclarationResolution();
            if (lexicalScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getResolutionScopeForDeclaration"));
            }
            return lexicalScope;
        }
        throw new IllegalStateException("Don't call this method for local declarations: " + jetDeclaration + "\n" + PsiUtilPackage.getElementTextWithContext(jetDeclaration));
    }

    @Override
    @NotNull
    public DataFlowInfo getOuterDataFlowInfoForDeclaration(@NotNull PsiElement elementOfDeclaration) {
        if (elementOfDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementOfDeclaration", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getOuterDataFlowInfoForDeclaration"));
        }
        DataFlowInfo dataFlowInfo = DataFlowInfo.EMPTY;
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/DeclarationScopeProviderImpl", "getOuterDataFlowInfoForDeclaration"));
        }
        return dataFlowInfo;
    }
}

