/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.KotlinOutputParserHelper;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"d\b))1i\u0014'P\u001d*11\u000b\u001e:j]\u001eTaa[8uY&t'\u0002\u00026bm\u0006TA\u0001\\1oO*Aq-\u001a;D\u001f2{eJ\u0003\u000eL_Rd\u0017N\\(viB,H\u000fU1sg\u0016\u0014\b*\u001a7qKJ\\EO\u0003\tQ\u001fNKE+S(O?B\u000bE\u000bV#S\u001d*9\u0001+\u0019;uKJt'\u0002B;uS2TQA]3hKbTqc[8uY&tgF\u001b<n]Ac\u0017\r\u001e4pe6$\u0016\u0010]3\u000b'\u001d,G\u000fU(T\u0013RKuJT0Q\u0003R#VI\u0015(\u000b\u0015\u0005$G-T3tg\u0006<WMC\u0004nKN\u001c\u0018mZ3\u000b\u0007\u0005s\u0017P\u0003\u0005nKN\u001c\u0018mZ3t\u0015-iU\u000f^1cY\u0016d\u0015n\u001d;\u000b\u000f\t{w\u000e\\3b]*1qJ\u00196fGRTA\u0001T5ti*)\u0001/\u0019:tK*!A.\u001b8f\u0015\u0019\u0011X-\u00193fe*\u0001r*\u001e;qkRd\u0015N\\3SK\u0006$WM\u001d\u0006\u0004G>l'bB1oIJ|\u0017\u000e\u001a\u0006\u0004S\u0012,'BB2p[6|gNC\u0003cY\u0006lWM\u0003\u0004qCJ\u001cXM\u001d\u0006\u0007Y><w-\u001a:\u000b\u000f%cunZ4fe*)Q\u000f^5mg*1\u0012-\\3oI:+\u0007\u0010\u001e'j]\u0016\u001c\u0018J\u001a(fK\u0012,GMC\u0003d_2|gNC\u0002J]RTQ\"[:OKb$X*Z:tC\u001e,'BD:lSB$%/\u001b<f\u001f:<\u0016N\u001c\u0006\u0019gR\f'\u000f^:XSRD7+\u001a<fe&$\u0018\u0010\u0015:fM&D(\"F:vEN$(/\u001b8h\u0003\u001a$XM]!oIR\u0013\u0018.\u001c\u0006\u0006S:$W\r\u001f\u0006\u0017gV\u00147\u000f\u001e:j]\u001e\u0014UMZ8sK\u0006sG\r\u0016:j[2\u000e!B\u0001\t\u0003\u0015\u0019A\u0001\u0001E\u0001\u0019\u0001)\u0011\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A\t!\u0002\u0002\u0005\u0003!%QA\u0001C\u0003\u0011\u0015)1\u0001B\u0002\t\t1\u0001QA\u0001\u0003\u0004\u0011\u0011)1\u0001\u0002\u0001\t\u00101\u0001Qa\u0001\u0003\u0001\u0011#a\u0001!B\u0002\u0005\u0001!IA\u0002A\u0003\u0003\t\u0007A\u0019\"\u0002\u0002\u0005\u0006!QQ!\u0001E\r\u000b\t!q\u0001C\u0007\u0006\u0005\u0011=\u00012D\u0003\u0003\t!Aa\"\u0002\u0002\u0005\u0012!uQA\u0001\u0003\n\u0011=)!\u0001b\u0005\t\n\u0015\u0019AA\u0003\u0005\r\u0019\u0001)!\u0001b\u0004\t\"\u0015\u0019Aa\u0003\u0005\u0011\u0019\u0001)!\u0001\u0002\u0006\t\u0019\u0015\u0011Aa\u0003\u0005\u0011\u000b\r!\u0001\u0001\u0003\n\r\u0001\u0015\rB!\u0019\u000b\u0019\u0001\u0005\u001aQ!\u0001E\u00011\u0003)6\u0001C\u0003\u0004\t\u0001I\u0011\u0001\u0003\u0002\u000e\u0007\u0011\u0015\u0011\"\u0001\u0005\u00031\u000e\u0019Qq\u0006\u0003b\ta\u001d\u0011%C\u0003\u0002\u0011\u000f\u0001Z!\u0006\u0003\u0006\u0003!\u001dA\u0012\u0001M\u00041\u000f)6\u0001C\u0003\u0004\t\u000fI\u0011\u0001\u0003\u0003\u000e\u0007\u00111\u0011\"\u0001\u0005\u00051\u000e\u0019Qa\n\u0003\u00021\u001bi\n\u0002\u0002\u0001\t\u000f5!Q!\u0001E\u0005\u0019\u0003AJ\u0001U\u0002\u0001;3!\u0001\u0001\u0003\u0005\u000e\u0011\u0015\t\u0001\"B\u0005\u0005\u0013\r)\u0011\u0001#\u0003\u0019\na)\u0001k!\u0001\"\u0007\u0015\t\u00012\u0002M\u0006#\u000e9AQB\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0004\u000e\u0003!5\u0001lA\u0002\u0006w\u0011\u0019\u0001TCO\b\t\u0001A1\"D\u0002\u0006\u0003!\u0005\u0001\u0014\u0001)\u0004\u0001u=A\u0001\u0001E\f\u001b\r)\u0011\u0001#\u0006\u0019\u0016A\u001b\t!(\u0007\u0005\u0001!AQ\u0002C\u0003\u0002\u0011\u0015IA!C\u0002\u0006\u0003!%\u0001\u0014\u0002\r\u0006!\u000e\tQt\u0002\u0003\u0001\u0011?i1!B\u0001\t\u0018a]\u0001ka\u0001\"\u0007\u0015\t\u00012\u0002M\u0006#\u000eYAQC\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0002\u000e\u0003!aQ\"\u0001E\u0007\u001b\u0005AI\u0002W\u0002\u0004\u000bs!\u0011!F\u0002\u0006\u0003!\u0005\u0001\u0014\u0001\r\u0012;\u001f!\u0001\u0001c\u0006\u000e\u0007\u0015\t\u0001R\u0003M\u000b!\u000e\u0005\u0011eA\u0003\u0002\u0011\u0003A\n!U\u0002\b\tEI\u0011\u0001\u0003\u0002\u000e\u0003!\u0011Q\"\u0001\u0005\r1\u000e\u0019QA\u0005\u0003\u0002+\r)\u0011\u0001#\u0001\u0019\u0002a\r\u0012eA\u0003\u0002\u00115AR\"U\u0002\u0006\tGI\u0011\u0001\"\u0002\u000e\u0003!\u0011\u0001lA\u0002\u0006%\u0011\tQcA\u0003\u0002\u0011\u0003A\n\u0001'\n\"\u0007\u0015\t\u00012\u0002M\u0006#\u000e)AQE\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0002Y\u0007\r)I\u0004B\u0001\u0016\u0007\u0015\t\u0001\"\u0004\r\u000e1Miz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001E\u00011\u0003\u00016\u0011A\u0011\u0004\u000b\u0005AQ\u0002G\u0007R\u0007\u001d!1#C\u0001\u0005\u00065\tAQA\u0007\u0002\u0011\tA6aA\u0003\u0013\t\u0005)2!B\u0001\t\u0002a\u0005\u0001tE\u0011\u0004\u000b\u0005AY\u0001g\u0003R\u0007\u0015!9#C\u0001\u0005\u00025\t\u0001B\u0001-\u0004\u0007\u0015eB!A\u000b\u0004\u000b\u0005A\t\u0001'\u0001\u0019)u=A\u0001\u0001E\u0015\u001b\r)\u0011\u0001C\u0007\u0019\u001bA\u001b\t!I\u0002\u0006\u0003!\u0005\u0001\u0014A)\u0004\u000f\u0011!\u0012\"\u0001\u0005\u0003\u001b\u0005A!!D\u0001\u0005\u0006a\u001b1!\"\u000f\u0005\u0003U\u0019Q!\u0001E\u00011\u0003AR#h\u0004\u0005\u0001!%RbA\u0003\u0002\u00115AR\u0002UB\u0001C\r)\u0011\u0001#\u0001\u0019\u0002E\u001bq\u0001B\u000b\n\u0003!\u0011Q\"\u0001\u0005\u0003\u001b\u0005!)\u0001W\u0002\u0004"})
public final class KotlinOutputParserHelperKt {
    @NotNull
    static final String COLON = ":";
    static final Pattern POSITION_PATTERN;

    public static final boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Object> messages, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        int colonIndex1 = KotlinOutputParserHelperKt.colon(line);
        if (colonIndex1 < 0) {
            return false;
        }
        String severity = KotlinOutputParserHelperKt.substringBeforeAndTrim(line, colonIndex1);
        if (!KotlinOutputParserHelperKt.startsWithSeverityPrefix(severity)) {
            return false;
        }
        String lineWoSeverity = KotlinOutputParserHelperKt.substringAfterAndTrim(line, colonIndex1);
        int colonIndex2 = KotlinOutputParserHelperKt.skipDriveOnWin(KotlinOutputParserHelperKt.colon(lineWoSeverity), lineWoSeverity);
        if (colonIndex2 >= 0) {
            String path = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoSeverity, colonIndex2);
            File file = new File(path);
            if (!file.isFile() && Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)file.getName()), (Object)"kt") ^ true) {
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelper.createMessage$default(KotlinOutputParserHelper.INSTANCE$, logger, severity, KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader), null, null, null, null, 120), messages);
            }
            String lineWoPath = KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoSeverity, colonIndex2);
            int colonIndex3 = KotlinOutputParserHelperKt.colon(lineWoPath);
            if (colonIndex3 >= 0) {
                String position = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoPath, colonIndex3);
                Matcher matcher = POSITION_PATTERN.matcher(position);
                String message = KotlinOutputParserHelperKt.amendNextLinesIfNeeded(KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoPath, colonIndex3), reader);
                if (matcher.matches()) {
                    String lineNumber = matcher.group(1);
                    String symbolNumber = matcher.group(2);
                    if (lineNumber != null && symbolNumber != null) {
                        try {
                            return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelper.INSTANCE$.createMessage(logger, severity, message, path, StringsKt.toInt((String)lineNumber), StringsKt.toInt((String)symbolNumber), StringsKt.toInt((String)symbolNumber)), messages);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelper.createMessage$default(KotlinOutputParserHelper.INSTANCE$, logger, severity, message, null, null, null, null, 120), messages);
            }
            return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelper.createMessage$default(KotlinOutputParserHelper.INSTANCE$, logger, severity, KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader), null, null, null, null, 120), messages);
        }
        return false;
    }

    @NotNull
    public static final String getCOLON() {
        return COLON;
    }

    public static final Pattern getPOSITION_PATTERN() {
        return POSITION_PATTERN;
    }

    @NotNull
    public static final String amendNextLinesIfNeeded(String $receiver, @NotNull OutputLineReader reader) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        String nextLine = reader.readLine();
        StringBuilder builder = new StringBuilder($receiver);
        while (nextLine != null && !KotlinOutputParserHelperKt.isNextMessage(nextLine)) {
            builder.append("\n").append(nextLine);
            if (!reader.hasNextLine()) break;
            nextLine = reader.readLine();
        }
        if (nextLine != null) {
            reader.pushBack(nextLine);
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    public static final boolean isNextMessage(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int colonIndex1 = StringsKt.indexOf$default((String)$receiver, (String)COLON, (int)0, (boolean)false, (int)6);
        return colonIndex1 >= 0 && KotlinOutputParserHelperKt.startsWithSeverityPrefix(StringsKt.substring((String)$receiver, (int)0, (int)colonIndex1)) || StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILURE") || StringUtil.containsIgnoreCase((String)$receiver, (String)"FAILED");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean startsWithSeverityPrefix(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = StringsKt.trim((String)$receiver);
        switch (string.hashCode()) {
            case 119: {
                if (!string.equals("w")) return false;
                return true;
            }
            case 118: {
                if (!string.equals("v")) return false;
                return true;
            }
            case 101: {
                if (!string.equals("e")) return false;
                return true;
            }
            case 105: {
                if (!string.equals("i")) return false;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static final String substringAfterAndTrim(String $receiver, int index2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.trim((String)StringsKt.substring((String)$receiver, (int)(index2 + 1)));
    }

    @NotNull
    public static final String substringBeforeAndTrim(String $receiver, int index2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.trim((String)StringsKt.substring((String)$receiver, (int)0, (int)index2));
    }

    public static final int colon(String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return StringsKt.indexOf$default((String)$receiver, (String)COLON, (int)0, (boolean)false, (int)6);
    }

    public static final int skipDriveOnWin(int $receiver, @NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        return $receiver == 1 ? StringsKt.indexOf$default((String)line, (String)COLON, (int)($receiver + 1), (boolean)false, (int)4) : $receiver;
    }

    public static final boolean addMessage(@Nullable Object message, @NotNull List<Object> messages) {
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        if (message == null) {
            return false;
        }
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            Object lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = Intrinsics.areEqual((Object)lastMessage, (Object)message);
        }
        if (!duplicatesPrevious) {
            messages.add(message);
        }
        return true;
    }

    static {
        COLON = COLON;
        POSITION_PATTERN = Pattern.compile("\\(([0-9]*), ([0-9]*)\\)");
    }
}

