/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.kotlin.cfg.BlockInfo;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.psi.JetElement;

public class BreakableBlockInfo
extends BlockInfo {
    private final JetElement element;
    private final Label entryPoint;
    private final Label exitPoint;
    private final Set<Label> referablePoints = Sets.newHashSet();

    public BreakableBlockInfo(JetElement element2, Label entryPoint, Label exitPoint) {
        this.element = element2;
        this.entryPoint = entryPoint;
        this.exitPoint = exitPoint;
        this.markReferablePoints(entryPoint, exitPoint);
    }

    protected void markReferablePoints(Label ... labels) {
        Collections.addAll(this.referablePoints, labels);
    }

    public JetElement getElement() {
        return this.element;
    }

    public Label getEntryPoint() {
        return this.entryPoint;
    }

    public Label getExitPoint() {
        return this.exitPoint;
    }

    public Set<Label> getReferablePoints() {
        return this.referablePoints;
    }
}

