/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.protobuf.MessageLite;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Mutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ClassBuilderOnDemand;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PackagePartCodegen;
import org.jetbrains.kotlin.codegen.ScriptCodegen;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.fileClasses.FileClassesPackage;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.DiagnosticsPackage;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class PackageCodegen {
    private final ClassBuilderOnDemand v;
    private final GenerationState state;
    private final Collection<JetFile> files;
    private final Type packageClassType;
    private final PackageFragmentDescriptor packageFragment;
    private final PackageFragmentDescriptor compiledPackageFragment;
    private final List<DeserializedCallableMemberDescriptor> previouslyCompiledCallables;
    private final PackageParts packageParts;

    public PackageCodegen(@NotNull GenerationState state, @NotNull Collection<JetFile> files, @NotNull FqName fqName2) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/PackageCodegen", "<init>"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/codegen/PackageCodegen", "<init>"));
        }
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/PackageCodegen", "<init>"));
        }
        this.state = state;
        this.files = files;
        this.packageFragment = this.getOnlyPackageFragment(fqName2);
        this.packageClassType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(PackageClassUtils.getPackageClassFqName(fqName2));
        this.compiledPackageFragment = this.getCompiledPackageFragment(fqName2);
        this.previouslyCompiledCallables = PackageCodegen.filterDeserializedCallables(this.compiledPackageFragment);
        assert (this.packageFragment != null || this.compiledPackageFragment != null) : fqName2.asString() + " " + files;
        this.v = new ClassBuilderOnDemand(new Function0<ClassBuilder>(){

            public ClassBuilder invoke() {
                Collection files = PackageCodegen.this.files;
                JetFile sourceFile = PackageCodegen.this.getRepresentativePackageFile(files);
                ClassBuilder v = PackageCodegen.this.state.getFactory().newVisitor(DiagnosticsPackage.PackageFacade(PackageCodegen.this.packageFragment == null ? PackageCodegen.this.compiledPackageFragment : PackageCodegen.this.packageFragment), PackageCodegen.this.packageClassType, PackagePartClassUtils.getFilesWithCallables(files));
                v.defineClass((PsiElement)sourceFile, 50, 131089, PackageCodegen.this.packageClassType.getInternalName(), null, "java/lang/Object", ArrayUtil.EMPTY_STRING_ARRAY);
                if (sourceFile != null) {
                    v.visitSource(sourceFile.getName(), null);
                }
                return v;
            }
        });
        this.packageParts = new PackageParts(fqName2.asString());
    }

    @Nullable
    private JetFile getRepresentativePackageFile(@NotNull Collection<JetFile> packageFiles) {
        if (packageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFiles", "org/jetbrains/kotlin/codegen/PackageCodegen", "getRepresentativePackageFile"));
        }
        if (!this.previouslyCompiledCallables.isEmpty()) {
            return null;
        }
        List<JetFile> packageFilesWithCallables = PackagePartClassUtils.getFilesWithCallables(packageFiles);
        return packageFilesWithCallables.size() == 1 ? packageFilesWithCallables.get(0) : null;
    }

    @Nullable
    private PackageFragmentDescriptor getCompiledPackageFragment(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/codegen/PackageCodegen", "getCompiledPackageFragment"));
        }
        if (!IncrementalCompilation.isEnabled()) {
            return null;
        }
        for (PackageFragmentDescriptor fragment : this.state.getModule().getPackage(fqName2).getFragments()) {
            if (!(fragment instanceof IncrementalPackageFragmentProvider.IncrementalPackageFragment) || !((IncrementalPackageFragmentProvider.IncrementalPackageFragment)fragment).getTarget().equals(this.state.getTargetId())) continue;
            return fragment;
        }
        return null;
    }

    @NotNull
    private static List<DeserializedCallableMemberDescriptor> filterDeserializedCallables(@Nullable PackageFragmentDescriptor packageFragment) {
        if (packageFragment == null) {
            List<DeserializedCallableMemberDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/PackageCodegen", "filterDeserializedCallables"));
            }
            return list;
        }
        ArrayList callables = Lists.newArrayList();
        for (DeclarationDescriptor member : packageFragment.getMemberScope().getDescriptors(DescriptorKindFilter.CALLABLES, JetScope.ALL_NAME_FILTER)) {
            if (!(member instanceof DeserializedCallableMemberDescriptor)) continue;
            callables.add((DeserializedCallableMemberDescriptor)member);
        }
        ArrayList arrayList = callables;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/PackageCodegen", "filterDeserializedCallables"));
        }
        return arrayList;
    }

    private void generateDelegationsToPreviouslyCompiled(@NotNull @Mutable Map<CallableMemberDescriptor, Runnable> generateCallableMemberTasks) {
        if (generateCallableMemberTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generateCallableMemberTasks", "org/jetbrains/kotlin/codegen/PackageCodegen", "generateDelegationsToPreviouslyCompiled"));
        }
        for (final DeserializedCallableMemberDescriptor member : this.previouslyCompiledCallables) {
            generateCallableMemberTasks.put(member, new Runnable(){

                @Override
                public void run() {
                    FieldOwnerContext context = PackageCodegen.this.state.getRootContext().intoPackageFacade(AsmUtil.asmTypeByFqNameWithoutInnerClasses(PackagePartClassUtils.getPackagePartFqName(member)), PackageCodegen.this.compiledPackageFragment);
                    MemberCodegen memberCodegen = PackageCodegen.this.createCodegenForPartOfPackageFacade(context);
                    if (member instanceof DeserializedSimpleFunctionDescriptor) {
                        DeserializedSimpleFunctionDescriptor function2 = (DeserializedSimpleFunctionDescriptor)member;
                        memberCodegen.functionCodegen.generateMethod(DiagnosticsPackage.OtherOrigin(function2), function2, new FunctionGenerationStrategy(){

                            @Override
                            public void generateBody(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull JvmMethodSignature signature, @NotNull MethodContext context, @NotNull MemberCodegen<?> parentCodegen) {
                                if (mv == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/PackageCodegen$2$1", "generateBody"));
                                }
                                if (frameMap == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameMap", "org/jetbrains/kotlin/codegen/PackageCodegen$2$1", "generateBody"));
                                }
                                if (signature == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/kotlin/codegen/PackageCodegen$2$1", "generateBody"));
                                }
                                if (context == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/PackageCodegen$2$1", "generateBody"));
                                }
                                if (parentCodegen == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCodegen", "org/jetbrains/kotlin/codegen/PackageCodegen$2$1", "generateBody"));
                                }
                                throw new IllegalStateException("shouldn't be called");
                            }
                        });
                        memberCodegen.functionCodegen.generateDefaultIfNeeded(context.intoFunction(function2), function2, OwnerKind.PACKAGE, DefaultParameterValueLoader.DEFAULT, null);
                        memberCodegen.functionCodegen.generateOverloadsWithDefaultValues(null, function2, function2);
                    } else if (member instanceof DeserializedPropertyDescriptor) {
                        memberCodegen.propertyCodegen.generateInPackageFacade((DeserializedPropertyDescriptor)member);
                    } else {
                        throw new IllegalStateException("Unexpected member: " + member);
                    }
                }
            });
        }
    }

    public void generate(@NotNull CompilationErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/kotlin/codegen/PackageCodegen", "generate"));
        }
        ArrayList<JvmSerializationBindings> bindings = new ArrayList<JvmSerializationBindings>(this.files.size() + 1);
        HashMap<CallableMemberDescriptor, Runnable> generateCallableMemberTasks = new HashMap<CallableMemberDescriptor, Runnable>();
        for (JetFile file : this.files) {
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            try {
                ClassBuilder builder = this.generateFile(file, generateCallableMemberTasks);
                if (builder == null) continue;
                bindings.add(builder.getSerializationBindings());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                VirtualFile vFile = file.getVirtualFile();
                errorHandler.reportException(e, vFile == null ? "no file" : vFile.getUrl());
                DiagnosticUtils.throwIfRunningOnServer(e);
                if (!ApplicationManager.getApplication().isInternal()) continue;
                e.printStackTrace();
            }
        }
        this.generateDelegationsToPreviouslyCompiled(generateCallableMemberTasks);
        if (!generateCallableMemberTasks.isEmpty()) {
            this.generatePackageFacadeClass(generateCallableMemberTasks, bindings);
        }
    }

    private void generatePackageFacadeClass(@NotNull Map<CallableMemberDescriptor, Runnable> tasks, @NotNull List<JvmSerializationBindings> bindings) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "org/jetbrains/kotlin/codegen/PackageCodegen", "generatePackageFacadeClass"));
        }
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "org/jetbrains/kotlin/codegen/PackageCodegen", "generatePackageFacadeClass"));
        }
        this.generateKotlinPackageReflectionField();
        MemberCodegen.generateModuleNameField(this.state, this.v);
        for (CallableMemberDescriptor member : Ordering.from((Comparator)MemberComparator.INSTANCE).sortedCopy(tasks.keySet())) {
            tasks.get(member).run();
        }
        bindings.add(this.v.getSerializationBindings());
        this.writeDeprecatedAnnotation();
        this.writeKotlinPackageAnnotationIfNeeded(JvmSerializationBindings.union(bindings));
    }

    private void generateKotlinPackageReflectionField() {
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 8, "<clinit>", "()V", null, null);
        Method method = AsmUtil.method("createKotlinPackage", AsmTypes.K_PACKAGE_TYPE, AsmTypes.getType(Class.class), AsmTypes.getType(String.class));
        InstructionAdapter iv = new InstructionAdapter(mv);
        MemberCodegen.generateReflectionObjectField(this.state, this.packageClassType, this.v, method, "$kotlinPackage", iv);
        iv.areturn(Type.VOID_TYPE);
        FunctionCodegen.endVisit(mv, "package facade static initializer", null);
    }

    private void writeKotlinPackageAnnotationIfNeeded(@NotNull JvmSerializationBindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "org/jetbrains/kotlin/codegen/PackageCodegen", "writeKotlinPackageAnnotationIfNeeded"));
        }
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        for (JetFile file : this.files) {
            if (!file.isScript()) continue;
            return;
        }
        DescriptorSerializer serializer = DescriptorSerializer.createTopLevel(new JvmSerializerExtension(bindings, this.state.getTypeMapper()));
        ArrayList packageFragments2 = Lists.newArrayList();
        ContainerUtil.addIfNotNull((Collection)packageFragments2, (Object)this.packageFragment);
        ContainerUtil.addIfNotNull((Collection)packageFragments2, (Object)this.compiledPackageFragment);
        ProtoBuf.Package packageProto = serializer.packageProtoWithoutDescriptors().build();
        AnnotationVisitor av = this.v.newAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE), true);
        JvmCodegenUtil.writeAbiVersion(av);
        AnnotationVisitor array = av.visitArray("data");
        for (String string : BitEncoding.encodeBytes(serializer.serialize((MessageLite)packageProto))) {
            array.visit(null, (Object)string);
        }
        array.visitEnd();
        av.visitEnd();
    }

    private void writeDeprecatedAnnotation() {
        AnnotationVisitor av = this.v.newAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.JAVA_LANG_DEPRECATED), true);
        av.visitEnd();
    }

    @Nullable
    private ClassBuilder generateFile(@NotNull JetFile file, @NotNull Map<CallableMemberDescriptor, Runnable> generateCallableMemberTasks) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/PackageCodegen", "generateFile"));
        }
        if (generateCallableMemberTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generateCallableMemberTasks", "org/jetbrains/kotlin/codegen/PackageCodegen", "generateFile"));
        }
        JvmFileClassInfo fileClassInfo = this.state.getFileClassesProvider().getFileClassInfo(file);
        if (fileClassInfo.getIsMultifileClass()) {
            Type fileFacadeType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo.getFacadeClassFqName());
            this.addDelegateToFileClassMemberTasks(file, generateCallableMemberTasks, fileFacadeType);
            return null;
        }
        Type fileClassType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fileClassInfo.getFileClassFqName());
        PackageContext packagePartContext = this.state.getRootContext().intoPackagePart(this.packageFragment, fileClassType);
        boolean generatePackagePart = false;
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (declaration instanceof JetProperty || declaration instanceof JetNamedFunction) {
                generatePackagePart = true;
                continue;
            }
            if (declaration instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)declaration;
                if (!this.state.getGenerateDeclaredClassFilter().shouldGenerateClass(classOrObject)) continue;
                this.generateClassOrObject(classOrObject);
                continue;
            }
            if (!(declaration instanceof JetScript)) continue;
            JetScript script = (JetScript)declaration;
            if (!this.state.getGenerateDeclaredClassFilter().shouldGenerateScript(script)) continue;
            ScriptCodegen.createScriptCodegen(script, this.state, packagePartContext).generate();
        }
        if (!generatePackagePart || !this.state.getGenerateDeclaredClassFilter().shouldGeneratePackagePart(file)) {
            return null;
        }
        String name2 = fileClassType.getInternalName();
        this.packageParts.getParts().add(name2.substring(name2.lastIndexOf(47) + 1));
        ClassBuilder builder = this.state.getFactory().newVisitor(DiagnosticsPackage.PackagePart(file, this.packageFragment), fileClassType, (PsiFile)file);
        new PackagePartCodegen(builder, file, fileClassType, packagePartContext, this.state).generate();
        this.addDelegateToFileClassMemberTasks(file, generateCallableMemberTasks, fileClassType);
        return builder;
    }

    private void addDelegateToFileClassMemberTasks(@NotNull JetFile file, @NotNull Map<CallableMemberDescriptor, Runnable> generateCallableMemberTasks, @NotNull Type fileClassType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/codegen/PackageCodegen", "addDelegateToFileClassMemberTasks"));
        }
        if (generateCallableMemberTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generateCallableMemberTasks", "org/jetbrains/kotlin/codegen/PackageCodegen", "addDelegateToFileClassMemberTasks"));
        }
        if (fileClassType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassType", "org/jetbrains/kotlin/codegen/PackageCodegen", "addDelegateToFileClassMemberTasks"));
        }
        FieldOwnerContext packageFacade = this.state.getRootContext().intoPackageFacade(fileClassType, this.packageFragment);
        final MemberCodegen<?> memberCodegen = this.createCodegenForPartOfPackageFacade(packageFacade);
        for (final JetDeclaration declaration : file.getDeclarations()) {
            if (!(declaration instanceof JetNamedFunction) && !(declaration instanceof JetProperty)) continue;
            DeclarationDescriptor descriptor2 = this.state.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
            assert (descriptor2 instanceof CallableMemberDescriptor) : "Expected callable member, was " + descriptor2 + " for " + declaration.getText();
            generateCallableMemberTasks.put((CallableMemberDescriptor)descriptor2, new Runnable(){

                @Override
                public void run() {
                    memberCodegen.genFunctionOrProperty(declaration);
                }
            });
        }
    }

    private MemberCodegen<?> createCodegenForPartOfPackageFacade(@NotNull FieldOwnerContext packageFacade) {
        if (packageFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFacade", "org/jetbrains/kotlin/codegen/PackageCodegen", "createCodegenForPartOfPackageFacade"));
        }
        return new MemberCodegen<JetFile>(this.state, null, packageFacade, null, (ClassBuilder)this.v){

            @Override
            protected void generateDeclaration() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void generateBody() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void generateKotlinAnnotation() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Nullable
    private PackageFragmentDescriptor getOnlyPackageFragment(@NotNull FqName expectedFqName) {
        if (expectedFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFqName", "org/jetbrains/kotlin/codegen/PackageCodegen", "getOnlyPackageFragment"));
        }
        SmartList fragments2 = new SmartList();
        for (JetFile file : this.files) {
            PackageFragmentDescriptor fragment = this.state.getBindingContext().get(BindingContext.FILE_TO_PACKAGE_FRAGMENT, file);
            assert (fragment != null) : "package fragment is null for " + file + "\n" + file.getText();
            assert (expectedFqName.equals(fragment.getFqName())) : "expected package fq name: " + expectedFqName + ", actual: " + fragment.getFqName();
            if (fragments2.contains((Object)fragment)) continue;
            fragments2.add((Object)fragment);
        }
        if (fragments2.size() > 1) {
            throw new IllegalStateException("More than one package fragment, files: " + this.files + " | fragments: " + fragments2);
        }
        if (fragments2.isEmpty()) {
            return null;
        }
        return (PackageFragmentDescriptor)fragments2.get(0);
    }

    public void generateClassOrObject(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/kotlin/codegen/PackageCodegen", "generateClassOrObject"));
        }
        JetFile file = classOrObject.getContainingJetFile();
        Type packagePartType = FileClassesPackage.getFileClassType(this.state.getFileClassesProvider(), file);
        PackageContext context = this.state.getRootContext().intoPackagePart(this.packageFragment, packagePartType);
        MemberCodegen.genClassOrObject(context, classOrObject, this.state, null);
    }

    public void done() {
        this.v.done();
    }

    public PackageParts getPackageParts() {
        return this.packageParts;
    }

    public Collection<JetFile> getFiles() {
        return this.files;
    }
}

