/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.KotlinConsoleKeeperKt;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u000f\n)\u00192j\u001c;mS:\u001cuN\\:pY\u0016\\U-\u001a9fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004d_:\u001cx\u000e\\3\u000b\u0007\u0005s\u0017P\u0003\u0004=S:LGO\u0010\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRT1aY8n\u0015!Ig\u000e^3mY&T'bB8qK:\f\u0007/\u001b\u0006\u000bG>t7o\u001c7f\u001b\u0006\u0004(BC'vi\u0006\u0014G.Z'ba*Ya+\u001b:uk\u0006dg)\u001b7f\u0015\r1hm\u001d\u0006\u0014\u0017>$H.\u001b8D_:\u001cx\u000e\\3Sk:tWM\u001d\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'bA'ba*Qq-\u001a;Qe>TWm\u0019;\u000b/\u0005$G\rU1uQR{7i\\7qS2,GmT;uaV$(\"\u00039be\u0006lG*[:u\u00159\u0001\u0016M]1nKR,'o\u001d'jgRT\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u001d\r|gNZ5hkJ\fG/[8og*1Qn\u001c3vY\u0016Ta!T8ek2,'\u0002B+oSRT\u0011c\u0019:fCR,7i\\7nC:$G*\u001b8f\u0015I9UM\\3sC2\u001cu.\\7b]\u0012d\u0015N\\3\u000b7\r\u0014X-\u0019;f\u0015\u00064\u0018\rU1sC6,G/\u001a:t/&$\bn\u00153l\u00159Q\u0015M^1QCJ\fW.\u001a;feNTqcZ3u\u0007>t7o\u001c7f\u0005f4\u0016N\u001d;vC24\u0015\u000e\\3\u000b\u0017YL'\u000f^;bY\u001aKG.\u001a\u0006\u0018aV$h+\u001b:uk\u0006dg)\u001b7f)>\u001cuN\\:pY\u0016TQB]3n_Z,7i\u001c8t_2,'b\u0001:v]*AA/Z:u\u001b>$WMC\u0004C_>dW-\u00198\u000b3A\u0014XM^5pkN\u001cu.\u001c9jY\u0006$\u0018n\u001c8GC&dW\r\u001a\u0006\n\u0007>l\u0007/\u00198j_:\u0014\u001fA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\u0006!\u0015A\u0002A\u0003\u0002\u0011\u0013)!\u0001b\u0002\t\u000b\u0015\u0011A\u0001\u0002E\u0006\u000b\t!I\u0001c\u0002\u0006\u0007\u0011)\u0001\u0002\u0002\u0007\u0001\u000b\t!Q\u0001\u0003\u0003\u0006\u0007\u0011\u0015\u0001R\u0002\u0007\u0001\u000b\t!I\u0001c\u0004\u0006\u0007\u00119\u0001b\u0002\u0007\u0001\u000b\r!\u0019\u0001\u0003\u0005\r\u0001\u0015\t\u0001\u0012C\u0003\u0003\t#A\u0011\"\u0002\u0002\u0005\u0013!MQA\u0001\u0003\u0005\u00111)!\u0001\u0002\u0006\t\u001a\u0015\u0019AQ\u0003E\f\u0019\u0001)!\u0001\"\u0003\t\u001b\u0015\u0019Aq\u0003E\u000e\u0019\u0001)1\u0001\"\u0002\t\u001d1\u0001QA\u0001C\u000b\u0011/)!\u0001b\u0006\t\u001c\u0015\u0019AQ\u0003\u0005\u0010\u0019\u0001)!\u0001\"\u0006\t\u001f\u0015\u0019AQ\u0003\u0005\u0011\u0019\u0001)!\u0001\"\u0006\t!\u0015\u0011A1\u0001\u0005\t\u000b\t!q\u0001C\u0004\u0006\u0007\u0011\u0015\u0001r\u0005\u0007\u0001\t\ra!\u0001%\u000b\u001a\u0007\u0015\t\u0001b\u0001\r\u0004;\u0003%RF\u0006\u0003b\ta1\u0011%D\u0003\u0002\u0011\u001bIA!C\u0002\u0006\u0003!=\u0001tB\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011a5Qk\u0001\u0003\u0006\u0007\u00111\u0011\"\u0001E\n[A!1\r\u0002M\u0004C\r)\u0011\u0001c\u0003\u0019\fU\u001b\u0001\"B\u0002\u0005\b%\t\u0001BB\u0007\u0004\t)I\u0011\u0001\u0003\u0004.@\u0011\t\u0001TCO\b\t\u0001A1\"D\u0002\u0006\u0003!Y\u0001d\u0003)\u0004\u0001u=A\u0001\u0001\u0005\u000e\u001b\r)\u0011\u0001\u0003\u0007\u0019\u0019A\u001b\t!I\u0002\u0006\u0003!e\u0001\u0014D)\u0004\u000f\u0011U\u0011\"\u0001\u0003\u0001\u001b\u0005AQ\"D\u0001\t\u001c52B!\u0001M\u000f;\u001f!\u0001\u0001C\u0007\u000e\u0007\u0015\t\u0001\u0002\u0004\r\r!\u000e\u0001\u0011\u0005B\u0003\u0002\u00119a\t\u0001\u0007\bR\u0007\u0015!i\"C\u0001\t\u001e5\t\u00012D\u0017\u0016\t\u0005Az\"h\u0004\u0005\u0001!iQbA\u0003\u0002\u00111AB\u0002U\u0002\u0001C\r)\u0011\u0001C\b\u0019\u001fE\u001bQ\u0001b\b\n\u0003!}Q\"\u0001E\u000e[Y!1\u0001'\t\u001e\u0010\u0011\u0001\u0001\"E\u0007\u0004\u000b\u0005Ay\u0001g\u0004Q\u0007\u0001\tC!B\u0001\t\u00111\u0005\u0001\u0004C)\u0004\u000b\u0011\u0005\u0012\"\u0001\u0005\u0011\u001b\u0005A\t#,\u0011\u0005\u0007a\rRt\u0002\u0003\u0001\u0011Ei1!B\u0001\t\u0010a=\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BA\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0003\tC!B\u0001\t\u00111\u0005\u0001\u0004C)\u0004\u000f\u0011\r\u0012\"\u0001\u0005\u0011\u001b\u0005A\t#D\u0001\t!52Ba\u0001\r\u0013;\u001f!\u0001\u0001C\t\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\u0001\u0011\u0005B\u0003\u0002\u0011!a\t\u0001\u0007\u0005R\u0007\u0015!!#C\u0001\t!5\t\u0001\u0012E\u0017,\t\rA*#h\u0004\u0005\u0001!iQbA\u0003\u0002\u00111AB\u0002U\u0002\u0001;\u001f!\u0011\u0001C\n\u000e\u0007\u0015\t\u0001\"\u0005\r\u0012!\u000e\u0005Qt\u0002\u0003\u0002\u0011Qi1!B\u0001\t#a\t\u0002kA\u0001\"\t\u0015\t\u0001\u0002\u0003G\u00011!\t6!\u0003C\u0013\u0013\u0005A\u0001#D\u0001\t\u001c5\tA\u0011A\u0007\u0002\t\u0003)l#b\u000b\u0005G\u0004A2!h\u0004\u0005\u0001!\u001dQbA\u0003\u0002\u0011\u0017AZ\u0001U\u0002\u0001C\r)\u0011\u0001\u0003\u0002\u0019\u0005E\u001bQ\u0001B\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u0007"})
public final class KotlinConsoleKeeper {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Map<VirtualFile, KotlinConsoleRunner> consoleMap;
    @NotNull
    private final Project project;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinConsoleKeeper.class);
        Companion companion = Companion = new Companion(null);
    }

    @Nullable
    public final KotlinConsoleRunner getConsoleByVirtualFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        return this.consoleMap.get(virtualFile);
    }

    @Nullable
    public final KotlinConsoleRunner putVirtualFileToConsole(@NotNull VirtualFile virtualFile, @NotNull KotlinConsoleRunner console) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)console), (String)"console");
        return this.consoleMap.put(virtualFile, console);
    }

    @Nullable
    public final KotlinConsoleRunner removeConsole(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        return this.consoleMap.remove(virtualFile);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KotlinConsoleRunner run(@NotNull Module module, boolean testMode, boolean previousCompilationFailed) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String path = module.getModuleFilePath();
        GeneralCommandLine generalCommandLine = this.createCommandLine(module);
        if (generalCommandLine == null) {
            void $receiver;
            KotlinConsoleKeeper kotlinConsoleKeeper = this;
            KotlinConsoleKeeper $receiver2 = (KotlinConsoleKeeper)$receiver;
            RunExecuteActionsKt.errorNotification($receiver2.getProject(), "Module SDK not found");
            return null;
        }
        GeneralCommandLine cmdLine = generalCommandLine;
        KotlinConsoleRunner consoleRunner = new KotlinConsoleRunner(module, cmdLine, testMode, previousCompilationFailed, this.project, KotlinConsoleKeeperKt.getREPL_TITLE(), path);
        consoleRunner.initAndRun();
        consoleRunner.setupGutters();
        return consoleRunner;
    }

    @Nullable
    public static /* synthetic */ KotlinConsoleRunner run$default(KotlinConsoleKeeper kotlinConsoleKeeper, Module module, boolean bl, boolean bl2, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return kotlinConsoleKeeper.run(module, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final GeneralCommandLine createCommandLine(Module module) {
        void destination;
        void $receiver;
        void $receiver2;
        SdkTypeId sdkType;
        JavaParameters javaParameters = this.createJavaParametersWithSdk(module);
        Sdk sdk = javaParameters.getJdk();
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        SdkTypeId sdkTypeId = sdkType = sdk2.getSdkType();
        if (sdkTypeId == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.projectRoots.JavaSdkType");
        }
        String exePath = ((JavaSdkType)sdkTypeId).getVMExecutablePath(sdk2);
        GeneralCommandLine commandLine = JdkUtil.setupJVMCommandLine((String)exePath, (SimpleJavaParameters)((SimpleJavaParameters)javaParameters), (boolean)true);
        ParametersList paramList = commandLine.getParametersList();
        paramList.clearAll();
        KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForIdeaPlugin();
        Iterable iterable = CollectionsKt.listOf((Object[])new File[]{kotlinPaths.getCompilerPath(), kotlinPaths.getReflectPath(), kotlinPaths.getRuntimePath()});
        void var11_10 = $receiver2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it;
            File file = (File)item;
            void var16_15 = destination;
            String string = it.getAbsolutePath();
            var16_15.add(string);
        }
        Iterable iterable2 = (List)destination;
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
        String replClassPath = CollectionsKt.joinToString$default((Iterable)iterable2, (String)string, null, null, (int)0, null, null, (int)62);
        paramList.add("-cp");
        paramList.add(replClassPath);
        paramList.add("-Dkotlin.repl.ideMode=true");
        paramList.add("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler");
        ParametersList parametersList = paramList;
        Intrinsics.checkExpressionValueIsNotNull((Object)parametersList, (String)"paramList");
        this.addPathToCompiledOutput(parametersList, module);
        return commandLine;
    }

    private final JavaParameters createJavaParametersWithSdk(Module module) {
        JavaParameters params2 = new JavaParameters();
        params2.setCharset((Charset)null);
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk != null && sdk.getSdkType() instanceof JavaSdkType && new File(sdk.getHomePath()).exists()) {
            params2.setJdk(sdk);
        }
        if (params2.getJdk() == null) {
            params2.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
        }
        return params2;
    }

    private final void addPathToCompiledOutput(ParametersList paramList, Module module) {
        String[] stringArray = CompilerPathsEx.getOutputPaths((Module[])new Module[]{module});
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
        String compiledModulePath = StringsKt.join$default((String[])stringArray, (String)string, null, null, (int)0, null, (int)30);
        String moduleDependencies = OrderEnumerator.orderEntries((Module)module).recursively().getPathsList().getPathsString();
        String compiledOutputClasspath = compiledModulePath + File.pathSeparator + moduleDependencies;
        paramList.add("-cp");
        paramList.add(compiledOutputClasspath);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinConsoleKeeper(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.consoleMap = new ConcurrentHashMap();
    }

    @JvmStatic
    public static final KotlinConsoleKeeper getInstance(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return Companion.getInstance(project);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0017\u0004)I1i\\7qC:LwN\u001c\u0006\u0014\u0017>$H.\u001b8D_:\u001cx\u000e\\3LK\u0016\u0004XM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*91m\u001c8t_2,'bA!os*Yq-\u001a;J]N$\u0018M\\2f\u0015\u001d\u0001(o\u001c6fGRTq\u0001\u0015:pU\u0016\u001cGOC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015]Yw\u000e\u001e7j]:Rg/\u001c\u0018QY\u0006$hm\u001c:n)f\u0004X\r\u0018\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\r!\u0019\u0001#\u0001\r\u0001\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u0011\u0019\u0001b\u0001\u0007\u0001\u000b\u0005AQ!\u0002\u0002\u0005\t!-QA\u0001C\u0005\u0011\u0019)!\u0001B\u0003\t\t\u0015\u0019A1\u0002E\u0005\u0019\u0001)!\u0001b\u0001\t\u0002\u0015\u0011A1\u0002E\u0005\t\r\u000fARA\r\u0004\u000b\u0005A9\u0001g\u0002.7\u0011\u001d\u0001tAO\b\t\u0001AA!D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0001\u0005JQ!\u0001\u0005\u0003!\u001b)B!B\u0001\t\u00051\u0005\u0001D\u0001\r\u0003#\u000e)AqA\u0005\u0002\u0011\u001bi\u0011\u0001C\u00046\u0001\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        @JvmStatic
        public final KotlinConsoleKeeper getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return (KotlinConsoleKeeper)ServiceManager.getService((Project)project, KotlinConsoleKeeper.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

