/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterLayer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.KotlinConsoleCompilerHelper;
import org.jetbrains.kotlin.console.KotlinConsoleExecutor;
import org.jetbrains.kotlin.console.KotlinConsoleHistoryManager;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.KotlinConsoleRunnerKt;
import org.jetbrains.kotlin.console.KotlinReplOutputHandler;
import org.jetbrains.kotlin.console.actions.BuildAndRestartConsoleAction;
import org.jetbrains.kotlin.console.actions.KtExecuteCommandAction;
import org.jetbrains.kotlin.console.gutter.IconWithTooltip;
import org.jetbrains.kotlin.console.gutter.KotlinConsoleGutterContentProvider;
import org.jetbrains.kotlin.console.gutter.KotlinConsoleIndicatorRenderer;
import org.jetbrains.kotlin.console.gutter.ReplIcons;
import org.jetbrains.kotlin.console.highlight.KotlinHistoryHighlighter;
import org.jetbrains.kotlin.console.highlight.KotlinReplOutputHighlighter;
import org.jetbrains.kotlin.console.highlight.ReplColors;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.idea.completion.KotlinCompletionContributorKt;
import org.jetbrains.kotlin.psi.JetFile;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\n\u001a)\u00192j\u001c;mS:\u001cuN\\:pY\u0016\u0014VO\u001c8fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0004d_:\u001cx\u000e\\3\u000bA\u0005\u00137\u000f\u001e:bGR\u001cuN\\:pY\u0016\u0014VO\u001c8fe^KG\u000f\u001b%jgR|'/\u001f\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u0013\u0015DXmY;uS>t'b\u0002:v]:,'o\u001d\u0006\u0014\u0019\u0006tw-^1hK\u000e{gn]8mKZKWm\u001e\u0006\u0007y%t\u0017\u000e\u001e \u000b\r5|G-\u001e7f\u0015\u0019iu\u000eZ;mK*9q\u000e]3oCBL'bB2nI2Kg.\u001a\u0006\u0013\u000f\u0016tWM]1m\u0007>lW.\u00198e\u0019&tWM\u0003\bd_:4\u0017nZ;sCRLwN\\:\u000b\u0011Q,7\u000f^'pI\u0016TqAQ8pY\u0016\fgNC\rqe\u00164\u0018n\\;t\u0007>l\u0007/\u001b7bi&|gNR1jY\u0016$'\"C7z!J|'.Z2u\u0015\u001d\u0001&o\u001c6fGRTq\u0001\u001d:pU\u0016\u001cGOC\u0003uSRdWM\u0003\u0004TiJLgn\u001a\u0006\u0005a\u0006$\bN\u0003\u0003kCZ\f'\u0002\u00027b]\u001eTq\u0001P:fi6zdHC\u000eL_Rd\u0017N\\\"p]N|G.Z\"p[BLG.\u001a:IK2\u0004XM\u001d\u0006\u000fG>l\u0007/\u001b7fe\"+G\u000e]3s\u0015]\u0019w.\u001c9jY\u0016\u0014\b*\u001a7qKJ$C-\u001a7fO\u0006$XM\u0003\u0006qe>\u0004XM\u001d;jKNT\u0011CU3bI^\u0013\u0018\u000e^3Qe>\u0004XM\u001d;z\u0015E9W\r^\"p[BLG.\u001a:IK2\u0004XM\u001d\u0006\u0012g\u0016$8i\\7qS2,'\u000fS3ma\u0016\u0014(\u0002\u0005*b]\u001e,\u0007*[4iY&<\u0007\u000e^3s\u0015\u0019)G-\u001b;pe*1Q.\u0019:lkBT\u0001dY8og>dW-\u00123ji>\u0014\b*[4iY&<\u0007\u000e^3s\u0015\u0005\u001awN\\:pY\u0016,E-\u001b;pe\"Kw\r\u001b7jO\"$XM\u001d\u0013eK2,w-\u0019;f\u0015m9W\r^\"p]N|G.Z#eSR|'\u000fS5hQ2Lw\r\u001b;fe*Y2/\u001a;D_:\u001cx\u000e\\3FI&$xN\u001d%jO\"d\u0017n\u001a5uKJTACU;o\u0007>tG/\u001a8u\t\u0016\u001c8M]5qi>\u0014(BA;j\u0015Q!\u0017n\u001d9pg\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*iB-[:q_N\f'\r\\3EKN\u001c'/\u001b9u_J$C-\u001a7fO\u0006$XMC\fhKR$\u0015n\u001d9pg\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*92/\u001a;ESN\u0004xn]1cY\u0016$Um]2sSB$xN\u001d\u0006\tKb,7-\u001e;pe*)2j\u001c;mS:\u001cuN\\:pY\u0016,\u00050Z2vi>\u0014(bC4fi\u0016CXmY;u_JT!\u0003[5ti>\u0014\u0018\u0010S5hQ2Lw\r\u001b;fe*A2j\u001c;mS:D\u0015n\u001d;pefD\u0015n\u001a5mS\u001eDG/\u001a:\u000b\u0013!Lw\r\u001b7jO\"$(B\u00045jgR|'/_'b]\u0006<WM\u001d\u0006\u001c\u0017>$H.\u001b8D_:\u001cx\u000e\\3ISN$xN]=NC:\fw-\u001a:\u000b\u0013\u001d,G/T8ek2,'BE1eI\u001e+H\u000f^3s\u0013:$\u0017nY1u_JT\u0001\"\u00123ji>\u0014X\t\u001f\u0006\u0003KbTq\"[2p]^KG\u000f\u001b+p_2$\u0018\u000e\u001d\u0006\u0010\u0013\u000e|gnV5uQR{w\u000e\u001c;ja*1q-\u001e;uKJTAd\u00195b]\u001e,7i\u001c8t_2,W\tZ5u_JLe\u000eZ5dCR|'O\u0003\noK^L5m\u001c8XSRDGk\\8mi&\u0004(\u0002B+oSRTQcY8ogR\u0014Xo\u0019;D_:\u001cx\u000e\\3USRdWMC\fde\u0016\fG/Z\"p]N|G.Z#yK\u000e\f5\r^5p]*Y2m\u001c8t_2,W\t_3dkR,\u0017i\u0019;j_:D\u0015M\u001c3mKJT\u0001\u0006\u0015:pG\u0016\u001c8OQ1dW\u0016$7i\u001c8t_2,W\t_3dkR,\u0017i\u0019;j_:D\u0015M\u001c3mKJTAcQ8og>dW-\u0012=fGV$X-Q2uS>t'\"E2sK\u0006$XmQ8og>dWMV5fo*Q2M]3bi\u0016,\u00050Z2vi\u0016\f5\r^5p]\"\u000bg\u000e\u001a7fe*i1M]3bi\u0016\u0004&o\\2fgNTq\u0001\u0015:pG\u0016\u001c8OC\u0004O_RtU\u000f\u001c7\u000b\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0015GJ,\u0017\r^3Qe>\u001cWm]:IC:$G.\u001a:\u000b\u000fA\u0014xnY3tg*\u0001rj\u0015)s_\u000e,7o\u001d%b]\u0012dWM\u001d\u0006\u0012I&\u001c\u0018M\u00197f\u0007>l\u0007\u000f\\3uS>t'bC2p]N|G.\u001a,jK^Tq\u0001Z5ta>\u001cXM\u0003\ngS2dGk\\8m\u0005\u0006\u0014\u0018i\u0019;j_:\u001c(B\u0004;p_2\u0014\u0017M]!di&|gn\u001d\u0006\u0013\t\u00164\u0017-\u001e7u\u0003\u000e$\u0018n\u001c8He>,\bO\u0003\u0007bGRLwN\\*zgR,WNC\beK\u001a\fW\u000f\u001c;Fq\u0016\u001cW\u000f^8s\u0015!)\u00050Z2vi>\u0014(\"E2p]R,g\u000e\u001e#fg\u000e\u0014\u0018\u000e\u001d;pe*!A*[:u\u0015!\te.Q2uS>t'\u0002B;uS2TAb]3ukB<U\u000f\u001e;feNT\u0001c]3ukB\u0004F.Y2fQ>dG-\u001a:i\b)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0001\t\u0007\u0015\u0011AQ\u0001E\u0004\u000b\t!1\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0004\t\u0011A)\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u0001BA\u0003\u0004\t\u0015AQ\u0001\u0004\u0001\u0006\u0005\u0011\u0019\u0001bB\u0003\u0003\t\u0019Aa!B\u0002\u0005\u000e!5A\u0002A\u0003\u0003\t\u000fA\t\"B\u0002\u0005\u0010!AA\u0002A\u0003\u0002\u0011\u0007)1\u0001\"\u0005\t\u00141\u0001QA\u0001\u0003\u0007\u0011/)1\u0001b\u0005\t\u00171\u0001Qa\u0001C\t\u00113a\u0001!\u0002\u0002\u0005\u000e!5QA\u0001C\b\u0011!)!\u0001b\u0005\t\u0017\u0015\t\u00012D\u0003\u0003\t3Aa\"\u0002\u0002\u0005\u001b!eQa\u0001C\u0002\u0011=a\u0001!\u0002\u0002\u0005\u0012!\u0005RA\u0001C\u000f\u0011E)!\u0001b\u0001\t\u001f\u0015\u0011AA\u0002\u0005\u0014\u000b\t!\u0001\u0003c\n\u0006\u0007\u0011\u0005\u0002R\u0005\u0007\u0001\u000b\t!\t\u0003#\n\u0006\u0005\u0011\u001d\u0001RF\u0003\u0004\tIAa\u0003\u0004\u0001\u0006\u0005\u0011\u0011\u0002BF\u0003\u0004\t\u0007A\u0019\u0004\u0004\u0001\u0006\u0005\u0011\r\u00012G\u0003\u0003\t\u0007A9$B\u0002\u0005*!YB\u0002A\u0003\u0003\tSA1$B\u0002\u0005\u0004!eB\u0002A\u0003\u0003\t\u0007AI$\u0002\u0002\u0005!!uRa\u0001\u0003\u0018\u0011ya\u0001!\u0002\u0002\u0005\u0004!\u0001Sa\u0001\u0003\u0019\u0011\u007fa\u0001!\u0002\u0002\u0005/!qRA\u0001\u0003\u0019\u0011\u007f)1\u0001\"\u0005\tD1\u0001Qa\u0001\u0003\u0006\u0011\u000fb\u0001!B\u0002\u0005\u000b!!C\u0002A\u0003\u0003\t\u0015AA%\u0002\u0002\u0005\u000b!\u001dSA\u0001\u0003\u0006\u0011\u0015)1\u0001B\u0007\tM1\u0001QA\u0001C\u0001\u0011\u001d*1\u0001b\u000f\tN1\u0001QA\u0001\u0003\u000e\u0011\u0019*!\u0001b\u0002\tQ\u0015\u0019Aa\bE)\u0019\u0001)!\u0001B\u0010\tR\u0015\u0011AA\u0002\u0005-\u000b\r!\t\u0005c\u0016\r\u0001\u0015\u0019Aq\u0001\u0005.\u0019\u0001)1\u0001\"\u0005\t]1\u0001Qa\u0001C!\u0011;b\u0001!\u0002\u0002\u0005\u001a!ySA\u0001\u0003$\u00119*!\u0001\"\u0011\tX\u0015\u0011Aq\u0001\u0005.\t\ra!!\u0007\u0005\u0006\u0003!%\u0011\u0002B\u0005\u0004\u000b\u0005AY\u0001g\u0003\u0019\n5bA!\u0019\u0003\u0019\u0010\u0005\u001aQ!\u0001\u0005\t1!)6\u0001B\u0003\u0004\t\u001fI\u0011\u0001c\u0006.B\u0011\u0019M\u0002g\b\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005Aa\u0002\u0007\bQ\u0007\u0001\t3!B\u0001\t\u001daqAe\t\u0015$+\u000eqQa\u0001\u0003\u0011\u0013\u0005Aq\"D\u0002\u0005$%\t\u0001rD\t\u0006\tII\u0011\u0001\u0002\u0001\u000e\u0003!}Q\u0016\t\u0003B\u001aa!Rt\u0002\u0003\u0001\u0011;i1!B\u0001\t#a\t\u0002k\u0001\u0001\"\u0007\u0015\t\u0001\"\u0005\r\u0012I\u0005B\u0013%V\u0002\u000f\u000b\r!I#C\u0001\t\u001f5\u0019A!F\u0005\u0002\u0011G\tR\u0001b\u000b\n\u0003\u0011\u0001Q\"\u0001E\u0012[\u0003\"\u0011\u0019\u0004\r\u0018;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u0001R\u0005M\u0013!\u000e\u0001\u0011eA\u0003\u0002\u0011KA*\u0003J\u0011)CU\u001ba\"B\u0002\u00050%\t\u0001bD\u0007\u0004\taI\u0011\u0001C\n\u0012\u000b\u0011E\u0012\"\u0001\u0003\u0001\u001b\u0005A1#\f\t\u0005G\u0012A\u0012$I\u0002\u0006\u0003!\u001d\u0002tE+\u0004\u0011\u0015\u0019A!G\u0005\u0002\u0011Qi1\u0001\u0002\u000e\n\u0003!!R\u0006\u0004\u0003b\taU\u0012eA\u0003\u0002\u0011UAR#V\u0002\u0005\u000b\r!)$C\u0001\t,5bA!\u0019\u0003\u00199\u0005\u001aQ!\u0001\u0005\u00171Y)6\u0001B\u0003\u0004\tqI\u0011\u0001#\f.!\u0011\u0019G\u0001\u0007\u0004\"\u0007\u0015\t\u0001b\u0002\r\b+\u000eAQa\u0001\u0003\u0007\u0013\u0005A1\"D\u0002\u0005;%\t\u0001bC\u0017\r\t\u0005$\u0001DC\u0011\u0004\u000b\u0005A\u0011\u0002G\u0005V\u0007\u0011)1\u0001\u0002\u0006\n\u0003\u0011\u0005Q\u0006\u0004\u0003b\taI\u0011eA\u0003\u0002\u0011%A\u0012\"V\u0002\u0005\u000b\r!\u0011\"C\u0001\u0005\u00025~Ba\u0001M\u001e;\u001f!\u0001\u0001C\n\u000e\u0007\u0015\t\u0001r\u0006M\u0018!\u000e\u0001Qt\u0002\u0003\u0001\u0011}i1!B\u0001\t2aE\u0002k!\u0001\"\u0007\u0015\t\u0001\"\u0005\r\u0012#\u000e9A1H\u0005\u0002\u0011Gi\u0011\u0001C\r\u000e\u0003!MR&\u0006\u0003\u00041\u0003jz\u0001\u0002\u0001\tC5\u0019Q!\u0001E\u00191c\u00016\u0001A\u0011\u0004\u000b\u0005A!\u0004\u0007\u000eR\u0007\u0015!\t%C\u0001\u0005\u00015\t\u00012G\u0017\u0016\t)A\"%h\u0004\u0005\u0001!aQbA\u0003\u0002\u0011+A*\u0002U\u0002\u0001C\r)\u0011\u0001#\u0006\u0019\u0016E\u001bQ\u0001\u0002\u0012\n\u0003!mQ\"\u0001E\u000e[U!!\u0002'\u0012\u001e\u0010\u0011\u0001\u0001bI\u0007\u0004\u000b\u0005A)\u0004'\u000eQ\u0007\u0001\t3!B\u0001\t7aY\u0012kA\u0003\u0005F%\t\u0001rG\u0007\u0002\u0011qi;\u0002\u0002\u0006\u0019J\u0005\"Q!\u0001E\u0006\u0019\u0003AZ!U\u0002\u0004\t\u0013J\u0011\u0001#\u000f.\u0016\u0011Q\u0001$J\u0011\u0004\u000b\u0005A)\u0004'\u000eR\u0007\r!Q%C\u0001\t95jAA\u0003M&C\u0017)\u0011\u0001C\u000f\u0019;E\u001b\u0011\u0001\u0002\u0010R\u0007\r!Y%C\u0001\t>5*BA\u0003M(;\u001f!\u0001\u0001\u0003\u0015\u000e\u0007\u0015\t\u0001\"\b\r\u001e!\u000e\u0001\u0011eA\u0003\u0002\u0011\u007fAz$U\u0002\u0006\t\u001fJ\u0011\u0001\u0003\u0011\u000e\u0003!uR&\u0006\u0003\u00021%jz\u0001\u0002\u0001\tT5\u0019Q!\u0001E\u00061\u0017\u00016\u0001A\u0011\u0004\u000b\u0005A!\u0004\u0007\u000eR\u0007\u0015!\u0011&C\u0001\u0005\u00015\t\u0001\u0012HW\u000b\t\u000fA\"&I\u0002\u0006\u0003!Q\u0002DG)\u0004\u0007\u0011Q\u0013\"\u0001\u0003\u0001[=\"!\u0002'\u0016\u001e\u0010\u0011\u0001\u0001bK\u0007\u0004\u000b\u0005A\u0011\u0005G\u0011Q\u0007\u0001iz\u0001\u0002\u0001\tZ5\u0019Q!\u0001E\"1\u0007\u00026\u0011AO\b\t\u0001AY&D\u0002\u0006\u0003!\u0015\u0002T\u0005)\u0004\u0003\u0005BQ!\u0001\u0005#\u0013\u0011I1!B\u0001\tFa\u0015\u0003DI)\u0004\u0013\u0011U\u0013\"\u0001E$\u001b\u0005AA%D\u0001\tJ5\t\u0001bEW\u000b\t\rAz&I\u0002\u0006\u0003!Q\u0002DG)\u0004\u0007\u0011}\u0013\"\u0001\u0003\u0001[U!\u0011\u0001\u0007\u0019\u001e\u0010\u0011\u0001\u0001bE\u0007\u0004\u000b\u0005Ay\u0003g\fQ\u0007\u0001\t3!B\u0001\t5aQ\u0012kA\u0003\u0005a%\tA\u0001A\u0007\u0002\u0011e)t\u001bACV\u0002\u0011\u0019\u000f\u0001g\u0003\u001e\u0010\u0011\u0001\u0001BB\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t\u00105\u0019Q!\u0001\u0005\t1!\u00016\u0011AO\b\t\u0001A\u0011\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0003u=A\u0001\u0001\u0005\u000b\u001b\r)\u0011\u0001C\u0005\u0019\u0013A\u001b\u0019!h\u0004\u0005\u0001!UQbA\u0003\u0002\u0011)A\"\u0002U\u0002\u0003;\u001f!\u0001\u0001\u0003\u0007\u000e\u0007\u0015\t\u0001R\u0003M\u000b!\u000e\u0015Q\u0014\u0003\u0003\u0001\u00115iA!B\u0001\t\u00161\u0005\u0001T\u0003)\u0004\u0007\u0005\u001aQ!\u0001\u0005\u00031\t\t6!\u0005C\u0006\u0013\u0005!\u0001!D\u0001\t\u00175\t\u0001rC\u0007\u0002\t\u0003i\u0011\u0001\"\u0001\u000e\u0003!aQ\"\u0001E\u000e\u001b\u0005AY\u0002"})
public final class KotlinConsoleRunner
extends AbstractConsoleRunnerWithHistory<LanguageConsoleView> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final KotlinConsoleHistoryManager historyManager;
    private final KotlinHistoryHighlighter historyHighlighter;
    private final ReadWriteProperty<? super Object, RangeHighlighter> consoleEditorHighlighter$delegate;
    private final ReadWriteProperty<? super Object, RunContentDescriptor> disposableDescriptor$delegate;
    @NotNull
    private final KotlinConsoleExecutor executor;
    @NotNull
    private final ReadWriteProperty<? super Object, KotlinConsoleCompilerHelper> compilerHelper$delegate;
    @NotNull
    private final Module module;
    private final GeneralCommandLine cmdLine;
    private final boolean testMode;
    private final boolean previousCompilationFailed;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinConsoleRunner.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("consoleEditorHighlighter"), new PropertyMetadataImpl("disposableDescriptor"), new PropertyMetadataImpl("compilerHelper")};
    }

    private final RangeHighlighter getConsoleEditorHighlighter() {
        return (RangeHighlighter)this.consoleEditorHighlighter$delegate.get((Object)this, $propertyMetadata[0]);
    }

    private final void setConsoleEditorHighlighter(RangeHighlighter rangeHighlighter) {
        this.consoleEditorHighlighter$delegate.set((Object)this, $propertyMetadata[0], (Object)rangeHighlighter);
    }

    private final RunContentDescriptor getDisposableDescriptor() {
        return (RunContentDescriptor)this.disposableDescriptor$delegate.get((Object)this, $propertyMetadata[1]);
    }

    private final void setDisposableDescriptor(RunContentDescriptor runContentDescriptor) {
        this.disposableDescriptor$delegate.set((Object)this, $propertyMetadata[1], (Object)runContentDescriptor);
    }

    @NotNull
    public final KotlinConsoleExecutor getExecutor() {
        return this.executor;
    }

    @NotNull
    public final KotlinConsoleCompilerHelper getCompilerHelper() {
        return (KotlinConsoleCompilerHelper)this.compilerHelper$delegate.get((Object)this, $propertyMetadata[2]);
    }

    public final void setCompilerHelper(@NotNull KotlinConsoleCompilerHelper kotlinConsoleCompilerHelper) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinConsoleCompilerHelper, (String)"<set-?>");
        this.compilerHelper$delegate.set((Object)this, $propertyMetadata[2], (Object)kotlinConsoleCompilerHelper);
    }

    @NotNull
    protected Process createProcess() {
        return this.cmdLine.createProcess();
    }

    @Nullable
    protected LanguageConsoleView createConsoleView() {
        EditorEx consoleEditor2;
        LanguageConsoleView consoleView2 = new LanguageConsoleBuilder().gutterContentProvider((GutterContentProvider)new KotlinConsoleGutterContentProvider()).build(this.getProject(), (Language)JetLanguage.INSTANCE);
        consoleView2.setPrompt((String)null);
        LanguageConsoleView languageConsoleView = consoleView2;
        Intrinsics.checkExpressionValueIsNotNull((Object)languageConsoleView, (String)"consoleView");
        this.disableCompletion(languageConsoleView);
        EditorEx editorEx = consoleEditor2 = consoleView2.getConsoleEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"consoleEditor");
        this.setupPlaceholder(editorEx);
        consoleEditor2.getContentComponent().addKeyListener(this.historyManager);
        VirtualFile virtualFile = consoleView2.getVirtualFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"consoleView.virtualFile");
        KtExecuteCommandAction executeAction = new KtExecuteCommandAction(virtualFile);
        executeAction.registerCustomShortcutSet(CommonShortcuts.CTRL_ENTER, consoleView2.getConsoleEditor().getComponent());
        return consoleView2;
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(@NotNull Process process2) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        KotlinReplOutputHighlighter kotlinReplOutputHighlighter = new KotlinReplOutputHighlighter(this, this.historyManager, this.testMode, this.previousCompilationFailed);
        String string = this.cmdLine.getCommandLineString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cmdLine.commandLineString");
        KotlinReplOutputHandler processHandler = new KotlinReplOutputHandler(this.historyHighlighter, kotlinReplOutputHighlighter, process2, string);
        VirtualFile consoleFile = this.getConsoleView().getVirtualFile();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        KotlinConsoleKeeper keeper = KotlinConsoleKeeper.Companion.getInstance(project);
        VirtualFile virtualFile = consoleFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"consoleFile");
        keeper.putVirtualFileToConsole(virtualFile, this);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(keeper, consoleFile){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ KotlinConsoleKeeper $keeper;
            final /* synthetic */ VirtualFile $consoleFile;

            static {
                $kotlinClass = Reflection.createKotlinClass(createProcessHandler.1.class);
            }

            public void processTerminated(@NotNull ProcessEvent _) {
                Intrinsics.checkParameterIsNotNull((Object)_, (String)"_");
                VirtualFile virtualFile = this.$consoleFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"consoleFile");
                this.$keeper.removeConsole(virtualFile);
            }
            {
                this.$keeper = $captured_local_variable$0;
                this.$consoleFile = $captured_local_variable$1;
            }
        });
        return processHandler;
    }

    @NotNull
    protected ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler() {
        return new ProcessBackedConsoleExecuteActionHandler(this, this.getProcessHandler(), false){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ KotlinConsoleRunner this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(createExecuteActionHandler.1.class);
            }

            public void runExecuteAction(@NotNull LanguageConsoleView _) {
                Intrinsics.checkParameterIsNotNull((Object)_, (String)"_");
                this.this$0.getExecutor().executeCommand();
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2);
            }
        };
    }

    @NotNull
    protected List<AnAction> fillToolBarActions(@NotNull DefaultActionGroup toolbarActions, @NotNull Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)toolbarActions, (String)"toolbarActions");
        Intrinsics.checkParameterIsNotNull((Object)defaultExecutor, (String)"defaultExecutor");
        Intrinsics.checkParameterIsNotNull((Object)contentDescriptor, (String)"contentDescriptor");
        this.setDisposableDescriptor(contentDescriptor);
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.setCompilerHelper(new KotlinConsoleCompilerHelper(project, this.module, defaultExecutor, contentDescriptor));
        Object[] objectArray = new AnAction[3];
        objectArray[0] = new BuildAndRestartConsoleAction(this);
        ProcessBackedConsoleExecuteActionHandler processBackedConsoleExecuteActionHandler = this.getConsoleExecuteActionHandler();
        Intrinsics.checkExpressionValueIsNotNull((Object)processBackedConsoleExecuteActionHandler, (String)"consoleExecuteActionHandler");
        objectArray[1] = (AnAction)this.createConsoleExecAction(processBackedConsoleExecuteActionHandler);
        AnAction anAction = this.createCloseAction(defaultExecutor, contentDescriptor);
        Intrinsics.checkExpressionValueIsNotNull((Object)anAction, (String)"createCloseAction(defaul\u2026cutor, contentDescriptor)");
        objectArray[2] = anAction;
        ArrayList actionList = CollectionsKt.arrayListOf((Object[])objectArray);
        toolbarActions.addAll((Collection)actionList);
        return actionList;
    }

    @NotNull
    protected ConsoleExecuteAction createConsoleExecAction(@NotNull ProcessBackedConsoleExecuteActionHandler consoleExecuteActionHandler) {
        Intrinsics.checkParameterIsNotNull((Object)consoleExecuteActionHandler, (String)"consoleExecuteActionHandler");
        return new ConsoleExecuteAction(this.getConsoleView(), (ConsoleExecuteAction.ConsoleExecuteActionHandler)consoleExecuteActionHandler, KotlinConsoleRunnerKt.getKOTLIN_SHELL_EXECUTE_ACTION_ID(), (Condition)consoleExecuteActionHandler);
    }

    @NotNull
    protected String constructConsoleTitle(@NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        return title + " (in module " + this.module.getName() + ")";
    }

    private final void setupPlaceholder(EditorEx editor) {
        AnAction executeCommandAction = ActionManager.getInstance().getAction(KotlinConsoleRunnerKt.getKOTLIN_SHELL_EXECUTE_ACTION_ID());
        String executeCommandActionShortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)executeCommandAction);
        editor.setPlaceholder((CharSequence)("<" + executeCommandActionShortcutText + "> to execute"));
        editor.setShowPlaceholderWhenFocused(true);
        TextAttributes placeholderAttrs = new TextAttributes();
        placeholderAttrs.setForegroundColor((Color)ReplColors.INSTANCE$.getPLACEHOLDER_COLOR());
        placeholderAttrs.setFontType(Font.ITALIC);
        editor.setPlaceholderAttributes(placeholderAttrs);
    }

    private final void disableCompletion(LanguageConsoleView consoleView2) {
        VirtualFile consoleFile = consoleView2.getVirtualFile();
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(consoleFile);
        if (!(psiFile instanceof JetFile)) {
            psiFile = null;
        }
        JetFile jetFile = (JetFile)psiFile;
        if (jetFile == null) {
            return;
        }
        JetFile jetFile2 = jetFile;
        KotlinCompletionContributorKt.setDoNotComplete(jetFile2, true);
    }

    public final void setupGutters() {
        Function3<EditorEx, Color, IconWithTooltip, RangeHighlighter> configureEditorGutter$ = new Function3<EditorEx, Color, IconWithTooltip, RangeHighlighter>(this){
            final /* synthetic */ KotlinConsoleRunner this$0;

            @NotNull
            public final RangeHighlighter invoke(@NotNull EditorEx editor, @NotNull Color color, @NotNull IconWithTooltip iconWithTooltip) {
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
                Intrinsics.checkParameterIsNotNull((Object)iconWithTooltip, (String)"iconWithTooltip");
                editor.getSettings().setLineMarkerAreaShown(true);
                editor.getSettings().setFoldingOutlineShown(true);
                editor.getGutterComponentEx().setPaintBackground(true);
                EditorColorsScheme editorColorScheme = editor.getColorsScheme();
                editorColorScheme.setColor(EditorColors.GUTTER_BACKGROUND, color);
                editor.setColorsScheme(editorColorScheme);
                return this.this$0.addGutterIndicator(editor, iconWithTooltip);
            }
            {
                this.this$0 = kotlinConsoleRunner;
                super(3);
            }
        };
        EditorEx historyEditor = this.getConsoleView().getHistoryViewer();
        EditorEx consoleEditor2 = this.getConsoleView().getConsoleEditor();
        EditorEx editorEx = historyEditor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"historyEditor");
        configureEditorGutter$.invoke(editorEx, (Color)ReplColors.INSTANCE$.getHISTORY_GUTTER_COLOR(), ReplIcons.INSTANCE$.getHISTORY_INDICATOR());
        EditorEx editorEx2 = consoleEditor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)editorEx2, (String)"consoleEditor");
        this.setConsoleEditorHighlighter(configureEditorGutter$.invoke(editorEx2, (Color)ReplColors.INSTANCE$.getEDITOR_GUTTER_COLOR(), ReplIcons.INSTANCE$.getEDITOR_INDICATOR()));
        historyEditor.getSettings().setUseSoftWraps(true);
        historyEditor.getSettings().setAdditionalLinesCount(0);
        consoleEditor2.getSettings().setCaretRowShown(true);
        consoleEditor2.getSettings().setAdditionalLinesCount(2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RangeHighlighter addGutterIndicator(@NotNull EditorEx editor, @NotNull IconWithTooltip iconWithTooltip) {
        void $receiver;
        RangeHighlighter indicatorHighlighter;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)iconWithTooltip, (String)"iconWithTooltip");
        KotlinConsoleIndicatorRenderer indicator = new KotlinConsoleIndicatorRenderer(iconWithTooltip);
        MarkupModelEx editorMarkup = editor.getMarkupModel();
        RangeHighlighter rangeHighlighter = indicatorHighlighter = editorMarkup.addRangeHighlighter(0, editor.getDocument().getTextLength(), HighlighterLayer.LAST, (TextAttributes)null, HighlighterTargetArea.LINES_IN_RANGE);
        RangeHighlighter $receiver2 = (RangeHighlighter)$receiver;
        $receiver2.setGutterIconRenderer((GutterIconRenderer)indicator);
        RangeHighlighter rangeHighlighter2 = (RangeHighlighter)$receiver;
        Intrinsics.checkExpressionValueIsNotNull((Object)rangeHighlighter2, (String)"indicatorHighlighter app\u2026conRenderer = indicator }");
        return rangeHighlighter2;
    }

    public final void changeConsoleEditorIndicator(@NotNull IconWithTooltip newIconWithTooltip) {
        Intrinsics.checkParameterIsNotNull((Object)newIconWithTooltip, (String)"newIconWithTooltip");
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (Runnable)new Runnable(this, newIconWithTooltip){
            final /* synthetic */ KotlinConsoleRunner this$0;
            final /* synthetic */ IconWithTooltip $newIconWithTooltip;

            public final void run() {
                KotlinConsoleRunner.access$getConsoleEditorHighlighter$0(this.this$0).setGutterIconRenderer((GutterIconRenderer)new KotlinConsoleIndicatorRenderer(this.$newIconWithTooltip));
            }
            {
                this.this$0 = kotlinConsoleRunner;
                this.$newIconWithTooltip = iconWithTooltip;
            }
        });
    }

    public final void dispose() {
        this.getProcessHandler().destroyProcess();
        Disposer.dispose((Disposable)((Disposable)this.getDisposableDescriptor()));
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    public KotlinConsoleRunner(@NotNull Module module, @NotNull GeneralCommandLine cmdLine, boolean testMode, boolean previousCompilationFailed, @NotNull Project myProject, @NotNull String title, @Nullable String path) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        super(myProject, title, path);
        this.module = module;
        this.cmdLine = cmdLine;
        this.testMode = testMode;
        this.previousCompilationFailed = previousCompilationFailed;
        this.historyManager = new KotlinConsoleHistoryManager(this);
        this.historyHighlighter = new KotlinHistoryHighlighter(this);
        this.consoleEditorHighlighter$delegate = Delegates.INSTANCE$.notNull();
        this.disposableDescriptor$delegate = Delegates.INSTANCE$.notNull();
        this.executor = new KotlinConsoleExecutor(this, this.historyManager, this.historyHighlighter);
        this.compilerHelper$delegate = Delegates.INSTANCE$.notNull();
    }

    @NotNull
    public static final /* synthetic */ RangeHighlighter access$getConsoleEditorHighlighter$0(KotlinConsoleRunner $this) {
        return $this.getConsoleEditorHighlighter();
    }

    public static final /* synthetic */ void access$setConsoleEditorHighlighter$0(KotlinConsoleRunner $this, @NotNull RangeHighlighter rangeHighlighter) {
        $this.setConsoleEditorHighlighter(rangeHighlighter);
    }
}

