/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Charsets;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.KotlinReplOutputHandlerKt;
import org.jetbrains.kotlin.console.SeverityDetails;
import org.jetbrains.kotlin.console.highlight.KotlinHistoryHighlighter;
import org.jetbrains.kotlin.console.highlight.KotlinReplOutputHighlighter;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0018\f)92j\u001c;mS:\u0014V\r\u001d7PkR\u0004X\u000f\u001e%b]\u0012dWM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*91m\u001c8t_2,'\u0002E(T!J|7-Z:t\u0011\u0006tG\r\\3s\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*IQ\r_3dkRLwN\u001c\u0006\baJ|7-Z:t\u0015\u0019a\u0014N\\5u})\u0011\u0002.[:u_JL\b*[4iY&<\u0007\u000e^3s\u0015aYu\u000e\u001e7j]\"K7\u000f^8ss\"Kw\r\u001b7jO\"$XM\u001d\u0006\nQ&<\u0007\u000e\\5hQRT\u0011c\\;uaV$\b*[4iY&<\u0007\u000e^3s\u0015mYu\u000e\u001e7j]J+\u0007\u000f\\(viB,H\u000fS5hQ2Lw\r\u001b;fe*9\u0001K]8dKN\u001c(\u0002\u00026bm\u0006TA\u0001\\1oO*Y1m\\7nC:$G*\u001b8f\u0015\u0019\u0019FO]5oO*AAMQ;jY\u0012,'OC\bE_\u000e,X.\u001a8u\u0005VLG\u000eZ3s\u0015\u0015Q\u0017M^1y\u0015\rAX\u000e\u001c\u0006\ba\u0006\u00148/\u001a:t\u0015]Yw\u000e\u001e7j]:Rg/\u001c\u0018QY\u0006$hm\u001c:n)f\u0004XM\u0003\njg\n+\u0018\u000e\u001c3J]\u001a|7\t[3dW\u0016$'b\u0002\"p_2,\u0017M\u001c\u0006\u001fEVLG\u000eZ,be:LgnZ%g\u001d\u0016,G-\u001a3CK\u001a|'/Z%oSRTqaY8oi\u0016tGO\u0003\u0003V]&$(BF2sK\u0006$XmQ8na&dWM]'fgN\fw-Z:\u000b'I,h\u000e^5nK\u0016\u0013(o\u001c:t%\u0016\u0004xN\u001d;\u000b\t1K7\u000f\u001e\u0006\u0010'\u00164XM]5us\u0012+G/Y5mg*!Q\u000f^5m\u0015aI7oU5mK:$H.\u001f#fgR\u0014x._(o\u00072|7/\u001a\u0006\u0014]>$\u0018NZ=UKb$\u0018I^1jY\u0006\u0014G.\u001a\u0006\u0005i\u0016DHOC\u0002lKfT1aS3z\u0015\u001dy\u0007/\u001a8ba&T1b\u001d;s)>\u001cv.\u001e:dK*\t1O\u0003\u0005f]\u000e|G-\u001b8h\u0015\u001d\u0019\u0005.\u0019:tKRT1A\\5p\u0015\u001d\u0019\u0007.\u0019:tKRT1\"\u00138qkR\u001cv.\u001e:dK*\u00191/\u0019=\u000b\u0015Q|7+\u001a<fe&$\u0018P\u0003\u0005TKZ,'/\u001b;z\u0015-!\u0017.Y4o_N$\u0018nY:5\u0006)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0001\t\u0007\u0015\u0011AQ\u0001E\u0004\u000b\t!1\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0004\t\u0011A)\u0001\u0004\u0001\u0006\u0005\u0011\r\u0001RB\u0003\u0004\t\u0015Aa\u0001\u0004\u0001\u0006\u0007\u0011)\u0001r\u0002\u0007\u0001\u000b\u0005A\t\"\u0002\u0002\u0005\u000e!IQa\u0001\u0003\b\u0011!a\u0001!B\u0001\t\u0004\u0015\u0019A\u0001\u0003\u0005\u000b\u0019\u0001)!\u0001B\u0003\t\r\u0015\u0011A!\u0002E\b\u000b\t!q\u0001\u0003\u0005\u0006\u0005\u00119\u0001BC\u0003\u0002\u0011/)!\u0001B\u0006\t\u0019\u0015\u0011Aq\u0003E\r\u000b\r!A\u0002C\u0006\r\u0001\u0015\u0011A\u0001\u0004\u0005\f\u000b\r!\u0001\u0002\u0003\b\r\u0001\u0015\u0019A\u0001\u0003E\u0010\u0019\u0001)1\u0001\u0002\u0005\t#1\u0001Qa\u0001C\u0002\u0011Ga\u0001!\u0002\u0002\u0005\u000e!\u0011RA\u0001C\u0010\u0011E)!\u0001B\u0002\t+\u0015\u0011A\u0011\u0005\u0005\u0013\u000b\r!\u0011\u0003#\u000b\r\u0001\u0015\u0011A!\u0005E\u0015\u000b\t!i\u0001c\f\u0006\u0005\u0011\u0015\u0002\u0002G\u0003\u0004\tMAq\u0003\u0004\u0001\u0006\u0005\u0011\u0001\u0001\u0002D\u0003\u0003\tQA\u0011$B\u0002\u0005*!EB\u0002A\u0003\u0003\tSA\t$\u0002\u0002\u0005'!9RA\u0001\u0003\u0002\u0011k)1\u0001\"\f\t51\u0001QA\u0001C\u0017\u0011i!1\u0001\u0004\u0002\u001a\u0007\u0015\t\u0001\u0012\u0002M\u0005[I!\u0011\r\u0002M\u000bC%)\u0011\u0001#\u0007\u0011\u001bU!Q!\u0001E\r\u0019\u0003AJ\u0002'\u0007V\u0007\u0011)1\u0001\"\u0006\n\u0003!iQ\u0006\u0004\u0003b\ta-\u0011eA\u0003\u0002\u0011\u0017AZ!V\u0002\u0005\u000b\r!Y!C\u0001\t\u00135bA!1\u0007\u0019\u001c\u0005\u001aQ!\u0001E\u000e17)6\u0001B\u0003\u0004\t7I\u0011\u0001\"\u0001.\u0019\u0011\tG\u0001G\u0004\"\u0007\u0015\t\u0001B\u0002\r\u0007+\u000e!Qa\u0001\u0003\b\u0013\u0005A\u0019\"L\u000b\u0005\u0003auQt\u0002\u0003\u0001\u0011=i1!B\u0001\t\u0012aE\u0001k\u0001\u0001\"\u0007\u0015\t\u0001B\u0004\r\u000f#\u000e)AQD\u0005\u0002\t\u0001i\u0011\u0001#\u0006.5\u0011\t\u0001\u0004EO\b\t\u0001A\t#D\u0002\u0006\u0003!E\u0001\u0014\u0003)\u0004\u0001\u0005BQ!\u0001E\u000f\u0013\u0011I1!B\u0001\t\u001fay\u0001TD)\u0004\u000b\u0011\u0001\u0012\"\u0001\u0005\u0011\u001b\u0005A)\",\u0006\u0005\u0017a\u0015\u0012eA\u0003\u0002\u00117AZ\"U\u0002\u0004\tKI\u0011\u0001\"\u0001.F\u0011Y\u0001dEO\b\t\u0001A9#D\u0002\u0006\u0003!E\u0001\u0014\u0003)\u0004\u0001uUA\u0001\u0001\u0005\u0015\u001b\u0019)\u0011\u0001c\t\n\u0003\u0011\rA\u0012\u0001M\u0012!\u000e\u0005\u0011eA\u0003\u0002\u00119Ab\"U\u0002\b\tMI\u0011\u0001\u0002\u0001\u000e\u0003!UQ\"\u0001\u0005\u0013[\u007f!\u0011\u0001g\u000b\u001e\u0010\u0011\u0001\u0001BF\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0001iz\u0001B\u0001\t.5\u0019Q!\u0001E\u00141O\u00016\u0011A\u0011\u0004\u000b\u0005AQ\u0003G\u000bR\u0007\u001d!Y#C\u0001\t,5\t\u0001RC\u0007\u0002\u0011Yi\u000b\u0003B\u0001\u0016\u0007\u0015\t\u0001\u0012\u0003M\t1g\t3!B\u0001\t/a9\u0012kA\u0003\u00054%\t\u0001rF\u0007\u0002\u0011+)d'B\u001b\u0005G\u0004AR!h\u0004\u0005\u0001!-QbA\u0003\u0002\u0011\u0017AZ\u0001U\u0002\u0001;\u001f!\u0001\u0001C\u0004\u000e\u0007\u0015\t\u0001B\u0002\r\u0007!\u000e\u0005Qt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\u0010a=\u0001kA\u0001\u001e\u0010\u0011\u0001\u00012C\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0007\t3!B\u0001\t\u0005a\u0011\u0011kA\u0006\u0005\u000b%\tA\u0001A\u0007\u0002\u0011%i\u0011\u0001c\u0005\u000e\u0003!QQ\"\u0001E\u000b"})
public final class KotlinReplOutputHandler
extends OSProcessHandler {
    public static final /* synthetic */ KClass $kotlinClass;
    private boolean isBuildInfoChecked;
    private final DocumentBuilder dBuilder;
    private final KotlinHistoryHighlighter historyHighlighter;
    private final KotlinReplOutputHighlighter outputHighlighter;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinReplOutputHandler.class);
    }

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void notifyTextAvailable(@NotNull String text, @Nullable Key<?> key) {
        String content2;
        block16: {
            block17: {
                block15: {
                    block21: {
                        block20: {
                            block18: {
                                block19: {
                                    block22: {
                                        String string;
                                        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                                        if (StringsKt.startsWith$default((String)text, (String)"warning: classpath entry points to a non-existent location", (boolean)false, (int)2)) {
                                            return;
                                        }
                                        if (!StringsKt.startsWith$default((String)text, (String)KotlinReplOutputHandlerKt.getXML_PREFIX(), (boolean)false, (int)2)) {
                                            super.notifyTextAvailable(text, key);
                                            return;
                                        }
                                        Document output = this.dBuilder.parse(KotlinReplOutputHandler.strToSource$default(this, text, null, 2));
                                        Node node = output.getFirstChild();
                                        if (node == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                                        }
                                        Element root = (Element)node;
                                        String outputType = root.getAttribute("type");
                                        content2 = StringUtil.replace((String)root.getTextContent(), (String[])KotlinReplOutputHandlerKt.getXML_REPLACEMENTS(), (String[])KotlinReplOutputHandlerKt.getSOURCE_CHARS());
                                        String string2 = string = outputType;
                                        if (string2 == null) return;
                                        switch (string2.hashCode()) {
                                            case -229373764: {
                                                if (!string.equals("COMPILE_ERROR")) return;
                                                break block15;
                                            }
                                            case -1672278994: {
                                                if (!string.equals("REPL_INCOMPLETE")) return;
                                                break block15;
                                            }
                                            case -485608986: {
                                                if (!string.equals("INTERNAL_ERROR")) return;
                                                break block16;
                                            }
                                            case -401150303: {
                                                if (!string.equals("RUNTIME_ERROR")) return;
                                                break block17;
                                            }
                                            case -426149139: {
                                                if (!string.equals("REPL_RESULT")) return;
                                                break block18;
                                            }
                                            case 1956927199: {
                                                if (!string.equals("INITIAL_PROMPT")) return;
                                                break;
                                            }
                                            case 224746485: {
                                                if (!string.equals("USER_OUTPUT")) return;
                                                break block19;
                                            }
                                            case -2147099059: {
                                                if (!string.equals("READLINE_START")) return;
                                                break block20;
                                            }
                                            case 1995515270: {
                                                if (!string.equals("READLINE_END")) return;
                                                break block21;
                                            }
                                            case 1634273314: {
                                                if (!string.equals("HELP_PROMPT")) return;
                                                break block22;
                                            }
                                        }
                                        String string3 = content2;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"content");
                                        this.buildWarningIfNeededBeforeInit(string3);
                                        return;
                                    }
                                    String string = content2;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content");
                                    this.outputHighlighter.printHelp(string);
                                    return;
                                }
                                String string = content2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content");
                                this.outputHighlighter.printUserOutput(string);
                                return;
                            }
                            String string = content2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content");
                            this.outputHighlighter.printResultWithGutterIcon(string);
                            return;
                        }
                        this.historyHighlighter.setIsReadLineMode(true);
                        return;
                    }
                    this.historyHighlighter.setIsReadLineMode(false);
                    return;
                }
                String string = content2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content");
                this.outputHighlighter.highlightCompilerErrors(this.createCompilerMessages(string));
                return;
            }
            this.outputHighlighter.printRuntimeError(StringsKt.trim((String)content2) + "\n");
            return;
        }
        String string = content2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"content");
        this.outputHighlighter.printInternalErrorMessage(string);
    }

    private final void buildWarningIfNeededBeforeInit(String content2) {
        if (!this.isBuildInfoChecked) {
            this.outputHighlighter.printBuildInfoWarningIfNeeded();
            this.isBuildInfoChecked = true;
        }
        this.outputHighlighter.printInitialPrompt(content2);
    }

    private final InputSource strToSource(String s, Charset encoding) {
        return new InputSource(new ByteArrayInputStream(StringsKt.toByteArray((String)s, (Charset)encoding)));
    }

    static /* synthetic */ InputSource strToSource$default(KotlinReplOutputHandler kotlinReplOutputHandler, String string, Charset charset, int n) {
        if ((n & 2) != 0) {
            charset = Charsets.getUTF_8();
        }
        return kotlinReplOutputHandler.strToSource(string, charset);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SeverityDetails> createCompilerMessages(String runtimeErrorsReport) {
        ArrayList compilerMessages = CollectionsKt.arrayListOf((Object[])new SeverityDetails[0]);
        int n = 0;
        Document report2 = this.dBuilder.parse(this.strToSource(runtimeErrorsReport, Charsets.getUTF_16()));
        NodeList entries = report2.getElementsByTagName("reportEntry");
        int n2 = entries.getLength() - 1;
        if (n <= n2) {
            while (true) {
                String description;
                void i;
                Node node = entries.item((int)i);
                if (node == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element reportEntry = (Element)node;
                Severity severityLevel = this.toSeverity(reportEntry.getAttribute("severity"));
                int rangeStart = StringsKt.toInt((String)reportEntry.getAttribute("rangeStart"));
                int rangeEnd = StringsKt.toInt((String)reportEntry.getAttribute("rangeEnd"));
                String string = description = reportEntry.getTextContent();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"description");
                compilerMessages.add(new SeverityDetails(severityLevel, string, new TextRange(rangeStart, rangeEnd)));
                if (i == n2) break;
                ++i;
            }
        }
        return compilerMessages;
    }

    private final Severity toSeverity(String $receiver) {
        Severity severity;
        switch ($receiver) {
            case "ERROR": {
                severity = Severity.ERROR;
                break;
            }
            case "WARNING": {
                severity = Severity.WARNING;
                break;
            }
            case "INFO": {
                severity = Severity.INFO;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported Severity: '" + $receiver + "'");
            }
        }
        return severity;
    }

    public KotlinReplOutputHandler(@NotNull KotlinHistoryHighlighter historyHighlighter, @NotNull KotlinReplOutputHighlighter outputHighlighter, @NotNull Process process2, @NotNull String commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)historyHighlighter, (String)"historyHighlighter");
        Intrinsics.checkParameterIsNotNull((Object)outputHighlighter, (String)"outputHighlighter");
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        super(process2, commandLine);
        this.historyHighlighter = historyHighlighter;
        this.outputHighlighter = outputHighlighter;
        this.dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }
}

