/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.MapsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.CachedAttributeData;
import org.jetbrains.kotlin.idea.caches.FileAttributeService;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"y\u0006)Ab)\u001b7f\u0003R$(/\u001b2vi\u0016\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*11-Y2iKNTACR5mK\u0006#HO]5ckR,7+\u001a:wS\u000e,'B\u0002\u001fj]&$hH\u0003\u0006biR\u0014\u0018NY;uKNT!\"T;uC\ndW-T1q\u0015\u0019\u0019FO]5oO*ia)\u001b7f\u0003R$(/\u001b2vi\u0016T1aY8n\u0015!Ig\u000e^3mY&T'bB8qK:\f\u0007/\u001b\u0006\u0004m\u001a\u001c(B\u00028foZ47O\u0003\u0003kCZ\f'\u0002B;uS2T1!T1q\u001559W\r^!uiJL'-\u001e;fg*\tAK\u0003\u0003F]Vl'\u0002\u00063fg\u0016\u0014\u0018.\u00197ju\u0016,e.^7WC2,XMC\u0001j\u0015\rIe\u000e\u001e\u0006\u0006W2\f7o\u001d\u0006\u0006\u00072\f7o\u001d\u0006\u0005Y\u0006twMC\u0007sK\u0006$\u0017\t\u001e;sS\n,H/\u001a\u0006\u0003S\u0012TAAZ5mK*Ya+\u001b:uk\u0006dg)\u001b7f\u0015M\u0019\u0015m\u00195fI\u0006#HO]5ckR,G)\u0019;b\u0015!\u0011XmZ5ti\u0016\u0014(b\u0002<feNLwN\u001c\u0006\u0005+:LGO\u0003\bxe&$X-\u0011;ue&\u0014W\u000f^3\u000b\u000bY\fG.^3I\u0004)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)1\u0001\u0002\u0002\t\u00011\u0001Qa\u0001\u0003\u0003\u0011\ra\u0001!B\u0001\t\u0004\u0015\u0019Aq\u0001E\u0005\u0019\u0001)1\u0001b\u0002\t\u000b1\u0001Q!\u0001\u0005\u0007\u000b\t!Q\u0001#\u0004\u0006\u0005\u0011-\u0001bB\u0003\u0003\t\u0019Ay!\u0002\u0002\u0005\u000e!AQa\u0001\u0003\b\u0011\u0017a\u0001!B\u0001\t\u0012\u0015\u0011A\u0001\u0003\u0005\n\u000b\t!\t\u0002c\u0005\u0006\u0007\u0011\u001d\u0001b\u0003\u0007\u0001\u000b\r!9\u0001#\u0007\r\u0001\u0015\u0011A\u0001\u0003\u0005\u000f\u000b\r!)\u0002c\u0007\r\u0001\u0015\u0011AQ\u0003\u0005\f\u000b\t!)\u0002c\u0007\u0006\u0007\u00115\u0001\u0002\u0005\u0007\u0001\u000b\r!!\u0001#\t\r\u0001\u0015\u0011AA\u0001E\u0011\u000b\t!)\u0002C\u0003\u0006\u0005\u00115\u0001\u0002E\u0003\u0004\t\u000fA!\u0003\u0004\u0001\u0005\u00071\u0015\u0011dA\u0003\u0002\u0011\rA2!\f\u000e\u0005G\u0012AB!I\u0007\u0006\u0003!!\u0011\u0002B\u0005\u0004\u000b\u0005AI\u0001'\u0003\n\t%\u0019Q!\u0001E\b1\u001fAB!V\u0002\t\u000b\r!A!C\u0001\t\u00135\u0019AAC\u0005\u0002\u0011%i;\u0007B\u0001\u0012\u0019\u0011\u0001\u0001RC\u000b\n\u000b\u0005A\u0019\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A\u001a\u0002g\u0006\u001e\u0010\u0011\u0001\u0001\u0002D\u0007\u0004\u000b\u0005A!\u0002\u0007\u0006Q\u0007\u0001iZ\u0002\u0002\u0001\t\u001b5IQ!\u0001\u0005\f\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001\r\f!\u000e\u0005\u0011\u0005B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001R\u0007\u001d!9\"C\u0001\t\u00185\tAQA\u0007\u0002\u00111iC\u0019\u0001\u0003\f#1!\u0001\u0001#\u0006\u0016\u0013\u0015\t\u00012C\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u00014\u0003M\u000f;\u001f!\u0001\u0001C\b\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0001Qt\u0002\u0003\u0001\u0011?i1!B\u0001\t\u001aae\u0001k!\u0001\u001e\u001c\u0011\u0001\u0001\"D\u0007\n\u000b\u0005A1\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A2\u0002U\u0002\u0002C))\u0011\u0001C\u0007\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002\u0001$\u0001\u0019\u001bE\u001b\u0011\u0002\"\b\n\u0003!mQ\"\u0001\u0005\u000f\u001b\u0005Ai\"D\u0001\t\u00195~Ba\u0003\r\u0012;\u001f!\u0001\u0001C\b\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0001Qt\u0002\u0003\u0001\u0011Gi1!B\u0001\t\u0015aQ\u0001k!\u0001\"\u0007\u0015\t\u0001b\u0004\r\u0010#\u000e9A!E\u0005\u0002\t\u0001i\u0011\u0001\u0003\b\u000e\u0003\u0011\u0015QF\u0010\u0003\f#1!\u0001\u0001#\u0006\u0016\u0013\u0015\t\u00012C\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u00014\u0003M\u0013;\u001f!\u0001\u0001C\b\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0001Qt\u0002\u0003\u0001\u0011?i1!B\u0001\t\u001aae\u0001k!\u0001\u001e\u0012\u0011\u0001\u0001bE\u0007\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001A\u001b\u0011!I\u0005\u0006\u0003!i\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001ai\u0011kA\u0005\u0005&%\t\u00012D\u0007\u0002\u00119i\u0011\u0001#\b\u000e\u0003!]Q\u0007D\u0003\f\t\r\b\u0001tA\u0011\u0004\u000b\u0005A)\u0001'\u0002R\u0007\r!9!C\u0001\u0005\u0001\u0001"})
public final class FileAttributeServiceImpl
implements FileAttributeService {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final Map<String, FileAttribute> attributes;

    static {
        $kotlinClass = Reflection.createKotlinClass(FileAttributeServiceImpl.class);
    }

    @NotNull
    public final Map<String, FileAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void register(@NotNull String id, int version) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        MapsKt.set(this.attributes, (Object)id, (Object)new FileAttribute(id, version, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <T extends Enum<T>> CachedAttributeData<T> writeAttribute(@NotNull String id, @NotNull VirtualFile file, @NotNull T value2) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        FileAttribute fileAttribute = this.attributes.get(id);
        if (fileAttribute == null) {
            throw (Throwable)new IllegalArgumentException("Attribute with " + id + " wasn't registered");
        }
        FileAttribute attribute = fileAttribute;
        CachedAttributeData<T> data2 = new CachedAttributeData<T>(value2, file.getTimeStamp());
        Closeable closeable = attribute.writeAttribute(file);
        boolean closed = false;
        try {
            DataOutputStream it = (DataOutputStream)$receiver;
            DataInputOutputUtil.writeTIME((DataOutput)it, (long)data2.getTimeStamp());
            T t = data2.getValue();
            DataInputOutputUtil.writeINT((DataOutput)it, (int)(t != null ? t.ordinal() : -1));
            it = Unit.INSTANCE$;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver.close();
            }
        }
        return data2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <T extends Enum<T>> CachedAttributeData<T> readAttribute(@NotNull String id, @NotNull VirtualFile file, @NotNull Class<T> klass) {
        Object it;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(klass, (String)"klass");
        FileAttribute fileAttribute = this.attributes.get(id);
        if (fileAttribute == null) {
            throw (Throwable)new IllegalArgumentException("Attribute with " + id + " wasn't registered");
        }
        FileAttribute attribute = fileAttribute;
        DataInputStream dataInputStream = attribute.readAttribute(file);
        if (dataInputStream == null) {
            return null;
        }
        DataInputStream stream = dataInputStream;
        Closeable closeable = stream;
        boolean closed = false;
        try {
            it = (DataInputStream)$receiver;
            long timeStamp = DataInputOutputUtil.readTIME((DataInput)((DataInput)it));
            int intValue = DataInputOutputUtil.readINT((DataInput)((DataInput)it));
            it = file.getTimeStamp() == timeStamp ? new CachedAttributeData<T>(this.deserializeEnumValue(intValue, klass), timeStamp) : (CachedAttributeData)null;
        }
        catch (Exception e) {
            closed = true;
            try {
                $receiver.close();
            }
            catch (Exception closeException) {
                // empty catch block
            }
            throw (Throwable)e;
        }
        finally {
            if (!closed) {
                $receiver.close();
            }
        }
        return (CachedAttributeData)it;
    }

    private final <T extends Enum<T>> T deserializeEnumValue(int i, Class<T> klass) {
        Method method = klass.getMethod("values", new Class[0]);
        Object object = method.invoke(null, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Enum[] values = (Enum[])object;
        return (T)values[i];
    }

    public FileAttributeServiceImpl() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap()");
        this.attributes = concurrentMap;
    }
}

