/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.io.URLUtil;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.data;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.CachedAttributeData;
import org.jetbrains.kotlin.idea.caches.FileAttributeService;
import org.jetbrains.kotlin.idea.caches.JarUserDataManager;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"Q\b)\u0011\"*\u0019:Vg\u0016\u0014H)\u0019;b\u001b\u0006t\u0017mZ3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006TaaY1dQ\u0016\u001c(bA!os*!b-\u001b7f\u0003R$(/\u001b2vi\u0016\u001cVM\u001d<jG\u0016TACR5mK\u0006#HO]5ckR,7+\u001a:wS\u000e,'bF4fi\u001aKG.Z!uiJL'-\u001e;f'\u0016\u0014h/[2f\u0015\u001d1XM]:j_:T1!\u00138u\u0015)9W\r\u001e,feNLwN\u001c\u0006\u0014Q\u0006\u001ch)\u001b7f/&$\b\u000e\u0015:pa\u0016\u0014H/\u001f\u0006\bG>,h\u000e^3s\u0015eQ\u0015M\u001d\"p_2,\u0017M\u001c)s_B,'\u000f^=D_VtG/\u001a:\u000b\t\u0019LG.\u001a\u0006\f-&\u0014H/^1m\r&dWMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015\r1hm\u001d\u0006\b\u0005>|G.Z1o\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006-\u0015\u0006\u0014Xk]3s\t\u0006$\u0018-T1oC\u001e,'\u000f\n&be\n{w\u000e\\3b]B\u0013x\u000e]3sif\u001cu.\u001e8uKJT\u0001B]3hSN$XM\u001d\u0006\u0005+:LGOC\u000btG\",G-\u001e7f\u0015\u0006\u0014\bK]8dKN\u001c\u0018N\\4\u000b\u000f)\f'OR5mK*aAn\\2bY*\u000b'OR5mK*i1\u000f^8sKV\u001bXM\u001d#bi\u0006T\u0011\u0002^5nKN$\u0018-\u001c9\u000b\t1{gn\u001a\u0006\u0012\u0015\u0006\u0014h)\u001b7f'f\u001cH/Z7Vi&d'\u0002\u0004)s_B,'\u000f^=ECR\f'\"B*uCR,g5\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\u0007!\u0019A\u0002A\u0003\u0004\t\tAA\u0001\u0004\u0001\u0006\u0005\u0011\u0011\u0001\u0002B\u0003\u0004\t\rAY\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001r\u0002\u0007\u0001\u000b\u0005A\u0011\"\u0002\u0002\u0005\r!MQA\u0001C\u0007\u0011))!\u0001B\u0004\t\u0016\u0015\u0019Aq\u0002E\t\u0019\u0001)1\u0001B\u0002\t\u00171\u0001Q!\u0001E\f\u000b\t!\u0011\u0002\u0003\u0007\u0006\u0005\u0011M\u0001bC\u0003\u0003\t\tAI\"\u0002\u0002\u0005\u0010!EQa\u0001\u0003\u0004\u00117a\u0001!B\u0002\u0005\u0007!\u0005B\u0002A\u0003\u0003\t'A\t\u0003B2\u0002\u0019\u000bI2!B\u0001\t\ba\u001dQDa\u0004\u0012$Ii\u0013\u0003B2\u00051\u000f\tC!B\u0001\t\t1\u0005\u0001\u0004B+\u0004\u0011\u0015\u0019AqA\u0005\u0002\u0011\u0013i1\u0001\"\u0003\n\u0003!%Q\u0006\u0005\u0003d)a)\u0011eA\u0003\u0002\u0011\u0015AR!V\u0002\t\u000b\r!Q!C\u0001\u0005\u00065\u0019AAB\u0005\u0002\t\u000bi\u000b\u0005B\u0002\u0019\u000eu=A\u0001\u0001\u0005\b\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0001!h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011!A\u0002\u0002UB\u0001C\u0011)\u0011\u0001#\u0005\r\u0002aE\u0011kA\u0004\u0005\u000e%\t\u0001BC\u0007\u0002\u0011+i\u0011\u0001C\u0006.+\u0011\u0019\u0001$DO\b\t\u0001Aq!D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0001\u0005\u001aQ!\u0001E\f1/\t6!\u0002\u0003\u000e\u0013\u0005!\u0001!D\u0001\t\u00165RC!\u0001\r\u000f;\u001f!\u0001\u0001C\u0004\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u0001Qt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u0011aA\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001bD\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0005\t3!B\u0001\t\u0018a]\u0011kA\u0005\u0005\u001d%\tA\u0001A\u0007\u0002\u0011+i\u0011\u0001C\u0006\u000e\u0003!YQV\u000e\u0003\u00021?iz\u0001\u0002\u0001\t\u000f5\u0019Q!\u0001E\u00061\u0017\u00016\u0001AO\b\t\u0001Aq\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0002uEA\u0001\u0001E\u0007\u001b\u0011)\u0011\u0001#\u0005\r\u0002aE\u0001kA\u0001\u001e\u0012\u0011\t\u0001\u0002E\u0007\u0005\u000b\u0005AA\u0002$\u0001\u0019\u0019A\u001b\u0019!I\u0002\u0006\u0003!]\u0001tC)\u0004\u0017\u0011}\u0011\"\u0001\u0003\u0001\u001b\u0005A)\"D\u0001\t\u00175\t\u0001BC\u0007\u0002\u00113)\u0004\u0001"})
public final class JarUserDataManager {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final int version = 2;
    @Nullable
    public static final FileAttributeService fileAttributeService;
    public static final JarUserDataManager INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(JarUserDataManager.class);
        new JarUserDataManager();
    }

    public final int getVersion() {
        return version;
    }

    @Nullable
    public final FileAttributeService getFileAttributeService() {
        return fileAttributeService;
    }

    public final void register(@NotNull JarBooleanPropertyCounter counter) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
        FileAttributeService fileAttributeService = JarUserDataManager.fileAttributeService;
        if (fileAttributeService != null) {
            String string = counter.getKey().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"counter.key.toString()");
            fileAttributeService.register(string, version);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
    }

    @Nullable
    public final Boolean hasFileWithProperty(@NotNull JarBooleanPropertyCounter counter, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)counter, (String)"counter");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        VirtualFile virtualFile = JarFileSystemUtil.INSTANCE$.findLocalJarFile(file);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile localJarFile = virtualFile;
        PropertyData stored = (PropertyData)localJarFile.getUserData(counter.getKey());
        if (stored != null && localJarFile.getTimeStamp() == stored.getTimestamp()) {
            return stored.getHasFileWithProperty();
        }
        if (stored == null && fileAttributeService != null) {
            String string = counter.getKey().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"counter.key.toString()");
            CachedAttributeData<State> savedData = fileAttributeService.readAttribute(string, localJarFile, State.class);
            if (savedData != null && savedData.getValue() != null) {
                boolean hasFileWithProperty2 = Intrinsics.areEqual((Object)((Object)savedData.getValue()), (Object)((Object)State.HAS_FILE));
                this.storeUserData(counter, localJarFile, hasFileWithProperty2, savedData.getTimeStamp());
                if (localJarFile.getTimeStamp() == savedData.getTimeStamp()) {
                    return hasFileWithProperty2;
                }
            }
        }
        VirtualFile virtualFile2 = JarFileSystemUtil.INSTANCE$.findJarFileRoot(file);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile jarFileRoot = virtualFile2;
        this.scheduleJarProcessing(counter, jarFileRoot, localJarFile);
        return null;
    }

    private final void scheduleJarProcessing(JarBooleanPropertyCounter counter, VirtualFile jarFile, VirtualFile localJarFile) {
        PropertyData userData = (PropertyData)localJarFile.getUserData(counter.getKey());
        if (userData != null && localJarFile.getTimeStamp() == userData.getTimestamp()) {
            return;
        }
        JarUserDataManager.storeUserData$default(this, counter, localJarFile, null, null, 8);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(jarFile, counter, localJarFile){
            final /* synthetic */ VirtualFile $jarFile;
            final /* synthetic */ JarBooleanPropertyCounter $counter;
            final /* synthetic */ VirtualFile $localJarFile;

            public final void run() {
                ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ scheduleJarProcessing.1 this$0;

                    public final void invoke() {
                        CachedAttributeData<Enum> cachedAttributeData;
                        boolean hasFileWithProperty2 = !VfsUtilCore.processFilesRecursively((VirtualFile)this.this$0.$jarFile, (Processor)((Processor)new Processor<VirtualFile>(this){
                            final /* synthetic */ scheduleJarProcessing.1 this$0;

                            public final boolean process(VirtualFile file) {
                                JarBooleanPropertyCounter jarBooleanPropertyCounter = this.this$0.this$0.$counter;
                                VirtualFile virtualFile = file;
                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                                return !jarBooleanPropertyCounter.hasProperty(virtualFile);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }));
                        State state = hasFileWithProperty2 ? State.HAS_FILE : State.NO_FILE;
                        FileAttributeService fileAttributeService = JarUserDataManager.INSTANCE$.getFileAttributeService();
                        if (fileAttributeService != null) {
                            String string = this.this$0.$counter.getKey().toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"counter.key.toString()");
                            cachedAttributeData = fileAttributeService.writeAttribute(string, this.this$0.$localJarFile, (Enum)state);
                        } else {
                            cachedAttributeData = null;
                        }
                        CachedAttributeData<Enum> savedData = cachedAttributeData;
                        CachedAttributeData<Enum> cachedAttributeData2 = savedData;
                        JarUserDataManager.access$storeUserData$0(JarUserDataManager.INSTANCE$, this.this$0.$counter, this.this$0.$localJarFile, hasFileWithProperty2, cachedAttributeData2 != null ? cachedAttributeData2.getTimeStamp() : this.this$0.$localJarFile.getTimeStamp());
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$jarFile = virtualFile;
                this.$counter = jarBooleanPropertyCounter;
                this.$localJarFile = virtualFile2;
            }
        });
    }

    private final void storeUserData(JarBooleanPropertyCounter counter, VirtualFile localJarFile, Boolean hasFileWithProperty2, Long timestamp) {
        PreconditionsKt.assert((boolean)localJarFile.isInLocalFileSystem());
        PreconditionsKt.assert((timestamp == null == (hasFileWithProperty2 == null) ? 1 : 0) != 0, (Object)"Using empty timestamp is only allowed for storing not counted value");
        Long l = timestamp;
        localJarFile.putUserData(counter.getKey(), (Object)new PropertyData(hasFileWithProperty2, l != null ? ((Number)l).longValue() : localJarFile.getTimeStamp()));
    }

    static /* synthetic */ void storeUserData$default(JarUserDataManager jarUserDataManager, JarBooleanPropertyCounter jarBooleanPropertyCounter, VirtualFile virtualFile, Boolean bl, Long l, int n) {
        if ((n & 8) != 0) {
            l = null;
        }
        jarUserDataManager.storeUserData(jarBooleanPropertyCounter, virtualFile, bl, l);
    }

    JarUserDataManager() {
        INSTANCE$ = this;
        version = 2;
        fileAttributeService = (FileAttributeService)ServiceManager.getService(FileAttributeService.class);
    }

    public static final /* synthetic */ void access$storeUserData$0(JarUserDataManager $this, @NotNull JarBooleanPropertyCounter counter, @NotNull VirtualFile localJarFile, @Nullable Boolean hasFileWithProperty2, @Nullable Long timestamp) {
        $this.storeUserData(counter, localJarFile, hasFileWithProperty2, timestamp);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"}\u0015\u0015\u0019F/\u0019;f\u0015IQ\u0015M]+tKJ$\u0015\r^1NC:\fw-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*11-Y2iKNTA!\u00128v[*1A(\u001b8jizRAA[1wC*!A.\u00198h\u0015\u0019\u0019FO]5oO*!\u0011JT%U\u0015!A\u0015iU0G\u00132+%b\u0002(P?\u001aKE*\u0012%\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0002\u0006\u0007\u0011\u001d\u0001r\u0001\u0007\u0001\u000b\u0005AI!\u0002\u0002\u0005\n!)QA\u0001\u0003\u0006\u0011\u0017!1\u0019\u0001\u0007\u00043!)\u0011\u0001\u0003\u0003\n\t%\u0019Q!\u0001\u0005\u00041\rAB!m\u0001\u0007\u000e\u001d)\u0004#B\b\u0005C\u0004AB!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u000f\u0011!\u0011\"\u0001\u0003\u0001\u001b\u0005AY!D\u0001\u0005\u0006\u0001"})
    public static final class State
    extends Enum<State> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ State INIT;
        public static final /* enum */ State HAS_FILE;
        public static final /* enum */ State NO_FILE;
        private static final /* synthetic */ State[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(State.class);
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = INIT = new State();
            stateArray[1] = HAS_FILE = new State();
            stateArray[2] = NO_FILE = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"+\u0004)\t\"*\u0019:GS2,7+_:uK6,F/\u001b7\u000b%)\u000b'/V:fe\u0012\u000bG/Y'b]\u0006<WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015\u0019\u0019\u0017m\u00195fg*\u0019\u0011I\\=\u000b\u001f\u0019Lg\u000e\u001a&be\u001aKG.\u001a*p_RT\u0011\"\u001b8KCJ4\u0015\u000e\\3\u000b\u0017YK'\u000f^;bY\u001aKG.\u001a\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*\u0019aOZ:\u000b!\u0019Lg\u000e\u001a'pG\u0006d'*\u0019:GS2,GL\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0004\t\tA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\b!\u001dA\u0002A\u0003\u0002\u0011\u0017)!\u0001\"\u0003\t\r\u0015\u0011A!\u0002E\u0007\u000b\t!Y\u0001C\u0004\u0006\u0007\u00111\u0001\"\u0002\u0007\u0001\u000b\t!a\u0001C\u0003\u0005G\u0006a1!G\u0002\u0006\u0003!!\u0001\u0004B\u0017\u0017\t\rAB!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0001C\u0011)\u0011\u0001#\u0004\r\u0002a5\u0011kA\u0003\u0005\t%\t\u0001bB\u0007\u0002\u0011\u001dic\u0003B\u0002\u0019\u0010u=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!\t\u0003\u0006\u0003!5A\u0012\u0001M\u0007#\u000e)AqB\u0005\u0002\u0011\u001di\u0011\u0001C\u00046\u0001\u0001"})
    public static final class JarFileSystemUtil {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final JarFileSystemUtil INSTANCE$;

        static {
            $kotlinClass = Reflection.createKotlinClass(JarFileSystemUtil.class);
            new JarFileSystemUtil();
        }

        @Nullable
        public final VirtualFile findJarFileRoot(@NotNull VirtualFile inJarFile) {
            Intrinsics.checkParameterIsNotNull((Object)inJarFile, (String)"inJarFile");
            if (!StringsKt.startsWith$default((String)inJarFile.getUrl(), (String)"jar://", (boolean)false, (int)2)) {
                return null;
            }
            VirtualFile jarFile = inJarFile;
            while (jarFile.getParent() != null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)jarFile.getParent(), (String)"jarFile.getParent()");
            }
            return jarFile;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final VirtualFile findLocalJarFile(@NotNull VirtualFile inJarFile) {
            void value2;
            Intrinsics.checkParameterIsNotNull((Object)inJarFile, (String)"inJarFile");
            if (!StringsKt.startsWith$default((String)inJarFile.getUrl(), (String)"jar://", (boolean)false, (int)2)) {
                return null;
            }
            String path = inJarFile.getPath();
            int jarSeparatorIndex = StringsKt.indexOf$default((String)path, (String)URLUtil.JAR_SEPARATOR, (int)0, (boolean)false, (int)6);
            boolean bl = jarSeparatorIndex >= 0;
            if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
                String message = "Path passed to JarFileSystem must have jar separator '!/': " + path;
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            String localPath = StringsKt.substring((String)path, (int)0, (int)jarSeparatorIndex);
            return StandardFileSystems.local().findFileByPath(localPath);
        }

        JarFileSystemUtil() {
            INSTANCE$ = this;
        }
    }

    @data
    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"v\u0004)a\u0001K]8qKJ$\u0018\u0010R1uC*\u0011\"*\u0019:Vg\u0016\u0014H)\u0019;b\u001b\u0006t\u0017mZ3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006TaaY1dQ\u0016\u001c(bA!os*1A(\u001b8jizR1\u0003[1t\r&dWmV5uQB\u0013x\u000e]3sifTqAQ8pY\u0016\fgNC\u0005uS6,7\u000f^1na*!Aj\u001c8h\u0015\u0011Q\u0017M^1\u000b\t1\fgn\u001a\u0006\u0017O\u0016$\b*Y:GS2,w+\u001b;i!J|\u0007/\u001a:us*aq-\u001a;US6,7\u000f^1na*Q1m\\7q_:,g\u000e^\u0019\u000b\u0015\r|W\u000e]8oK:$(G\u0003\u0003d_BL(b\b&beV\u001bXM\u001d#bi\u0006l\u0015M\\1hKJ$\u0003K]8qKJ$\u0018\u0010R1uCzS!\u0001\u0005\u0002\u000b\t!\u0001\u0001c\u0001\u0006\u0005\u0011\u0005\u0001BA\u0003\u0003\t\u0005A)!\u0002\u0002\u0005\u0004!\u0019Qa\u0001\u0003\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\t)1\u0001b\u0002\t\b1\u0001Qa\u0001C\u0004\u0011\u0015a\u0001!B\u0002\u0005\b!1A\u0002A\u0003\u0002\u0011\u001b)!\u0001b\u0003\t\u000f\u0015\u0011AA\u0002\u0005\u0006\u000b\t!!\u0001\u0003\u0006\u0005\b1\u0019\u0011dA\u0003\u0002\u0011\u0011AB!L\t\u0005G\u0012AJ!\t\u0003\u0006\u0003!%A\u0012\u0001M\u0005+\u000eAQa\u0001C\u0005\u0013\u0005Ai!D\u0002\u0005\u0010%\t\u0001RB\u0017\u0011\t\r$\u00014B\u0011\u0004\u000b\u0005AQ\u0001G\u0003V\u0007!)1\u0001b\u0003\n\u0003\u0011\u001dQb\u0001\u0003\t\u0013\u0005!9!,\u0007\u0005\u0007\u000e\u000b\u0001\u0014C\u0011\u0005\u000b\u0005AI\u0001$\u0001\u0019\nE\u001b1\u0001\"\u0005\n\u0003!5Qv\u0003\u0003D\u0007\u0006A\u0012\"I\u0002\u0006\u0003!)\u0001$B)\u0004\u0007\u0011I\u0011\"\u0001C\u0004[\u0005\"1i\u0001M\n;#!\u0011\u0001#\u0003\u000e\t\u0015\t\u0001\u0012\u0002G\u00011\u0013\u00016\u0001AO\b\t\u0005AY!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00041\r\t6a\u0002C\n\u0013\u0005Aq!D\u0001\t\u000e5\tAqA\u001b#\u000b\u0005\"1\u001d\u0001\r\u0005;#!\u0001\u0001#\u0003\u000e\t\u0015\t\u0001\u0012\u0002G\u00011\u0013\u00016\u0001AO\b\t\u0001AY!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00041\r\t6a\u0002\u0003\u0005\u0013\u0005!\u0001!D\u0001\t\u000e5\tAq\u0001"})
    public static final class PropertyData {
        public static final /* synthetic */ KClass $kotlinClass;
        @Nullable
        private final Boolean hasFileWithProperty;
        private final long timestamp;

        static {
            $kotlinClass = Reflection.createKotlinClass(PropertyData.class);
        }

        @Nullable
        public final Boolean getHasFileWithProperty() {
            return this.hasFileWithProperty;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public PropertyData(@Nullable Boolean hasFileWithProperty2, long timestamp) {
            this.hasFileWithProperty = hasFileWithProperty2;
            this.timestamp = timestamp;
        }

        @Nullable
        public final Boolean component1() {
            return this.hasFileWithProperty;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final PropertyData copy(@Nullable Boolean hasFileWithProperty2, long timestamp) {
            return new PropertyData(hasFileWithProperty2, timestamp);
        }

        @NotNull
        public static /* synthetic */ PropertyData copy$default(PropertyData propertyData, Boolean bl, long l, int n) {
            if ((n & 1) != 0) {
                bl = propertyData.hasFileWithProperty;
            }
            if ((n & 2) != 0) {
                l = propertyData.timestamp;
            }
            return propertyData.copy(bl, l);
        }

        public String toString() {
            return "PropertyData(hasFileWithProperty=" + this.hasFileWithProperty + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            Boolean bl = this.hasFileWithProperty;
            long l = this.timestamp;
            return (bl != null ? ((Object)bl).hashCode() : 0) * 31 + (int)(l ^ l >>> 32);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PropertyData)) break block3;
                    PropertyData propertyData = (PropertyData)object;
                    if (!Intrinsics.areEqual((Object)this.hasFileWithProperty, (Object)propertyData.hasFileWithProperty) || !(this.timestamp == propertyData.timestamp)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"v\u0004)I\"*\u0019:C_>dW-\u00198Qe>\u0004XM\u001d;z\u0007>,h\u000e^3s\u0015IQ\u0015M]+tKJ$\u0015\r^1NC:\fw-\u001a:\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*11-Y2iKNT1!\u00118z\u0015\u0019a\u0014N\\5u})91.Z=OC6,'BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT1a[3z\u0015\rYU-\u001f\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*!Q\u000f^5m\u00151\u0001&o\u001c9feRLH)\u0019;b\u0015\u00199W\r^&fs*Y\u0001.Y:Qe>\u0004XM\u001d;z\u0015\u00111\u0017\u000e\\3\u000b\u0017YK'\u000f^;bY\u001aKG.\u001a\u0006\u0004m\u001a\u001c(b\u0002\"p_2,\u0017M\u001c\u0006\ti>\u001cFO]5oOb\r!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!\u0011Qa\u0001C\u0004\u0011\u000fa\u0001!B\u0002\u0005\b!)A\u0002A\u0003\u0002\u0011\u0017)!\u0001B\u0003\t\r\u0015\u0011A1\u0002\u0005\u0006\u000b\u0005Ay!\u0002\u0002\u0005\u000e!AQA\u0001\u0003\b\u0011#)!\u0001b\u0004\t\u0013\u0015\u0019A\u0001\u0003\u0005\b\u0019\u0001)1\u0001\"\u0002\t\u00141\u0001QA\u0001\u0003\t\u0011\u001d)!\u0001b\u0004\t\u0019\u0015\u0019AA\u0003E\f\u0019\u0001)1\u0001b\u0002\t\u001a1\u0001QA\u0001\u0003\u000b\u0011/!1\u0003D\u0002\u001a\u0007\u0015\t\u0001\u0002\u0002\r\u0005[U!1\r\u0002M\u0007C!)\u0011\u0001#\u0005\n\t%\u0019Q!\u0001\u0005\n1%A\n\"V\u0002\t\u000b\r!i!C\u0001\t\u00145\u0019AAC\u0005\u0002\u0011'iS\u0003B\n\u0019\u0016u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001#\u0006\u0019\u0016A\u001b\u0001!I\u0002\u0006\u0003!Y\u0001dC)\u0004\u000b\u0011U\u0011\"\u0001C\u0001\u001b\u0005A9\",\u0006\u0005\u0017ai\u0011eA\u0003\u0002\u0011\u0013AJ!U\u0002\u0004\t5I\u0011\u0001\u0003\u00046.\u0015-Ba9\u0001\u0019\tu=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0001!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u000b\u0011!\u0011\"\u0001\u0003\u0001\u001b\u0005Aa\u0001"})
    public static abstract class JarBooleanPropertyCounter {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Key<PropertyData> key;

        static {
            $kotlinClass = Reflection.createKotlinClass(JarBooleanPropertyCounter.class);
        }

        @NotNull
        public final Key<PropertyData> getKey() {
            return this.key;
        }

        public abstract boolean hasProperty(@NotNull VirtualFile var1);

        @NotNull
        public String toString() {
            return "Counter: " + this.key;
        }

        public JarBooleanPropertyCounter(@NotNull String keyName) {
            Intrinsics.checkParameterIsNotNull((Object)keyName, (String)"keyName");
            Key key = Key.create((String)keyName);
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<PropertyData>(keyName)");
            this.key = key;
        }
    }
}

