/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches;

import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.JetClassShortNameIndex;
import org.jetbrains.kotlin.idea.stubindex.JetSourceFilterScope;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;

public class JetGotoClassContributor
implements GotoClassContributor {
    public String getQualifiedName(NavigationItem item) {
        JetNamedDeclaration jetClass;
        FqName name2;
        if (item instanceof JetNamedDeclaration && (name2 = (jetClass = (JetNamedDeclaration)item).getFqName()) != null) {
            return name2.asString();
        }
        return null;
    }

    public String getQualifiedNameSeparator() {
        return ".";
    }

    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        String[] stringArray = (String[])ArrayUtil.toObjectArray((Collection)JetClassShortNameIndex.getInstance().getAllKeys(project), String.class);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/JetGotoClassContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name2, String pattern2, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope2 = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project);
        Collection<JetClassOrObject> classesOrObjects = JetClassShortNameIndex.getInstance().get(name2, project, JetSourceFilterScope.kotlinSourceAndClassFiles(scope2, project));
        if (classesOrObjects.isEmpty()) {
            if (NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/JetGotoClassContributor", "getItemsByName"));
            }
            return NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY;
        }
        ArrayList<JetClassOrObject> items = new ArrayList<JetClassOrObject>();
        for (JetClassOrObject classOrObject : classesOrObjects) {
            if (classOrObject == null || classOrObject instanceof JetEnumEntry) continue;
            items.add(classOrObject);
        }
        NavigationItem[] navigationItemArray = (NavigationItem[])ArrayUtil.toObjectArray(items, NavigationItem.class);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/caches/JetGotoClassContributor", "getItemsByName"));
        }
        return navigationItemArray;
    }
}

