/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.FakeLightClassForFileOfPackage;
import org.jetbrains.kotlin.asJava.KotlinLightClassForFacade;
import org.jetbrains.kotlin.asJava.KotlinLightElement;
import org.jetbrains.kotlin.idea.caches.resolve.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinLightClassForDecompiledDeclaration;
import org.jetbrains.kotlin.idea.caches.resolve.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.resolve.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.SdkInfo;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.JetCodeFragment;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"+\u0006)Qr-\u001a;N_\u0012,H.Z%oM>\u0014\u0015PV5siV\fGNR5mK*9\u0001O]8kK\u000e$(b\u0002)s_*,7\r\u001e\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*Ya/\u001b:uk\u0006dg)\u001b7f\u0015-1\u0016N\u001d;vC24\u0015\u000e\\3\u000b\u0007Y47O\u0003\tjg\u0012+7m\\7qS2,GMR5mK*9!i\\8mK\u0006t'BB6pi2LgN\u0003\bJI\u0016\fWj\u001c3vY\u0016LeNZ8\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*!\u0011\u000eZ3b\u0015\u0019\u0019\u0017m\u00195fg*9!/Z:pYZ,'bD$fi6{G-\u001e7f\u0013:4wn\u0013;\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGOC\u0002qg&TQbZ3u\u001b>$W\u000f\\3J]\u001a|'BE&pi2Lg\u000eT5hQR,E.Z7f]RTa!Y:KCZ\f'\u0002H4fi6{G-\u001e7f\u0013:4wNR8s\u0019&<\u0007\u000e^#mK6,g\u000e\u001eO\u0002\u0015\t\u00012A\u0003\u0003\t\u0001A!!\u0002\u0002\u0005\u0002!\u0015QA\u0001\u0003\u0002\u0011\u0003)1\u0001b\u0001\t\u00031\u0001QA\u0001\u0003\u0002\u0011\u0011)1\u0001\"\u0002\t\b1\u0001Q!\u0001E\u0006\u000b\r!9\u0001C\u0003\r\u0001\u0015\t\u0001RB\u0003\u0003\t\u0013Aq!\u0002\u0002\u0005\u000b!-QA\u0001C\u0006\u0011\u001f)!\u0001\u0002\u0004\t\u0011\u0015\u0011AQ\u0002E\t\u000b\r!q\u0001\u0003\u0004\r\u0001\u0015\u0011Aa\u0002\u0005\u0007\u000b\t!\u0019\u0001C\u0001\u0006\u0005\u0011\u0015\u0001rA\u0003\u0003\t\u0003A!\"B\u0002\u0005\u0014!MA\u0002A\u0003\u0003\t'A\u0019\"\u0002\u0002\u0005\f!]Qa\u0001\u0003\f\u0011-a\u0001!\u0002\u0002\u0005\u0017!YQq\u000b\u0003\u00021\u0001iz\u0001\u0002\u0001\t\u00025\u0019Q!\u0001\u0005\u00031\t\u00016\u0001AO\b\t\u0001A1!D\u0002\u0006\u0003!\u0019\u0001d\u0001)\u0004\u0002u=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0011!I\u0002\u0006\u0003!=\u0001tB)\u0004\u0013\u0011\u0001\u0011\"\u0001\u0005\t\u001b\u0005A\t\"D\u0001\t\u00135\tA\u0011\u0001-\u0004\u0013\u0015\u0011BaA\u000b\u0004\u000b\u0005A!\u0002\u0007\u0006\u0019\u0016\u0005\u001aQ!\u0001E\b1\u001f\t6!\u0002C\u000b\u0013\u0005A\u0001\"D\u0001\t\u0016a\u001b\u0011\"\u0002\f\u0005\u0003U9Q!\u0001E\f\u0013\u0005!\u0019!C\u0001\u0005\u0004a]\u0001\u0004D\u0011\u0004\u000b\u0005Ay\u0001g\u0004R\u0007\u0015!A\"C\u0001\t\u00115\t\u0001\u0002\u0004-\u0004\u0013\u0001"})
public final class GetModuleInfoKt {
    @NotNull
    public static final IdeaModuleInfo getModuleInfo(PsiElement $receiver) {
        Object explicitModuleInfo;
        String doNotAnalyze;
        PsiElement context;
        JetFile containingJetFile;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        getModuleInfo.1 logAndReturnDefault$ = getModuleInfo.1.INSTANCE$;
        if ($receiver instanceof KotlinLightElement) {
            return GetModuleInfoKt.getModuleInfoForLightElement((KotlinLightElement)$receiver);
        }
        PsiElement psiElement2 = $receiver;
        if (!(psiElement2 instanceof JetElement)) {
            psiElement2 = null;
        }
        JetElement jetElement = (JetElement)psiElement2;
        Object object = jetElement != null ? jetElement.getContainingFile() : null;
        if (!(object instanceof JetFile)) {
            object = null;
        }
        JetFile jetFile = containingJetFile = (JetFile)object;
        Object object2 = context = jetFile != null ? JetPsiFactoryKt.getAnalysisContext(jetFile) : null;
        if (context != null) {
            return GetModuleInfoKt.getModuleInfo(context);
        }
        JetFile jetFile2 = containingJetFile;
        String string = doNotAnalyze = jetFile2 != null ? JetPsiFactoryKt.getDoNotAnalyze(jetFile2) : null;
        if (doNotAnalyze != null) {
            StringBuilder stringBuilder = new StringBuilder().append("Should not analyze element: ").append($receiver.getText()).append(" in file ");
            Object object3 = containingJetFile;
            if (object3 == null || (object3 = ((JetFile)object3).getName()) == null) {
                object3 = " <no file>";
            }
            return logAndReturnDefault$.invoke(stringBuilder.append((String)object3).append("\n").append(doNotAnalyze).toString());
        }
        Object object4 = containingJetFile;
        if (object4 == null || (object4 = JetPsiFactoryKt.getModuleInfo((JetFile)object4)) == null) {
            JetFile jetFile3 = containingJetFile;
            Object object5 = jetFile3 != null ? jetFile3.getOriginalFile() : null;
            if (!(object5 instanceof JetFile)) {
                object5 = null;
            }
            JetFile jetFile4 = (JetFile)object5;
            object4 = explicitModuleInfo = jetFile4 != null ? JetPsiFactoryKt.getModuleInfo(jetFile4) : null;
        }
        if (explicitModuleInfo instanceof IdeaModuleInfo) {
            return (IdeaModuleInfo)explicitModuleInfo;
        }
        if (containingJetFile instanceof JetCodeFragment) {
            Object object6 = ((JetCodeFragment)containingJetFile).getContext();
            if (object6 == null || (object6 = GetModuleInfoKt.getModuleInfo(object6)) == null) {
                object6 = logAndReturnDefault$.invoke("Analyzing code fragment of type " + ((JetCodeFragment)containingJetFile).getClass() + " with no context element" + "\n" + "Text:" + "\n" + ((JetCodeFragment)containingJetFile).getText());
            }
            return object6;
        }
        Project project = $receiver.getProject();
        PsiFile psiFile = $receiver.getContainingFile();
        if (psiFile == null) {
            return logAndReturnDefault$.invoke("Analyzing element of type " + $receiver.getClass() + " with no containing file" + "\n" + "Text:" + "\n" + $receiver.getText());
        }
        PsiFile containingFile = psiFile;
        VirtualFile virtualFile = containingFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return logAndReturnDefault$.invoke("Analyzing non-physical file " + containingFile + " of type " + containingFile.getClass());
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        PsiFile psiFile2 = containingFile;
        if (!(psiFile2 instanceof JetFile)) {
            psiFile2 = null;
        }
        JetFile jetFile5 = (JetFile)psiFile2;
        return GetModuleInfoKt.getModuleInfoByVirtualFile(project2, virtualFile2, jetFile5 != null ? jetFile5.isCompiled() : false);
    }

    @NotNull
    public static final IdeaModuleInfo getModuleInfoByVirtualFile(@NotNull Project project, @NotNull VirtualFile virtualFile, boolean isDecompiledFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(virtualFile);
        if (module != null) {
            Function0<Unit> warnIfDecompiled$ = new Function0<Unit>(isDecompiledFile, virtualFile, module){
                final /* synthetic */ boolean $isDecompiledFile;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ Module $module;

                public final void invoke() {
                    if (this.$isDecompiledFile) {
                        KotlinCacheServiceKt.getLOG().warn("Decompiled file for " + this.$virtualFile.getCanonicalPath() + " is in content of " + this.$module);
                    }
                }
                {
                    this.$isDecompiledFile = bl;
                    this.$virtualFile = virtualFile;
                    this.$module = module;
                    super(0);
                }
            };
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            if (moduleFileIndex.isInTestSourceContent(virtualFile)) {
                warnIfDecompiled$.invoke();
                return IdeaModuleInfosKt.testSourceInfo(module);
            }
            if (moduleFileIndex.isInSourceContent(virtualFile)) {
                warnIfDecompiled$.invoke();
                return IdeaModuleInfosKt.productionSourceInfo(module);
            }
        }
        List orderEntries = projectFileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry orderEntry : orderEntries) {
            OrderEntry orderEntry2 = orderEntry;
            if (orderEntry2 instanceof LibraryOrderEntry) {
                Library library;
                if (((LibraryOrderEntry)orderEntry).getLibrary() == null) {
                    continue;
                }
                if (ProjectRootsUtil.isLibraryClassFile(project, virtualFile) && !isDecompiledFile) {
                    Library library2 = library;
                    Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"library");
                    return new LibraryInfo(project, library2);
                }
                if (!ProjectRootsUtil.isLibraryFile(project, virtualFile) && !isDecompiledFile) continue;
                Library library3 = library;
                Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
                return new LibrarySourceInfo(project, library3);
            }
            if (!(orderEntry2 instanceof JdkOrderEntry)) continue;
            Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
            if (sdk == null) {
                continue;
            }
            Sdk sdk2 = sdk;
            return new SdkInfo(project, sdk2);
        }
        return NotUnderContentRootModuleInfo.INSTANCE$;
    }

    @NotNull
    public static final IdeaModuleInfo getModuleInfoForLightElement(KotlinLightElement<?, ?> $receiver) {
        NavigatablePsiElement navigatablePsiElement;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if ($receiver instanceof KotlinLightClassForDecompiledDeclaration) {
            Project project = ((KotlinLightClassForDecompiledDeclaration)$receiver).getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"getProject()");
            VirtualFile virtualFile = ((KotlinLightClassForDecompiledDeclaration)$receiver).getContainingFile().getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"getContainingFile().getVirtualFile()");
            return GetModuleInfoKt.getModuleInfoByVirtualFile(project, virtualFile, false);
        }
        Object obj = $receiver.getOrigin();
        if (obj != null) {
            navigatablePsiElement = (NavigatablePsiElement)obj;
        } else {
            PsiFile psiFile;
            KotlinLightElement<?, ?> kotlinLightElement = $receiver;
            if (kotlinLightElement instanceof FakeLightClassForFileOfPackage) {
                psiFile = ((FakeLightClassForFileOfPackage)$receiver).getContainingFile();
                if (psiFile == null) {
                    Intrinsics.throwNpe();
                }
            } else if (kotlinLightElement instanceof KotlinLightClassForFacade) {
                psiFile = (PsiFile)CollectionsKt.first((Iterable)((KotlinLightClassForFacade)$receiver).getFiles());
            } else {
                throw (Throwable)new IllegalStateException("Unknown light class without origin is referenced by IDE lazy resolve: " + $receiver.getClass());
            }
            navigatablePsiElement = (NavigatablePsiElement)psiFile;
        }
        NavigatablePsiElement element2 = navigatablePsiElement;
        return GetModuleInfoKt.getModuleInfo((PsiElement)element2);
    }
}

