/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Queue;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.caches.resolve.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleIndex;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ModuleTestSourceInfo;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"b\u0004)iq-\u001a;EKB,g\u000eZ3oiNTa!\\8ek2,'BB'pIVdWMC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015\r\u0019V\r\u001e\u0006\u0007W>$H.\u001b8\u000b\t)\fg/\u0019\u0006\u0005kRLGN\u0003\nN_\u0012,H.\u001a#fa\u0016tG-\u001a8ug.#(BD4fi6{G-\u001e7f\u0013:$W\r\u001f\u0006\baJ|'.Z2u\u0015\u001d\u0001&o\u001c6fGRT1\"T8ek2,\u0017J\u001c3fq*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(\u0002B5eK\u0006TaaY1dQ\u0016\u001c(b\u0002:fg>dg/\u001a\u0006\u0011\u001b>$W\u000f\\3T_V\u00148-Z%oM>T1cZ3u\t\u0016\u0004XM\u001c3f]Rlu\u000eZ;mKN\u0014\u001aA\u0003\u0002\u0011\u0007)!\u0001\u0002\u0001\t\u0005\u0015\u0011A\u0011\u0001E\u0003\u000b\t!\u0011\u0001#\u0001\u0006\u0007\u0011\r\u0001\"\u0001\u0007\u0001\u000b\u0005A9!B\u0002\u0005\u0006!\u0019A\u0002A\u0003\u0002\u0011\u0011)!\u0001b\u0002\t\n\u0015\u0011A\u0001\u0002\u0005\u0004\u000b\t!\u0019\u0001C\u0001\u0006\u0005\u0011\t\u0001BB\u0003\u0004\t\u0017Ai\u0001\u0004\u0001\u0006\u0003!=QA\u0001C\u0007\u0011!)!\u0001B\u0004\t\b\u0015\u0011Aq\u0002E\t\u000b\t!\u0001\u0002C\u0005\u0006\u0005\u0011E\u00012C\u0003\u0004\t%Aq\u0001\u0004\u0001\u0006\u0005\u0011I\u0001bB\u0003\u0003\t\u0017Ai!B\u0002\u0005\u0013!QA\u0002A\u0003\u0003\t%A!\"b\u000e\u0005\u0003a\u0001Qt\u0002\u0003\u0001\u0011\u0003i1!B\u0001\t\u0005a\u0011\u0001k\u0001\u0001\"\u0011\u0015\t\u0001bA\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0002\u0019\u0005a\u0019\u0011kA\u0003\u0005\u0001%\t\u0001\u0012B\u0007\u0002\u0011\u0015A6!BC\u0017\t\u0005AZ!h\u0004\u0005\u0001!1QbA\u0003\u0002\u0011\u0019Ab\u0001U\u0002\u0001C\r)\u0011\u0001c\u0005\u0019\u0014E\u001bQ\u0001b\u0003\n\u0003!QQ\"\u0001E\u000b1\u000e)Qa\u0006\u0003\u0004+\r)\u0011\u0001C\u0006\u0019\u0017aU\u0011\u0005C\u0003\u0002\u0011\rIA!C\u0002\u0006\u0003!Y\u0001d\u0003\r\u0004#\u000e)AQC\u0005\u0002\u0011\u0013i\u0011\u0001c\u0006Y\u0007\u0015\u0001"})
public final class ModuleDependentsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ModuleSourceInfo> getDependentModules(ModuleSourceInfo $receiver) {
        void var3_5;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Set<Module> dependents = ModuleDependentsKt.getDependents($receiver.getModule());
        if (IdeaModuleInfosKt.isTests($receiver)) {
            void $receiver2;
            Iterable iterable = dependents;
            Collection destination = new HashSet();
            for (Object item : $receiver2) {
                void it;
                Module module = (Module)item;
                Collection collection = destination;
                ModuleTestSourceInfo moduleTestSourceInfo = IdeaModuleInfosKt.testSourceInfo((Module)it);
                collection.add(moduleTestSourceInfo);
            }
            return (Set)destination;
        }
        Iterable $receiver2 = dependents;
        Collection destination = new HashSet();
        for (Object element2 : $receiver2) {
            Module it = (Module)element2;
            Iterable list = CollectionsKt.listOf((Object[])new ModuleSourceInfo[]{IdeaModuleInfosKt.productionSourceInfo(it), IdeaModuleInfosKt.testSourceInfo(it)});
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        return (Set)var3_5;
    }

    @NotNull
    public static final Set<Module> getDependents(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        THashSet result2 = new THashSet();
        result2.add((Object)module);
        THashSet processedExporting = new THashSet();
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.getProject()");
        ModuleIndex index2 = ModuleDependentsKt.getModuleIndex(project);
        Queue walkingQueue = new Queue(10);
        walkingQueue.addLast((Object)module);
        while (!walkingQueue.isEmpty()) {
            Module current;
            Module module2 = current = (Module)walkingQueue.pullFirst();
            if (module2 == null) {
                Intrinsics.throwNpe();
            }
            processedExporting.add((Object)module2);
            result2.addAll(index2.getPlainUsages().get((Object)current));
            for (Module dependent : index2.getExportingUsages().get((Object)current)) {
                result2.add((Object)dependent);
                if (!processedExporting.add((Object)dependent)) continue;
                walkingQueue.addLast((Object)dependent);
            }
        }
        return (Set)result2;
    }

    @NotNull
    public static final ModuleIndex getModuleIndex(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, new CachedValueProvider<T>(project){
            final /* synthetic */ Project $project;

            @NotNull
            public final CachedValueProvider.Result<ModuleIndex> compute() {
                ModuleIndex index2 = new ModuleIndex();
                Module[] moduleArray = ModuleManager.getInstance((Project)this.$project).getModules();
                for (int i = 0; i < moduleArray.length; ++i) {
                    Module module = moduleArray[i];
                    OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
                    for (int j = 0; j < orderEntryArray.length; ++j) {
                        Module referenced;
                        OrderEntry orderEntry = orderEntryArray[j];
                        if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                        MultiMap<Module, Module> map2 = ((ModuleOrderEntry)orderEntry).isExported() ? index2.getExportingUsages() : index2.getPlainUsages();
                        map2.putValue((Object)referenced, (Object)module);
                    }
                }
                return new CachedValueProvider.Result((Object)index2, new Object[]{ProjectRootModificationTracker.getInstance((Project)this.$project)});
            }
            {
                this.$project = project;
            }
        });
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (ModuleIndex)object;
    }
}

