/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.JetType;

public abstract class KotlinExpressionSurrounder
implements Surrounder {
    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinExpressionSurrounder", "isApplicable"));
        }
        if (elements.length != 1 || !(elements[0] instanceof JetExpression)) {
            return false;
        }
        JetExpression expression2 = (JetExpression)elements[0];
        if (expression2 instanceof JetCallExpression && expression2.getParent() instanceof JetQualifiedExpression) {
            return false;
        }
        JetType type2 = ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL).getType(expression2);
        if (type2 == null || KotlinBuiltIns.isUnit(type2)) {
            return false;
        }
        return this.isApplicable(expression2);
    }

    protected abstract boolean isApplicable(@NotNull JetExpression var1);

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinExpressionSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinExpressionSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinExpressionSurrounder", "surroundElements"));
        }
        assert (elements.length == 1) : "KotlinExpressionSurrounder should be applicable only for 1 expression: " + elements.length;
        return this.surroundExpression(project, editor, (JetExpression)elements[0]);
    }

    @Nullable
    protected abstract TextRange surroundExpression(@NotNull Project var1, @NotNull Editor var2, @NotNull JetExpression var3);
}

