/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.AbstractUnwrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtil;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;

public abstract class KotlinUnwrapRemoveBase
extends AbstractUnwrapper<Context> {
    private final String key;

    protected KotlinUnwrapRemoveBase(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase", "<init>"));
        }
        super("");
        this.key = key;
    }

    public String getDescription(PsiElement e) {
        assert (e instanceof JetElement);
        return JetBundle.message(this.key, JetRefactoringUtil.getExpressionShortText((JetElement)e));
    }

    protected boolean canExtractExpression(@NotNull JetExpression expression2, @NotNull JetElement parent2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase", "canExtractExpression"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase", "canExtractExpression"));
        }
        if (expression2 instanceof JetBlockExpression) {
            JetBlockExpression block = (JetBlockExpression)expression2;
            return block.getStatements().size() <= 1 || parent2 instanceof JetBlockExpression;
        }
        return true;
    }

    protected Context createContext() {
        return new Context();
    }

    protected static class Context
    extends AbstractUnwrapper.AbstractContext {
        protected Context() {
        }

        protected boolean isWhiteSpace(PsiElement element2) {
            return element2 instanceof PsiWhiteSpace;
        }

        public void extractFromBlock(@NotNull JetBlockExpression block, @NotNull JetElement from) throws IncorrectOperationException {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "extractFromBlock"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "extractFromBlock"));
            }
            List<JetExpression> expressions = block.getStatements();
            if (!expressions.isEmpty()) {
                this.extract((PsiElement)expressions.get(0), (PsiElement)expressions.get(expressions.size() - 1), (PsiElement)from);
            }
        }

        public void extractFromExpression(@NotNull JetExpression expression2, @NotNull JetElement from) throws IncorrectOperationException {
            if (expression2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "extractFromExpression"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "extractFromExpression"));
            }
            if (expression2 instanceof JetBlockExpression) {
                this.extractFromBlock((JetBlockExpression)expression2, from);
            } else {
                this.extract((PsiElement)expression2, (PsiElement)expression2, (PsiElement)from);
            }
        }

        public void replace(@NotNull JetElement originalElement, @NotNull JetElement newElement) {
            if (originalElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "replace"));
            }
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrapRemoveBase$Context", "replace"));
            }
            if (this.myIsEffective) {
                originalElement.replace((PsiElement)newElement);
            }
        }
    }
}

