/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinComponentUnwrapper;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinRemover;
import org.jetbrains.kotlin.idea.codeInsight.unwrap.KotlinUnwrapRemoveBase;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetCatchClause;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFinallySection;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.PsiPackage;

public class KotlinUnwrappers {
    private KotlinUnwrappers() {
    }

    public static class KotlinFinallyRemover
    extends KotlinRemover {
        public KotlinFinallyRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof JetFinallySection;
        }
    }

    public static class KotlinFinallyUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinFinallyUnwrapper(String key) {
            super(key);
        }

        @Override
        public boolean isApplicableTo(PsiElement e) {
            return super.isApplicableTo(e) && this.getEnclosingElement((JetElement)e).getParent() instanceof JetBlockExpression;
        }

        @Override
        @NotNull
        protected JetElement getEnclosingElement(@NotNull JetElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinFinallyUnwrapper", "getEnclosingElement"));
            }
            JetElement jetElement = (JetElement)element2.getParent();
            if (jetElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinFinallyUnwrapper", "getEnclosingElement"));
            }
            return jetElement;
        }

        @Override
        protected JetExpression getExpressionToUnwrap(@NotNull JetElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinFinallyUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof JetFinallySection ? ((JetFinallySection)target).getFinalExpression() : null;
        }
    }

    public static class KotlinCatchRemover
    extends KotlinRemover {
        public KotlinCatchRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof JetCatchClause;
        }
    }

    public static class KotlinCatchUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinCatchUnwrapper(String key) {
            super(key);
        }

        @Override
        @NotNull
        protected JetElement getEnclosingElement(@NotNull JetElement element2) {
            if (element2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinCatchUnwrapper", "getEnclosingElement"));
            }
            JetElement jetElement = (JetElement)element2.getParent();
            if (jetElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinCatchUnwrapper", "getEnclosingElement"));
            }
            return jetElement;
        }

        @Override
        protected JetExpression getExpressionToUnwrap(@NotNull JetElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinCatchUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof JetCatchClause ? ((JetCatchClause)target).getCatchBody() : null;
        }
    }

    public static class KotlinTryUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinTryUnwrapper(String key) {
            super(key);
        }

        @Override
        @Nullable
        protected JetExpression getExpressionToUnwrap(@NotNull JetElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinTryUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof JetTryExpression ? ((JetTryExpression)target).getTryBlock() : null;
        }
    }

    public static class KotlinLoopUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinLoopUnwrapper(String key) {
            super(key);
        }

        @Override
        @Nullable
        protected JetExpression getExpressionToUnwrap(@NotNull JetElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinLoopUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof JetLoopExpression ? ((JetLoopExpression)target).getBody() : null;
        }
    }

    public static class KotlinElseRemover
    extends KotlinUnwrapRemoveBase {
        public KotlinElseRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof JetIfExpression && ((JetIfExpression)e).getCondition() != null && ((JetIfExpression)e).getThen() != null && ((JetIfExpression)e).getElse() != null;
        }

        protected void doUnwrap(PsiElement element2, KotlinUnwrapRemoveBase.Context context) throws IncorrectOperationException {
            JetIfExpression ifExpr = (JetIfExpression)element2;
            context.replace(ifExpr, PsiPackage.JetPsiFactory((PsiElement)ifExpr).createIf(ifExpr.getCondition(), ifExpr.getThen(), null));
        }
    }

    public static class KotlinThenUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinThenUnwrapper(String key) {
            super(key);
        }

        @Override
        protected JetExpression getExpressionToUnwrap(@NotNull JetElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinThenUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof JetIfExpression ? ((JetIfExpression)target).getThen() : null;
        }
    }

    public static class KotlinElseUnwrapper
    extends KotlinComponentUnwrapper {
        public KotlinElseUnwrapper(String key) {
            super(key);
        }

        @Override
        protected JetExpression getExpressionToUnwrap(@NotNull JetElement target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/idea/codeInsight/unwrap/KotlinUnwrappers$KotlinElseUnwrapper", "getExpressionToUnwrap"));
            }
            return target instanceof JetIfExpression ? ((JetIfExpression)target).getElse() : null;
        }
    }

    public static class KotlinExpressionRemover
    extends KotlinRemover {
        public KotlinExpressionRemover(String key) {
            super(key);
        }

        public boolean isApplicableTo(PsiElement e) {
            return e instanceof JetExpression && e.getParent() instanceof JetBlockExpression;
        }
    }
}

