/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.refactoring.RefactoringPackage;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;

public abstract class AbstractJetUpDownMover
extends LineMover {
    protected AbstractJetUpDownMover() {
    }

    protected abstract boolean checkSourceElement(@NotNull PsiElement var1);

    protected abstract LineRange getElementSourceLineRange(@NotNull PsiElement var1, @NotNull Editor var2, @NotNull LineRange var3);

    @Nullable
    protected LineRange getSourceRange(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement, @NotNull Editor editor, LineRange oldRange) {
        JetBlockExpression block;
        if (firstElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstElement", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "getSourceRange"));
        }
        if (lastElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastElement", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "getSourceRange"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "getSourceRange"));
        }
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        int topExtension = 0;
        int bottomExtension = 0;
        if (parent2 instanceof JetFunctionLiteral && (block = ((JetFunctionLiteral)parent2).getBodyExpression()) != null) {
            PsiElement comment = null;
            boolean extendDown = false;
            if (AbstractJetUpDownMover.checkCommentAtBlockBound(firstElement, lastElement, block)) {
                comment = lastElement;
                extendDown = true;
                lastElement = block.getLastChild();
            } else if (AbstractJetUpDownMover.checkCommentAtBlockBound(lastElement, firstElement, block)) {
                comment = firstElement;
                firstElement = block.getFirstChild();
            }
            if (comment != null) {
                int extension = RefactoringPackage.getLineCount(comment);
                if (extendDown) {
                    bottomExtension = extension;
                } else {
                    topExtension = extension;
                }
            }
            parent2 = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        }
        if (parent2 == null) {
            return null;
        }
        Pair originalRange = AbstractJetUpDownMover.getElementRange((PsiElement)parent2, (PsiElement)firstElement, (PsiElement)lastElement);
        if (!this.checkSourceElement((PsiElement)originalRange.first) || !this.checkSourceElement((PsiElement)originalRange.second)) {
            return null;
        }
        LineRange lineRange1 = this.getElementSourceLineRange((PsiElement)originalRange.first, editor, oldRange);
        if (lineRange1 == null) {
            return null;
        }
        LineRange lineRange2 = this.getElementSourceLineRange((PsiElement)originalRange.second, editor, oldRange);
        if (lineRange2 == null) {
            return null;
        }
        LineRange parentLineRange = this.getElementSourceLineRange(parent2, editor, oldRange);
        LineRange sourceRange = new LineRange(lineRange1.startLine - topExtension, lineRange2.endLine + bottomExtension);
        if (parentLineRange != null && sourceRange.startLine == parentLineRange.startLine && sourceRange.endLine == parentLineRange.endLine) {
            sourceRange.firstElement = sourceRange.lastElement = parent2;
        } else {
            sourceRange.firstElement = (PsiElement)originalRange.first;
            sourceRange.lastElement = (PsiElement)originalRange.second;
        }
        return sourceRange;
    }

    protected static int getElementLine(PsiElement element2, Editor editor, boolean first) {
        if (element2 == null) {
            return -1;
        }
        Document doc = editor.getDocument();
        TextRange spaceRange = element2.getTextRange();
        return first ? doc.getLineNumber(spaceRange.getStartOffset()) : doc.getLineNumber(spaceRange.getEndOffset());
    }

    protected static PsiElement getLastNonWhiteSiblingInLine(@Nullable PsiElement element2, @NotNull Editor editor, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "getLastNonWhiteSiblingInLine"));
        }
        if (element2 == null) {
            return null;
        }
        int line = AbstractJetUpDownMover.getElementLine(element2, editor, down);
        PsiElement lastElement = element2;
        while (true) {
            if (lastElement == null) {
                return null;
            }
            PsiElement sibling = AbstractJetUpDownMover.firstNonWhiteSibling(lastElement, down);
            if (AbstractJetUpDownMover.getElementLine(sibling, editor, down) != line) break;
            lastElement = sibling;
        }
        return lastElement;
    }

    private static boolean checkCommentAtBlockBound(PsiElement blockElement, PsiElement comment, JetBlockExpression block) {
        return PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)blockElement, (boolean)true) && comment instanceof PsiComment;
    }

    @Nullable
    protected static PsiElement getSiblingOfType(@NotNull PsiElement element2, boolean down, @NotNull Class<? extends PsiElement> type2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "getSiblingOfType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "getSiblingOfType"));
        }
        return down ? PsiTreeUtil.getNextSiblingOfType((PsiElement)element2, type2) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)element2, type2);
    }

    @Nullable
    protected static PsiElement firstNonWhiteSibling(@NotNull LineRange lineRange, boolean down) {
        if (lineRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineRange", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "firstNonWhiteSibling"));
        }
        return AbstractJetUpDownMover.firstNonWhiteElement((PsiElement)(down ? lineRange.lastElement.getNextSibling() : lineRange.firstElement.getPrevSibling()), (boolean)down);
    }

    @Nullable
    protected static PsiElement firstNonWhiteSibling(@NotNull PsiElement element2, boolean down) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "firstNonWhiteSibling"));
        }
        return AbstractJetUpDownMover.firstNonWhiteElement((PsiElement)(down ? element2.getNextSibling() : element2.getPrevSibling()), (boolean)down);
    }

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "checkAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "checkAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractJetUpDownMover", "checkAvailable"));
        }
        return file instanceof JetFile && super.checkAvailable(editor, file, info, down);
    }
}

