/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.openapi.project.Project;
import java.util.HashSet;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0003\b)Q\u0012*\u001c9peR\f'\r\\3Gc:\u000bW.Z\"mCN\u001c\u0018NZ5fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002B2pe\u0016T1!\u00118z\u0015\u0019a\u0014N\\5u})!a-\u001b7f\u0015\u001dQU\r\u001e$jY\u0016T1\u0001]:j\u0015=\tG\u000e\\+oI\u0016\u0014\u0018*\u001c9peR\u001c(b\u0002%bg\"\u001cV\r\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'B\u0002$r\u001d\u0006lWM\u0003\u0003oC6,'\"\u00069sK\u000eL7/Z%na>\u0014H\u000fU1dW\u0006<Wm\u001d\u0006\u000faJ,7-[:f\u00136\u0004xN\u001d;t\u0015!\u0019G.Y:tS\u001aL(B\u00024r\u001d\u0006lWMC\u0005jgB\u000b7m[1hK*9!i\\8mK\u0006t'BD\"mCN\u001c\u0018NZ5dCRLwN\u001c\u0006*\u00136\u0004xN\u001d;bE2,g)\u001d(b[\u0016\u001cE.Y:tS\u001aLWM\u001d\u0013DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b7!\f7\u000f\u0015:fG&\u001cX-S7q_J$hI]8n!\u0006\u001c7.Y4f\u0015-\u0001\u0018mY6bO\u0016t\u0015-\\3\u000b9%\u001c\u0018*\u001c9peR,GmV5uQ\u0006cG.\u00168eKJLU\u000e]8si*Y\u0012n]%na>\u0014H/\u001a3XSRD\u0007K]3dSN,\u0017*\u001c9peR4\u0019A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\u0004\u0011\ra\u0001!\u0002\u0002\u0005\u0003!)Qa\u0001\u0003\u0005\u0011\u0013a\u0001!\u0002\u0002\u0005\t!%Q!\u0001E\u0007\u000b\t!Y\u0001C\u0004\u0006\u0007\u00111\u0001B\u0002\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0005\u0006\u0007\u00119\u0001r\u0002\u0007\u0001\u000b\t!a\u0001\u0003\u0004\u0006\u0007\u0011\u0019\u0001b\u0003\u0007\u0001\u000b\r!)\u0001c\u0006\r\u0001\u0015\u0011AA\u0001\u0005\r\u000b\t!q\u0001c\u0004\u0005\u00071\u0015\u0011dA\u0003\u0002\u0011\u000fA:!(A\f[E!\u0011\r\u0002M\u0006C!)\u0011\u0001#\u0004\n\t%\u0019Q!\u0001E\b1\u001fAj!V\u0002\u0005\u000b\r!Y!C\u0001\t\u00115bA!\u0019\u0003\u0019\t\u0005\u001aQ!\u0001E\u00051\u0013)6\u0001B\u0003\u0004\t\u0011I\u0011\u0001C\u0003.#\u0011\tG\u0001'\u0005\"\u0011\u0015\t\u0001RB\u0005\u0005\u0013\r)\u0011\u0001c\u0004\u0019\u0010a5Qk\u0001\u0003\u0006\u0007\u0011E\u0011\"\u0001\u0005\t[E!\u0011\r\u0002\r\nC!)\u0011\u0001#\u0004\n\t%\u0019Q!\u0001E\b1\u001fAj!V\u0002\u0005\u000b\r!\u0011\"C\u0001\t\u00115~Ba\u0001M\n;\u001f!\u0001\u0001\u0003\u0006\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\u0001Qt\u0002\u0003\u0001\u0011+i1!B\u0001\t\u0012aE\u0001k!\u0001\"\u0007\u0015\t\u0001\"\u0003\r\n#\u000e9A1C\u0005\u0002\u0011'i\u0011\u0001\u0003\u0006\u000e\u0003\u0011\u0005Q&\u0006\u0003\u000213iz\u0001\u0002\u0001\t\u001b5\u0019Q!\u0001E\b1\u001f\u00016\u0001A\u0011\u0004\u000b\u0005A\t\u0002'\u0005R\u0007\u0015!I\"C\u0001\u0005\u00025\t\u0001BC\u0017\u0016\t\u0005AZ\"h\u0004\u0005\u0001!AQbA\u0003\u0002\u0011\u001fAz\u0001U\u0002\u0001C\r)\u0011\u0001#\u0005\u0019\u0012E\u001bQ\u0001b\u0007\n\u0003\u0011\u0005Q\"\u0001\u0005\u000b[U!\u0011\u0001\u0007\b\u001e\u0010\u0011\u0001\u0001\u0002C\u0007\u0004\u000b\u0005Ay\u0001g\u0004Q\u0007\u0001\t3!B\u0001\t\u0012aE\u0011kA\u0003\u0005\u001d%\tA\u0011A\u0007\u0002\u0011))l#b\u000b\u0005G\u0004A:!h\u0004\u0005\u0001!!QbA\u0003\u0002\u0011\u0013AJ\u0001U\u0002\u0001C\r)\u0011\u0001#\u0002\u0019\u0006E\u001bQ\u0001b\u0002\n\u0003\u0011\u0001Q\"\u0001\u0005\u0006"})
public final class ImportableFqNameClassifier {
    public static final /* synthetic */ KClass $kotlinClass;
    private final HashSet<FqName> preciseImports;
    private final HashSet<FqName> preciseImportPackages;
    private final HashSet<FqName> allUnderImports;
    private final JetFile file;

    static {
        $kotlinClass = Reflection.createKotlinClass(ImportableFqNameClassifier.class);
    }

    @NotNull
    public final Classification classify(@NotNull FqName fqName2, boolean isPackage) {
        Classification classification;
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        ImportPath importPath = new ImportPath(fqName2, false);
        if (isPackage) {
            return this.isImportedWithPreciseImport(fqName2) ? Classification.preciseImport : (fqName2.parent().isRoot() ? Classification.topLevelPackage : Classification.notImported);
        }
        if (CollectionsKt.isNotEmpty(JavaToKotlinClassMap.INSTANCE.mapPlatformClass(fqName2))) {
            classification = Classification.notToBeUsedInKotlin;
        } else if (Intrinsics.areEqual((Object)fqName2.parent(), (Object)this.file.getPackageFqName())) {
            classification = Classification.fromCurrentPackage;
        } else {
            Project project = this.file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            if (ImportInsertHelper.Companion.getInstance(project).isImportedWithDefault(importPath, this.file)) {
                classification = Classification.defaultImport;
            } else if (this.isImportedWithPreciseImport(fqName2)) {
                classification = Classification.preciseImport;
            } else if (this.isImportedWithAllUnderImport(fqName2)) {
                classification = Classification.allUnderImport;
            } else {
                FqName fqName3 = fqName2.parent();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName.parent()");
                classification = this.hasPreciseImportFromPackage(fqName3) ? Classification.hasImportFromSamePackage : Classification.notImported;
            }
        }
        return classification;
    }

    private final boolean isImportedWithPreciseImport(FqName name2) {
        return this.preciseImports.contains(name2);
    }

    private final boolean isImportedWithAllUnderImport(FqName name2) {
        return this.allUnderImports.contains(name2.parent());
    }

    private final boolean hasPreciseImportFromPackage(FqName packageName) {
        return this.preciseImportPackages.contains(packageName);
    }

    public ImportableFqNameClassifier(@NotNull JetFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        this.preciseImports = new HashSet();
        this.preciseImportPackages = new HashSet();
        this.allUnderImports = new HashSet();
        for (JetImportDirective jetImportDirective : this.file.getImportDirectives()) {
            ImportPath importPath;
            if (jetImportDirective.getImportPath() == null) {
                continue;
            }
            FqName fqName2 = importPath.fqnPart();
            if (importPath.isAllUnder()) {
                this.allUnderImports.add(fqName2);
                continue;
            }
            this.preciseImports.add(fqName2);
            this.preciseImportPackages.add(fqName2.parent());
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0002\u0006)q1\t\\1tg&4\u0017nY1uS>t'BG%na>\u0014H/\u00192mK\u001a\u000bh*Y7f\u00072\f7o]5gS\u0016\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t%$W-\u0019\u0006\u0005G>\u0014XM\u0003\u0003F]Vl'B\u0002\u001fj]&$hH\u0003\u0003kCZ\f'\u0002\u00027b]\u001eTaa\u0015;sS:<'B\u00054s_6\u001cUO\u001d:f]R\u0004\u0016mY6bO\u0016Tq\u0002^8q\u0019\u00164X\r\u001c)bG.\fw-\u001a\u0006\u000eI\u00164\u0017-\u001e7u\u00136\u0004xN\u001d;\u000b\u001bA\u0014XmY5tK&k\u0007o\u001c:u\u00159\tG\u000e\\+oI\u0016\u0014\u0018*\u001c9peRT\u0001\u0004[1t\u00136\u0004xN\u001d;Ge>l7+Y7f!\u0006\u001c7.Y4f\u0015-qw\u000e^%na>\u0014H/\u001a3\u000b'9|G\u000fV8CKV\u001bX\rZ%o\u0017>$H.\u001b8I\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)!\u0001b\u0001\t\u0007\u0015\u0019AA\u0001E\u0001\u0019\u0001)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0003\u000b\r!9\u0001c\u0002\r\u0001\u0015\t\u0001\u0012B\u0003\u0003\t\u0013AQ!\u0002\u0002\u0005\u000b!-Aa1\u0001\r\u0007eAQ!\u0001\u0005\u0005\u0013\u0011I1!B\u0001\t\u0007a\u0019\u0001\u0004B\u0019\u0005\r\u001b9y\u0001#\u0005\n\u0014U\u0002Ra\u0004\u0003b\u0002a!\u0011eA\u0003\u0002\u0011\rA2!U\u0002\b\t\u0011I\u0011\u0001\u0002\u0001\u000e\u0003!-Q\"\u0001C\u0003"})
    public static final class Classification
    extends Enum<Classification> {
        public static final /* synthetic */ KClass $kotlinClass;
        public static final /* enum */ Classification fromCurrentPackage;
        public static final /* enum */ Classification topLevelPackage;
        public static final /* enum */ Classification defaultImport;
        public static final /* enum */ Classification preciseImport;
        public static final /* enum */ Classification allUnderImport;
        public static final /* enum */ Classification hasImportFromSamePackage;
        public static final /* enum */ Classification notImported;
        public static final /* enum */ Classification notToBeUsedInKotlin;
        private static final /* synthetic */ Classification[] $VALUES;

        static {
            $kotlinClass = Reflection.createKotlinClass(Classification.class);
            Classification[] classificationArray = new Classification[8];
            Classification[] classificationArray2 = classificationArray;
            classificationArray[0] = fromCurrentPackage = new Classification();
            classificationArray[1] = topLevelPackage = new Classification();
            classificationArray[2] = defaultImport = new Classification();
            classificationArray[3] = preciseImport = new Classification();
            classificationArray[4] = allUnderImport = new Classification();
            classificationArray[5] = hasImportFromSamePackage = new Classification();
            classificationArray[6] = notImported = new Classification();
            classificationArray[7] = notToBeUsedInKotlin = new Classification();
            $VALUES = classificationArray;
        }

        public static Classification[] values() {
            return (Classification[])$VALUES.clone();
        }

        public static Classification valueOf(String string) {
            return Enum.valueOf(Classification.class, string);
        }
    }
}

