/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.formatter;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;

public class JetCodeStyleSettings
extends CustomCodeStyleSettings {
    public boolean SPACE_AROUND_RANGE = false;
    public boolean SPACE_BEFORE_TYPE_COLON = false;
    public boolean SPACE_AFTER_TYPE_COLON = true;
    public boolean SPACE_BEFORE_EXTEND_COLON = true;
    public boolean SPACE_AFTER_EXTEND_COLON = true;
    public boolean INSERT_WHITESPACES_IN_SIMPLE_ONE_LINE_METHOD = true;
    public boolean ALIGN_IN_COLUMNS_CASE_BRANCH = false;
    public boolean SPACE_AROUND_FUNCTION_TYPE_ARROW = true;
    public boolean SPACE_AROUND_WHEN_ARROW = true;
    public boolean SPACE_BEFORE_LAMBDA_ARROW = true;
    public boolean LBRACE_ON_NEXT_LINE = false;
    public int NAME_COUNT_TO_USE_STAR_IMPORT = ApplicationManager.getApplication().isUnitTestMode() ? Integer.MAX_VALUE : 5;
    public boolean IMPORT_NESTED_CLASSES = false;
    public final PackageEntryTable PACKAGES_TO_USE_STAR_IMPORTS = new PackageEntryTable();

    public static JetCodeStyleSettings getInstance(Project project) {
        return (JetCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JetCodeStyleSettings.class);
    }

    public JetCodeStyleSettings(CodeStyleSettings container2) {
        super("JetCodeStyleSettings", container2);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.PACKAGES_TO_USE_STAR_IMPORTS.addEntry(new PackageEntry(false, "java.util", false));
        }
    }

    public Object clone() {
        JetCodeStyleSettings clone = new JetCodeStyleSettings(this.getContainer());
        clone.copyFrom(this);
        return clone;
    }

    private void copyFrom(@NotNull JetCodeStyleSettings from) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/kotlin/idea/core/formatter/JetCodeStyleSettings", "copyFrom"));
        }
        ReflectionUtil.copyFields((Field[])((Object)((Object)this)).getClass().getFields(), (Object)((Object)from), (Object)((Object)this));
        this.PACKAGES_TO_USE_STAR_IMPORTS.copyFrom(from.PACKAGES_TO_USE_STAR_IMPORTS);
    }
}

