/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.module.impl.scopes.LibraryScopeBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"4\b)\u0019AjT$\u000b\r1{wmZ3s\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'B\u00033jC\u001etwn\u001d;jG*92n\u001c;mS:t#N^7/!2\fGOZ8s[RK\b/\u001a\u0006\u0007O\u0016$HjT$\u000bSA{7/\u001b;j_:l\u0015M\\1hKJd\u0015N\u0019:bef\u001cE.Y:t\r&dWmU3be\u000eDWM]&u\u0015\t2\u0017N\u001c3QC\u000e\\\u0017mZ3QCJ$h)\u001b7f\u001d\u0006lWm\u001d$pe\u0016cW-\\3oi*IQ\r\\3nK:$\u0018\t\u001e\u0006\u000b\u0015\u0016$X\t\\3nK:$(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\u0007A\u001c\u0018N\u0003\u0003MSN$(BB*ue&twM\u0003\u0003kCZ\f'\u0002B;uS2T\u0011FZ5oIB\u000b7m[1hKB\u000b'\u000f^%oi\u0016\u0014h.\u00197OC6,gi\u001c:MS\n\u0014\u0018M]=GS2,'b\u0005;pa2+g/\u001a7EK\u000ed\u0017M]1uS>t'B\u0004&fi\u0012+7\r\\1sCRLwN\u001c\u0006\u0005Y\u0006twM\u0003\u0004sK:$WM\u001d\u0006\u0005I\u0016\u001c8MC\u000bEK\u000ed\u0017M]1uS>tG)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\fe\u0016\u0004xN\u001d;FeJ|'OC\u0004fY\u0016lWM\u001c;\u000b\u0015\u0011,7o\u0019:jaR|'O\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(\u0002B+oSR\u0004\u001cA\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0007\u0011\r\u0001\u0012\u0001\u0007\u0001\u000b\t!\u0019\u0001#\u0001\u0006\u0003!1QA\u0001\u0003\u0004\u0011\u001b)!\u0001b\u0002\t\u000f\u0015\u0011A\u0001\u0002E\b\u000b\r!I\u0001c\u0003\r\u0001\u0015\t\u0001bB\u0003\u0004\t\u0017A\u0001\u0002\u0004\u0001\u0006\u0007\u0011-\u0001\u0012\u0003\u0007\u0001\u000b\u0005A\u0011\"\u0002\u0002\u0005\u000f!MQA\u0001C\b\u0011!)!\u0001\"\u0003\t\f\u0015\u0019A\u0011\u0002\u0005\f\u0019\u0001)!\u0001B\u0004\t\u0018\u0015\u0011A1\u0003E\t\u000b\t!I\u0001C\u0006\u0006\u0005\u0011!\u00012D\u0003\u0004\t-AQ\u0002\u0004\u0001\u0006\u0005\u0011Y\u0001\"D\u0003\u0004\t-Ay\u0002\u0004\u0001\u0006\u0007\u0011-\u0001\u0002\u0005\u0007\u0001\u000b\t!1\u0002c\b\u00060\u0011\tG\u0001\u0007\u0001\"\u0013\u0015\t\u0001B\u0001\t\u0004+\u0011)\u0011\u0001\u0003\u0002\r\u0002a\u0011\u0001DA+\u0004\u0011\u0015\u0019A\u0001A\u0005\u0002\u0011\u000bi1\u0001b\u0002\n\u0003!\u0015\u0001l\u0001\u0003\u00068\u0011\t\u0001\u0014BO\b\t\u0001AQ!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001\u0005BQ!\u0001\u0005\u0007\u0013\u0011I1!B\u0001\t\u000ea5\u0001DB)\u0004\u000b\u0011%\u0011\"\u0001\u0005\t\u001b\u0005A\t\u0002W\u0002\u0005\u000b_!1\u0001\u0007\u0006\u001e\u0010\u0011\u0001\u0001RC\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0001\tC!B\u0001\t\u000e1\u0005\u0001TB)\u0004\u000b\u0011Q\u0011\"\u0001\u0005\u000b\u001b\u0005A)\u0002W\u0002\u0005\u000b[!\u0011\u0001\u0007\u0007\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005A9\u0002g\u0006Q\u0007\u0001\t3!B\u0001\t\u000ea5\u0011kA\u0003\u0005\u0019%\t\u0001BC\u0007\u0002\u00111A6\u0001B\u0003#\t\u0005Ab\"h\u0004\u0005\u0001!uQbA\u0003\u0002\u0011\u0015AR\u0001U\u0002\u0001;#!\u0001\u0001C\b\u000e\t\u0015\t\u0001\u0012\u0004G\u000113\u00016\u0011A\u0011\u0004\u000b\u0005AQ\u0002G\u0007R\u0007\u001d!a\"C\u0001\u0005\u00015\t\u0001\u0012C\u0007\u0002\u00117A6\u0001\u0002"})
public final class PositionManagerLibraryClassFileSearcherKt {
    static final Logger LOG = Logger.getInstance((String)"org.jetbrains.kotlin.idea.debugger");

    public static final Logger getLOG() {
        return LOG;
    }

    @Nullable
    public static final String findPackagePartInternalNameForLibraryFile(@NotNull JetDeclaration topLevelDeclaration) {
        Collection destination;
        Iterable $receiver;
        Iterable $receiver2;
        Collection<CallableDescriptor> collection;
        Intrinsics.checkParameterIsNotNull((Object)topLevelDeclaration, (String)"topLevelDeclaration");
        String packagePartFile = (String)CollectionsKt.singleOrNull(PositionManagerLibraryClassFileSearcherKt.findPackagePartFileNamesForElement(topLevelDeclaration));
        if (packagePartFile != null) {
            return packagePartFile;
        }
        DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor(topLevelDeclaration);
        if (!(descriptor2 instanceof CallableDescriptor)) {
            return null;
        }
        FqName packageFqName = topLevelDeclaration.getContainingJetFile().getPackageFqName();
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule(descriptor2);
        FqName fqName2 = packageFqName;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"packageFqName");
        PackageViewDescriptor packageDescriptor = moduleDescriptor.getPackage(fqName2);
        String descFromSourceText = PositionManagerLibraryClassFileSearcherKt.render(descriptor2);
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof FunctionDescriptor) {
            JetScope jetScope = packageDescriptor.getMemberScope();
            Name name2 = ((FunctionDescriptor)descriptor2).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"descriptor.name");
            collection = jetScope.getFunctions(name2, NoLookupLocation.FROM_IDE);
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            JetScope jetScope = packageDescriptor.getMemberScope();
            Name name3 = ((PropertyDescriptor)descriptor2).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"descriptor.name");
            collection = jetScope.getProperties(name3, NoLookupLocation.FROM_IDE);
        } else {
            PositionManagerLibraryClassFileSearcherKt.reportError(topLevelDeclaration, (CallableDescriptor)descriptor2);
            collection = CollectionsKt.listOf();
        }
        Collection<FunctionDescriptor> descriptors = collection;
        Iterable iterable = descriptors;
        void var9_9 = $receiver2;
        Collection collection2 = new ArrayList();
        for (Object element2 : $receiver) {
            if (!(element2 instanceof DeserializedCallableMemberDescriptor)) continue;
            destination.add(element2);
        }
        $receiver2 = (List)destination;
        $receiver = $receiver2;
        destination = new ArrayList();
        for (Object element2 : $receiver) {
            DeserializedCallableMemberDescriptor it = (DeserializedCallableMemberDescriptor)element2;
            if (!Intrinsics.areEqual((Object)PositionManagerLibraryClassFileSearcherKt.render(it), (Object)descFromSourceText)) continue;
            destination.add(element2);
        }
        DeserializedCallableMemberDescriptor deserializedDescriptor = (DeserializedCallableMemberDescriptor)CollectionsKt.singleOrNull((List)((List)destination));
        if (deserializedDescriptor == null) {
            PositionManagerLibraryClassFileSearcherKt.reportError(topLevelDeclaration, (CallableDescriptor)descriptor2);
            return null;
        }
        ProtoBuf.Callable proto = deserializedDescriptor.getProto();
        if (proto.hasExtension(JvmProtoBuf.implClassName)) {
            NameResolver nameResolver = deserializedDescriptor.getNameResolver();
            Object object = proto.getExtension(JvmProtoBuf.implClassName);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Name name4 = nameResolver.getName(((Number)object).intValue());
            return JvmClassName.byFqNameWithoutInnerClasses(packageFqName.child(name4)).getInternalName();
        }
        return null;
    }

    @NotNull
    public static final List<String> findPackagePartFileNamesForElement(@NotNull JetElement elementAt) {
        LibraryScopeBase libraryScopeBase;
        Intrinsics.checkParameterIsNotNull((Object)elementAt, (String)"elementAt");
        Project project = elementAt.getProject();
        JetFile file = elementAt.getContainingJetFile();
        String packagePartName = PackagePartClassUtils.getPackagePartFqName(file).shortName().asString();
        String packagePartNameWoHash = StringsKt.substring((String)packagePartName, (int)0, (int)(StringsKt.lastIndexOf$default((String)packagePartName, (String)"$", (int)0, (boolean)false, (int)6) + 1));
        OrderEntry libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)file.getVirtualFile(), (Project)project);
        if (libraryEntry instanceof LibraryOrderEntry) {
            Library library = ((LibraryOrderEntry)libraryEntry).getLibrary();
            if (library == null) {
                VirtualFile virtualFile = file.getVirtualFile();
                throw (Throwable)((Object)new AssertionError((Object)("Cannot find library for file " + (virtualFile != null ? virtualFile.getPath() : null))));
            }
            libraryScopeBase = (LibraryScopeBase)new LibraryScope(project, library);
        } else {
            OrderEntry orderEntry = libraryEntry;
            if (orderEntry == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.roots.JdkOrderEntry");
            }
            libraryScopeBase = (LibraryScopeBase)new JdkScope(project, (JdkOrderEntry)orderEntry);
        }
        LibraryScopeBase scope2 = libraryScopeBase;
        Sequence packagePartFiles2 = SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])FilenameIndex.getAllFilenames((Project)project)), (Function1)((Function1)new Function1<String, Boolean>(packagePartNameWoHash){
            final /* synthetic */ String $packagePartNameWoHash;

            public final boolean invoke(String it) {
                return StringsKt.startsWith$default((String)it, (String)this.$packagePartNameWoHash, (boolean)false, (int)2) && StringsKt.endsWith$default((String)it, (String)".class", (boolean)false, (int)2) && !StringsKt.contains$default((String)StringsKt.substringAfter$default((String)it, (String)this.$packagePartNameWoHash, null, (int)2), (CharSequence)"$", (boolean)false, (int)2);
            }
            {
                this.$packagePartNameWoHash = string;
                super(1);
            }
        })), (Function1)((Function1)new Function1<String, Sequence<? extends VirtualFile>>(project, scope2){
            final /* synthetic */ Project $project;
            final /* synthetic */ LibraryScopeBase $scope;

            @NotNull
            public final Sequence<VirtualFile> invoke(String it) {
                return CollectionsKt.asSequence((Iterable)FilenameIndex.getVirtualFilesByName((Project)this.$project, (String)it, (GlobalSearchScope)((GlobalSearchScope)this.$scope)));
            }
            {
                this.$project = project;
                this.$scope = libraryScopeBase;
                super(1);
            }
        })), (Function1)((Function1)new Function1<VirtualFile, String>(file){
            final /* synthetic */ JetFile $file;

            @NotNull
            public final String invoke(VirtualFile it) {
                FqName packageFqName = this.$file.getPackageFqName();
                return packageFqName.isRoot() ? it.getNameWithoutExtension() : packageFqName.asString() + "." + it.getNameWithoutExtension();
            }
            {
                this.$file = jetFile;
                super(1);
            }
        }));
        return SequencesKt.toList((Sequence)packagePartFiles2);
    }

    @NotNull
    public static final String render(@NotNull DeclarationDescriptor desc) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        return DescriptorRenderer.Companion.getFQ_NAMES_IN_TYPES().render(desc);
    }

    public static final void reportError(@NotNull JetElement element2, @Nullable CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        LOG.error("Couldn't calculate class name for element in library scope:\n" + PsiUtilsKt.getElementTextWithContext((PsiElement)element2) + (descriptor2 != null ? "\n" + "descriptor = " + PositionManagerLibraryClassFileSearcherKt.render(descriptor2) : ""));
    }
}

